/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx;

import com.gamelion.speedx.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class Settings {
    public static final int SENSITIVITY_LOW = 0;
    public static final int SENSITIVITY_MEDIUM = 1;
    public static final int SENSITIVITY_HIGH = 2;
    private static final String STORE_NAME = "settings";
    private static final int RECORD_ID = 1;
    private static final int INITIAL_TUTORIALS_NUM = 4;
    private int sensitivity = 1;
    private boolean sound = true;
    private boolean music = true;
    private boolean vibrations = true;
    private boolean invert = false;
    private int tutorialsNum = 4;
    private int personalBest;

    public void load() {
        RecordStore store = null;
        try {
            Debug.trace("Load settings");
            store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
            byte[] record = store.getRecord(1);
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(record));
            int sensitivity = stream.readInt();
            int tutorialsNum = stream.readInt();
            int personalBest = stream.readInt();
            boolean sound = stream.readBoolean();
            boolean music = stream.readBoolean();
            boolean vibrations = stream.readBoolean();
            boolean invert = stream.readBoolean();
            this.sensitivity = sensitivity;
            this.personalBest = personalBest;
            this.sound = sound;
            this.music = music;
            this.vibrations = vibrations;
            this.invert = invert;
            this.tutorialsNum = tutorialsNum;
        }
        catch (IOException ex) {
            Debug.error(ex, "Failed to load settings");
        }
        catch (RecordStoreNotFoundException ex) {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.warn("Settings store doesn't exist yet");
            this.save(true);
        }
        catch (RecordStoreException ex) {
            Debug.error((Exception)((Object)ex), "Failed to load settings");
        }
    }

    public void setSensitivity(int sensitivity) {
        this.sensitivity = sensitivity;
        this.save(false);
    }

    public int sensitivityLevel() {
        return this.sensitivity;
    }

    public void setMusicState(boolean enabled) {
        this.music = enabled;
        this.save(false);
    }

    public boolean musicEnabled() {
        return this.music;
    }

    public void setSoundState(boolean enabled) {
        this.sound = enabled;
        this.save(false);
    }

    public boolean soundEnabled() {
        return this.sound;
    }

    public void setInvertState(boolean invert) {
        this.invert = invert;
        this.save(false);
    }

    public boolean controlsInverted() {
        return this.invert;
    }

    public void setVibrationsState(boolean enabled) {
        this.vibrations = enabled;
        this.save(false);
    }

    public boolean vibrationsEnabled() {
        return this.vibrations;
    }

    public void setTutorialsNum(int tutorialsNum) {
        this.tutorialsNum = tutorialsNum;
        this.save(false);
    }

    public int tutorialsNum() {
        return this.tutorialsNum;
    }

    public void setPersonalBest(int score) {
        this.personalBest = score;
        this.save(false);
    }

    public int personalBest() {
        return this.personalBest;
    }

    private void save(boolean create) {
        try {
            Debug.trace("Save settings");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(baos);
            stream.writeInt(this.sensitivity);
            stream.writeInt(this.tutorialsNum);
            stream.writeInt(this.personalBest);
            stream.writeBoolean(this.sound);
            stream.writeBoolean(this.music);
            stream.writeBoolean(this.vibrations);
            stream.writeBoolean(this.invert);
            RecordStore store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            byte[] data = baos.toByteArray();
            if (create) {
                store.addRecord(data, 0, data.length);
            } else {
                store.setRecord(1, data, 0, data.length);
            }
            store.closeRecordStore();
        }
        catch (IOException ex) {
            Debug.error(ex, "Failed to write settings");
        }
        catch (RecordStoreException ex) {
            Debug.error((Exception)((Object)ex), "Failed to write settings");
        }
    }
}

