/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx;

import com.gamelion.speedx.Debug;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundPool {
    private Player player;
    private Hashtable soundsData = new Hashtable();
    private boolean enabled;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void addSound(String name, String path, String mime) {
        try {
            this.soundsData.put(name, Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(path), (String)mime));
        }
        catch (Exception ex) {
            Debug.error(ex, "failed to load sound " + name + " " + path + " " + mime);
        }
    }

    public void play(String name) {
        if (!this.enabled) {
            return;
        }
        Player newPlayer = (Player)this.soundsData.get(name);
        if (newPlayer != null) {
            if (this.player != null) {
                try {
                    this.player.stop();
                    this.player.deallocate();
                    this.player = null;
                }
                catch (Exception ex) {
                    Debug.error(ex, "Failed to stop sound");
                }
            }
            try {
                this.player = newPlayer;
                this.player.prefetch();
                this.player.start();
            }
            catch (Exception ex) {
                Debug.error(ex, "Failed to play sound");
            }
        } else {
            Debug.error("No sound with id " + name);
        }
    }
}

