/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.ExtMath;
import com.gamelion.speedx.game.Color;
import com.gamelion.speedx.game.Matrix4f;
import com.gamelion.speedx.game.Spline;
import com.gamelion.speedx.game.Vector2f;
import com.gamelion.speedx.game.Vector3f;
import com.gamelion.speedx.game.Vertex;
import java.util.Random;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class TunnelMesh {
    public static final int SEGMENTS = 30;
    public static final int TUBE_SEGMENTS = 12;
    public static final float SEGMENT_LEN = 2.0f * (float)Math.sin(0.2617993877991494);
    public static final int PART_INNER_TUBE = 0;
    public static final int PART_FLAT = 1;
    public static final int PART_OUTER_TUBE = 2;
    private static final float EPSILON = 1.0E-7f;
    private static final float FIXED8_TO_FLOAT = 0.00390625f;
    private static final float[] SIN = new float[13];
    private static final float[] COS = new float[13];
    private static final float[] FLAT = new float[13];
    private static final float[] MORPH_SIN = new float[1542];
    private static final float[] MORPH_COS = new float[1542];
    private static boolean initialized = false;
    private static final int VERTICES_COUNT = 403;
    private static final int TILES_COUNT = 360;
    private Matrix4f morphMtx = new Matrix4f();
    private Vector3f u = new Vector3f();
    private Vector3f v = new Vector3f();
    private Vector3f up2 = new Vector3f();
    private int[] color1 = new int[4];
    private int[] color2 = new int[4];
    private int[] out = new int[4];
    private Matrix4f ptfMtx = new Matrix4f();
    private Vector3f ptfV = new Vector3f();
    private Matrix4f singleSegmentMtx = new Matrix4f();
    private Vector3f singleSegmentV = new Vector3f();
    private Vector3f singleSegmentBase = new Vector3f();
    private Vector3f tubePoint = new Vector3f();
    private Vector3f flatPoint = new Vector3f();
    private Vertex[] vertices = new Vertex[403];
    private VertexBuffer vertexBuffer;
    private VertexArray posArray;
    private short[] posBuffer;
    private VertexArray uvArray;
    private short[] uvBuffer;
    private VertexArray colorArray;
    private byte[] colorBuffer;
    private IndexBuffer indicesBuffer;
    private IndexBuffer bandIndicesBuffer;
    private Vector3f[] tube = new Vector3f[403];
    private Vector2f[] texCoords = new Vector2f[403];
    private int[] indices = new int[2160];
    private int[] bandIndices = new int[360];
    private Vector3f[] p = new Vector3f[31];
    private Vector3f[] m = new Vector3f[31];
    private Vector3f[] up = new Vector3f[31];
    private Vector3f[] cross = new Vector3f[31];
    private Spline spline;
    private int current;
    private int next;

    public static void initializeLookups() {
        if (!initialized) {
            int i;
            for (i = 0; i <= 12; ++i) {
                TunnelMesh.FLAT[i] = ((float)(-i) + 6.0f) * SEGMENT_LEN;
                TunnelMesh.SIN[i] = (float)Math.sin((double)((float)i * 2.0f) * Math.PI / 12.0);
                TunnelMesh.COS[i] = (float)Math.cos((double)((float)i * 2.0f) * Math.PI / 12.0);
            }
            int ndx = 0;
            for (i = 0; i <= 256; ++i) {
                int j = 0;
                while (j < 6) {
                    float a = (float)((double)((float)i / 256.0f) * (0.2617993877991494 + (double)j * Math.PI / 6.0));
                    TunnelMesh.MORPH_SIN[ndx] = (float)Math.sin(a);
                    TunnelMesh.MORPH_COS[ndx] = (float)Math.cos(a);
                    ++j;
                    ++ndx;
                }
            }
        }
        initialized = true;
    }

    public TunnelMesh(Random rand) {
        int j;
        int base;
        int i;
        int i2;
        this.spline = new Spline(SEGMENT_LEN, rand);
        int pos = 0;
        for (i2 = 0; i2 <= 30; ++i2) {
            int j2 = 0;
            while (j2 <= 12) {
                this.texCoords[pos] = new Vector2f();
                this.texCoords[pos].set(i2 % 2 != 0 ? 1.0f : 0.0f, j2 % 2 != 0 ? 1.0f : 0.0f);
                ++j2;
                ++pos;
            }
        }
        for (i2 = 0; i2 < this.vertices.length; ++i2) {
            this.vertices[i2] = new Vertex();
        }
        for (i2 = 0; i2 < this.tube.length; ++i2) {
            this.tube[i2] = new Vector3f();
        }
        for (i2 = 0; i2 < this.p.length; ++i2) {
            this.p[i2] = new Vector3f();
        }
        for (i2 = 0; i2 < this.m.length; ++i2) {
            this.m[i2] = new Vector3f();
        }
        for (i2 = 0; i2 < this.up.length; ++i2) {
            this.up[i2] = new Vector3f();
        }
        for (i2 = 0; i2 < this.cross.length; ++i2) {
            this.cross[i2] = new Vector3f();
        }
        TunnelMesh.initializeLookups();
        int[] stripLens = new int[720];
        int[] indices = new int[2160];
        int lenPos = 0;
        int indexPos = 0;
        for (i = 0; i < 30; ++i) {
            base = 13 * i;
            for (j = 0; j < 12; ++j) {
                stripLens[lenPos++] = 3;
                indices[indexPos++] = base + j + 12 + 1 + 1;
                indices[indexPos++] = base + j + 1;
                indices[indexPos++] = base + j;
                stripLens[lenPos++] = 3;
                indices[indexPos++] = base + j + 12 + 1;
                indices[indexPos++] = base + j + 12 + 1 + 1;
                indices[indexPos++] = base + j;
            }
        }
        this.indicesBuffer = new TriangleStripArray(indices, stripLens);
        stripLens = new int[120];
        indices = new int[360];
        lenPos = 0;
        indexPos = 0;
        for (i = 0; i < 30; ++i) {
            base = 13 * i;
            j = 0;
            stripLens[lenPos++] = 3;
            this.bandIndices[indexPos++] = base + j + 12 + 1 + 1;
            this.bandIndices[indexPos++] = base + j + 1;
            this.bandIndices[indexPos++] = base + j;
            stripLens[lenPos++] = 3;
            this.bandIndices[indexPos++] = base + j + 12 + 1;
            this.bandIndices[indexPos++] = base + j + 12 + 1 + 1;
            this.bandIndices[indexPos++] = base + j;
        }
        for (i = 0; i < 30; ++i) {
            base = 13 * i;
            j = 11;
            stripLens[lenPos++] = 3;
            this.bandIndices[indexPos++] = base + j + 12 + 1 + 1;
            this.bandIndices[indexPos++] = base + j + 1;
            this.bandIndices[indexPos++] = base + j;
            stripLens[lenPos++] = 3;
            this.bandIndices[indexPos++] = base + j + 12 + 1;
            this.bandIndices[indexPos++] = base + j + 12 + 1 + 1;
            this.bandIndices[indexPos++] = base + j;
        }
        this.bandIndicesBuffer = new TriangleStripArray(this.bandIndices, stripLens);
        this.vertexBuffer = new VertexBuffer();
        this.posArray = new VertexArray(403, 3, 2);
        this.uvArray = new VertexArray(403, 2, 2);
        this.colorArray = new VertexArray(403, 3, 1);
        this.posBuffer = new short[1209];
        this.uvBuffer = new short[806];
        this.colorBuffer = new byte[1209];
        this.vertexBuffer.setPositions(this.posArray, 0.015625f, null);
        this.vertexBuffer.setTexCoords(0, this.uvArray, 0.00390625f, null);
    }

    public void initialize() {
        int i;
        this.current = 0;
        this.next = 0;
        this.spline.begin(this.p[0], this.m[0]);
        this.up[0].set(0.0f, 1.0f, 0.0f);
        for (i = 0; i <= 30; ++i) {
            if (i > 0) {
                this.spline.next(this.p[i], this.m[i]);
                this.PTF(i);
            }
            Vector3f.cross(this.cross[i], this.m[i], this.up[i]);
            this.cross[i].normalize();
            this.generateSingleSegment(i);
        }
        for (i = 0; i < 403; ++i) {
            this.vertices[i].u = this.texCoords[i].x;
            this.vertices[i].v = this.texCoords[i].y;
        }
    }

    public void moveBy(int count) {
        int i;
        if (count < 30) {
            int i2;
            int vertCount = count * 13;
            for (i2 = 0; i2 < this.vertices.length - vertCount; ++i2) {
                this.vertices[i2].set(this.vertices[i2 + vertCount]);
            }
            for (i2 = 0; i2 < this.tube.length - vertCount; ++i2) {
                this.tube[i2].set(this.tube[i2 + vertCount]);
            }
            for (i2 = 0; i2 < this.p.length - count; ++i2) {
                this.p[i2].set(this.p[i2 + count]);
            }
            for (i2 = 0; i2 < this.m.length - count; ++i2) {
                this.m[i2].set(this.m[i2 + count]);
            }
            for (i2 = 0; i2 < this.up.length - count; ++i2) {
                this.up[i2].set(this.up[i2 + count]);
            }
            for (i2 = 0; i2 < this.cross.length - count; ++i2) {
                this.cross[i2].set(this.cross[i2 + count]);
            }
        }
        for (i = Math.max(1, 31 - count); i <= 30; ++i) {
            this.spline.next(this.p[i], this.m[i]);
            this.PTF(i);
            Vector3f.cross(this.cross[i], this.m[i], this.up[i]);
            this.cross[i].normalize();
            this.generateSingleSegment(i);
        }
        for (i = 0; i < 403; ++i) {
            this.vertices[i].u = this.texCoords[i].x;
            this.vertices[i].v = this.texCoords[i].y;
        }
    }

    public void morph(int factor) {
        boolean dir = 1 == this.current ? 0 == this.next : 0 == this.current;
        int coeff = 1 == this.current ? 256 - factor : factor;
        float destOffset = dir ? 0.0f : -2.0f;
        for (int i = 0; i < 31; ++i) {
            float z;
            float y;
            float x;
            float cosa;
            float sina;
            float vZ;
            float vY;
            float vX;
            int pos;
            Vector3f tangent = this.m[i];
            Vector3f upVector = this.up[i];
            float offX = upVector.x * (0.00390625f * (float)coeff * destOffset);
            float offY = upVector.y * (0.00390625f * (float)coeff * destOffset);
            float offZ = upVector.z * (0.00390625f * (float)coeff * destOffset);
            int basepos = i * 13;
            int cpos = basepos + 6;
            Vector3f center = this.tube[cpos];
            this.vertices[cpos].pos.x = center.x + offX;
            this.vertices[cpos].pos.y = center.y + offY;
            this.vertices[cpos].pos.z = center.z + offZ;
            this.morphMtx.setIdentity();
            float prevX = center.x;
            float prevY = center.y;
            float prevZ = center.z;
            float ptX = center.x;
            float ptY = center.y;
            float ptZ = center.z;
            int j = 5;
            int ndx = 0;
            while (j >= 0) {
                pos = basepos + j;
                vX = this.tube[pos].x - prevX;
                vY = this.tube[pos].y - prevY;
                vZ = this.tube[pos].z - prevZ;
                prevX = this.tube[pos].x;
                prevY = this.tube[pos].y;
                prevZ = this.tube[pos].z;
                sina = MORPH_SIN[coeff * 6 + ndx];
                cosa = MORPH_COS[coeff * 6 + ndx];
                this.morphMtx.setupRotation(tangent, dir ? sina : -sina, cosa);
                x = vX * this.morphMtx.m[0][0] + vY * this.morphMtx.m[0][1] + vZ * this.morphMtx.m[0][2] + this.morphMtx.m[0][3];
                y = vX * this.morphMtx.m[1][0] + vY * this.morphMtx.m[1][1] + vZ * this.morphMtx.m[1][2] + this.morphMtx.m[1][3];
                z = vX * this.morphMtx.m[2][0] + vY * this.morphMtx.m[2][1] + vZ * this.morphMtx.m[2][2] + this.morphMtx.m[2][3];
                this.vertices[pos].pos.x = (ptX += x) + offX;
                this.vertices[pos].pos.y = (ptY += y) + offY;
                this.vertices[pos].pos.z = (ptZ += z) + offZ;
                --j;
                ++ndx;
            }
            prevX = center.x;
            prevY = center.y;
            prevZ = center.z;
            ptX = center.x;
            ptY = center.y;
            ptZ = center.z;
            j = 7;
            ndx = 0;
            while (j <= 12) {
                pos = basepos + j;
                vX = this.tube[pos].x - prevX;
                vY = this.tube[pos].y - prevY;
                vZ = this.tube[pos].z - prevZ;
                prevX = this.tube[pos].x;
                prevY = this.tube[pos].y;
                prevZ = this.tube[pos].z;
                sina = -MORPH_SIN[coeff * 6 + ndx];
                cosa = MORPH_COS[coeff * 6 + ndx];
                this.morphMtx.setupRotation(tangent, dir ? sina : -sina, cosa);
                x = vX * this.morphMtx.m[0][0] + vY * this.morphMtx.m[0][1] + vZ * this.morphMtx.m[0][2] + this.morphMtx.m[0][3];
                y = vX * this.morphMtx.m[1][0] + vY * this.morphMtx.m[1][1] + vZ * this.morphMtx.m[1][2] + this.morphMtx.m[1][3];
                z = vX * this.morphMtx.m[2][0] + vY * this.morphMtx.m[2][1] + vZ * this.morphMtx.m[2][2] + this.morphMtx.m[2][3];
                this.vertices[pos].pos.x = (ptX += x) + offX;
                this.vertices[pos].pos.y = (ptY += y) + offY;
                this.vertices[pos].pos.z = (ptZ += z) + offZ;
                ++j;
                ++ndx;
            }
        }
    }

    public void setNextPartType(int type) {
        this.current = this.next;
        this.next = type;
    }

    public int getCurrentPartType() {
        return this.current;
    }

    public int getNextPartType() {
        return this.next;
    }

    public void calculateSplieDataAt(int seg, float segRem, Vector3f out, Vector3f up) {
        if (out != null) {
            Vector3f.lerp(out, this.p[seg], this.p[seg + 1], segRem);
        }
        if (up != null) {
            Vector3f.lerp(up, this.up[seg], this.up[seg + 1], segRem);
        }
    }

    public void calculateVectorBetween(int vertex1, int vertex2, Vector3f out) {
        out.x = this.vertices[vertex1].pos.x - this.vertices[vertex2].pos.x;
        out.y = this.vertices[vertex1].pos.y - this.vertices[vertex2].pos.y;
        out.z = this.vertices[vertex1].pos.z - this.vertices[vertex2].pos.z;
    }

    public void calculatePointAndNormalAt(int seg, float segRem, int pos, float posRem, boolean interpolateAtEdges, Vector3f out, Vector3f up) {
        int basepos = seg * 13 + pos;
        this.calculateVectorBetween(basepos, basepos + 1, this.u);
        this.calculateVectorBetween(basepos + 1 + 13, basepos + 1, this.v);
        if (null != out) {
            out.x = this.vertices[basepos + 1].pos.x + this.u.x * posRem + this.v.x * segRem;
            out.y = this.vertices[basepos + 1].pos.y + this.u.y * posRem + this.v.y * segRem;
            out.z = this.vertices[basepos + 1].pos.z + this.u.z * posRem + this.v.z * segRem;
        }
        if (null != up) {
            Vector3f.cross(up, this.u, this.v);
            up.normalize();
            if (posRem >= 0.5f) {
                if (interpolateAtEdges || pos != 0) {
                    basepos = seg * 13 + (pos + 12 - 1) % 12;
                    this.calculateVectorBetween(basepos, basepos + 1, this.u);
                    this.calculateVectorBetween(basepos + 1 + 13, basepos + 1, this.v);
                    float coeff = posRem - 0.5f;
                    Vector3f.cross(this.up2, this.u, this.v);
                    this.up2.normalize();
                    Vector3f.lerp(up, up, this.up2, coeff);
                    up.normalize();
                }
            } else if (interpolateAtEdges || pos != 11) {
                basepos = seg * 13 + (pos + 1) % 12;
                this.calculateVectorBetween(basepos, basepos + 1, this.u);
                this.calculateVectorBetween(basepos + 1 + 13, basepos + 1, this.v);
                float coeff = posRem + 0.5f;
                Vector3f.cross(this.up2, this.u, this.v);
                this.up2.normalize();
                Vector3f.lerp(up, this.up2, up, coeff);
                up.normalize();
            }
        }
    }

    public void render(Graphics3D g3d, Appearance appearance, Transform transform, boolean useColorArray) {
        if (useColorArray) {
            this.vertexBuffer.setColors(this.colorArray);
        }
        g3d.render(this.vertexBuffer, this.indicesBuffer, appearance, transform);
        this.vertexBuffer.setColors(null);
    }

    public void renderBands(Graphics3D g3d, Appearance appearance, Transform transform, float alpha) {
        this.vertexBuffer.setDefaultColor((int)(alpha * 255.0f) << 24 | 0xFFFFFF);
        g3d.render(this.vertexBuffer, this.bandIndicesBuffer, appearance, transform);
        this.vertexBuffer.setDefaultColor(-1);
    }

    public void renderSpots(Graphics3D g3d, Appearance appearance, Transform transform, IndexBuffer indexBuffer, Color color) {
        this.vertexBuffer.setDefaultColor(color.toInt());
        g3d.render(this.vertexBuffer, indexBuffer, appearance, transform);
        this.vertexBuffer.setDefaultColor(-1);
    }

    public Vector3f getVertex(int seg, int pos) {
        return this.vertices[seg * 13 + pos + 1].pos;
    }

    public void getTileVertices(int segment, int position, Vector3f[] base) {
        int baseoff = segment * 13;
        int offFront = baseoff + position;
        int offBack = baseoff + 13 + position;
        Debug.error("segments " + segment + " " + 30);
        base[0].set(this.vertices[offFront].pos);
        base[1].set(this.vertices[offFront + 1].pos);
        base[2].set(this.vertices[offBack].pos);
        base[3].set(this.vertices[offBack + 1].pos);
    }

    public void clearColor(Color color) {
        byte r = (byte)(color.r * 255.0f);
        byte g = (byte)(color.g * 255.0f);
        byte b = (byte)(color.b * 255.0f);
        for (int i = 0; i < 403; ++i) {
            this.vertices[i].r = r;
            this.vertices[i].g = g;
            this.vertices[i].b = b;
        }
    }

    public void fillColorStrip(int segmentFrom, int segmentTo, int position, Color color) {
        byte r = (byte)(color.r * 255.0f);
        byte g = (byte)(color.g * 255.0f);
        byte b = (byte)(color.b * 255.0f);
        for (int i = segmentTo; i >= segmentFrom; --i) {
            this.vertices[13 * i + position].r = r;
            this.vertices[13 * i + position].g = g;
            this.vertices[13 * i + position].b = b;
        }
    }

    public void blendColorStrip(int segmentFrom, int segmentTo, int position, Color color, float coeff) {
        if (coeff >= 0.9999999f) {
            this.fillColorStrip(segmentFrom, segmentTo, position, color);
        } else if (coeff > 1.0E-7f) {
            int alpha = (int)(256.0f * coeff);
            int oneMinusAlpha = 256 - alpha;
            this.color2[0] = (int)(color.a * 255.0f);
            this.color2[1] = (int)(color.r * 255.0f);
            this.color2[2] = (int)(color.g * 255.0f);
            this.color2[3] = (int)(color.b * 255.0f);
            for (int i = segmentTo; i >= segmentFrom; --i) {
                this.color1[0] = 255;
                this.color1[1] = this.vertices[13 * i + position].r;
                this.color1[2] = this.vertices[13 * i + position].g;
                this.color1[3] = this.vertices[13 * i + position].b;
                this.out[0] = this.color1[0] * oneMinusAlpha + this.color2[0] * alpha >> 8;
                this.out[1] = this.color1[1] * oneMinusAlpha + this.color2[1] * alpha >> 8;
                this.out[2] = this.color1[2] * oneMinusAlpha + this.color2[2] * alpha >> 8;
                this.out[3] = this.color1[3] * oneMinusAlpha + this.color2[3] * alpha >> 8;
                this.vertices[13 * i + position].r = (byte)this.out[1];
                this.vertices[13 * i + position].g = (byte)this.out[2];
                this.vertices[13 * i + position].b = (byte)this.out[3];
            }
        }
    }

    public void createVBO() {
    }

    public void freeVBO() {
    }

    public void updateVBO() {
        int posIndex = 0;
        int uvIndex = 0;
        int colorIndex = 0;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vertex v = this.vertices[i];
            this.posBuffer[posIndex++] = (short)(v.pos.x * 64.0f);
            this.posBuffer[posIndex++] = (short)(v.pos.y * 64.0f);
            this.posBuffer[posIndex++] = (short)(v.pos.z * 64.0f);
            this.uvBuffer[uvIndex++] = (short)(v.u * 256.0f);
            this.uvBuffer[uvIndex++] = (short)(v.v * 256.0f);
            this.colorBuffer[colorIndex++] = v.r;
            this.colorBuffer[colorIndex++] = v.g;
            this.colorBuffer[colorIndex++] = v.b;
        }
        this.posArray.set(0, 403, this.posBuffer);
        this.uvArray.set(0, 403, this.uvBuffer);
        this.colorArray.set(0, 403, this.colorBuffer);
    }

    private void PTF(int seg) {
        if (seg < 1 || seg > 30) {
            Debug.error("PTF condition failed");
        }
        Vector3f.cross(this.ptfV, this.m[seg - 1], this.m[seg]);
        this.ptfV.normalize();
        float d = Vector3f.dot(this.m[seg - 1], this.m[seg]);
        if (d >= 0.9999999f) {
            this.up[seg].set(this.up[seg - 1]);
        } else {
            this.ptfMtx.setIdentity();
            this.ptfMtx.setupRotate((float)ExtMath.acos(d), this.ptfV);
            this.ptfMtx.transform(this.up[seg], this.up[seg - 1]);
        }
    }

    private void generateSingleSegment(int seg) {
        Vector3f center = this.p[seg];
        Vector3f upVector = this.up[seg];
        Vector3f tangent = this.m[seg];
        Vector3f translate = this.cross[seg];
        this.singleSegmentMtx.setIdentity();
        if (seg < 0 || seg > 30) {
            Debug.error("generateSingleSegment failed");
        }
        if (1 == this.current) {
            boolean inner;
            boolean bl = inner = 0 == this.next;
            if (inner) {
                this.singleSegmentV.set(upVector);
            } else {
                this.singleSegmentV.setNegate(upVector);
            }
            this.singleSegmentBase.x = center.x - upVector.x;
            this.singleSegmentBase.y = center.y - upVector.y;
            this.singleSegmentBase.z = center.z - upVector.z;
            int i = 0;
            int pos = seg * 13;
            while (i <= 12) {
                this.singleSegmentMtx.setupRotation(tangent, inner ? SIN[i] : -SIN[i], COS[i]);
                this.singleSegmentMtx.transform(this.tubePoint, this.singleSegmentV);
                this.tubePoint.add(center);
                this.flatPoint.set(this.singleSegmentBase);
                this.flatPoint.x += translate.x * FLAT[i];
                this.flatPoint.y += translate.y * FLAT[i];
                this.flatPoint.z += translate.z * FLAT[i];
                this.tube[pos].set(this.tubePoint);
                this.vertices[pos].pos.set(this.flatPoint);
                ++i;
                ++pos;
            }
        } else {
            boolean inner;
            boolean bl = inner = 0 == this.current;
            if (inner) {
                this.singleSegmentV.set(upVector);
            } else {
                this.singleSegmentV.setNegate(upVector);
            }
            int i = 0;
            int pos = seg * 13;
            while (i <= 12) {
                this.singleSegmentMtx.setupRotation(tangent, inner ? SIN[i] : -SIN[i], COS[i]);
                this.singleSegmentMtx.transform(this.tubePoint, this.singleSegmentV);
                this.tubePoint.add(center);
                this.tube[pos].set(this.tubePoint);
                this.vertices[pos].pos.set(this.tubePoint);
                ++i;
                ++pos;
            }
        }
    }
}

