/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PlatformService;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.MyFont;
import com.renderedideas.superbike3d.SuperCanvas;
import javax.microedition.lcdui.Graphics;

class ScoreCanvas
extends SuperCanvas
implements Runnable {
    Game game;
    Bitmap backImage = new Bitmap("/back_button.png");
    Bitmap retryText = new Bitmap("/retryText.png");
    Bitmap yes = new Bitmap("/yes.png");
    Bitmap no = new Bitmap("/no.png");
    boolean retry;
    boolean conn;
    boolean info;
    Thread scoreThread;
    String[] scores;
    String[] names;
    String globalRank;

    ScoreCanvas(Game g) {
        this.game = g;
        this.retry = false;
        this.conn = true;
        this.info = false;
        this.names = new String[50];
        this.scores = new String[50];
        this.globalRank = "NA";
        this.downloadScores();
    }

    public void update(float deltaTime) {
    }

    public void paint(Graphics g) {
        Bitmap.fillColor(g, 0, 0, Game.width, Game.height, 0, 0, 0);
        MyFont.drawString("Global hi-scores", g, Game.width / 2 - MyFont.stringWidth("Global hi-scores") / 2, Game.height / 30);
        if (this.conn) {
            MyFont.drawString("Loading", g, Game.width / 2 - MyFont.stringWidth("Loading") / 2, Game.height / 2 - MyFont.stringHeight() / 2);
            Bitmap.drawBitmap(g, this.backImage, 0, Game.height - this.backImage.getHeight());
        } else if (this.retry) {
            Bitmap.drawBitmap(g, this.retryText, Game.width / 2 - this.retryText.getWidth() / 2, Game.height / 2 - this.retryText.getHeight() / 2);
            Bitmap.drawBitmap(g, this.yes, 0, Game.height - this.yes.getHeight());
            Bitmap.drawBitmap(g, this.no, Game.width - this.no.getWidth(), Game.height - this.no.getHeight());
        } else if (this.info) {
            Bitmap.drawBitmap(g, this.backImage, 0, Game.height - this.backImage.getHeight());
            for (int i = 0; i < 8; ++i) {
                MyFont.drawString(i + 1 + ".", g, 10, 45 + 20 * i);
                MyFont.drawString(this.names[i], g, 45, 45 + 20 * i);
                MyFont.drawString(this.scores[i], g, 220, 45 + 20 * i);
            }
            MyFont.drawString("Your rank: " + this.globalRank, g, Game.width / 2 - MyFont.stringWidth("Your rank: " + this.globalRank) / 2, Game.height - MyFont.stringHeight() * 2);
        }
    }

    public void keyPressed(int i) {
        if (i == 101 || i == 103) {
            if (this.retry) {
                this.game.playSelectSound();
                this.downloadScores();
            } else {
                this.game.playSelectSound();
                this.game.setMain_score();
            }
        } else if (i == 102 && this.retry) {
            this.game.playSelectSound();
            this.game.setMain_score();
        }
    }

    public void keyReleased(int i) {
    }

    public void keyRepeated(int i) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pointerPressed(int xx, int yy) {
        if (this.conn || this.info) {
            if (xx > 65) return;
            if (yy < Game.height - this.backImage.getHeight() * 2) return;
            this.game.playSelectSound();
            this.game.setMain_score();
            return;
        }
        if (!this.retry) return;
        if (xx <= this.yes.getWidth() * 3 / 2) {
            if (yy >= Game.height - this.yes.getHeight() * 3 / 2) {
                this.keyPressed(101);
                return;
            }
        }
        if (xx < Game.width - this.no.getWidth() * 3 / 2) return;
        if (yy < Game.height - this.no.getHeight() * 3 / 2) return;
        this.keyPressed(102);
    }

    public void pointerReleased(int xx, int yy) {
    }

    public void pointerDragged(int xx, int yy) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void onBackKey() {
        this.game.playSelectSound();
        this.game.setMain_score();
    }

    public void deallocate() {
        this.names = null;
        this.scores = null;
        this.no = null;
        this.yes = null;
        this.retryText = null;
        this.backImage = null;
    }

    public void downloadScores() {
        this.retry = false;
        this.info = false;
        this.conn = true;
        Thread scoreThread = new Thread(this);
        scoreThread.start();
    }

    public void run() {
        this.loadScoresFromServer();
        if (!this.retry) {
            this.info = true;
            this.conn = false;
            this.retry = false;
        }
    }

    public void loadScoresFromServer() {
        String str = "";
        str = PlatformService.getScoresFromServer("http://www.renderedideas.com/scores/HighwayRacing3D.php", Game.topName, Game.topScore + "");
        if (this.names == null) {
            return;
        }
        try {
            if (str != null) {
                this.getScores(str);
            } else {
                this.retry = true;
                this.conn = false;
                this.info = false;
            }
        }
        catch (Exception e2) {
            this.retry = true;
            this.conn = false;
            this.info = false;
        }
    }

    public void getScores(String str) {
        int startIndex = 0;
        for (int i = 0; i < 30; ++i) {
            this.names[i] = str.substring(startIndex, str.indexOf("|", startIndex));
            startIndex = str.indexOf("|", startIndex) + 1;
            this.scores[i] = str.substring(startIndex, str.indexOf("|", startIndex));
            startIndex = str.indexOf("|", startIndex) + 1;
        }
        this.globalRank = Game.topName.equals("Player") ? "---" : str.substring(startIndex, str.indexOf("|", startIndex));
    }

    public void handleSwipe(int direction) {
    }
}

