/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PlatformService;
import com.renderedideas.game.PrintConsole;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.ImageSet;
import com.renderedideas.superbike3d.MyFont;
import com.renderedideas.superbike3d.SuperCanvas;
import javax.microedition.lcdui.Graphics;

class SplashCanvas
extends SuperCanvas
implements Runnable {
    boolean disable = false;
    boolean companyDrawn = false;
    Bitmap image;
    Bitmap yes;
    Bitmap no;
    Bitmap company_logo;
    Game game;

    SplashCanvas(Game g) {
        this.game = g;
        this.image = ImageSet.loadImage("/music.png");
        this.yes = ImageSet.loadImage("/yes.png");
        this.no = ImageSet.loadImage("/no.png");
        this.company_logo = ImageSet.loadImage("/company_logo.png");
        new Thread(this).start();
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 5000L) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        this.companyDrawn = true;
    }

    public void update(float deltaTime) {
    }

    public void paint(Graphics g) {
        if (this.disable) {
            return;
        }
        if (!this.companyDrawn) {
            Bitmap.fillColor(g, 0, 0, Game.width, Game.height, 255, 255, 255);
            Bitmap.drawBitmap(g, this.company_logo, Game.width / 2 - this.company_logo.getWidth() / 2, Game.height / 2 - this.company_logo.getHeight() / 2);
            return;
        }
        Bitmap.fillColor(g, 0, 0, Game.width, Game.height, 0, 0, 0);
        Bitmap.drawBitmap(g, this.image, Game.width / 2 - this.image.getWidth() / 2, Game.height / 2 - this.image.getHeight() / 2 - Game.height / 5);
        MyFont.drawString("Enable sounds?", g, Game.width / 2 - MyFont.stringWidth("Enable Sounds?") / 2, Game.height / 2);
        Bitmap.drawBitmap(g, this.yes, 0, Game.height - this.yes.getHeight());
        Bitmap.drawBitmap(g, this.no, Game.width - this.no.getWidth(), Game.height - this.yes.getHeight());
    }

    public void keyPressed(int i) {
        if (!this.companyDrawn) {
            return;
        }
        if (this.disable) {
            return;
        }
        if (i == 101 || i == 103) {
            this.disable = true;
            this.game.setMenu_splash(true);
            PrintConsole.print("sound enabled");
        } else if (i == 102) {
            this.disable = true;
            this.game.setMenu_splash(false);
            PrintConsole.print("sound disabled");
        }
    }

    public void keyReleased(int key) {
    }

    public void keyRepeated(int key) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pointerPressed(int xx, int yy) {
        if (this.disable) {
            return;
        }
        if (!this.companyDrawn) {
            return;
        }
        if (xx <= this.yes.getWidth() * 3 / 2) {
            if (yy >= Game.height - this.yes.getHeight() * 3 / 2) {
                this.keyPressed(101);
                return;
            }
        }
        if (xx < Game.width - this.no.getWidth() * 3 / 2) return;
        if (yy < Game.height - this.no.getHeight() * 3 / 2) return;
        this.keyPressed(102);
    }

    public void pointerReleased(int xx, int yy) {
    }

    public void pointerDragged(int xx, int yy) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void onBackKey() {
        PlatformService.exit();
    }

    public void deallocate() {
        this.company_logo = null;
        this.no = null;
        this.yes = null;
        this.image = null;
    }

    public void handleSwipe(int direction) {
    }
}

