/*
 * Decompiled with CFR 0.152.
 */
package de.mef.menu;

import de.mef.menu.Anchored;
import de.mef.menu.Scrollable;
import de.mef.menu.Widget;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class BasicMenu
extends Anchored
implements Scrollable,
KeyListener {
    private int cursor;
    private int contentHeight;
    private int intervalStart;
    private int intervalEnd;
    private int maxHeight;
    private int alignment;
    private Vector contents;

    public final void setCursor(int n) {
        if (this.contents.size() > 0) {
            if (n < 0) {
                n = 0;
            }
            if (n > this.contents.size()) {
                n = this.contents.size() - 1;
            }
            this.cursor = n;
            Object e = this.contents.elementAt(n);
            if (!(e instanceof Widget) || !((Widget)e).isEnabled()) {
                this.moveCursor(1);
            }
            this.updateFocus();
            this.calcInterval();
        }
    }

    private void calcDimensions() {
        int n;
        this.contentHeight = 0;
        this.width = 0;
        for (n = 0; n < this.contents.size(); ++n) {
            Widget widget = (Widget)this.contents.elementAt(n);
            if (this.width < widget.getWidth()) {
                this.width = widget.getWidth();
            }
            this.contentHeight += widget.getHeight();
        }
        this.height = 0;
        if (this.contents.size() > 0) {
            for (n = this.intervalStart; n <= this.intervalEnd; ++n) {
                this.height += ((Widget)this.contents.elementAt(n)).getHeight();
            }
        }
    }

    private void calcInterval() {
        if (this.contents.size() == 0) {
            this.intervalStart = 0;
            this.intervalEnd = 0;
            return;
        }
        if (this.contentHeight <= this.maxHeight) {
            this.intervalStart = 0;
            this.intervalEnd = this.contents.size() - 1;
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.cursor <= this.intervalStart) {
            this.intervalStart = this.cursor - 1;
            for (n2 = this.intervalStart = Math.max(0, this.intervalStart); n2 < this.contents.size() && n + ((Widget)this.contents.elementAt(n2)).getHeight() <= this.maxHeight; ++n2) {
                n += ((Widget)this.contents.elementAt(n2)).getHeight();
            }
            this.intervalEnd = n2 - 1;
            return;
        }
        if (this.cursor >= this.intervalEnd) {
            this.intervalEnd = this.cursor + 1;
            for (n2 = this.intervalEnd = Math.min(this.contents.size() - 1, this.intervalEnd); n2 >= 0 && n + ((Widget)this.contents.elementAt(n2)).getHeight() <= this.maxHeight; --n2) {
                n += ((Widget)this.contents.elementAt(n2)).getHeight();
            }
            this.intervalStart = n2 + 1;
        }
    }

    private void updateFocus() {
        if (this.contents.size() > 0) {
            this.cursor = Math.min(this.contents.size() - 1, this.cursor);
        }
        for (int i = 0; i < this.contents.size(); ++i) {
            ((Widget)this.contents.elementAt(i)).setFocus(false);
        }
        if (this.contents.size() > 0) {
            ((Widget)this.contents.elementAt(this.cursor)).setFocus(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void display(Graphics var1_1) {
        var2_2 = 0;
        switch (this.alignment & 50) {
            case 32: {
                if (this.contentHeight >= this.height) break;
                v0 = 0;
                v1 = this.height - this.contentHeight;
                ** GOTO lbl12
            }
            case 2: {
                if (this.contentHeight >= this.height) break;
                v0 = 0;
                v1 = (this.height - this.contentHeight) / 2;
lbl12:
                // 2 sources

                var2_2 = v0 + v1;
            }
        }
        for (var3_3 = this.intervalStart; var3_3 <= this.intervalEnd; ++var3_3) {
            switch (this.alignment & 13) {
                case 1: {
                    v2 = (Widget)this.contents.elementAt(var3_3);
                    v3 = var1_1;
                    v4 = this.width / 2;
                    v5 = var2_2;
                    v6 = 17;
                    break;
                }
                case 8: {
                    v2 = (Widget)this.contents.elementAt(var3_3);
                    v3 = var1_1;
                    v4 = this.width;
                    v5 = var2_2;
                    v6 = 24;
                    break;
                }
                default: {
                    v2 = (Widget)this.contents.elementAt(var3_3);
                    v3 = var1_1;
                    v4 = 0;
                    v5 = var2_2;
                    v6 = 20;
                }
            }
            v2.paint(v3, v4, v5, v6);
            var2_2 += ((Widget)this.contents.elementAt(var3_3)).getHeight();
        }
    }

    private void moveCursor(int n) {
        if (this.contents.size() > 0) {
            int n2 = this.cursor;
            do {
                this.cursor += n;
                if (this.cursor < 0) {
                    this.cursor = this.contents.size() - 1;
                }
                this.cursor %= this.contents.size();
            } while (!((Widget)this.contents.elementAt(this.cursor)).isEnabled() && n2 != this.cursor);
            this.updateFocus();
            this.calcInterval();
            this.calcDimensions();
        }
    }

    public final void keyPressed(int n) {
        if (n == Handset.DOWN || n == Handset.NUM8) {
            this.moveCursor(1);
            return;
        }
        if (n == Handset.UP || n == Handset.NUM2) {
            this.moveCursor(-1);
            return;
        }
        if (n == Handset.FIRE || n == Handset.MENU_LEFT || n == Handset.NUM5) {
            ((Widget)this.contents.elementAt(this.cursor)).select();
            return;
        }
        Object e = this.contents.elementAt(this.cursor);
        if (e instanceof KeyListener) {
            ((KeyListener)e).keyPressed(n);
        }
    }

    public final void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public final void keyReleased(int n) {
    }

    public final void addElement(Widget widget) {
        if (widget == null) {
            return;
        }
        this.contents.addElement(widget);
        this.contentHeight += widget.getHeight();
        this.updateFocus();
        this.calcInterval();
        this.calcDimensions();
    }

    public final void removeAllElements() {
        this.contents.removeAllElements();
        this.cursor = 0;
        this.calcInterval();
        this.calcDimensions();
    }

    public final void refresh() {
        for (int i = 0; i < this.contents.size(); ++i) {
            ((Anchored)this.contents.elementAt(i)).refresh();
        }
        this.updateFocus();
        this.calcInterval();
        this.calcDimensions();
    }

    public BasicMenu(int n) {
        this.maxHeight = n;
        this.contents = new Vector();
        this.contentHeight = 0;
        this.cursor = 0;
        this.refresh();
    }

    public final void setAlignment(int n) {
        this.alignment = n;
    }

    public final int getWindowX() {
        return 1;
    }

    public final int getWindowY() {
        return this.intervalEnd - this.intervalStart;
    }

    public final int getRangeX() {
        return 1;
    }

    public final int getRangeY() {
        return this.contents.size() - 1;
    }

    public final int getScrollX() {
        return 0;
    }

    public final int getScrollY() {
        return this.intervalStart;
    }
}

