/*
 * Decompiled with CFR 0.152.
 */
package de.mef.menu;

import de.mef.menu.Anchored;
import javax.microedition.lcdui.Graphics;

public final class ProgressBar
extends Anchored {
    private int range;
    private int progress;
    private int border;
    private int empty;
    private int full;

    public ProgressBar(int n, int n2, int n3) {
        this.range = n;
        this.height = n3;
        this.width = n2;
        this.setColor(0xC0C0C0, 0xFFFFFF, 16262180);
    }

    private ProgressBar() {
    }

    private void setColor(int n, int n2, int n3) {
        this.border = n;
        this.empty = n2;
        this.full = n3;
    }

    protected final void display(Graphics graphics) {
        if (this.empty != -1) {
            graphics.setColor(this.empty);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        graphics.setColor(this.full);
        if (this.range > 0) {
            graphics.fillRect(0, 0, this.progress * 1000 / this.range * this.width / 1000, this.height);
        } else {
            int n = (int)(System.currentTimeMillis() / 75L % 40L);
            int n2 = graphics.getClipHeight();
            int n3 = graphics.getClipWidth();
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = -20;
            while (n6 + n <= this.width) {
                graphics.setClip(0, 0, this.width, this.height);
                graphics.fillRect(n6 + n, 0, 20, this.height);
                n6 += 40;
            }
            graphics.setClip(n4, n5, n3, n2);
        }
        graphics.setColor(this.border);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    public final void refresh() {
    }

    public final void setProgress(int n) {
        this.progress = Math.min(n, this.range);
        this.progress = Math.max(this.progress, 0);
    }
}

