/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.CCar;
import main.CCarBase;
import main.CartoonRacer;
import main.LanguageManager;
import main.Platform;
import main.TRaceInfo;
import main.TRaceTimes;
import main.TTimesRecordVector;
import main.TTrackInfo;
import main.Utils;
import main.swvVector3D;

public class Window {
    private static final boolean USE_WRONG_WAY_IMAGE = false;
    int iLongL;
    int m_iCorner = -1;
    int m_iGear = 0;
    int m_iGearAnt = -1;
    int m_iCornerAnt = -1;
    int m_iCurrentFizz = 2;
    int m_iHUDturn = 0;
    float m_fGearPercent;
    int m_iSpeed = 0;
    int m_iRaceTime = 0;
    int m_iLap = 1;
    int m_iLapAnt = 0;
    boolean m_bRaceTimeNeg;
    int m_iCornerH;
    int m_iCornerW;
    int m_iWeaponY;
    int m_iWeaponW;
    int m_iWeaponH;
    int[] m_iPos = new int[4];
    int[] m_iPosAnt = new int[4];
    int m_iHUDBaseY;
    int m_iHUDBaseX;
    int m_iLapY;
    int m_iLapX;
    int m_iTimeX;
    int m_iTimeY;
    int m_iTimeWidth;
    int m_iTimeHeight;
    int m_iFontHeight;
    int m_iNeedleX;
    int m_iNeedleY;
    int m_iNeedleHeight;
    int m_iCalaveraX;
    int m_iCalaveraY;
    int m_iGearX;
    int m_iGearY;
    int m_iSpeedX;
    int m_iSpeedY;
    int m_iSpeedWidth;
    int m_iHUDImageWidth;
    int m_iHUDImageHeight;
    String sLongitudLiteral;
    String sVueltasLiteral;
    String sTiempoLiteral;
    String sLongitud;
    String sVueltas;
    String sTiempo;
    String m_sBestTimes;
    String[] m_sCircuit = new String[3];
    int iLongitudLong;
    int iVueltasLong;
    int iTiempoLong;
    String m_hRacer;
    String m_hPosicion;
    String m_hTiempo;
    String m_hPuntos;
    String m_hCat;
    CartoonRacer m_AppUi;
    TRaceInfo m_tRaceInfo;
    swvVector3D m_WorkVector3D = new swvVector3D();
    protected Image[] m_ImageCorner = new Image[6];
    protected Image m_HUDImage;
    protected Image m_OilIcon;
    protected Image m_RocketIcon;
    protected Image m_BombIcon;
    protected Image[] m_BombFizz = null;
    protected Image m_VelImage = null;
    protected Image m_WrongWayImage = null;
    protected Image m_PilotsImage = null;
    protected Image m_RiderImage = null;
    private Image[] m_ImageGangs = null;
    private int m_iPilotsImageW;
    private int m_iPilotsImageH;
    private int m_iRiderImageW;
    private int m_iRiderImageH;
    private int m_iVelImageX;
    private int m_iVelImageY;
    private boolean m_bBlink;
    private boolean m_bBlink2;
    private int m_iHeightGangs;
    char[] m_SpeedChars = new char[]{'0', '0', '0'};
    char[] m_TimeChars = new char[]{'0', '0', ':', '0', '0', ':', '0', '0'};
    String m_sKmh;
    String m_sGear;
    String m_sCat;
    String m_sLap;
    String m_sWrongWay;
    String m_sWrongWayPersistent;
    String m_sPos;
    String m_sBomb;
    int m_iBombWidth;
    int m_iKmhAncho;
    int m_iGearAncho;
    int m_iAlto;
    int m_iAltoBase;
    int m_iBase;
    int m_iCharTimeWidth;
    int m_iLapAncho;
    int m_iPosAncho;
    int m_iCharWidth;
    Font m_Font;
    boolean m_bRepaint = true;
    boolean m_bHasPUPAnt = false;
    boolean m_bHasBombAnt = false;
    boolean m_bShowHUD = true;
    String m_sTotalCarrera = null;
    String m_hVueltas = null;
    int[] iTiempo = new int[4];
    int[] m_iPosHUDAnt = new int[8];
    private float m_fAngle;
    private int[] m_iNeedle = new int[6];
    private int[] m_iNeedleAnt = new int[6];
    int[] m_iPosPUP = new int[10];
    int[] m_iPosPUPAnt = new int[10];
    int[] m_iKindOfPUP = new int[5];
    TTimesRecordVector m_Tiempos = null;
    private static final boolean TRIANGLE = true;

    Window(CartoonRacer p_Object) {
        this.m_AppUi = p_Object;
        if (this.m_ImageGangs == null) {
            this.createImageGangs();
        }
        this.m_sCircuit[0] = LanguageManager.GetString("M71");
        this.m_sCircuit[1] = LanguageManager.GetString("M72");
        this.m_sCircuit[2] = LanguageManager.GetString("M73");
    }

    Window(CartoonRacer p_Object, TRaceInfo p_ri, Font p_Font) {
        this.m_AppUi = p_Object;
        this.m_tRaceInfo = p_ri;
        this.m_Font = p_Font;
        if (this.m_AppUi.getGameState() >= 105) {
            try {
                this.m_ImageCorner[0] = Image.createImage((String)"/green_l.png");
                this.m_ImageCorner[1] = Image.createImage((String)"/yellow_l.png");
                this.m_ImageCorner[2] = Image.createImage((String)"/red_l.png");
                this.m_ImageCorner[3] = Image.createImage((String)"/green_r.png");
                this.m_ImageCorner[4] = Image.createImage((String)"/yellow_r.png");
                this.m_ImageCorner[5] = Image.createImage((String)"/red_r.png");
                this.m_iCornerW = this.m_ImageCorner[0].getWidth();
                this.m_iCornerH = this.m_ImageCorner[0].getHeight();
                this.m_sWrongWay = LanguageManager.GetString("M184");
                this.m_sWrongWayPersistent = LanguageManager.GetString("M186");
                this.m_sBomb = LanguageManager.GetString("M185");
                this.m_iBombWidth = this.m_Font.stringWidth(this.m_sBomb);
                this.m_VelImage = Image.createImage((String)"/velocimetro.png");
                this.m_PilotsImage = Image.createImage((String)"/gangs.png");
                this.m_iPilotsImageW = this.m_PilotsImage.getWidth() / 4;
                this.m_iPilotsImageH = this.m_PilotsImage.getHeight();
                this.m_RiderImage = Image.createImage((String)("/gang" + (this.m_AppUi.getRacer() + 1) + ".png"));
                this.m_iRiderImageW = this.m_RiderImage.getWidth();
                this.m_iRiderImageH = this.m_RiderImage.getHeight();
                if (this.m_AppUi.getKindOfRace() == 2 || this.m_AppUi.getKindOfRace() == 3) {
                    int aPlusW = 0;
                    Image aImage = null;
                    if (this.m_AppUi.getKindOfRace() == 3) {
                        this.m_BombIcon = Image.createImage((String)"/bomb.png");
                        this.m_BombFizz = new Image[3];
                        this.m_BombFizz[0] = Image.createImage((String)"/fizz1.png");
                        this.m_BombFizz[1] = Image.createImage((String)"/fizz2.png");
                        this.m_BombFizz[2] = Image.createImage((String)"/fizz3.png");
                        aImage = this.m_BombIcon;
                        aPlusW = this.m_BombFizz[0].getWidth();
                    } else {
                        this.m_RocketIcon = Image.createImage((String)"/rocket.png");
                        aImage = this.m_OilIcon = Image.createImage((String)"/oil.png");
                    }
                    this.m_iWeaponW = aImage.getWidth() + aPlusW;
                    this.m_iWeaponH = aImage.getHeight();
                    this.m_iWeaponY = 96 - this.m_iCornerH;
                    aImage = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setHUDTrack(this.m_tRaceInfo.tTrackInfo.iImageHud);
        this.m_sKmh = LanguageManager.GetString("M179");
        this.m_iKmhAncho = this.m_Font.stringWidth(this.m_sKmh);
        this.m_sGear = LanguageManager.GetString("M180");
        this.m_iGearAncho = this.m_Font.stringWidth(this.m_sGear);
        this.m_iAlto = this.m_Font.getHeight();
        this.m_iBase = this.m_Font.getBaselinePosition();
        this.m_iAltoBase = this.m_iAlto - this.m_iBase + 1;
        this.m_iBase -= this.m_iAltoBase;
        this.m_iCharTimeWidth = this.m_Font.stringWidth(" 00:00:00 ");
        this.m_sLap = LanguageManager.GetString("M182");
        this.m_iLapAncho = this.m_Font.stringWidth(this.m_sLap);
        this.m_iCharWidth = this.m_Font.charWidth('0');
        this.m_iLapX = 4 + (this.m_iHUDImageWidth >> 1) - (this.m_iLapAncho + this.m_iCharWidth >> 1);
        this.m_iLapY = this.m_iHUDImageHeight + 4;
        this.m_sPos = LanguageManager.GetString("M183");
        this.m_iPosAncho = this.m_Font.stringWidth(this.m_sPos);
        this.m_iFontHeight = this.m_Font.getHeight() + 0;
        int iFBLHeight = Platform.FONT_SYSTEM_BOLD_LARGE.getHeight() + 0;
        this.m_iTimeY = this.m_iLapY + this.m_iFontHeight + (this.m_iFontHeight >> 1);
        if (this.m_tRaceInfo.iKindOfRace == 3) {
            this.m_iTimeWidth = Platform.FONT_SYSTEM_BOLD_LARGE.charWidth('0') << 2;
            this.m_iTimeHeight = iFBLHeight;
            this.m_iTimeX = 80 - (this.m_iTimeWidth >> 1);
            if (this.m_iTimeY + iFBLHeight > 96) {
                this.m_iTimeY = 96 - iFBLHeight;
            }
        } else {
            this.m_iTimeWidth = this.m_Font.charsWidth(this.m_TimeChars, 0, 8);
            this.m_iTimeHeight = this.m_iFontHeight;
            this.m_iTimeX = 4 + (this.m_iHUDImageWidth >> 1) - (this.m_iTimeWidth >> 1);
        }
        if (this.m_iTimeX < 4) {
            this.m_iTimeX = 4;
        }
        this.m_iNeedleX = 316 - (this.m_VelImage.getWidth() >> 1);
        this.m_iNeedleY = 4 + this.m_VelImage.getHeight() - (int)((float)this.m_VelImage.getHeight() * 0.25f);
        this.m_iNeedleHeight = (int)((float)this.m_VelImage.getHeight() * 0.5f);
        this.m_iCalaveraX = this.m_iNeedleX;
        this.m_iCalaveraY = this.m_iNeedleY;
        this.m_iGearX = this.m_iNeedleX - (this.m_VelImage.getWidth() >> 1) + this.m_iCharWidth;
        this.m_iGearY = 4 + this.m_VelImage.getHeight() - this.m_iFontHeight;
        this.m_iSpeedWidth = this.m_Font.charsWidth(this.m_SpeedChars, 0, 3);
        this.m_iSpeedX = this.m_iNeedleX - (this.m_iSpeedWidth >> 1);
        this.m_iSpeedY = 4 + this.m_VelImage.getHeight();
        this.setGearPercent(0.0f);
        this.m_iPosAnt[3] = -1;
        this.m_iPosAnt[2] = -1;
        this.m_iPosAnt[1] = -1;
        this.m_iPosAnt[0] = -1;
        this.m_iPos[0] = 4;
        this.m_iPos[1] = 1;
        this.m_iPos[2] = 2;
        this.m_iPos[3] = 3;
    }

    private void createImageGangs() {
        this.m_iHeightGangs = 0;
        try {
            this.m_ImageGangs = new Image[4];
            this.m_ImageGangs[0] = Image.createImage((String)"/gang1.png");
            this.m_ImageGangs[1] = Image.createImage((String)"/gang2.png");
            this.m_ImageGangs[2] = Image.createImage((String)"/gang3.png");
            this.m_ImageGangs[3] = Image.createImage((String)"/gang4.png");
            int iIndex = this.m_ImageGangs.length;
            while (--iIndex >= 0) {
                if (this.m_iHeightGangs >= this.m_ImageGangs[iIndex].getHeight()) continue;
                this.m_iHeightGangs = this.m_ImageGangs[iIndex].getHeight();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCorner(int p_iCorner) {
        this.m_iCorner = p_iCorner < 0 || p_iCorner > 5 ? -1 : p_iCorner;
    }

    public void setRaceTime(int p_iTime) {
        this.m_iRaceTime = p_iTime;
        this.m_bRaceTimeNeg = this.m_iRaceTime < 0;
        Utils.TimeToCharsParam(this.m_bRaceTimeNeg ? 0 : this.m_iRaceTime, this.m_TimeChars);
    }

    public void setSpeed(float p_fSpeed) {
        this.m_iSpeed = (int)(p_fSpeed * 3.6f);
        Utils.IntToCharsParam(this.m_iSpeed, this.m_SpeedChars, 3, true);
    }

    public void setGear(int p_iGear) {
        this.m_iGear = p_iGear;
    }

    public void setPos(int aIndex, int p_iPos) {
        this.m_iPos[aIndex] = p_iPos;
    }

    public void setLap(int p_iLap) {
        this.m_iLap = p_iLap < 1 ? 1 : (p_iLap > 3 ? 3 : p_iLap);
    }

    public void setGearPercent(float p_fPercent) {
        this.m_fGearPercent = p_fPercent;
        this.m_fAngle = this.m_fGearPercent * 3.6f;
        if (this.m_fAngle > 3.6f) {
            this.m_fAngle = 3.6f;
        }
        this.m_iNeedle[0] = (int)(Math.cos(this.m_fAngle) * (double)this.m_iNeedleHeight);
        this.m_iNeedle[1] = (int)(Math.sin(this.m_fAngle) * (double)this.m_iNeedleHeight);
        this.m_fAngle = (float)((double)this.m_fAngle - 1.5707963267948966);
        this.m_iNeedle[2] = (int)(Math.cos(this.m_fAngle) * 3.0);
        this.m_iNeedle[3] = (int)(Math.sin(this.m_fAngle) * 3.0);
        this.m_fAngle = (float)((double)this.m_fAngle + Math.PI);
        this.m_iNeedle[4] = (int)(Math.cos(this.m_fAngle) * 3.0);
        this.m_iNeedle[5] = (int)(Math.sin(this.m_fAngle) * 3.0);
    }

    public void setHUDTrack(Image p_iImage) {
        this.m_HUDImage = p_iImage;
        this.m_iHUDImageWidth = this.m_HUDImage.getWidth();
        this.m_iHUDImageHeight = this.m_HUDImage.getHeight();
        this.m_iHUDBaseY = 4;
        this.m_iHUDBaseX = 4;
    }

    public void setTrackInfo(TTrackInfo p_TrackInfo) {
        this.sLongitudLiteral = LanguageManager.GetString("M171") + " ";
        this.sLongitud = p_TrackInfo.iLongitud + " mts.";
        this.sVueltasLiteral = LanguageManager.GetString("M172") + " ";
        this.sVueltas = "3";
        if (p_TrackInfo.iTiempo != 0) {
            this.sTiempoLiteral = LanguageManager.GetString("M173") + " ";
            this.sTiempo = Utils.timeToString(p_TrackInfo.iTiempo);
        } else {
            this.sTiempoLiteral = "";
            this.sTiempo = "";
        }
    }

    public void setPersonalTimes(TTimesRecordVector pTRV) {
        this.m_Font = Platform.FONT_MENU;
        this.m_hPosicion = LanguageManager.GetString("M174");
        this.m_hRacer = LanguageManager.GetString("M67");
        this.m_hTiempo = LanguageManager.GetString("M177");
        this.m_hCat = LanguageManager.GetString("M176");
        this.m_Tiempos = pTRV;
    }

    public void showPersonalBestTimes(Graphics g) {
        if (this.m_AppUi.getGameState() == 69) {
            Window.PaintTop(g);
        }
        Font aFont = g.getFont();
        g.setFont(this.m_Font);
        this._showPersonalBestTimes(g, false);
        this._showPersonalBestTimes(g, true);
        g.setFont(aFont);
    }

    private void _showPersonalBestTimes(Graphics gc, boolean p_bColor) {
        if (this.m_ImageGangs == null) {
            this.createImageGangs();
        }
        int iAlto = this.m_iHeightGangs + 1;
        int iPosY = this.m_AppUi.getGameState() == 69 ? 72 - iAlto + 0 : 92;
        int iDesplaX = 0;
        int iDesplaY = 0;
        int iMargen = 80;
        if (p_bColor) {
            gc.setColor(8033535);
        } else {
            gc.setColor(0);
            iDesplaY = -1;
            iDesplaX = -1;
        }
        if (this.m_Tiempos.iPosition != -1) {
            iPosY -= iPosY >> 2;
            gc.setFont(Platform.FONT_MENU_TITLE);
            if (this.m_sBestTimes == null) {
                this.m_sBestTimes = new String(LanguageManager.GetString("M5").toUpperCase());
            }
            gc.drawString(this.m_sBestTimes, 160, iPosY + iDesplaY, 17);
            iPosY += gc.getFont().getHeight() + 0;
            if (p_bColor) {
                gc.setColor(16711749);
            } else {
                gc.setColor(0);
            }
            String circuitName = "";
            switch (this.m_AppUi.getTrack() - 1) {
                case 0: {
                    circuitName = "M71";
                    break;
                }
                case 1: {
                    circuitName = "M72";
                    break;
                }
                case 2: {
                    circuitName = "M73";
                }
            }
            gc.drawString(LanguageManager.GetString(circuitName), 160, iPosY + iDesplaY, 17);
            iPosY += gc.getFont().getHeight() + 0;
            gc.setFont(this.m_Font);
        } else {
            iPosY += gc.getFont().getHeight() + 0 >> 1;
        }
        if (p_bColor) {
            gc.setColor(16711749);
        }
        gc.drawString(this.m_hRacer + " / " + this.m_hCat + " / " + this.m_hTiempo, 160 + iDesplaX, iPosY + iDesplaY, 17);
        iPosY = (int)((float)iPosY + (float)(this.m_Font.getHeight() + 0) * 2.5f);
        if (!p_bColor) {
            gc.setColor(0);
            iDesplaY = -1;
            iDesplaX = -1;
        }
        for (int aIndex = 0; aIndex < this.m_Tiempos.iHowMany && this.m_Tiempos.tTimes[aIndex].iTime != 0; ++aIndex) {
            String tTiempo = Utils.timeToString(this.m_Tiempos.tTimes[aIndex].iTime);
            if (p_bColor) {
                if (this.m_Tiempos.iPosition == aIndex) {
                    gc.setColor(16711749);
                } else {
                    gc.setColor(0xFFFFFF);
                }
            }
            gc.drawString(this.m_Tiempos.tTimes[aIndex].sName, 160 - iMargen + iDesplaX, iPosY + iDesplaY + 0, 17);
            if (p_bColor) {
                gc.drawImage(this.m_ImageGangs[this.m_Tiempos.tTimes[aIndex].iRacer], 160, iPosY + 0, 3);
            }
            gc.drawString(tTiempo, 160 + iMargen + iDesplaX, iPosY + iDesplaY + 0, 17);
            iPosY += iAlto;
        }
    }

    public void showTrackInfo1(Graphics g, Image aHUDImage, int p_iY, int[] viTranslateX) {
        this.showTrackInfo(g, aHUDImage, p_iY, -1, viTranslateX);
    }

    public void showTrackInfo2(Graphics g, Image aHUDImage, int p_iY, int p_iTrack) {
        this.showTrackInfo(g, aHUDImage, p_iY, p_iTrack, null);
    }

    public void showTrackInfo(Graphics g, Image aHUDImage, int p_iY, int p_iTrack, int[] viTranslateX) {
        boolean p_bNombre = p_iTrack != -1;
        this._showTrackInfo(g, aHUDImage, p_iY, p_bNombre, p_iTrack, false, viTranslateX);
        this._showTrackInfo(g, aHUDImage, p_iY, p_bNombre, p_iTrack, true, viTranslateX);
    }

    public void _showTrackInfo(Graphics g, Image aHUDImage, int p_iY, boolean p_bNombre, int p_iTrack, boolean p_bNormal, int[] viTranslateX) {
        int p_iYBase;
        Font aFont = g.getFont();
        int iAlto = aFont.getHeight();
        int SCREEN_WIDTH = 320;
        int p_iSepa = aFont.getHeight() + 0;
        int iY = p_iYBase = p_iY + p_iSepa * 2;
        if (p_bNormal && p_bNombre) {
            g.setColor(8033535);
            g.drawString(this.m_sCircuit[p_iTrack - 1], 25, p_iYBase - p_iSepa, 20);
        }
        if (p_bNormal) {
            g.setColor(16711749);
        } else {
            g.setColor(0);
        }
        int iBaseX1 = 25;
        if (viTranslateX != null) {
            iBaseX1 += viTranslateX[0];
        }
        this.iLongitudLong = aFont.stringWidth(this.sLongitudLiteral);
        g.drawString(this.sLongitudLiteral, p_bNormal ? iBaseX1 : iBaseX1 + 1, p_bNormal ? iY : iY + 1, 20);
        iY += p_iSepa;
        int iBaseX2 = 25;
        if (viTranslateX != null) {
            iBaseX2 += viTranslateX[1];
        }
        this.iVueltasLong = aFont.stringWidth(this.sVueltasLiteral);
        g.drawString(this.sVueltasLiteral, p_bNormal ? iBaseX2 : iBaseX2 + 1, p_bNormal ? iY : iY + 1, 20);
        iY += p_iSepa;
        int iBaseX3 = 25;
        if (this.sTiempo.length() != 0) {
            if (viTranslateX != null) {
                iBaseX3 += viTranslateX[2];
            }
            this.iTiempoLong = aFont.stringWidth(this.sTiempoLiteral);
            if (viTranslateX == null) {
                // empty if block
            }
            g.drawString(this.sTiempoLiteral, p_bNormal ? iBaseX3 : iBaseX3 + 1, p_bNormal ? iY : iY + 1, 20);
        } else if (viTranslateX != null) {
            viTranslateX[2] = 0;
        }
        if (p_bNormal) {
            g.setColor(0xFFFFFF);
        } else {
            g.setColor(0);
        }
        iY = p_iYBase;
        iBaseX1 = 25;
        if (viTranslateX != null) {
            iBaseX1 += viTranslateX[0];
        }
        g.drawString(this.sLongitud, p_bNormal ? iBaseX1 + this.iLongitudLong : iBaseX1 + this.iLongitudLong + 1, p_bNormal ? iY : iY + 1, 20);
        iY += p_iSepa;
        iBaseX2 = 25;
        if (viTranslateX != null) {
            iBaseX2 += viTranslateX[1];
        }
        g.drawString(this.sVueltas, p_bNormal ? iBaseX2 + this.iVueltasLong : iBaseX2 + this.iVueltasLong + 1, p_bNormal ? iY : iY + 1, 20);
        iBaseX3 = 25;
        if (this.sTiempo.length() != 0) {
            if (viTranslateX != null) {
                iBaseX3 += viTranslateX[2];
            }
            if (viTranslateX == null) {
                // empty if block
            }
            g.drawString(this.sTiempo, p_bNormal ? iBaseX3 + this.iTiempoLong : iBaseX3 + this.iTiempoLong + 1, p_bNormal ? iY : (iY += p_iSepa) + 1, 20);
        }
        if (p_bNormal) {
            int iBaseX4 = 25;
            if (viTranslateX != null) {
                iBaseX4 += viTranslateX[3];
            }
            iY += p_iSepa;
            if (aHUDImage != null) {
                g.drawImage(aHUDImage, iBaseX4, iY, 20);
            }
        }
        if (viTranslateX != null && viTranslateX[3] != 0) {
            if (viTranslateX[0] == -1) {
                viTranslateX[0] = 0;
            }
            viTranslateX[0] = viTranslateX[0] >> 1;
            if (viTranslateX[0] == 0) {
                if (viTranslateX[1] == -1) {
                    viTranslateX[1] = 0;
                }
                viTranslateX[1] = viTranslateX[1] >> 1;
                if (viTranslateX[1] == 0) {
                    if (viTranslateX[2] == -1) {
                        viTranslateX[2] = 0;
                    }
                    viTranslateX[2] = viTranslateX[2] >> 1;
                    if (viTranslateX[2] == 0) {
                        if (viTranslateX[3] == -1) {
                            viTranslateX[3] = 0;
                        }
                        viTranslateX[3] = viTranslateX[3] >> 1;
                    }
                }
            }
        }
    }

    public void showRace(Graphics g) {
        CCarBase[] a_Cars = this.m_tRaceInfo.m_Cars;
        CCar aUserCar = (CCar)a_Cars[0];
        TTrackInfo aTInfo = this.m_tRaceInfo.tTrackInfo;
        int iTotalRiders = this.m_tRaceInfo.iTotalRiders;
        int iKindOfRace = this.m_tRaceInfo.iKindOfRace;
        g.setStrokeStyle(0);
        Font aFont = g.getFont();
        if (aUserCar.isDrivingBackwards()) {
            g.setFont(Platform.FONT_WRONG_WAY);
            g.setColor(0xFF0000);
            String sWrongWay = null;
            sWrongWay = aUserCar.wrongWayPersistent() ? this.m_sWrongWayPersistent : this.m_sWrongWay;
            g.drawString(sWrongWay, 160, 96, 17);
        }
        if (this.m_bRepaint || this.m_iCornerAnt != this.m_iCorner) {
            if (this.m_iCorner != -1) {
                g.drawImage(this.m_ImageCorner[this.m_iCorner], 160, 96, 33);
            } else {
                g.setColor(3102130);
                g.fillRect(160 - (this.m_iCornerW >> 1), 96 - this.m_iCornerH, this.m_iCornerW, this.m_iCornerH);
            }
            this.m_iCornerAnt = this.m_iCorner;
        }
        g.setFont(this.m_Font);
        if (this.m_bShowHUD) {
            this.m_iHUDturn = this.m_iHUDturn < 3 ? ++this.m_iHUDturn : 0;
            if (this.m_bRepaint || this.m_iHUDturn == 0) {
                g.drawImage(this.m_HUDImage, 4, 4, 20);
            }
            swvVector3D aPos = this.m_WorkVector3D;
            int aIndex = 0;
            if (this.m_iHUDturn < iTotalRiders) {
                aIndex = this.m_iHUDturn;
            }
            a_Cars[aIndex].getPos(aPos);
            swvVector3D.restaV(aPos, aTInfo.vMin);
            aPos.x = aPos.x / aTInfo.vSize.x * (float)(aTInfo.bRotatedHud ? this.m_iHUDImageHeight : this.m_iHUDImageWidth);
            aPos.y = aPos.y / aTInfo.vSize.y * (float)(aTInfo.bRotatedHud ? this.m_iHUDImageWidth : this.m_iHUDImageHeight);
            if (aTInfo.bRotatedHud) {
                int iTemp = (int)aPos.x;
                aPos.x = (float)this.m_iHUDImageWidth - aPos.y;
                aPos.y = iTemp;
            }
            if (aPos.x - 2.0f < 0.0f) {
                aPos.x = 2.0f;
            } else if (aPos.x + 2.0f > (float)this.m_iHUDImageWidth) {
                aPos.x = this.m_iHUDImageWidth - 2;
            }
            if (aPos.y - 2.0f < 0.0f) {
                aPos.y = 2.0f;
            } else if (aPos.y + 2.0f > (float)this.m_iHUDImageHeight) {
                aPos.y = this.m_iHUDImageHeight - 2;
            }
            if (aIndex == 0) {
                g.setColor(65280);
                g.fillRect(this.m_iHUDBaseX + (int)aPos.x - 2, this.m_iHUDBaseY + this.m_iHUDImageHeight - (int)aPos.y - 2, 4, 4);
            } else {
                g.setColor(0xFFFF00);
                g.fillRect(this.m_iHUDBaseX + (int)aPos.x - 1, this.m_iHUDBaseY + this.m_iHUDImageHeight - (int)aPos.y - 1, 2, 2);
            }
            this.m_iPosHUDAnt[aIndex << 1] = (int)aPos.x;
            this.m_iPosHUDAnt[(aIndex << 1) + 1] = (int)aPos.y;
            if (this.m_iHUDturn == 0) {
                g.setColor(0xFFFF00);
                for (int iIndex = 1; iIndex < iTotalRiders; ++iIndex) {
                    g.fillRect(this.m_iHUDBaseX + this.m_iPosHUDAnt[iIndex << 1] - 1, this.m_iHUDBaseY + this.m_iHUDImageHeight - this.m_iPosHUDAnt[(iIndex << 1) + 1] - 1, 2, 2);
                }
            }
            if (iKindOfRace == 2) {
                int[] aiPosPUP = this.m_iPosPUP;
                int[] aiPosPUPAnt = this.m_iPosPUPAnt;
                aIndex = 5;
                while (--aIndex >= 0) {
                    int iIndexX2 = aIndex << 1;
                    if (aiPosPUP[iIndexX2] == Integer.MIN_VALUE) continue;
                    if (this.m_iHUDturn == 0 || this.m_iKindOfPUP[aIndex] == 0 || aiPosPUPAnt[iIndexX2] != aiPosPUP[iIndexX2] || aiPosPUPAnt[iIndexX2 + 1] != aiPosPUP[iIndexX2 + 1]) {
                        g.setColor(0);
                        g.fillRect(this.m_iHUDBaseX + aiPosPUPAnt[iIndexX2] - 2, this.m_iHUDBaseY + this.m_iHUDImageHeight - aiPosPUPAnt[iIndexX2 + 1] - 1 - 2, 4, 4);
                        if (this.m_iKindOfPUP[aIndex] == 0) {
                            aiPosPUP[iIndexX2] = Integer.MIN_VALUE;
                            continue;
                        }
                        aiPosPUPAnt[iIndexX2] = aiPosPUP[iIndexX2];
                        aiPosPUPAnt[iIndexX2 + 1] = aiPosPUP[iIndexX2 + 1];
                    }
                    g.setColor(this.m_iKindOfPUP[aIndex] == 1 ? 0xFF0000 : 0xFFFFFF);
                    g.fillRect(this.m_iHUDBaseX + aiPosPUP[iIndexX2] - 2, this.m_iHUDBaseY + this.m_iHUDImageHeight - aiPosPUP[iIndexX2 + 1] - 2, 4, 4);
                }
            }
        }
        if (iKindOfRace != 0) {
            boolean bRepaintWeapon = false;
            if (aUserCar.getLap() > 0 && this.m_AppUi.getGameState() != 116) {
                int iX = 160 - (this.m_iRiderImageW << 1);
                int iBombChase = 0;
                if (iKindOfRace == 3) {
                    iBombChase = 1;
                }
                if ((this.m_bRepaint || this.m_iPos[0] != this.m_iPosAnt[0]) && this.m_iPosAnt[0] != -1) {
                    g.setColor(3102130);
                    g.fillRect(iX + (iTotalRiders + iBombChase - this.m_iPosAnt[0]) * this.m_iRiderImageW - (this.m_iRiderImageW - this.m_iPilotsImageW), 0, this.m_iRiderImageW, this.m_iRiderImageH);
                }
                for (int aIndex = 1; aIndex < iTotalRiders; ++aIndex) {
                    if (!this.m_bRepaint && this.m_iPos[aIndex] == this.m_iPosAnt[aIndex]) continue;
                    int iRacer = a_Cars[aIndex].getRacer();
                    int iPos = iTotalRiders + iBombChase - this.m_iPos[aIndex];
                    if (this.m_iPosAnt[aIndex] != -1) {
                        g.setColor(3102130);
                        g.fillRect(iX + iPos * this.m_iPilotsImageW, 0, this.m_iPilotsImageW, this.m_iPilotsImageH);
                    }
                    g.drawRegion(this.m_PilotsImage, iRacer * this.m_iPilotsImageW, 0, this.m_iPilotsImageW, this.m_iPilotsImageH, 0, iX + iPos * this.m_iRiderImageW, 0, 20);
                    this.m_iPosAnt[aIndex] = this.m_iPos[aIndex];
                }
                if (this.m_bRepaint || this.m_iPos[0] != this.m_iPosAnt[0]) {
                    bRepaintWeapon = true;
                    g.drawImage(this.m_RiderImage, iX + (iTotalRiders + iBombChase - this.m_iPos[0]) * this.m_iRiderImageW - (this.m_iRiderImageW - this.m_iPilotsImageW), 0, 20);
                    this.m_iPosAnt[0] = this.m_iPos[0];
                }
            }
            if (iKindOfRace == 2) {
                if (this.m_bRepaint || this.m_bHasPUPAnt != aUserCar.hasPowerUp() || bRepaintWeapon) {
                    if (aUserCar.hasPowerUp()) {
                        if (aUserCar.getPowerUp() == 1) {
                            g.drawImage(this.m_RocketIcon, 160, this.m_iWeaponY, 33);
                        } else {
                            g.drawImage(this.m_OilIcon, 160, this.m_iWeaponY, 33);
                        }
                    } else {
                        g.setColor(3102130);
                        g.fillRect(160 - (this.m_iWeaponH >> 1), this.m_iWeaponY - this.m_iWeaponH, this.m_iWeaponW, this.m_iWeaponH);
                    }
                    this.m_bHasPUPAnt = aUserCar.hasPowerUp();
                }
            } else if (iKindOfRace == 3 && this.m_AppUi.getGameState() == 114) {
                if (this.m_bRepaint || this.m_bHasBombAnt != aUserCar.hasTheBomb()) {
                    if (aUserCar.hasTheBomb()) {
                        g.drawImage(this.m_BombIcon, 160, this.m_iWeaponY, 33);
                    } else {
                        g.setColor(3102130);
                        g.fillRect(160 - (this.m_iWeaponH >> 1), this.m_iWeaponY - this.m_iWeaponH, this.m_iWeaponW, this.m_iWeaponH);
                    }
                    this.m_bHasBombAnt = aUserCar.hasTheBomb();
                }
                if (aUserCar.hasTheBomb()) {
                    this.m_iCurrentFizz = this.m_iCurrentFizz == 2 ? 0 : ++this.m_iCurrentFizz;
                    g.drawImage(this.m_BombFizz[this.m_iCurrentFizz], 174, this.m_iWeaponY - this.m_iWeaponH, 17);
                }
            }
        }
        if (this.m_bRepaint) {
            g.drawImage(this.m_VelImage, 316, 4, 24);
            this.m_iNeedleAnt[0] = this.m_iNeedle[0];
            this.m_iNeedleAnt[1] = this.m_iNeedle[1];
            this.m_iNeedleAnt[2] = this.m_iNeedle[2];
            this.m_iNeedleAnt[3] = this.m_iNeedle[3];
            this.m_iNeedleAnt[4] = this.m_iNeedle[4];
            this.m_iNeedleAnt[5] = this.m_iNeedle[5];
        }
        g.setColor(3102130);
        g.fillTriangle(this.m_iNeedleX - this.m_iNeedleAnt[0], this.m_iNeedleY - this.m_iNeedleAnt[1], this.m_iNeedleX - this.m_iNeedleAnt[2], this.m_iNeedleY - this.m_iNeedleAnt[3], this.m_iNeedleX - this.m_iNeedleAnt[4], this.m_iNeedleY - this.m_iNeedleAnt[5]);
        g.setColor(16711749);
        g.fillTriangle(this.m_iNeedleX - this.m_iNeedle[0], this.m_iNeedleY - this.m_iNeedle[1], this.m_iNeedleX - this.m_iNeedle[2], this.m_iNeedleY - this.m_iNeedle[3], this.m_iNeedleX - this.m_iNeedle[4], this.m_iNeedleY - this.m_iNeedle[5]);
        this.m_iNeedleAnt[2] = this.m_iNeedle[2];
        this.m_iNeedleAnt[3] = this.m_iNeedle[3];
        this.m_iNeedleAnt[4] = this.m_iNeedle[4];
        this.m_iNeedleAnt[5] = this.m_iNeedle[5];
        this.m_iNeedleAnt[0] = this.m_iNeedle[0];
        this.m_iNeedleAnt[1] = this.m_iNeedle[1];
        g.drawImage(CartoonRacer.ms_CalaveraImage, this.m_iCalaveraX, this.m_iCalaveraY, 3);
        g.setColor(3102130);
        g.drawChar((char)(this.m_iGearAnt + 48), this.m_iGearX, this.m_iGearY, 20);
        g.setColor(this.m_fGearPercent > 0.95f ? 0xFF0808 : 0xFFFFFF);
        g.drawChar((char)(this.m_iGear + 48), this.m_iGearX, this.m_iGearY, 20);
        this.m_iGearAnt = this.m_iGear;
        g.setColor(3102130);
        g.fillRect(this.m_iSpeedX, this.m_iSpeedY, this.m_iSpeedWidth, this.m_iFontHeight);
        g.fillRect(this.m_iTimeX, this.m_iTimeY, this.m_iTimeWidth, this.m_iTimeHeight);
        g.setColor(0xFFFFFF);
        if (this.m_bRepaint) {
            g.drawString(this.m_sLap, this.m_iLapX, this.m_iLapY, 20);
        }
        Font f = g.getFont();
        if (this.m_bRaceTimeNeg) {
            g.setColor(0xFF0000);
        }
        if (iKindOfRace == 3) {
            g.setFont(Platform.FONT_SYSTEM_BOLD_LARGE);
            if (this.m_iRaceTime > 0 && this.m_iRaceTime <= 10000) {
                if (this.m_bBlink) {
                    g.setColor(0xFFFF00);
                    this.m_bBlink = false;
                } else {
                    g.setColor(0xFF0000);
                    this.m_bBlink = true;
                }
            } else {
                g.setColor(0xFFFF00);
            }
        }
        if (iKindOfRace == 3) {
            if (this.m_iRaceTime > 60000) {
                g.drawChars(this.m_TimeChars, 1, 4, this.m_iTimeX, this.m_iTimeY, 20);
            } else {
                g.drawChars(this.m_TimeChars, 3, 2, this.m_iTimeX, this.m_iTimeY, 20);
            }
            g.setFont(f);
        } else {
            g.drawChars(this.m_TimeChars, 0, 8, this.m_iTimeX, this.m_iTimeY, 20);
        }
        if (this.m_bRaceTimeNeg) {
            g.setColor(0xFFFFFF);
        }
        if (this.m_bRepaint || this.m_iLap != this.m_iLapAnt) {
            g.setColor(3102130);
            g.drawChar((char)(this.m_iLapAnt + 48), this.m_iLapX + this.m_iLapAncho, this.m_iLapY, 20);
            g.setColor(0xFFFFFF);
            g.drawChar((char)(this.m_iLap + 48), this.m_iLapX + this.m_iLapAncho, this.m_iLapY, 20);
            this.m_iLapAnt = this.m_iLap;
        }
        g.setColor(0xFFFFFF);
        g.drawChars(this.m_SpeedChars, 0, 3, this.m_iSpeedX, this.m_iSpeedY, 20);
        g.setFont(aFont);
        this.m_bRepaint = false;
    }

    void clearPowerUp(int aIndex) {
        this.m_iKindOfPUP[aIndex] = 0;
    }

    void setPowerUp(int aIndex, float[] aPos2D, int p_iKind) {
        swvVector3D aPos = this.m_WorkVector3D;
        TTrackInfo aTInfo = this.m_tRaceInfo.tTrackInfo;
        aPos.x = aPos2D[0] - aTInfo.vMin.x;
        aPos.y = aPos2D[1] - aTInfo.vMin.y;
        aPos.x = aPos.x / aTInfo.vSize.x * (float)(aTInfo.bRotatedHud ? this.m_iHUDImageHeight : this.m_iHUDImageWidth);
        aPos.y = aPos.y / aTInfo.vSize.y * (float)(aTInfo.bRotatedHud ? this.m_iHUDImageWidth : this.m_iHUDImageHeight);
        if (aTInfo.bRotatedHud) {
            int iTemp = (int)aPos.x;
            aPos.x = (float)this.m_iHUDImageWidth - aPos.y;
            aPos.y = iTemp;
        }
        if (aPos.x - 2.0f < 0.0f) {
            aPos.x = 2.0f;
        } else if (aPos.x + 2.0f > (float)this.m_iHUDImageWidth) {
            aPos.x = this.m_iHUDImageWidth - 2;
        }
        if (aPos.y - 2.0f < 0.0f) {
            aPos.y = 2.0f;
        } else if (aPos.y + 2.0f > (float)this.m_iHUDImageHeight) {
            aPos.y = this.m_iHUDImageHeight - 2;
        }
        this.m_iPosPUP[aIndex << 1] = (int)aPos.x;
        this.m_iPosPUP[(aIndex << 1) + 1] = (int)aPos.y;
        this.m_iKindOfPUP[aIndex] = p_iKind;
    }

    private static void PaintTop(Graphics g) {
        g.setColor(3102130);
        g.setStrokeStyle(0);
        g.fillRect(0, 0, 320, 96);
    }

    void displayUserTime(Graphics g) {
        if (this.m_bRepaint) {
            Window.PaintTop(g);
            this.m_bRepaint = false;
        }
        Font aFont = g.getFont();
        g.setFont(Platform.FONT_DISPLAY_USER_TIME);
        int MARGEN_X = 20;
        int KRgbTitulo = 8033535;
        int KRgbDetalle = 16711749;
        int KRgbBlack = 0;
        this.iTiempo[0] = this.m_AppUi.getLapControl().getTotalTime(0);
        for (int iIndex = 0; iIndex < 3; ++iIndex) {
            this.iTiempo[iIndex + 1] = this.m_AppUi.getLapControl().getLapTime(0, iIndex + 1);
        }
        int alto = g.getFont().getHeight() + 0;
        int iPosY = 67;
        if (this.m_sTotalCarrera == null) {
            this.m_sTotalCarrera = LanguageManager.GetString("M181");
            this.m_hVueltas = LanguageManager.GetString("M192");
        }
        int ancho = g.getFont().stringWidth(this.m_sTotalCarrera) >> 1;
        g.setColor(KRgbBlack);
        g.drawString(this.m_sTotalCarrera, 160 - ancho - 1, iPosY - 1, 20);
        g.setColor(KRgbTitulo);
        g.drawString(this.m_sTotalCarrera, 160 - ancho, iPosY, 20);
        ancho = g.getFont().charsWidth(Utils.Chars.Time(this.iTiempo[0]), 0, Utils.Chars.TIME_LENGTH) >> 1;
        g.setColor(KRgbBlack);
        g.drawChars(Utils.Chars.Time(this.iTiempo[0]), 0, Utils.Chars.TIME_LENGTH, 160 - ancho - 1, (iPosY += alto) - 1, 20);
        g.setColor(KRgbDetalle);
        g.drawChars(Utils.Chars.Time(this.iTiempo[0]), 0, Utils.Chars.TIME_LENGTH, 160 - ancho, iPosY, 20);
        ancho = g.getFont().stringWidth(this.m_hVueltas) >> 1;
        g.setColor(KRgbBlack);
        g.drawString(this.m_hVueltas, 160 - ancho - 1, (iPosY += alto + (alto >> 1)) - 1, 20);
        g.setColor(KRgbTitulo);
        g.drawString(this.m_hVueltas, 160 - ancho, iPosY, 20);
        iPosY += alto;
        int ancho0 = g.getFont().charWidth('0') + g.getFont().charWidth('.') + g.getFont().charWidth('-') + this.m_Font.charWidth(' ');
        int ancho1 = ancho0 + g.getFont().charWidth('0') * 8;
        for (int iIndex = 0; iIndex < 3; ++iIndex) {
            ancho = ancho1 >> 1;
            g.setColor(KRgbBlack);
            g.drawChar((char)(iIndex + 1 + 48), 160 - ancho - 1, iPosY - 1, 20);
            g.drawChars(Utils.Chars.Time(this.iTiempo[iIndex + 1]), 0, Utils.Chars.TIME_LENGTH, 160 - ancho - 1 + ancho0, iPosY - 1, 20);
            g.setColor(KRgbDetalle);
            g.drawChar((char)(iIndex + 1 + 48), 160 - ancho, iPosY, 20);
            g.drawChars(Utils.Chars.Time(this.iTiempo[iIndex + 1]), 0, Utils.Chars.TIME_LENGTH, 160 - ancho + ancho0, iPosY, 20);
            iPosY += alto;
        }
        g.setFont(aFont);
    }

    private void _displayRaceTimes(Graphics gc, boolean p_bColor) {
        int iAlto = this.m_RiderImage.getHeight() + 1;
        int iPosY = 67 + (this.m_Font.getHeight() + 0) + (iAlto >> 1);
        int iDesplaX = 0;
        int iDesplaY = 0;
        if (!p_bColor) {
            gc.setColor(0);
            iDesplaY = -1;
            iDesplaX = -1;
        }
        int aTime = this.m_AppUi.getCurrentTime() / 500;
        TRaceTimes pTiempos = this.m_AppUi.getRaceTimes();
        int iTotalCars = this.m_AppUi.getLapControl().getTotalCars();
        int iMargen = 80;
        for (int aIndex = 0; aIndex < iTotalCars; ++aIndex) {
            String tTiempo = Utils.timeToString(pTiempos.viTimes[aIndex]);
            int iRacer = this.m_tRaceInfo.m_Cars[pTiempos.viCarIndex[aIndex]].getRacer();
            if (p_bColor) {
                if (pTiempos.viCarIndex[aIndex] == 0) {
                    gc.drawImage(this.m_RiderImage, 160 - iMargen, iPosY + 0, 6);
                } else {
                    gc.drawRegion(this.m_PilotsImage, iRacer * this.m_iPilotsImageW, 0, this.m_iPilotsImageW, this.m_iPilotsImageH, 0, 160 - iMargen, iPosY + 0, 6);
                }
                if (pTiempos.viCarIndex[aIndex] == 0) {
                    gc.setColor(16711749);
                } else {
                    gc.setColor(0xFFFFFF);
                }
            }
            gc.drawString(tTiempo, 160 + iMargen + iDesplaX, iPosY + 0 + iDesplaY, 17);
            iPosY += iAlto;
            if (aTime <= aIndex) break;
        }
    }

    void displayRaceTimes(Graphics g) {
        if (this.m_bRepaint) {
            Window.PaintTop(g);
            this.m_bRepaint = false;
        }
        Font aFont = g.getFont();
        g.setFont(Platform.FONT_DISPLAY_RACER_TIMES);
        int iHeight = g.getFont().getHeight() + 0;
        String sTitle = LanguageManager.GetString("M140");
        g.setColor(0);
        g.drawString(sTitle, 160, 67 - iHeight, 17);
        g.setColor(8033535);
        g.drawString(sTitle, 159, 67 - iHeight - 1, 17);
        this._displayRaceTimes(g, false);
        this._displayRaceTimes(g, true);
        g.setFont(aFont);
    }

    void resetRace() {
        this.setLap(1);
        this.setRaceTime(0);
        this.setSpeed(0.0f);
        this.setGear(0);
        this.setGearPercent(0.0f);
        this.m_iPosAnt[3] = -1;
        this.m_iPosAnt[2] = -1;
        this.m_iPosAnt[1] = -1;
        this.m_iPosAnt[0] = -1;
        this.m_iPos[0] = 4;
        this.m_iPos[1] = 1;
        this.m_iPos[2] = 2;
        this.m_iPos[3] = 3;
        this.m_iGearAnt = -1;
        this.m_iCornerAnt = -1;
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            this.m_iPosPUPAnt[iIndex * 2] = Integer.MIN_VALUE;
            this.m_iPosPUP[iIndex * 2] = Integer.MIN_VALUE;
        }
        this.m_bBlink2 = false;
        this.m_bBlink = false;
        this.m_iCurrentFizz = 2;
        this.m_iHUDturn = 0;
    }

    void repaint() {
        this.m_bRepaint = true;
    }

    void destroy() {
        this.m_Tiempos = null;
        this.m_iPosHUDAnt = null;
        this.m_iPos = null;
        this.m_iPosAnt = null;
        this.m_sBestTimes = null;
        this.iTiempo = null;
        this.m_iNeedleAnt = null;
        this.m_iNeedle = null;
        this.m_SpeedChars = null;
        this.m_TimeChars = null;
        this.m_WorkVector3D = null;
        this.m_WrongWayImage = null;
        this.m_OilIcon = null;
        this.m_RocketIcon = null;
        this.m_BombIcon = null;
        this.m_PilotsImage = null;
        this.m_RiderImage = null;
        this.m_VelImage = null;
        this.m_HUDImage = null;
        if (this.m_BombFizz != null) {
            this.m_BombFizz[2] = null;
            this.m_BombFizz[1] = null;
            this.m_BombFizz[0] = null;
            this.m_BombFizz = null;
        }
        if (this.m_ImageGangs != null) {
            this.m_ImageGangs[3] = null;
            this.m_ImageGangs[2] = null;
            this.m_ImageGangs[1] = null;
            this.m_ImageGangs[0] = null;
            this.m_ImageGangs = null;
        }
        for (int aIndex = 0; aIndex < this.m_ImageCorner.length; ++aIndex) {
            this.m_ImageCorner[aIndex] = null;
        }
        this.m_ImageCorner = null;
        for (int iIndex = 0; iIndex < 3; ++iIndex) {
            this.m_sCircuit[iIndex] = null;
        }
    }
}

