/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import main.CBezierTrack;
import main.CCarBase;
import main.Colisions;
import main.GameSettings;
import main.MyMath;
import main.Symbian;
import main.TData;
import main.Utils;
import main.Window;

public class CCar
extends CCarBase {
    protected static final int MAX_GEARS = 6;
    protected Node m_BikeAccelBrake;
    protected Node m_hFrontView;
    protected boolean m_bLastBounceNeg;
    protected boolean m_bLejosCP;
    protected boolean m_bShowingCorner;
    protected boolean m_bSoftBrake;
    protected boolean m_bAccelBeforeGear;
    protected boolean m_bTrackColision;
    protected int m_iLastAction;
    protected int m_iTimeOutVibra;
    protected int m_iWaitForVibrateAgain;
    protected int m_iTimeSlowingDown;
    protected float m_fTimeInWrongWay;
    protected boolean m_bCanVibrate;
    protected boolean m_bTrackSlowDown;
    protected boolean m_bForceStop;
    protected float m_fGearPercent;
    protected float m_fSteerInc;
    protected float m_fSteering;
    protected float m_fSteeringTime;
    protected float m_fSkidding;
    protected float m_fTurnFactor;
    protected float[] m_fHeadPos = new float[3];
    protected boolean m_bWrongDirection;
    protected boolean m_bNoTurn;
    protected long m_lTimeoutWrongDirection;
    protected int m_iColisionState;
    protected float m_fBrakeFX = 0.0f;
    protected float m_fStandingStart = 5.0f;
    protected int m_nCurrentGear = 0;
    protected float m_TimeWithoutTurn = 0.0f;
    protected int m_iTurnAnt2;
    protected int m_iTurnAnt;
    protected int m_iTurn;
    protected static final float FIXED_WEIGHT = 0.145f;
    protected static final int SLOWDOWN_TIME = 1000;
    protected TGear[] m_Gearbox = new TGear[6];
    protected Node m_trackWorld;
    protected float m_wrongWay = 0.0f;
    protected int m_iShowingCornerTime;
    private int m_iKindOfRace;
    protected float[] m_float2Temp3 = new float[2];
    protected float[] m_float2Temp4 = new float[2];
    protected float[] m_float2Temp5 = new float[2];
    protected float[] direction = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
    protected float[] m_newPosition = new float[3];
    private static final float FIXED_FRICTION = 0.9999f;
    private static final float FIXED_GRAVITY = 9.8f;
    private static final int INT_BRAKEFACTOR = 3;
    private static final float FIXED_FRICGRAV = 9.79902f;
    private static final float FIXED_FRICGRAV_WEIGHT = 67.57945f;
    private static final float FIXED_BRAKE_DECEL = 202.73836f;
    private static final float OUTOFTRACK_SPEED_DECREASE_FACTOR = 17.0f;
    private static final float EXTRA_OUTOFTRACK_SPEED_DECREASE_FACTOR = 5.0f;
    private static final float DISTANCE_TO_START_CHECKING_TRACK_COLISION = 0.95f;
    private static final float DISTANCE_TO_START_DECREASING_SPEED = 0.625f;
    private static final float DISTANCE_TO_START_MIXING_ANGLES = 300.0f;
    private static final float DISTANCE_TO_START_MIXING_ANGLES_INV = 0.0033333334f;
    public static final int NO_TURN_STEERING_TIME_FACTOR = 5;
    public static final int NO_TURN_STEERING_FACTOR = 35;

    CCar(World p_World, int p_IdRoll, CBezierTrack p_BezierTrack, Colisions pColisions, Window p_Window, int p_Racer, int p_iSense) {
        super(p_World, p_IdRoll, p_BezierTrack, pColisions, p_Window, p_iSense);
        this.m_iRacer = p_Racer;
        if (this.m_AllRight) {
            this.m_hBackHead[this.m_iRacer].getTranslation(this.m_fHeadPos);
            this.m_hFrontView = (Node)this.m_BikeRoll.find(1007039349);
            this.m_BikeAccelBrake = null;
            this.m_fStandingStart = 5.0f;
            this.m_nCurrentGear = 0;
            this.m_TimeWithoutTurn = 0.0f;
            this.m_iTurn = 0;
            this.m_iTurnAnt = 0;
            this.m_iTurnAnt2 = 0;
            int[] iMaxSpeed = new int[]{24, 34, 44, 52, 56, 59};
            int[] iSpeedToChange = new int[]{21, 31, 42, 50, 54, 57};
            int[] iAcceleration = new int[]{60, 50, 40, 30, 20, 10};
            for (int iIndice = 0; iIndice < 6; ++iIndice) {
                this.m_Gearbox[iIndice] = new TGear();
                this.m_Gearbox[iIndice].fSpeed = (float)iMaxSpeed[iIndice] * TData.m_fRIDER_ATTR_FACTOR[this.m_iRacer][2];
                this.m_Gearbox[iIndice].fSpeedShouldChange = (float)iSpeedToChange[iIndice] * TData.m_fRIDER_ATTR_FACTOR[this.m_iRacer][2];
                this.m_Gearbox[iIndice].fAcceleration = (float)iAcceleration[iIndice] * TData.m_fRIDER_ATTR_FACTOR[this.m_iRacer][0];
                this.m_Gearbox[iIndice].fInvSpeed = 1.0f / this.m_Gearbox[iIndice].fSpeed;
            }
            this.m_fTurnFactor = TData.m_fRIDER_ATTR_FACTOR[this.m_iRacer][1];
            Symbian.transform_getPosition(this.m_BikeDyn, this.m_IniPos);
            this.m_IniYawAngle = p_iSense == 1 ? 1.5707964f : 0.0f;
            this.m_iKindOfRace = TData.GetCanvas().getKindOfRace();
            this.Reset();
        }
    }

    boolean isConsistent() {
        return this.m_AllRight;
    }

    float getRelSpeedToMaxSpeed() {
        return this.m_fSpeed * this.m_Gearbox[5].fInvSpeed;
    }

    float getSkidding() {
        return this.m_OriYawSkid.angle;
    }

    void vibrate(int aTime) {
        if (aTime == 0) {
            TData.GetDisplay().vibrate(0);
            this.m_bCanVibrate = true;
        } else if (GameSettings.m_bVibra && !this.m_HaveFinishedRace) {
            TData.GetDisplay().vibrate(0);
            this.m_bCanVibrate = false;
            this.m_iWaitForVibrateAgain = aTime << 1;
            this.m_iTimeOutVibra = this.m_iRaceTime;
            TData.GetDisplay().vibrate(aTime);
        }
    }

    boolean colisionWithTrack() {
        return this.m_bTrackColision;
    }

    void ResetDyn() {
        this.moveFreeTo(this.m_IniPos);
        this.m_fSkidding = 0.0f;
        this.m_fSteeringTime = 0.0f;
        this.m_fSpeed = 0.0f;
        this.m_fSpeedAnt = 0.0f;
        this.m_OriYaw.angle = this.m_IniYawAngle;
        this.m_OriYawSkid.angle = 0.0f;
        Symbian.transform_setOrientation(this.m_BikeYaw, this.m_OriYaw);
        Symbian.transform_setOrientation(this.m_BikeYawSkid, this.m_OriYawSkid);
        if (this.m_BikeAccelBrake != null) {
            this.m_OriAccel.angle = 0.0f;
            Symbian.transform_setOrientation(this.m_BikeAccelBrake, this.m_OriAccel);
        }
        this.m_bAccel = false;
        this.m_bBrake = false;
        this.m_bSoftBrake = false;
        this.m_bAccelBeforeGear = false;
        this.m_fGearPercent = 0.0f;
        this.m_fAcc = 0.0f;
        this.m_fAccAnt = 0.0f;
        this.m_fInc = 0.0f;
        this.m_nCurrentGear = 0;
        this.m_TimeWithoutTurn = 0.0f;
        this.m_iTurn = 0;
        this.m_iTurnAnt = 0;
        this.m_iTurnAnt2 = 0;
        this.m_iLastAction = 0;
        this.m_lTimeoutWrongDirection = 0L;
        this.m_fTimeInWrongWay = 0.0f;
        this.m_bForceStop = false;
        this.m_bWrongDirection = false;
        this.m_iColisionState = 0;
        this.m_wrongWay = 0.0f;
        this.m_Window.setCorner(-1);
    }

    void updateBackHead(float ayawrad) {
        this.m_hBackHead[this.m_iRacer].setOrientation(ayawrad * 57.29578f, 0.0f, 0.0f, 1.0f);
    }

    void Reset() {
        super.Reset();
        this.ResetDyn();
        this.m_hBackHead[this.m_iRacer].setRenderingEnable(true);
        this.m_hFrontHead[this.m_iRacer].setRenderingEnable(false);
        this.m_h3DHead[this.m_iRacer].setRenderingEnable(false);
        this.m_iIndexSpeedPoint = this.m_Track.FindIndexSpeedPoint(this.m_BikeDyn);
        this.m_iIndexSpeedPoint = this.m_iIndexSpeedPoint == this.m_Track.GetNumberOfSpeedPoints() - 1 ? 0 : ++this.m_iIndexSpeedPoint;
        this.m_CurrentSpeedPoint = this.m_Track.GetSpeedPoint(this.m_iIndexSpeedPoint);
        this.m_iIndexCornerPoint = 0;
        this.m_iIndexNextCornerPoint = 1;
        this.m_CurrentCornerPoint = this.m_Track.GetCornerPoint(this.m_iIndexCornerPoint);
        this.m_NextCornerPoint = this.m_Track.GetCornerPoint(this.m_iIndexNextCornerPoint);
        this.m_iIndexCornerPointAnt = -1;
        this.m_HaveFinishedRace = false;
        this.m_iTimeOutVibra = 0;
        this.m_bLejosCP = true;
        this.m_bShowingCorner = false;
        this.m_bShiftWithin = false;
        this.m_HaveFinishedRace = false;
        this.m_bCanVibrate = true;
        this.m_bLastBounceNeg = false;
        this.m_bTrackSlowDown = false;
        this.m_bNoTurn = false;
    }

    void setAccelBrakeID(int p_iIDAccelBrake) {
        if (this.m_BikeAccelBrake != null) {
            this.m_OriAccel.angle = 0.0f;
            Symbian.transform_setOrientation(this.m_BikeAccelBrake, this.m_OriAccel);
            Symbian.engine_ReleaseHandle((Object3D)this.m_BikeAccelBrake);
        }
        if (p_iIDAccelBrake != 0) {
            this.m_BikeAccelBrake = (Node)Symbian.wworld_findNode((Object3D)this.m_World, p_iIDAccelBrake);
        }
    }

    void shiftGearUp() {
        if (this.m_bAccelBeforeGear) {
            this.m_bAccelBeforeGear = false;
        } else if (this.m_nCurrentGear < 6) {
            if (this.m_nCurrentGear == 0 || this.m_iLastAction != 1) {
                ++this.m_nCurrentGear;
            } else if (this.m_iLastAction == 1 && this.m_nCurrentGear != 0 && this.m_fSpeed >= this.m_Gearbox[this.m_nCurrentGear - 1].fSpeedShouldChange) {
                ++this.m_nCurrentGear;
            }
        }
        this.m_bAccel = true;
        this.m_bBrake = false;
        this.m_fBrakeFX = 0.0f;
        this.m_BikeClip.setOrientation(this.m_fBrakeFX, 0.0f, 0.0f, 1.0f);
    }

    void adjustGear() {
        if (this.m_fSpeed <= 0.0f) {
            this.m_fSpeed = 0.0f;
            this.m_nCurrentGear = 1;
            this.m_bBrake = true;
            this.m_bAccel = false;
            this.m_bAccelBeforeGear = false;
        } else {
            boolean bEnter = false;
            for (int iIndex = 6; iIndex > 1; --iIndex) {
                if (this.m_fSpeed < this.m_Gearbox[iIndex - 1].fSpeedShouldChange) continue;
                if (this.m_nCurrentGear > iIndex + 1) {
                    this.m_nCurrentGear = iIndex + 1;
                    this.m_bBrake = false;
                    this.m_bAccelBeforeGear = true;
                }
                bEnter = true;
                break;
            }
            if (!bEnter) {
                this.m_nCurrentGear = 1;
            }
        }
    }

    private void manageMovement(float p_Time) {
        float TIME_TO_START_SKIDDING = 0.03f;
        float MINIMUM_SPEED_TO_SKID = 10.0f;
        float STEERING_SKID_FACTOR = 0.0625f;
        float INC_SKID_FACTOR = 0.145f;
        float GIVE_UP_SKID_FACTOR = 0.7f;
        if (this.m_fSpeed > 0.0f) {
            float fTempSkidding = 0.0f;
            if (this.m_fSteeringTime > 0.03f && this.m_fSpeed > 10.0f) {
                fTempSkidding = this.m_fSteeringTime - 0.03f + (this.m_fSpeed - 10.0f);
                this.m_fSkidding = (fTempSkidding *= this.m_fSteering * 0.0625f) >= 0.0f ? (this.m_fSkidding < fTempSkidding ? (this.m_fSkidding += fTempSkidding * 0.145f) : fTempSkidding) : (this.m_fSkidding > fTempSkidding ? (this.m_fSkidding += fTempSkidding * 0.145f) : fTempSkidding);
            }
            if (fTempSkidding == 0.0f) {
                this.m_fSkidding *= 0.7f;
            }
            if (MyMath.fabs(this.m_fSkidding) < 1.0E-4f) {
                this.m_fSkidding = 0.0f;
            }
            this.m_OriYawSkid.angle = this.m_fSkidding;
            Symbian.transform_setOrientation(this.m_BikeYawSkid, this.m_OriYawSkid);
        }
    }

    public void brake() {
        this.m_bBrake = true;
    }

    void updateDynamics(float p_Time, int p_iRaceTime) {
        boolean bDireccionProhibida = false;
        this.m_iRaceTime = p_iRaceTime;
        p_Time *= 1.0E-4f;
        this.m_bAccel = true;
        boolean aBrake = this.m_bBrake;
        if (this.m_bRollingOver) {
            int aRollingTime;
            if (!this.m_hFrontView.isRenderingEnabled()) {
                this.m_hFrontView.setRenderingEnable(true);
            }
            if (!this.m_h3DHead[this.m_iRacer].isRenderingEnabled()) {
                this.m_h3DHead[this.m_iRacer].setRenderingEnable(true);
                this.m_hBackHead[this.m_iRacer].setRenderingEnable(false);
                this.m_hFrontHead[this.m_iRacer].setRenderingEnable(false);
            }
            if ((aRollingTime = this.m_iRaceTime - this.m_iRollingTime) < 2000) {
                this.manageSoftBrake(120.0f * p_Time);
                this.spin(aRollingTime);
            } else {
                if (this.m_hFrontView.isRenderingEnabled()) {
                    this.m_hFrontView.setRenderingEnable(false);
                }
                this.stopRollingOver();
            }
        } else {
            this.manageTurn(p_Time);
            if (!this.m_bForceStop) {
                this.manageSpeed(p_Time);
                this.manageMovement(p_Time);
            } else {
                this.m_bBrake = true;
            }
        }
        this.m_OriYaw.angle += this.m_fSteering + this.m_fSkidding * 0.01f;
        if (this.m_OriYaw.angle < (float)(-Math.PI)) {
            this.m_OriYaw.angle += (float)Math.PI * 2;
        } else if (this.m_OriYaw.angle > (float)Math.PI) {
            this.m_OriYaw.angle -= (float)Math.PI * 2;
        }
        Symbian.transform_setOrientation(this.m_BikeYaw, this.m_OriYaw);
        float fAbsDistanceToCenter = MyMath.fabs(this.m_fDistanceToCenter);
        if (fAbsDistanceToCenter > 0.625f) {
            float fBounce;
            float aSpeedFactor = fAbsDistanceToCenter >= 0.875f ? 17.0f : 12.75f;
            float f = fBounce = this.m_fSpeed == 0.0f ? 0.0f : (Utils.m_Random.nextFloat() - 0.5f) * 0.009f;
            if (this.m_bLastBounceNeg) {
                if (fBounce < 0.0f) {
                    fBounce = -fBounce;
                }
                this.m_bLastBounceNeg = false;
            } else {
                if (fBounce > 0.0f) {
                    fBounce = -fBounce;
                }
                this.m_bLastBounceNeg = true;
            }
            this.m_hBackHead[this.m_iRacer].setTranslation(this.m_fHeadPos[0], this.m_fHeadPos[1], this.m_fHeadPos[2] + fBounce);
            if (this.m_bBrake) {
                if (this.m_fSpeedAnt > this.m_fSpeed) {
                    this.m_fSpeed -= aSpeedFactor * p_Time;
                } else {
                    this.m_fSpeed = this.m_fSpeedAnt - aSpeedFactor * p_Time;
                    this.m_bBrake = false;
                }
            } else if (fAbsDistanceToCenter <= 0.875f) {
                this.m_fSpeed = this.m_fSpeedAnt - aSpeedFactor * p_Time;
                if (this.m_fSpeed < 12.0f) {
                    this.m_fSpeed = 12.0f;
                }
            } else {
                this.m_fSpeed = this.m_fSpeedAnt - aSpeedFactor * p_Time;
            }
            if (this.m_fSpeed > 50.0f) {
                this.m_fSpeed -= 5.0f * p_Time;
            }
            if (this.m_nCurrentGear > 0 && this.m_fSpeed < 6.0f && !this.m_bForceStop) {
                this.m_fSpeed = 6.0f;
            }
            this.adjustGear();
            int iTime = 40 + Utils.m_Random.nextInt(10);
            if (this.m_bCanVibrate && this.m_fSpeed > 0.0f) {
                this.vibrate(iTime);
            }
        }
        Transform nT = this.m_tempTransform;
        this.m_Vector.x = this.m_fSteering == 0.0f ? 0.0f : this.m_fSkidding * 0.01f;
        this.m_Vector.y = this.m_fSpeed * p_Time;
        this.m_Vector.z = 0.0f;
        this.m_Vector.y = this.m_Vector.y < 1.0E-4f ? 0.0f : this.m_Vector.y;
        this.m_BikeYaw.getTransformTo(this.m_BikeDyn, nT);
        float[] v4 = this.m_v4;
        v4[0] = this.m_Vector.x;
        v4[1] = this.m_Vector.y;
        v4[2] = 0.0f;
        v4[3] = 0.0f;
        nT.transform(v4);
        this.m_Vector.x = this.m_Pos.x + v4[0];
        this.m_Vector.y = this.m_Pos.y + v4[1];
        this.moveFreeTo(this.m_Vector);
        this.m_newPosition[0] = this.m_Vector.x;
        this.m_newPosition[1] = this.m_Vector.y;
        this.m_newPosition[2] = this.m_Vector.z;
        this.calculateNextControlPoint(this.m_newPosition);
        this.calculateWrongWay(nT);
        bDireccionProhibida = this.isDrivingBackwards();
        this.m_bTrackColision = false;
        if (fAbsDistanceToCenter > 0.95f) {
            if (!this.doTrackCollision(2)) {
                if (this.doTrackCollision(1)) {
                    this.m_OriYaw.angle += 0.159f * Symbian.fu_sgn(this.m_wrongWay);
                    this.m_bTrackColision = true;
                }
            } else {
                this.m_OriYaw.angle -= 0.159f * Symbian.fu_sgn(this.m_wrongWay);
                this.m_bTrackColision = true;
            }
            if (this.m_bTrackColision) {
                this.adjustGear();
                if (!this.m_HaveFinishedRace) {
                    this.vibrate(175);
                    TData.GetCanvas().manageInRaceSound(2);
                    this.m_iTimeSlowingDown = this.m_iRaceTime;
                    this.m_bTrackSlowDown = true;
                }
                this.m_BikeDyn.setTranslation(this.m_newPosition[0], this.m_newPosition[1], this.m_newPosition[2]);
                this.m_Pos.x = this.m_newPosition[0];
                this.m_Pos.y = this.m_newPosition[1];
                this.m_Pos.z = this.m_newPosition[2];
                Symbian.transform_setOrientation(this.m_BikeYaw, this.m_OriYaw);
            }
        }
        if (this.m_BikeAccelBrake != null) {
            this.m_fAcc = (this.m_fSpeed - this.m_fSpeedAnt) / (p_Time * 10.0f) / ((float)this.m_nCurrentGear * 2.0f);
            if (this.m_fAcc > 20.0f) {
                this.m_fAcc = 20.0f;
            } else if (this.m_fAcc < -20.0f) {
                this.m_fAcc = -20.0f;
            }
        }
        if (bDireccionProhibida) {
            this.m_fTimeInWrongWay += p_Time;
            if (this.m_lTimeoutWrongDirection == 0L) {
                this.m_bBrake = true;
                this.m_lTimeoutWrongDirection = this.m_iRaceTime;
                this.m_bWrongDirection = true;
            }
            if (this.getLap() == 0 || this.m_fTimeInWrongWay > 0.5f) {
                this.m_bForceStop = true;
                this.m_fAcc = 0.0f;
                this.m_fSpeed = 0.0f;
            } else if (this.m_fSpeed > 10.0f) {
                this.m_fSpeed = 10.0f + (this.m_fSpeed - 10.0f) * 0.75f;
                this.m_fAcc = 0.0f;
            }
        } else {
            this.m_fTimeInWrongWay = 0.0f;
            if (this.m_bForceStop) {
                this.m_bForceStop = false;
                this.m_bBrake = false;
                this.m_bAccel = true;
            }
        }
        if (this.m_bWrongDirection) {
            if ((long)this.m_iRaceTime - this.m_lTimeoutWrongDirection > 1000L) {
                this.m_bWrongDirection = false;
                this.m_lTimeoutWrongDirection = 0L;
            }
        } else if (this.m_BikeAccelBrake != null) {
            this.m_OriAccel.angle = this.m_fAcc * 0.003f;
            if (this.m_OriAccel.angle < -0.02f) {
                this.m_OriAccel.angle = -0.02f;
            } else if (this.m_OriAccel.angle > 0.02f) {
                this.m_OriAccel.angle = 0.02f;
            }
            Symbian.transform_setOrientation(this.m_BikeAccelBrake, this.m_OriAccel);
        }
        this.manageCornerIndicator();
        this.m_fGearPercent = this.m_nCurrentGear == 0 ? this.m_fSpeed * this.m_Gearbox[0].fInvSpeed : this.m_fSpeed * this.m_Gearbox[this.m_nCurrentGear - 1].fInvSpeed;
        this.m_fAccAnt = this.m_fAcc;
        this.m_fSpeedAnt = this.m_fSpeed;
        if (aBrake) {
            this.m_bBrake = false;
        }
        if (!this.m_bCanVibrate) {
            if (GameSettings.m_bVibra) {
                if (this.m_iRaceTime - this.m_iTimeOutVibra > this.m_iWaitForVibrateAgain) {
                    this.m_hBackHead[this.m_iRacer].setTranslation(this.m_fHeadPos[0], this.m_fHeadPos[1], this.m_fHeadPos[2]);
                    this.vibrate(0);
                }
            } else {
                this.m_bCanVibrate = true;
            }
        }
    }

    public boolean wrongWayPersistent() {
        return this.m_bForceStop;
    }

    private void manageSpeed(float p_Time) {
        if (this.m_bBrake) {
            this.m_iLastAction = 1;
            this.m_fAcc = 202.73836f;
            this.m_fSpeed -= 202.73836f * p_Time;
            if (this.m_nCurrentGear > 0) {
                if (this.m_fSpeed < this.m_Gearbox[this.m_nCurrentGear - 1].fSpeedShouldChange - 1.0f) {
                    if (this.m_nCurrentGear > 1) {
                        --this.m_nCurrentGear;
                    }
                    this.adjustGear();
                } else {
                    this.m_fBrakeFX = Utils.m_Random.nextFloat() * 6.0f - 3.0f;
                    this.m_BikeClip.setOrientation(this.m_fBrakeFX, 0.0f, 0.0f, 1.0f);
                }
            } else if (this.m_fSpeed < 0.0f) {
                if (this.m_fBrakeFX != 0.0f) {
                    this.m_fBrakeFX = 0.0f;
                    this.m_BikeClip.setOrientation(0.0f, 0.0f, 0.0f, 1.0f);
                }
                this.m_fSpeed = 0.0f;
            }
        } else if (this.m_bTrackSlowDown) {
            if (this.m_iRaceTime - this.m_iTimeSlowingDown > 1000) {
                this.m_bAccel = true;
                this.m_bTrackSlowDown = false;
            } else {
                this.manageSoftBrake(60.0f * p_Time);
            }
        } else if (this.m_bAccel) {
            if (this.m_fBrakeFX != 0.0f) {
                this.m_fBrakeFX = 0.0f;
                this.m_BikeClip.setOrientation(0.0f, 0.0f, 0.0f, 1.0f);
            }
            this.m_bShiftWithin = false;
            this.m_iLastAction = 2;
            if (this.m_nCurrentGear != 0) {
                float fTemp0 = -MyMath.fabs(this.m_fSpeed * this.m_Gearbox[this.m_nCurrentGear - 1].fInvSpeed - 1.0f);
                this.m_fAcc = this.m_Gearbox[this.m_nCurrentGear - 1].fAcceleration * (1.0f - fTemp0);
                if (1.3f * this.m_fSpeed < this.m_Gearbox[this.m_nCurrentGear - 1].fSpeed && this.m_fAcc < this.m_fStandingStart) {
                    this.m_fAcc = this.m_fStandingStart;
                }
                this.m_fSpeed += this.m_fAcc * p_Time;
                if (this.m_fSpeed > this.m_Gearbox[this.m_nCurrentGear - 1].fSpeed) {
                    this.m_fSpeed = this.m_Gearbox[this.m_nCurrentGear - 1].fSpeed;
                    this.m_bShiftWithin = true;
                    this.shiftGearUp();
                }
            }
        }
        if (this.m_bSoftBrake || this.m_HaveFinishedRace) {
            if (!this.m_HaveFinishedRace) {
                this.manageSoftBrake(50.0f * p_Time);
            } else {
                this.manageSoftBrake(130.0f * p_Time);
            }
        }
    }

    public void calculateWrongWay(Transform nT) {
        float[] vXY = this.m_float2Temp1;
        this.direction[1] = 1.0f;
        this.direction[3] = 0.0f;
        this.direction[2] = 0.0f;
        this.direction[0] = 0.0f;
        nT.transform(this.direction);
        this.m_Colisions.getControlPoint(3, this.m_nextControlPoint, vXY);
        this.m_wrongWay = this.direction[0] * vXY[1] - this.direction[1] * vXY[0];
    }

    public boolean isDrivingBackwards() {
        return this.m_wrongWay < -0.05f && this.m_iRaceTime > 0;
    }

    protected boolean doTrackCollision(int type) {
        float[] cpNext = this.m_float2Temp1;
        float[] cp = this.m_float2Temp2;
        float[] vCPVector = this.m_float2Temp3;
        float[] vInToCar = this.m_float2Temp4;
        boolean crash = false;
        boolean changeCarAngle = true;
        this.m_Colisions.getControlPoint(type, this.m_nextControlPoint, cpNext);
        this.m_Colisions.getControlPoint(type, this.m_previousControlPoint, cp);
        MyMath.substract2D(vCPVector, cpNext, cp);
        MyMath.substract2D(vInToCar, this.m_newPosition, cp);
        boolean sign = type == 2 ? MyMath.scross(vCPVector, vInToCar) : MyMath.scross(vInToCar, vCPVector);
        if (sign) {
            crash = true;
            float ang = this.m_Colisions.getAngle(type, this.m_nextControlPoint);
            float yawRotation = 0.0f;
            yawRotation = this.m_OriYaw.angle > (float)Math.PI ? this.m_OriYaw.angle - (float)Math.PI : this.m_OriYaw.angle;
            float pyaw = yawRotation = (float)Math.toDegrees(yawRotation);
            float dif = MyMath.fabs(ang - pyaw);
            if (dif > 270.0f) {
                dif = 360.0f - dif;
            } else if (dif > 180.0f) {
                dif -= 180.0f;
            } else if (dif > 180.0f - dif) {
                dif = 180.0f - dif;
            }
            float f = dif = dif < 0.0f ? -dif : dif;
            if (dif < 30.0f) {
                this.m_fSpeed = 0.0f;
                changeCarAngle = false;
            } else {
                this.m_fSpeed -= MyMath.fabs(90.0f - dif) * 0.8f;
            }
            if (changeCarAngle) {
                yawRotation = this.isDrivingBackwards() ? ang - 90.0f + 180.0f : ang - 90.0f;
            }
            if (yawRotation < 0.0f) {
                yawRotation += 360.0f;
            } else if (yawRotation > 360.0f) {
                yawRotation -= 360.0f;
            }
            this.m_OriYaw.angle = (float)Math.toRadians(yawRotation);
            float[] intersection = this.m_float2Temp5;
            boolean ok = MyMath.closestPointLine2D(this.m_newPosition, cpNext, cp, intersection);
            MyMath.copy2D(this.m_newPosition, intersection);
        }
        return crash;
    }

    void manageSoftBrake(float p_DecVel) {
        this.m_iLastAction = 2;
        this.m_fSpeed -= p_DecVel;
        if (this.m_nCurrentGear > 1) {
            if (this.m_fSpeed < this.m_Gearbox[this.m_nCurrentGear - 2].fSpeedShouldChange - 1.0f) {
                --this.m_nCurrentGear;
            }
        } else if (this.m_fSpeed < 1.0f) {
            this.m_fSpeed = 0.0f;
            this.m_nCurrentGear = 0;
        }
        this.m_bSoftBrake = false;
        this.m_bAccel = false;
        if (this.m_nCurrentGear == 0) {
            this.m_bBrake = true;
        } else {
            this.m_bBrake = false;
            this.m_bAccelBeforeGear = true;
        }
    }

    void manageCornerIndicator() {
        float fDifPrev = MyMath.fabs(this.m_CurrentCornerPoint.GetPosition().x - this.m_Pos.x) + MyMath.fabs(this.m_CurrentCornerPoint.GetPosition().y - this.m_Pos.y);
        if (fDifPrev < 2.5f) {
            if (this.m_CurrentCornerPoint.GetCorner() == 0) {
                this.m_bShowingCorner = false;
                this.m_bLejosCP = true;
            } else if (this.m_iIndexCornerPointAnt != this.m_iIndexCornerPoint) {
                this.m_iIndexNextCornerPoint = this.m_iIndexCornerPoint == this.m_Track.GetNumberOfCornerPoints() - 1 ? 0 : this.m_iIndexCornerPoint + 1;
                this.m_NextCornerPoint = this.m_Track.GetCornerPoint(this.m_iIndexNextCornerPoint);
                this.m_iIndexCornerPointAnt = this.m_iIndexCornerPoint;
                this.m_bShowingCorner = true;
                this.m_iShowingCornerTime = this.m_iRaceTime;
            } else {
                this.m_bLejosCP = false;
            }
        } else if (this.m_CurrentCornerPoint.GetCorner() == 0) {
            this.m_iIndexCornerPoint = this.m_Track.FindIndexNextCornerPoint(this.m_iIndexCornerPoint);
            this.m_CurrentCornerPoint = this.m_Track.GetCornerPoint(this.m_iIndexCornerPoint);
            this.m_bLejosCP = true;
        } else if (this.m_bShowingCorner) {
            float fDistancia = MyMath.fabs(this.m_NextCornerPoint.GetPosition().x - this.m_Pos.x) + MyMath.fabs(this.m_NextCornerPoint.GetPosition().y - this.m_Pos.y);
            if (fDistancia < 2.5f || this.m_iRaceTime - this.m_iShowingCornerTime > 10000 || fDistancia < 5.0f && fDifPrev > 20.0f) {
                this.m_iIndexCornerPoint = this.m_Track.FindIndexNextCornerPoint(this.m_iIndexCornerPoint);
                this.m_iIndexCornerPoint = this.m_Track.FindIndexNextCornerPoint(this.m_iIndexCornerPoint);
                this.m_CurrentCornerPoint = this.m_Track.GetCornerPoint(this.m_iIndexCornerPoint);
                this.m_bShowingCorner = false;
                this.m_bLejosCP = true;
            } else {
                this.m_bLejosCP = false;
            }
        } else {
            this.m_bLejosCP = true;
        }
        if (this.m_bLejosCP || this.m_iRaceTime < 3000) {
            this.m_Window.setCorner(-1);
        } else {
            int iCorner = this.m_CurrentCornerPoint.GetCorner();
            if (iCorner != 0) {
                iCorner = iCorner < 0 ? -iCorner - 1 : (iCorner += 2);
            }
            this.m_Window.setCorner(iCorner);
        }
    }

    void softBrake() {
        this.m_bSoftBrake = true;
    }

    void turnLeft() {
        if (!this.m_bRollingOver) {
            this.m_iTurn = 1;
        }
    }

    void turnRight() {
        if (!this.m_bRollingOver) {
            this.m_iTurn = -1;
        }
    }

    void turn(float p_Time) {
        if (this.m_fSpeed < 6.0f) {
            this.m_fSteerInc = 1.0f;
        } else if (this.m_fSpeed < 10.5f) {
            this.m_fSteerInc = this.m_fSpeed * 0.12f;
        } else {
            float aSteerFactor = this.m_fSteeringTime < 0.025f ? 2.4225f : (this.m_fSteeringTime < 0.075f ? 1.7f : 1.2750001f);
            this.m_fSteerInc = aSteerFactor - this.m_fSpeed * this.m_Gearbox[5].fInvSpeed;
        }
        if (this.m_iTurnAnt != this.m_iTurn) {
            this.m_iTurnAnt = this.m_iTurn;
            if (this.m_TimeWithoutTurn < 0.05f) {
                this.m_fSteerInc *= 2.5f;
            }
        }
        if (this.m_iTurn > 0) {
            this.m_fSteering += p_Time * this.m_fSteerInc * this.m_fTurnFactor;
            if (this.m_fSteering > 0.261793f) {
                this.m_fSteering = 0.261793f;
            }
        } else {
            this.m_fSteering -= p_Time * this.m_fSteerInc * this.m_fTurnFactor;
            if (this.m_fSteering < -0.261793f) {
                this.m_fSteering = -0.261793f;
            }
        }
        if (p_Time == 0.0f) {
            this.m_fSteerInc = 0.0f;
            this.m_fSteering = 0.0f;
        }
        this.m_iTurn = 0;
    }

    void manageTurn(float p_Time) {
        if (this.m_iTurn != 0) {
            this.m_bNoTurn = false;
            this.turn(p_Time);
            this.m_fSteeringTime += p_Time;
            this.m_TimeWithoutTurn = 0.0f;
            this.m_bSoftBrake = false;
            this.m_bBrake = false;
            this.m_bAccel = false;
        } else {
            this.m_bNoTurn = true;
            this.m_TimeWithoutTurn += p_Time;
            this.m_fSteeringTime = this.m_fSteeringTime * p_Time * 5.0f;
            if (this.m_fSteeringTime < 1.0E-4f) {
                this.m_fSteeringTime = 0.0f;
            }
            this.m_fSteering *= p_Time * 35.0f;
            if (MyMath.fabs(this.m_fSteering) < 1.0E-4f) {
                this.m_fSteeringTime = 0.0f;
                this.m_fSteering = 0.0f;
            }
        }
    }

    int getGear() {
        return this.m_nCurrentGear;
    }

    float getGearPercent() {
        return this.m_fGearPercent;
    }

    public boolean launchedRocket() {
        return this.m_bUsePowerUp && this.m_iKindOfPowerUp == 1;
    }

    void destroy() {
        super.destroy();
        this.vibrate(0);
        this.m_Gearbox = null;
        this.m_trackWorld = null;
        this.m_float2Temp5 = null;
        this.m_float2Temp4 = null;
        this.m_float2Temp3 = null;
        this.m_float2Temp2 = null;
        this.m_float2Temp1 = null;
        this.direction = null;
        this.m_newPosition = null;
        this.m_BikeAccelBrake = null;
    }

    private class TGear {
        float fSpeed;
        float fInvSpeed;
        float fAcceleration;
        float fSpeedShouldChange;

        private TGear() {
        }
    }
}

