/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;
import main.ByteBufferedRMSManager;
import main.CCarBase;
import main.GameSettings;
import main.MyMath;
import main.Platform;
import main.Symbian;
import main.TData;
import main.TRaceInfo;
import main.Utils;
import main.Window;

public class PowerUp {
    private static final boolean TRAZA3D = false;
    private static final float MINIMUN_AI_SPEED_TO_OIL_SPOIL = 16.66f;
    private static final float ROCKET_POSZ = 0.1f;
    private static final int TIME_OIL_EXPIRATE = 30000;
    private static final int TIME_FLYING_ROCKET = 2500;
    private static final float DISTANCE_FOR_OIL = 0.45f;
    private static final float DISTANCE_TO_RENDER_OIL = 15.0f;
    private static final int MAX_OIL_STAINS = 3;
    private static final int EMPTY_SLOT = -1;
    private static final int NO_FREE_SLOT = Integer.MIN_VALUE;
    public static final int ROCKET = 1;
    public static final int NONE = 0;
    public static final int OIL = -1;
    public static final float ROCKET_DISTANCE = 700.0f;
    public static final float ROCKET_DISTANCE_INV = 0.0014285714f;
    public static final int MAX_ACTIVE_POWERUPS = 5;
    public static final float DISTANCE_TO_GET_POWERUP = 0.5f;
    private static final boolean CREATE_POWERUP_FILE = false;
    private static final String HEADER = "__info__";
    private static final String FILE_POWERUP_INFO = "powerupinfo";
    private float[] m_HomePowerupPos = null;
    private int m_iNumPowerUps = 0;
    private int m_iLastIndexPickedUp;
    private boolean m_bNotify;
    private int[] m_IndexActiveHomePowerUps = new int[5];
    private int[] m_IndexPowerUps3D = new int[5];
    private int[] m_iKind = new int[5];
    private int m_iMaxFrame;
    private int m_iCountOilPUP;
    private int m_iCountRocketPUP;
    private World m_world;
    private float[] m_fPosition = new float[3];
    private float[] m_fPos2D = new float[2];
    private Node m_TrackWorld;
    private Node[] m_Oil;
    private Node[] m_Rocket;
    private Node[] m_RocketFX;
    private Node[] m_OilFX;
    private CCarBase[] m_Car;
    private float[] m_vfTargetPos = new float[8];
    private int m_iLastCar;
    private float[] m_fWork = new float[2];
    private ThrownOil[] m_vThrownOils = new ThrownOil[3];
    private FlyingRocket[] m_vRocketsInFly = new FlyingRocket[4];

    PowerUp(Node p_World, TRaceInfo p_RaceInfo, CCarBase[] aCar) throws NullPointerException {
        this.m_world = (World)p_World;
        this.m_TrackWorld = (Node)Symbian.wworld_findNode((Object3D)this.m_world, p_RaceInfo.iIDTrack);
        this.m_Car = aCar;
        this.m_iLastCar = 0;
        if (this.m_TrackWorld != null) {
            if (!this.extractPowerUps(p_RaceInfo.iTrack)) {
                throw new NullPointerException();
            }
            this.m_TrackWorld = null;
        }
    }

    private void loadPowerUps(int p_iTrack) throws IOException {
        DataInputStream input = new DataInputStream(((Object)((Object)TData.GetCanvas())).getClass().getResourceAsStream("/powerupinfo" + p_iTrack + ".db"));
        Utils.MovePastHeader(input, HEADER);
        this.m_iNumPowerUps = input.readInt();
        this.m_HomePowerupPos = new float[this.m_iNumPowerUps * 2];
        for (int i = 0; i < this.m_iNumPowerUps; ++i) {
            this.m_HomePowerupPos[i << 1] = input.readFloat();
            this.m_HomePowerupPos[(i << 1) + 1] = input.readFloat();
        }
        input.close();
    }

    private void savePowerUps(int p_iTrack) throws IOException {
        ByteBufferedRMSManager mRMS = new ByteBufferedRMSManager(FILE_POWERUP_INFO + p_iTrack, true, true);
        mRMS.addString(HEADER);
        mRMS.addInt(this.m_iNumPowerUps);
        mRMS.addFloatArray(this.m_HomePowerupPos, false);
        mRMS.flush();
    }

    private boolean extractPowerUps(int p_iTrack) {
        int iIndex;
        try {
            this.loadPowerUps(p_iTrack);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_Rocket = new Node[5];
        this.m_Oil = new Node[5];
        this.m_RocketFX = new Node[4];
        this.m_OilFX = new Node[3];
        for (iIndex = 0; iIndex < 5; ++iIndex) {
            if (iIndex == 0) {
                this.m_Rocket[0] = (Node)Utils.LoadScene("/rocket");
                this.m_Oil[0] = (Node)Utils.LoadScene("/oil");
            } else {
                this.m_Rocket[iIndex] = (Node)this.m_Rocket[0].duplicate();
                this.m_Oil[iIndex] = (Node)this.m_Oil[0].duplicate();
                Platform.DuplicateMeshes((Object3D)this.m_Rocket[iIndex]);
                Platform.DuplicateMeshes((Object3D)this.m_Oil[iIndex]);
            }
            this.m_world.addChild(this.m_Rocket[iIndex]);
            this.m_world.addChild(this.m_Oil[iIndex]);
            this.m_Rocket[iIndex].setRenderingEnable(false);
            this.m_Oil[iIndex].setRenderingEnable(false);
        }
        for (iIndex = 0; iIndex < 4; ++iIndex) {
            if (iIndex == 0) {
                this.m_RocketFX[0] = (Node)Utils.LoadScene("/rocket_fx");
            } else {
                this.m_RocketFX[iIndex] = (Node)this.m_RocketFX[0].duplicate();
                Platform.DuplicateMeshes((Object3D)this.m_RocketFX[iIndex]);
            }
            this.m_world.addChild(this.m_RocketFX[iIndex]);
            this.m_RocketFX[iIndex].setRenderingEnable(false);
        }
        for (iIndex = 0; iIndex < 3; ++iIndex) {
            if (iIndex == 0) {
                this.m_OilFX[0] = (Node)Utils.LoadScene("/oil_fx");
            } else {
                this.m_OilFX[iIndex] = (Node)this.m_OilFX[0].duplicate();
                Platform.DuplicateMeshes((Object3D)this.m_OilFX[iIndex]);
            }
            this.m_world.addChild(this.m_OilFX[iIndex]);
            this.m_OilFX[iIndex].setRenderingEnable(false);
        }
        return this.m_Rocket != null && this.m_Oil != null && this.m_RocketFX != null && this.m_OilFX != null;
    }

    void destroy() {
        int iIndex;
        this.m_HomePowerupPos = null;
        this.m_IndexActiveHomePowerUps = null;
        this.m_IndexPowerUps3D = null;
        this.m_TrackWorld = null;
        for (iIndex = 0; iIndex < 4; ++iIndex) {
            if (this.m_vRocketsInFly[iIndex] != null) {
                this.m_vRocketsInFly[iIndex].destroy();
                this.m_vRocketsInFly[iIndex] = null;
            }
            Platform.RemoveDuplicatedMeshes((Object3D)this.m_RocketFX[iIndex]);
            this.m_world.removeChild(this.m_RocketFX[iIndex]);
            this.m_RocketFX[iIndex] = null;
        }
        for (iIndex = 0; iIndex < 3; ++iIndex) {
            if (this.m_vThrownOils[iIndex] != null) {
                this.m_vThrownOils[iIndex].destroy();
                this.m_vThrownOils[iIndex] = null;
            }
            Platform.RemoveDuplicatedMeshes((Object3D)this.m_OilFX[iIndex]);
            this.m_world.removeChild(this.m_OilFX[iIndex]);
            this.m_OilFX[iIndex] = null;
        }
        for (iIndex = 0; iIndex < 5; ++iIndex) {
            Platform.RemoveDuplicatedMeshes((Object3D)this.m_Rocket[iIndex]);
            Platform.RemoveDuplicatedMeshes((Object3D)this.m_Oil[iIndex]);
            this.m_world.removeChild(this.m_Rocket[iIndex]);
            this.m_world.removeChild(this.m_Oil[iIndex]);
            this.m_Rocket[iIndex] = null;
            this.m_Oil[iIndex] = null;
        }
        this.m_world = null;
        this.m_Car = null;
    }

    int pickUp(float pX, float pY, float pDistance) {
        int iTipo = 0;
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            float fDifY;
            float fDifX;
            int aIndex = this.m_IndexActiveHomePowerUps[iIndex];
            if (aIndex == -1 || (fDifX = MyMath.fabs(pX - this.m_HomePowerupPos[aIndex << 1])) > 10.0f || (fDifY = MyMath.fabs(pY - this.m_HomePowerupPos[(aIndex << 1) + 1])) > 10.0f || !(fDifX + fDifY < pDistance)) continue;
            iTipo = this.m_iKind[iIndex];
            Node aPowerUp = iTipo == 1 ? this.m_Rocket[iIndex] : this.m_Oil[iIndex];
            aPowerUp.setRenderingEnable(false);
            aPowerUp = null;
            this.m_IndexPowerUps3D[iIndex] = -1;
            this.m_IndexActiveHomePowerUps[iIndex] = -1;
            this.m_iLastIndexPickedUp = aIndex;
            this.m_bNotify = true;
            break;
        }
        return iTipo;
    }

    private boolean existsInActivePowerUpList(int p_iValue) {
        boolean bExists = false;
        int[] aIndexAHPUPs = this.m_IndexActiveHomePowerUps;
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            if (aIndexAHPUPs[iIndex] != p_iValue) continue;
            bExists = true;
            break;
        }
        return bExists;
    }

    private void addPowerUpInActivePowerUpList(int p_iIndex, int p_iValue, int p_iKind) {
        this.m_IndexActiveHomePowerUps[p_iIndex] = p_iValue;
        this.m_iKind[p_iIndex] = p_iKind;
        Node aPowerUp = this.m_iKind[p_iIndex] == 1 ? this.m_Rocket[p_iIndex] : this.m_Oil[p_iIndex];
        this.m_IndexPowerUps3D[p_iIndex] = p_iValue;
        aPowerUp.setTranslation(this.m_HomePowerupPos[p_iValue << 1], this.m_HomePowerupPos[(p_iValue << 1) + 1], 0.0f);
        aPowerUp.setRenderingEnable(true);
        this.show();
        this.m_bNotify = true;
    }

    private void removeIndexFromActivePowerUpList(int p_iIndex) {
        this.m_IndexActiveHomePowerUps[p_iIndex] = -1;
    }

    private int freeSlotInActivePowerUpList() {
        int iMyIndex = Integer.MIN_VALUE;
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            if (this.m_IndexActiveHomePowerUps[iIndex] != -1) continue;
            iMyIndex = iIndex;
            break;
        }
        return iMyIndex;
    }

    private void fillup() {
        this.m_iLastIndexPickedUp = -1;
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            int iIndexHomePowerUp = Math.abs(Utils.m_Random.nextInt() % this.m_iNumPowerUps);
            int iFreeIndex = this.freeSlotInActivePowerUpList();
            if (iFreeIndex == Integer.MIN_VALUE) continue;
            this.addPowerUpInActivePowerUpListStep1(iFreeIndex, iIndexHomePowerUp);
        }
    }

    void reset() {
        int iIndex;
        for (iIndex = 0; iIndex < 5; ++iIndex) {
            if (this.m_Rocket[iIndex] != null && this.m_Rocket[iIndex].isRenderingEnabled()) {
                this.m_Rocket[iIndex].setRenderingEnable(false);
            }
            if (this.m_Oil[iIndex] != null && this.m_Oil[iIndex].isRenderingEnabled()) {
                this.m_Oil[iIndex].setRenderingEnable(false);
            }
            this.m_IndexActiveHomePowerUps[iIndex] = -1;
            this.m_IndexPowerUps3D[iIndex] = -1;
            this.m_iKind[iIndex] = Integer.MIN_VALUE;
        }
        for (iIndex = 0; iIndex < 3; ++iIndex) {
            if (this.m_OilFX[iIndex].isRenderingEnabled()) {
                this.m_OilFX[iIndex].setRenderingEnable(false);
            }
            this.m_vThrownOils[iIndex] = null;
        }
        for (iIndex = 0; iIndex < 4; ++iIndex) {
            if (this.m_RocketFX[iIndex].isRenderingEnabled()) {
                this.m_RocketFX[iIndex].setRenderingEnable(false);
            }
            this.m_vRocketsInFly[iIndex] = null;
        }
        this.fillup();
    }

    void show() {
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            if (this.m_IndexActiveHomePowerUps[iIndex] == -1) continue;
        }
    }

    void addPowerUpInActivePowerUpListStep1(int aFree, int aHomePUP) {
        if (!this.existsInActivePowerUpList(aHomePUP)) {
            int aiKind = Utils.m_Random.nextInt(11) > 3 ? 1 : -1;
            int iCount = 0;
            if (aiKind == -1) {
                for (int iIndex = 0; iIndex < 3; ++iIndex) {
                    if (this.m_vThrownOils[iIndex] == null) continue;
                    ++iCount;
                }
                if (iCount + this.m_iCountOilPUP < 3) {
                    this.addPowerUpInActivePowerUpList(aFree, aHomePUP, aiKind);
                }
            } else {
                this.addPowerUpInActivePowerUpList(aFree, aHomePUP, aiKind);
            }
        }
    }

    void update(int iRaceTime) {
        int iIndexHomePowerUp;
        float[] avfTargetPos = this.m_vfTargetPos;
        CCarBase[] aCar = this.m_Car;
        float[] aWork = this.m_fWork;
        for (int iIndex = 0; iIndex < this.m_iLastCar; ++iIndex) {
            aCar[iIndex].getPosXY(aWork);
            avfTargetPos[iIndex << 1] = aWork[0];
            avfTargetPos[(iIndex << 1) + 1] = aWork[1];
        }
        this.m_iCountOilPUP = 0;
        this.m_iCountRocketPUP = 0;
        int[] avIndexAHPUPs = this.m_IndexActiveHomePowerUps;
        int aiFreeIndex = Integer.MIN_VALUE;
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            if (avIndexAHPUPs[iIndex] != -1) {
                if (this.m_iKind[iIndex] == 1) {
                    if (MyMath.fabs(avfTargetPos[0] - this.m_HomePowerupPos[avIndexAHPUPs[iIndex] << 1]) + MyMath.fabs(avfTargetPos[1] - this.m_HomePowerupPos[(avIndexAHPUPs[iIndex] << 1) + 1]) < 8.0f) {
                        if (!this.m_Rocket[iIndex].isRenderingEnabled()) {
                            this.m_Rocket[iIndex].setRenderingEnable(true);
                        }
                    } else if (this.m_Rocket[iIndex].isRenderingEnabled()) {
                        this.m_Rocket[iIndex].setRenderingEnable(false);
                    }
                    ++this.m_iCountRocketPUP;
                    continue;
                }
                ++this.m_iCountOilPUP;
                continue;
            }
            aiFreeIndex = iIndex;
        }
        if (aiFreeIndex != Integer.MIN_VALUE && this.m_iCountRocketPUP + this.m_iCountOilPUP < 5 && (Utils.m_Random.nextInt() & 0xF) == 7 && this.m_iLastIndexPickedUp != (iIndexHomePowerUp = Math.abs(Utils.m_Random.nextInt() % this.m_iNumPowerUps))) {
            this.addPowerUpInActivePowerUpListStep1(aiFreeIndex, iIndexHomePowerUp);
        }
        FlyingRocket[] aRocketsInFly = this.m_vRocketsInFly;
        int iCount = 0;
        int iIndex = 4;
        while (--iIndex >= 0) {
            if (aRocketsInFly[iIndex] == null) continue;
            if (aRocketsInFly[iIndex].finished()) {
                aRocketsInFly[iIndex].destroy();
                aRocketsInFly[iIndex] = null;
                continue;
            }
            aRocketsInFly[iIndex].update(iRaceTime);
            ++iCount;
        }
        ThrownOil[] aThrowOils = this.m_vThrownOils;
        iCount = 0;
        int iIndex2 = 3;
        while (--iIndex2 >= 0) {
            if (aThrowOils[iIndex2] == null) continue;
            if (aThrowOils[iIndex2].finished()) {
                aThrowOils[iIndex2].destroy();
                aThrowOils[iIndex2] = null;
                continue;
            }
            aThrowOils[iIndex2].update(iRaceTime);
            ++iCount;
        }
    }

    void notify(Window pWindow) {
        if (this.m_bNotify) {
            this.m_bNotify = false;
            for (int iIndex = 0; iIndex < 5; ++iIndex) {
                int aIndex = this.m_IndexActiveHomePowerUps[iIndex];
                if (aIndex != -1) {
                    this.m_fPos2D[0] = this.m_HomePowerupPos[aIndex << 1];
                    this.m_fPos2D[1] = this.m_HomePowerupPos[(aIndex << 1) + 1];
                    pWindow.setPowerUp(iIndex, this.m_fPos2D, this.m_iKind[iIndex]);
                    continue;
                }
                pWindow.clearPowerUp(iIndex);
            }
        }
    }

    public void launchRocket(int aiSource, int aiTarget, boolean aImpact, int iRaceTime) {
        this.m_vRocketsInFly[aiSource] = new FlyingRocket(aiSource, aiTarget, aImpact, iRaceTime);
    }

    public void throwOil(int i, int iRaceTime) {
        for (int iIndex = 0; iIndex < 3; ++iIndex) {
            if (this.m_vThrownOils[iIndex] != null) continue;
            this.m_vThrownOils[iIndex] = new ThrownOil(i, iIndex, iRaceTime);
            break;
        }
    }

    public int getNumberOfPowerUps() {
        return this.m_iNumPowerUps;
    }

    public int getNumberOfActivePowerUps() {
        int iCount = 0;
        for (int iIndex = 0; iIndex < 5; ++iIndex) {
            if (this.m_IndexActiveHomePowerUps[iIndex] == -1) continue;
            ++iCount;
        }
        return iCount;
    }

    public void setTotalCars(int a) {
        this.m_iLastCar = a;
    }

    protected class ThrownOil {
        private float[] m_fPos = new float[2];
        private float[] m_fTargetPos = new float[2];
        private boolean m_bFinish;
        private boolean m_bFree;
        private int m_iTime;
        private int m_iIndexCar;
        private int m_iIndexStain;

        ThrownOil(int aIndex, int iMyIndex, int iRaceTime) {
            this.m_iIndexCar = aIndex;
            this.m_iIndexStain = iMyIndex;
            PowerUp.this.m_Car[this.m_iIndexCar].getPosXY(this.m_fPos);
            PowerUp.this.m_OilFX[this.m_iIndexStain].setTranslation(this.m_fPos[0], this.m_fPos[1], 0.001f);
            this.m_bFinish = false;
            this.m_iTime = iRaceTime;
        }

        void update(int iRaceTime) {
            if (!this.m_bFinish) {
                if (iRaceTime - this.m_iTime > 30000) {
                    this.m_bFinish = true;
                    PowerUp.this.m_OilFX[this.m_iIndexStain].setRenderingEnable(false);
                } else {
                    float[] avfTargetPos = PowerUp.this.m_vfTargetPos;
                    float[] aSourcePos = this.m_fPos;
                    CCarBase[] aCar = PowerUp.this.m_Car;
                    for (int iIndex = 0; iIndex < PowerUp.this.m_iLastCar; ++iIndex) {
                        float fDistance = -1.0f;
                        if (iIndex == 0) {
                            fDistance = MyMath.fabs(aSourcePos[0] - avfTargetPos[iIndex << 1]) + MyMath.fabs(aSourcePos[1] - avfTargetPos[(iIndex << 1) + 1]);
                            Node aOilStain = PowerUp.this.m_OilFX[this.m_iIndexStain];
                            if (fDistance < 15.0f) {
                                if (!aOilStain.isRenderingEnabled()) {
                                    aOilStain.setRenderingEnable(true);
                                }
                            } else if (aOilStain.isRenderingEnabled()) {
                                aOilStain.setRenderingEnable(false);
                            }
                        }
                        if (!(iIndex != this.m_iIndexCar && aCar[iIndex].getSpeed() > 16.66f) && (iIndex != this.m_iIndexCar || iRaceTime - this.m_iTime <= 6000) || aCar[iIndex].getHasFinishedRace() || aCar[iIndex].rollingOver()) continue;
                        if (iIndex != 0) {
                            fDistance = MyMath.fabs(aSourcePos[0] - avfTargetPos[iIndex << 1]) + MyMath.fabs(aSourcePos[1] - avfTargetPos[(iIndex << 1) + 1]);
                        }
                        if (!(fDistance <= 0.45f)) continue;
                        aCar[iIndex].setRollingOver();
                    }
                }
            }
        }

        boolean finished() {
            return this.m_bFinish;
        }

        void destroy() {
            this.m_fPos = null;
            this.m_fTargetPos = null;
        }
    }

    protected class FlyingRocket {
        private float[] m_fSourcePos = new float[2];
        private float[] m_fTargetPos = new float[2];
        private float[] m_fComp = new float[2];
        private float[] m_fCurrentPos = new float[3];
        private boolean m_bImpact;
        private boolean m_bFinish;
        private int m_iTime;
        private int m_iSource;
        private int m_iTarget;
        private float m_fYaw = 0.0f;

        FlyingRocket(int aiSource, int aiTarget, boolean aImpact, int iRaceTime) {
            this.m_iSource = aiSource;
            this.m_iTarget = aiTarget;
            CCarBase[] aCar = PowerUp.this.m_Car;
            aCar[this.m_iSource].getPosXY(this.m_fSourcePos);
            this.m_fComp[0] = (float)Math.sin(-aCar[this.m_iSource].getYawAngle());
            this.m_fComp[1] = (float)Math.cos(-aCar[this.m_iSource].getYawAngle());
            CCarBase aTargetCar = aCar[this.m_iTarget];
            this.m_bImpact = aImpact;
            this.m_bFinish = false;
            Node aRocket = PowerUp.this.m_RocketFX[this.m_iSource];
            aRocket.setRenderingEnable(true);
            if (this.m_bImpact) {
                this.m_iTime = 0;
                aTargetCar.getPosXY(this.m_fTargetPos);
                PowerUp.this.m_iMaxFrame = (int)(MyMath.fabs(this.m_fTargetPos[0] - this.m_fSourcePos[0]) + MyMath.fabs(this.m_fTargetPos[1] - this.m_fSourcePos[1]) / 12.0f);
                if (PowerUp.this.m_iMaxFrame == 0) {
                    PowerUp.this.m_iMaxFrame = 1;
                }
            } else {
                this.m_iTime = iRaceTime;
            }
            aRocket.setOrientation(this.m_fYaw, 0.0f, 0.0f, 1.0f);
            this.m_fSourcePos[0] = this.m_fSourcePos[0] + this.m_fComp[0] * 0.1f;
            this.m_fSourcePos[1] = this.m_fSourcePos[1] + this.m_fComp[1] * 0.1f;
            aRocket.setTranslation(this.m_fSourcePos[0], this.m_fSourcePos[1], 0.1f);
        }

        void update(int iRaceTime) {
            if (!this.m_bFinish) {
                Node aRocket = PowerUp.this.m_RocketFX[this.m_iSource];
                if (this.m_bImpact) {
                    CCarBase aTargerCar = PowerUp.this.m_Car[this.m_iTarget];
                    aTargerCar.getPosXY(this.m_fTargetPos);
                    if (this.m_iTime == PowerUp.this.m_iMaxFrame) {
                        aRocket.setTranslation(this.m_fTargetPos[0], this.m_fTargetPos[1], 0.1f);
                        aTargerCar.setRollingOver();
                        TData.GetCanvas().manageInRaceSound(4);
                        if (this.m_iTarget == 0 && GameSettings.m_bVibra) {
                            TData.GetDisplay().vibrate(2000);
                        }
                        this.m_bFinish = true;
                    } else {
                        aRocket.getTranslation(this.m_fCurrentPos);
                        aRocket.setTranslation(this.m_fTargetPos[0] - (this.m_fTargetPos[0] - this.m_fCurrentPos[0]) * 0.5f, this.m_fTargetPos[1] - (this.m_fTargetPos[1] - this.m_fCurrentPos[1]) * 0.5f, 0.1f);
                        ++this.m_iTime;
                    }
                } else {
                    int iDifTime = iRaceTime - this.m_iTime;
                    if (iDifTime > 2500) {
                        this.m_bFinish = true;
                    } else {
                        aRocket.setTranslation(this.m_fSourcePos[0] + (float)iDifTime * this.m_fComp[0] * 0.01f, this.m_fSourcePos[1] + (float)iDifTime * this.m_fComp[1] * 0.01f, 0.1f);
                    }
                }
            }
        }

        void destroy() {
            PowerUp.this.m_RocketFX[this.m_iSource].setRenderingEnable(false);
            if (PowerUp.this.m_Car != null && PowerUp.this.m_Car[this.m_iSource] != null) {
                PowerUp.this.m_Car[this.m_iSource].finishRocket();
            }
            this.m_fTargetPos = null;
            this.m_fSourcePos = null;
            this.m_fComp = null;
            this.m_fCurrentPos = null;
        }

        boolean finished() {
            return this.m_bFinish;
        }
    }
}

