/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RMSManager {
    protected RecordStore recordStore = null;
    protected String mStoreName;
    protected static ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected static DataOutputStream outputStream = new DataOutputStream(baos);

    RMSManager() {
    }

    RMSManager(String aStoreName, boolean deleteifexists, boolean createifnotexists) {
        this.mStoreName = aStoreName;
        if (deleteifexists) {
            RMSManager.DeleteStore(aStoreName);
        }
        this.openStore(aStoreName, deleteifexists || createifnotexists);
    }

    public boolean exists() {
        return this.recordStore != null;
    }

    public static boolean Exists(String aStoreName) {
        try {
            RecordStore.openRecordStore((String)aStoreName, (boolean)false);
        }
        catch (RecordStoreException rse) {
            return false;
        }
        return true;
    }

    public void destroy() {
        this.closeStore();
        baos.reset();
        baos.reset();
    }

    public int getNumRecords() {
        int numrecords;
        try {
            numrecords = this.recordStore.getNumRecords();
        }
        catch (RecordStoreNotOpenException e) {
            numrecords = -1;
        }
        return numrecords;
    }

    public void deleteAllRecords() {
        this.closeStore();
        RMSManager.DeleteStore(this.mStoreName);
        this.openStore(this.mStoreName, true);
    }

    public static boolean DeleteStore(String aStoreName) {
        try {
            RecordStore.deleteRecordStore((String)aStoreName);
        }
        catch (RecordStoreException e) {
            return false;
        }
        return true;
    }

    public boolean openStore(String aStoreName, boolean createifnotexists) {
        this.closeStore();
        try {
            this.recordStore = RecordStore.openRecordStore((String)aStoreName, (boolean)createifnotexists);
        }
        catch (RecordStoreException rse) {
            this.recordStore = null;
            return false;
        }
        return true;
    }

    public final void closeStore() {
        if (this.recordStore != null) {
            try {
                this.recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            this.recordStore = null;
        }
    }

    public void setBoolean(int recordId, boolean value) {
        this.setInteger(recordId, value ? 1 : 0);
    }

    public boolean getBoolean(int recordId) {
        return this.getInteger(recordId) != 0;
    }

    public void setInteger(int recordId, int value) {
        try {
            baos.reset();
            outputStream.writeInt(value);
            byte[] b = baos.toByteArray();
            this.recordStore.setRecord(recordId, b, 0, b.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getInteger(int recordID) {
        int value = -1;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.recordStore.getRecord(recordID));
            DataInputStream inputStream = new DataInputStream(bais);
            value = inputStream.readInt();
            inputStream.close();
            bais.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void setString(int recordId, String value) {
        try {
            baos.reset();
            outputStream.writeUTF(value);
            byte[] b = baos.toByteArray();
            this.recordStore.setRecord(recordId, b, 0, b.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getString(int recordID) {
        String value = "";
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.recordStore.getRecord(recordID));
            DataInputStream inputStream = new DataInputStream(bais);
            value = inputStream.readUTF();
            inputStream.close();
            bais.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public byte[] getData(int recordID) {
        byte[] data = null;
        try {
            data = this.recordStore.getRecord(recordID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public void setIntegerArray(int recordId, int[] value) {
        try {
            baos.reset();
            outputStream.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                outputStream.writeInt(value[i]);
            }
            byte[] b = baos.toByteArray();
            this.recordStore.setRecord(recordId, b, 0, b.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getIntegerArray(int recordID) {
        int[] value = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.recordStore.getRecord(recordID));
            DataInputStream inputStream = new DataInputStream(bais);
            int numelements = inputStream.readInt();
            value = new int[numelements];
            for (int i = 0; i < numelements; ++i) {
                value[i] = inputStream.readInt();
            }
            inputStream.close();
            bais.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public final boolean addRecord(String aString) {
        try {
            baos.reset();
            outputStream.writeUTF(aString);
            byte[] b = baos.toByteArray();
            this.recordStore.addRecord(b, 0, b.length);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public final boolean addRecord(byte[] aBuffer) {
        try {
            this.recordStore.addRecord(aBuffer, 0, aBuffer.length);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public final boolean addRecord(byte aData) {
        byte[] data = new byte[]{aData};
        return this.addRecord(data);
    }

    public final boolean addRecord(int aData) {
        try {
            baos.reset();
            outputStream.writeInt(aData);
            byte[] b = baos.toByteArray();
            this.recordStore.addRecord(b, 0, b.length);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

