/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AECamera;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AELeafNode;
import AbyssEngine.AERenderer;
import AbyssEngine.AETexture;
import AbyssEngine.AETransform;
import AbyssEngine.JSRMesh;
import AbyssEngine.JSRParticleSystem;
import AbyssEngine.JSRQuadList;
import AbyssEngine.JSRSkyBox;

public abstract class AEGeometry
extends AELeafNode {
    public static final byte BLEND_DISABLE = 0;
    public static final byte BLEND_NORMAL = 1;
    public static final byte BLEND_ADD = 2;
    public static final byte BLEND_SUB = 3;
    protected int layer_id = 0;
    protected AETransform render_matrix = new AETransform();

    public void setLayer(int layer_id) {
        this.layer_id = layer_id;
    }

    public int getLayer() {
        return this.layer_id;
    }

    public void prerender(AECamera camera, AERenderer renderer) {
        if (this.isVisible && camera.isInFrustum(this.boundingSphere)) {
            this.render_matrix = camera.world.getInverse(this.render_matrix);
            this.render_matrix.multiply(this.world);
            renderer.add2Layer(this.layer_id, this);
        }
    }

    public abstract void render();

    public void renderTransp() {
    }

    public abstract AEGraphNode copy();

    public static AEGeometry createMesh(String filename, int culling_radius) {
        return new JSRMesh(filename, culling_radius);
    }

    public static AEGeometry createParticleSystem(int tex_size, int u1, int v1, int u2, int v2, int size, int count, byte blend_mode) {
        return new JSRParticleSystem(tex_size, u1, v1, u2, v2, size, count, blend_mode);
    }

    public static AEGeometry createSkyBox(String filename) {
        return new JSRSkyBox(filename);
    }

    public static AEGeometry createQuadList(int count, byte blend_mode) {
        return new JSRQuadList(count, blend_mode);
    }

    public abstract void setTexture(AETexture var1);

    public void release() {
        super.release();
        this.render_matrix = null;
    }

    public void update(long current_time) {
    }
}

