/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AECamera;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AERenderer;

public class AEGroup
extends AEGraphNode {
    protected AEGraphNode child = null;

    public void addChild(AEGraphNode child) {
        if (child != null) {
            child.parent = this;
            child.next = this.child;
            this.child = child;
            this.transformUpdate = true;
            this.notifyUpdate();
        }
    }

    public void removeChild(AEGraphNode child) {
        if (child == null || this.child == null) {
            return;
        }
        if (child == this.child) {
            this.child = this.child.next;
            child.parent = null;
            child.next = null;
            return;
        }
        AEGraphNode n = this.child;
        while (n != null) {
            if (n.next == child) {
                n.next = n.next.next;
                child.parent = null;
                child.next = null;
                return;
            }
            n = n.next;
        }
    }

    public AEGraphNode getChild() {
        return this.child;
    }

    public void prerender(AECamera camera, AERenderer renderer) {
        if (this.isVisible && camera.isInFrustum(this.boundingSphere)) {
            AEGraphNode n = this.child;
            while (n != null) {
                n.prerender(camera, renderer);
                n = n.next;
            }
        }
    }

    public void update(boolean transformUpdate) {
        if (this.pathUpdate || transformUpdate) {
            if (this.transformUpdate || transformUpdate) {
                if (this.parent != null) {
                    this.world = this.parent.world.multiply(this.local, this.world);
                } else {
                    this.world.set(this.local);
                }
            }
            AEGraphNode n = this.child;
            while (n != null) {
                n.update(this.transformUpdate || transformUpdate);
                n = n.next;
            }
            this.boundingSphere.set(this.world.getPositionX(), this.world.getPositionY(), this.world.getPositionZ(), 0);
            n = this.child;
            while (n != null) {
                this.boundingSphere.add(n.boundingSphere);
                n = n.next;
            }
            this.pathUpdate = false;
            this.transformUpdate = false;
        }
    }

    protected String toString(String in, int level) {
        for (int i = 0; i < level; ++i) {
            in = in + "  ";
        }
        in = in + "group\n";
        ++level;
        AEGraphNode n = this.child;
        while (n != null) {
            in = n.toString(in, level);
            n = n.next;
        }
        return in;
    }

    public void setAnimRange(int start_frame, int stop_frame) {
        AEGraphNode n = this.child;
        while (n != null) {
            n.setAnimRange(start_frame, stop_frame);
            n = n.next;
        }
    }

    public void playAnim(byte mode) {
        AEGraphNode n = this.child;
        while (n != null) {
            n.playAnim(mode);
            n = n.next;
        }
    }

    public void stopAnim() {
        AEGraphNode n = this.child;
        while (n != null) {
            n.stopAnim();
            n = n.next;
        }
    }

    public void stopAnim(int frame) {
        AEGraphNode n = this.child;
        while (n != null) {
            n.stopAnim(frame);
            n = n.next;
        }
    }

    public boolean isPlaying() {
        boolean result = false;
        AEGraphNode n = this.child;
        while (n != null) {
            result |= n.isPlaying();
            n = n.next;
        }
        return result;
    }

    public void release() {
        super.release();
        if (this.child != null) {
            this.child.release();
        }
        this.child = null;
    }
}

