/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;
import AbyssEngine.AEVector3D;

public class AEQuaternion {
    public int x;
    public int y;
    public int z;
    public int w;

    public AEQuaternion(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public AEQuaternion(AEQuaternion q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
    }

    public AEQuaternion() {
        this(0, 0, 0, 4096);
    }

    public AEQuaternion multiply(AEQuaternion q, AEQuaternion result) {
        result.w = (this.w * q.w >> 12) - (this.x * q.x >> 12) - (this.y * q.y >> 12) - (this.z * q.z >> 12);
        result.x = (this.w * q.x >> 12) + (this.x * q.w >> 12) + (this.y * q.z >> 12) - (this.z * q.y >> 12);
        result.y = (this.w * q.y >> 12) + (this.y * q.w >> 12) + (this.z * q.x >> 12) - (this.x * q.z >> 12);
        result.z = (this.w * q.z >> 12) + (this.z * q.w >> 12) + (this.x * q.y >> 12) - (this.y * q.x >> 12);
        return result;
    }

    public void multiply(AEQuaternion q) {
        int rx = (this.w * q.x >> 12) + (this.x * q.w >> 12) + (this.y * q.z >> 12) - (this.z * q.y >> 12);
        int ry = (this.w * q.y >> 12) + (this.y * q.w >> 12) + (this.z * q.x >> 12) - (this.x * q.z >> 12);
        int rz = (this.w * q.z >> 12) + (this.z * q.w >> 12) + (this.x * q.y >> 12) - (this.y * q.x >> 12);
        int rw = (this.w * q.w >> 12) - (this.x * q.x >> 12) - (this.y * q.y >> 12) - (this.z * q.z >> 12);
        this.x = rx;
        this.y = ry;
        this.z = rz;
        this.w = rw;
    }

    public AEQuaternion multiplyL(AEQuaternion q, AEQuaternion result) {
        result.x = (int)((long)this.w * (long)q.x + (long)this.x * (long)q.w + (long)this.y * (long)q.z - (long)this.z * (long)q.y >> 12);
        result.y = (int)((long)this.w * (long)q.y + (long)this.y * (long)q.w + (long)this.z * (long)q.x - (long)this.x * (long)q.z >> 12);
        result.z = (int)((long)this.w * (long)q.z + (long)this.z * (long)q.w + (long)this.x * (long)q.y - (long)this.y * (long)q.x >> 12);
        result.w = (int)((long)this.w * (long)q.w - (long)this.x * (long)q.x - (long)this.y * (long)q.y - (long)this.z * (long)q.z >> 12);
        return result;
    }

    public void multiplyL(AEQuaternion q) {
        int rx = (int)((long)this.w * (long)q.x + (long)this.x * (long)q.w + (long)this.y * (long)q.z - (long)this.z * (long)q.y >> 12);
        int ry = (int)((long)this.w * (long)q.y + (long)this.y * (long)q.w + (long)this.z * (long)q.x - (long)this.x * (long)q.z >> 12);
        int rz = (int)((long)this.w * (long)q.z + (long)this.z * (long)q.w + (long)this.x * (long)q.y - (long)this.y * (long)q.x >> 12);
        int rw = (int)((long)this.w * (long)q.w - (long)this.x * (long)q.x - (long)this.y * (long)q.y - (long)this.z * (long)q.z >> 12);
        this.x = rx;
        this.y = ry;
        this.z = rz;
        this.w = rw;
    }

    public void mul(int s) {
        this.x = (int)((long)s * (long)this.x >> 12);
        this.y = (int)((long)s * (long)this.y >> 12);
        this.z = (int)((long)s * (long)this.z >> 12);
        this.w = (int)((long)s * (long)this.w >> 12);
    }

    public AEQuaternion mul(int s, AEQuaternion result) {
        result.x = (int)((long)s * (long)this.x >> 12);
        result.y = (int)((long)s * (long)this.y >> 12);
        result.z = (int)((long)s * (long)this.z >> 12);
        result.w = (int)((long)s * (long)this.w >> 12);
        return result;
    }

    public int dot(AEQuaternion q) {
        return (this.w * q.w >> 12) + (this.x * q.x >> 12) + (this.y * q.y >> 12) + (this.z * q.z >> 12);
    }

    public int dotL(AEQuaternion q) {
        return (int)((long)this.x * (long)q.x + (long)this.y * (long)q.y + (long)this.z * (long)q.z + (long)this.w * (long)q.w >> 12);
    }

    public AEQuaternion normalize(AEQuaternion result) {
        int d = AEMath.invsqrt((this.x * this.x >> 12) + (this.y * this.y >> 12) + (this.z * this.z >> 12) + (this.w * this.w >> 12));
        result.x = this.x * d >> 12;
        result.y = this.y * d >> 12;
        result.z = this.z * d >> 12;
        result.w = this.w * d >> 12;
        return result;
    }

    public AEQuaternion normalizeL(AEQuaternion result) {
        int d = AEMath.invsqrt((int)((long)this.x * (long)this.x + (long)this.y * (long)this.y + (long)this.z * (long)this.z + (long)this.w * (long)this.w >> 12));
        result.x = this.x * d >> 12;
        result.y = this.y * d >> 12;
        result.z = this.z * d >> 12;
        result.w = this.w * d >> 12;
        return result;
    }

    public void normalize() {
        this.normalize(this);
    }

    public void normalizeL() {
        this.normalizeL(this);
    }

    public int length() {
        return AEMath.sqrt((int)((long)this.x * (long)this.x + (long)this.y * (long)this.y + (long)this.z * (long)this.z + (long)this.w * (long)this.w >> 12));
    }

    public int invLength() {
        return AEMath.invsqrt((int)((long)this.x * (long)this.x + (long)this.y * (long)this.y + (long)this.z * (long)this.z + (long)this.w * (long)this.w >> 12));
    }

    public AEQuaternion getConjugate(AEQuaternion result) {
        result.x = -this.x;
        result.y = -this.y;
        result.z = -this.z;
        result.w = this.w;
        return result;
    }

    public AEQuaternion getInverse(AEQuaternion result) {
        int invSqrLength = this.invLength();
        if (invSqrLength > 4050 && invSqrLength < 4140) {
            return this.getConjugate(result);
        }
        result = this.getConjugate(result);
        invSqrLength *= invSqrLength;
        result = result.mul(invSqrLength >> 12, result);
        return result;
    }

    public void invert() {
        this.getInverse(this);
    }

    public void conjugate() {
        this.getConjugate(this);
    }

    public void set(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void set(AEVector3D vec, int w) {
        this.set(vec.x, vec.y, vec.z, w);
    }

    public void set(AEQuaternion q) {
        this.set(q.x, q.y, q.z, q.w);
    }

    public String toString() {
        return "AEQuaternion | " + this.x + ",\t" + this.y + ",\t" + this.z + ",\t" + this.w;
    }
}

