/*
 * Decompiled with CFR 0.152.
 */
package AppKit;

import AppKit.AEMenuButton;
import AppKit.AEMenuScrollBox;
import contentHeliStrike.MainMenu;

public class AEMenuButtonLayout {
    protected int current_id;
    public AEMenuButton[] button;
    protected AEMenuScrollBox scroll_box;

    public void selectNextButton() {
        if (this.scroll_box == null) {
            if (this.button == null) {
                return;
            }
            this.button[this.current_id].deselect();
            for (int i = 0; i < this.button.length + 1; ++i) {
                ++this.current_id;
                if (this.current_id >= this.button.length) {
                    this.current_id = 0;
                }
                if (!this.button[this.current_id].isActive()) continue;
                this.button[this.current_id].select();
                break;
            }
        } else {
            this.scroll_box.scrollDown();
        }
    }

    public void selectPrevButton() {
        if (this.scroll_box == null) {
            if (this.button == null) {
                return;
            }
            this.button[this.current_id].deselect();
            for (int i = 0; i < this.button.length + 1; ++i) {
                --this.current_id;
                if (this.current_id < 0) {
                    this.current_id = this.button.length - 1;
                }
                if (!this.button[this.current_id].isActive()) continue;
                this.button[this.current_id].select();
                break;
            }
        } else {
            this.scroll_box.scrollUp();
        }
    }

    public void pressButton() {
        if (this.button == null) {
            return;
        }
        this.button[this.current_id].press();
    }

    public int getCurrentButton() {
        return this.button == null ? -1 : this.current_id;
    }

    public void addButton(AEMenuButton button) {
        if (this.button == null) {
            this.button = new AEMenuButton[1];
            this.button[0] = button;
        } else {
            AEMenuButton[] new_button = new AEMenuButton[this.button.length + 1];
            System.arraycopy(this.button, 0, new_button, 0, this.button.length);
            new_button[this.button.length] = button;
            this.button = new_button;
        }
    }

    public void removeButton(AEMenuButton button) {
        if (this.button == null) {
            return;
        }
        for (int i = 0; i < this.button.length; ++i) {
            if (this.button[i] != button) continue;
            this.removeButton(i);
            break;
        }
    }

    public void removeButton(int button_id) {
        if (this.button == null) {
            return;
        }
        if (button_id < this.button.length) {
            if (this.button.length == 1) {
                this.button = null;
                return;
            }
            AEMenuButton[] new_button = new AEMenuButton[this.button.length - 1];
            System.arraycopy(this.button, 0, new_button, 0, button_id);
            System.arraycopy(this.button, button_id + 1, new_button, button_id, this.button.length - button_id - 1);
            this.button = new_button;
        }
        if (button_id == this.current_id) {
            this.selectNextButton();
        } else if (button_id < this.current_id) {
            this.selectPrevButton();
        }
    }

    public void removeCurrentButton() {
        this.removeButton(this.current_id);
    }

    public void draw() {
        if (this.scroll_box == null) {
            if (this.button == null) {
                return;
            }
            for (int i = 0; i < this.button.length; ++i) {
                this.button[i].draw();
            }
        } else {
            MainMenu.iGeoffState = 6;
            this.scroll_box.draw();
        }
    }

    public void init() {
        if (this.scroll_box == null) {
            int i;
            this.current_id = 0;
            if (this.button == null) {
                return;
            }
            for (i = 0; i < this.button.length; ++i) {
                this.button[i].init();
                this.button[i].deselect();
            }
            for (i = 0; i < this.button.length; ++i) {
                if (!this.button[i].isActive()) continue;
                this.button[i].select();
                this.current_id = i;
                break;
            }
        } else {
            this.scroll_box.init();
        }
    }

    public boolean fadeIn() {
        if (this.scroll_box == null) {
            boolean result = true;
            for (int i = 0; this.button != null && i < this.button.length; ++i) {
                result &= this.button[i].fadeIn();
            }
            return result;
        }
        return this.scroll_box.fadeIn();
    }

    public boolean fadeOut() {
        if (this.scroll_box == null) {
            boolean result = true;
            for (int i = 0; this.button != null && i < this.button.length; ++i) {
                result &= this.button[i].fadeOut();
            }
            return result;
        }
        return this.scroll_box.fadeOut();
    }

    public void setScrollBox(AEMenuScrollBox scroll_box) {
        this.scroll_box = scroll_box;
    }

    public void forceFadeIn() {
        if (this.scroll_box != null) {
            this.scroll_box.forceFadeIn();
        } else {
            for (int i = 0; this.button != null && i < this.button.length; ++i) {
                this.button[i].forceFadeIn();
            }
        }
    }

    public AEMenuButton currentButton() {
        if (this.button == null || this.current_id < 0 || this.current_id >= this.button.length) {
            return null;
        }
        return this.button[this.current_id];
    }

    public void release() {
        if (this.button != null) {
            for (int i = 0; i < this.button.length; ++i) {
                this.button[i].release();
                this.button[i] = null;
            }
            this.button = null;
        }
        if (this.scroll_box != null) {
            this.scroll_box.release();
            this.scroll_box = null;
        }
    }
}

