/*
 * Decompiled with CFR 0.152.
 */
package ScrollerGame;

import AbyssEngine.AEGeometry;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AEScene;
import AbyssEngine.AETransform;
import AbyssEngine.AEVector3D;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCModulData;
import ScrollerGame.SCTileSet;
import contentHeliStrike.SCEnemyFactory;
import java.util.Random;

public class SCModul {
    public static final int TILE_SIZE = 4096;
    public static final int TILE_SHIFT = 12;
    public static final int CONNECTION_IN_LEFT = 1;
    public static final int CONNECTION_IN_TOP = 2;
    public static final int CONNECTION_IN_RIGHT = 4;
    public static final int CONNECTION_IN_BOTTOM = 8;
    public static final int CONNECTION_OUT_LEFT = 16;
    public static final int CONNECTION_OUT_TOP = 32;
    public static final int CONNECTION_OUT_RIGHT = 64;
    public static final int CONNECTION_OUT_BOTTOM = 128;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;
    public AEScene root = new AEScene();
    private long tx;
    private long tz;
    private int ry;
    private int out_connection;
    private int out_categorie;
    private SCModulData moduldata;
    private SCEnemySet enemy_set = new SCEnemySet();
    private static AEVector3D tmp_pos;
    private static AEVector3D tmp_left;
    private static AEVector3D tmp_up;
    private static AEVector3D tmp_dir;
    private boolean path_direction = true;

    public SCModul(Random rndm, SCTileSet tileset, long tile) {
        this.moduldata = tileset.getModuls()[rndm.nextInt(tileset.getModuls().length)];
        this.addStaticMeshes(tile);
        if ((this.moduldata.getConnectionInOut() & 0x10) != 0) {
            this.out_connection = 1;
            this.out_categorie = this.moduldata.getConnectionCategoryLeft();
        } else if ((this.moduldata.getConnectionInOut() & 0x20) != 0) {
            this.out_connection = 2;
            this.out_categorie = this.moduldata.getConnectionCategoryTop();
        } else if ((this.moduldata.getConnectionInOut() & 0x40) != 0) {
            this.out_connection = 3;
            this.out_categorie = this.moduldata.getConnectionCategoryRight();
        } else if ((this.moduldata.getConnectionInOut() & 0x80) != 0) {
            this.out_connection = 4;
            this.out_categorie = this.moduldata.getConnectionCategoryBottom();
        }
        this.setPathDirection();
        this.createStaticFields();
    }

    public SCModul(Random rndm, SCTileSet tileset, SCModul prev_modul, long tile) {
        this.getModulDataAndPlace(rndm, tileset, prev_modul);
        this.addStaticMeshes(tile);
        this.root.setRotation(0, this.ry, 0);
        this.setPathDirection();
        this.createStaticFields();
    }

    public void replace() {
        this.root.setTranslation((int)(this.tx + SCLevel.global_tx), 0, (int)(this.tz + SCLevel.global_tz));
        this.root.update(false);
    }

    public long getTx() {
        return this.tx;
    }

    public long getTz() {
        return this.tz;
    }

    public int getPathSpace(AETransform wm, int[] offset, int s, boolean invert_direction) {
        boolean bl = invert_direction ? !this.path_direction : (invert_direction = this.path_direction);
        if (invert_direction) {
            s = this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 9] - s;
        }
        if (s < 0 || s >= this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 9]) {
            if (invert_direction) {
                return s - 1;
            }
            return this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 9] - s - 1;
        }
        block0 : switch (this.ry) {
            case 0: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 9) {
                    int sx2;
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 9] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 9] - s << 12) / l_segment;
                    SCModul.tmp_pos.x = this.moduldata.getHeroPath()[i - 8] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 8]) >> 12) + (int)(this.tx + SCLevel.global_tx);
                    SCModul.tmp_pos.y = this.moduldata.getHeroPath()[i - 7] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 7]) >> 12);
                    SCModul.tmp_pos.z = this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 6]) >> 12) + (int)(this.tz + SCLevel.global_tz);
                    SCModul.tmp_left.x = this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 4] - this.moduldata.getHeroPath()[i - 5]) >> 12);
                    SCModul.tmp_left.y = this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 5] - this.moduldata.getHeroPath()[i - 4]) >> 12);
                    SCModul.tmp_left.z = this.moduldata.getHeroPath()[i - 3] + ((int)blend * (this.moduldata.getHeroPath()[i + 6] - this.moduldata.getHeroPath()[i - 3]) >> 12);
                    int sx1 = this.moduldata.getHeroPath()[i - 2] + ((int)blend * (this.moduldata.getHeroPath()[i + 7] - this.moduldata.getHeroPath()[i - 2]) >> 12);
                    if (sx1 <= (sx2 = this.moduldata.getHeroPath()[i - 1] + ((int)blend * (this.moduldata.getHeroPath()[i + 8] - this.moduldata.getHeroPath()[i - 1]) >> 12))) {
                        if (offset[0] < sx1) {
                            offset[0] = sx1;
                            break block0;
                        }
                        if (offset[0] <= sx2) break block0;
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] < sx2) {
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] <= sx1) break block0;
                    offset[0] = sx1;
                    break block0;
                }
                break;
            }
            case 1024: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 9) {
                    int sx2;
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 9] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 9] - s << 12) / l_segment;
                    SCModul.tmp_pos.z = -(this.moduldata.getHeroPath()[i - 8] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 8]) >> 12)) + (int)(this.tz + SCLevel.global_tz);
                    SCModul.tmp_pos.y = this.moduldata.getHeroPath()[i - 7] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 7]) >> 12);
                    SCModul.tmp_pos.x = this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 6]) >> 12) + (int)(this.tx + SCLevel.global_tx);
                    SCModul.tmp_left.z = -(this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 4] - this.moduldata.getHeroPath()[i - 5]) >> 12));
                    SCModul.tmp_left.y = this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 5] - this.moduldata.getHeroPath()[i - 4]) >> 12);
                    SCModul.tmp_left.x = this.moduldata.getHeroPath()[i - 3] + ((int)blend * (this.moduldata.getHeroPath()[i + 6] - this.moduldata.getHeroPath()[i - 3]) >> 12);
                    int sx1 = this.moduldata.getHeroPath()[i - 2] + ((int)blend * (this.moduldata.getHeroPath()[i + 7] - this.moduldata.getHeroPath()[i - 2]) >> 12);
                    if (sx1 <= (sx2 = this.moduldata.getHeroPath()[i - 1] + ((int)blend * (this.moduldata.getHeroPath()[i + 8] - this.moduldata.getHeroPath()[i - 1]) >> 12))) {
                        if (offset[0] < sx1) {
                            offset[0] = sx1;
                            break block0;
                        }
                        if (offset[0] <= sx2) break block0;
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] < sx2) {
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] <= sx1) break block0;
                    offset[0] = sx1;
                    break block0;
                }
                break;
            }
            case 2048: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 9) {
                    int sx2;
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 9] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 9] - s << 12) / l_segment;
                    SCModul.tmp_pos.x = -(this.moduldata.getHeroPath()[i - 8] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 8]) >> 12)) + (int)(this.tx + SCLevel.global_tx);
                    SCModul.tmp_pos.y = this.moduldata.getHeroPath()[i - 7] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 7]) >> 12);
                    SCModul.tmp_pos.z = -(this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 6]) >> 12)) + (int)(this.tz + SCLevel.global_tz);
                    SCModul.tmp_left.x = -(this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 4] - this.moduldata.getHeroPath()[i - 5]) >> 12));
                    SCModul.tmp_left.y = this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 5] - this.moduldata.getHeroPath()[i - 4]) >> 12);
                    SCModul.tmp_left.z = -(this.moduldata.getHeroPath()[i - 3] + ((int)blend * (this.moduldata.getHeroPath()[i + 6] - this.moduldata.getHeroPath()[i - 3]) >> 12));
                    int sx1 = this.moduldata.getHeroPath()[i - 2] + ((int)blend * (this.moduldata.getHeroPath()[i + 7] - this.moduldata.getHeroPath()[i - 2]) >> 12);
                    if (sx1 <= (sx2 = this.moduldata.getHeroPath()[i - 1] + ((int)blend * (this.moduldata.getHeroPath()[i + 8] - this.moduldata.getHeroPath()[i - 1]) >> 12))) {
                        if (offset[0] < sx1) {
                            offset[0] = sx1;
                            break block0;
                        }
                        if (offset[0] <= sx2) break block0;
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] < sx2) {
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] <= sx1) break block0;
                    offset[0] = sx1;
                    break block0;
                }
                break;
            }
            case 3072: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 9) {
                    int sx2;
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 9] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 9] - s << 12) / l_segment;
                    SCModul.tmp_pos.z = this.moduldata.getHeroPath()[i - 8] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 8]) >> 12) + (int)(this.tz + SCLevel.global_tz);
                    SCModul.tmp_pos.y = this.moduldata.getHeroPath()[i - 7] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 7]) >> 12);
                    SCModul.tmp_pos.x = -(this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 6]) >> 12)) + (int)(this.tx + SCLevel.global_tx);
                    SCModul.tmp_left.z = this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 4] - this.moduldata.getHeroPath()[i - 5]) >> 12);
                    SCModul.tmp_left.y = this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 5] - this.moduldata.getHeroPath()[i - 4]) >> 12);
                    SCModul.tmp_left.x = -(this.moduldata.getHeroPath()[i - 3] + ((int)blend * (this.moduldata.getHeroPath()[i + 6] - this.moduldata.getHeroPath()[i - 3]) >> 12));
                    int sx1 = this.moduldata.getHeroPath()[i - 2] + ((int)blend * (this.moduldata.getHeroPath()[i + 7] - this.moduldata.getHeroPath()[i - 2]) >> 12);
                    if (sx1 <= (sx2 = this.moduldata.getHeroPath()[i - 1] + ((int)blend * (this.moduldata.getHeroPath()[i + 8] - this.moduldata.getHeroPath()[i - 1]) >> 12))) {
                        if (offset[0] < sx1) {
                            offset[0] = sx1;
                            break block0;
                        }
                        if (offset[0] <= sx2) break block0;
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] < sx2) {
                        offset[0] = sx2;
                        break block0;
                    }
                    if (offset[0] <= sx1) break block0;
                    offset[0] = sx1;
                    break block0;
                }
                break;
            }
        }
        SCModul.tmp_pos.y += offset[1];
        tmp_left.normalize();
        if (invert_direction) {
            SCModul.tmp_pos.x -= offset[0] * SCModul.tmp_left.x >> 12;
            SCModul.tmp_pos.y -= offset[0] * SCModul.tmp_left.y >> 12;
            SCModul.tmp_pos.z -= offset[0] * SCModul.tmp_left.z >> 12;
        } else {
            SCModul.tmp_pos.x += offset[0] * SCModul.tmp_left.x >> 12;
            SCModul.tmp_pos.y += offset[0] * SCModul.tmp_left.y >> 12;
            SCModul.tmp_pos.z += offset[0] * SCModul.tmp_left.z >> 12;
        }
        tmp_up.set(0, 4096, 0);
        tmp_dir.set(tmp_left);
        tmp_dir.cross(tmp_up);
        tmp_dir.normalize();
        tmp_up.set(tmp_dir);
        tmp_up.cross(tmp_left);
        if (!invert_direction) {
            SCModul.tmp_dir.x = -SCModul.tmp_dir.x;
            SCModul.tmp_dir.y = -SCModul.tmp_dir.y;
            SCModul.tmp_dir.z = -SCModul.tmp_dir.z;
            SCModul.tmp_left.x = -SCModul.tmp_left.x;
            SCModul.tmp_left.y = -SCModul.tmp_left.y;
            SCModul.tmp_left.z = -SCModul.tmp_left.z;
        }
        wm.setRotationMatrix(tmp_left, tmp_up, tmp_dir);
        wm.setTranslation(tmp_pos);
        if (!invert_direction) {
            return s - 1;
        }
        return this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 9] - s - 1;
    }

    public int getPathPosition(AEVector3D pos, int s) {
        if (this.path_direction) {
            s = this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 7] - s;
            if (s < 0) {
                s = 0;
            }
        } else if (s >= this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 7]) {
            s = this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 7] - 1;
        }
        block0 : switch (this.ry) {
            case 0: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 7) {
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 7] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 7] - s << 12) / l_segment;
                    pos.x = this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 6]) >> 12) + (int)(this.tx + SCLevel.global_tx);
                    pos.y = this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 5]) >> 12);
                    pos.z = this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 4]) >> 12) + (int)(this.tz + SCLevel.global_tz);
                    break block0;
                }
                break;
            }
            case 1024: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 7) {
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 7] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 7] - s << 12) / l_segment;
                    pos.z = -(this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 6]) >> 12)) + (int)(this.tz + SCLevel.global_tz);
                    pos.y = this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 5]) >> 12);
                    pos.x = this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 4]) >> 12) + (int)(this.tx + SCLevel.global_tx);
                    break block0;
                }
                break;
            }
            case 2048: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 7) {
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 7] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 7] - s << 12) / l_segment;
                    pos.x = -(this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 6]) >> 12)) + (int)(this.tx + SCLevel.global_tx);
                    pos.y = this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 5]) >> 12);
                    pos.z = -(this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 4]) >> 12)) + (int)(this.tz + SCLevel.global_tz);
                    break block0;
                }
                break;
            }
            case 3072: {
                for (int i = 0; i < this.moduldata.getHeroPath().length; i += 7) {
                    if (s >= this.moduldata.getHeroPath()[i]) continue;
                    int l_segment = this.moduldata.getHeroPath()[i - 7] - this.moduldata.getHeroPath()[i];
                    long blend = (this.moduldata.getHeroPath()[i - 7] - s << 12) / l_segment;
                    pos.z = this.moduldata.getHeroPath()[i - 6] + ((int)blend * (this.moduldata.getHeroPath()[i + 1] - this.moduldata.getHeroPath()[i - 6]) >> 12) + (int)(this.tz + SCLevel.global_tz);
                    pos.y = this.moduldata.getHeroPath()[i - 5] + ((int)blend * (this.moduldata.getHeroPath()[i + 2] - this.moduldata.getHeroPath()[i - 5]) >> 12);
                    pos.x = -(this.moduldata.getHeroPath()[i - 4] + ((int)blend * (this.moduldata.getHeroPath()[i + 3] - this.moduldata.getHeroPath()[i - 4]) >> 12)) + (int)(this.tx + SCLevel.global_tx);
                    break block0;
                }
                break;
            }
        }
        if (this.path_direction) {
            return s - 1;
        }
        return this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 7] - s - 1;
    }

    public SCEnemySet getEnemies() {
        return this.enemy_set;
    }

    private void createStaticFields() {
        if (tmp_pos == null) {
            tmp_pos = new AEVector3D();
        }
        if (tmp_left == null) {
            tmp_left = new AEVector3D();
        }
        if (tmp_up == null) {
            tmp_up = new AEVector3D();
        }
        if (tmp_dir == null) {
            tmp_dir = new AEVector3D();
        }
    }

    private void setPathDirection() {
        switch (this.out_connection) {
            case 1: {
                if (this.moduldata.getHeroPath()[1] < this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 8]) {
                    this.path_direction = true;
                    break;
                }
                this.path_direction = false;
                break;
            }
            case 2: {
                if (this.moduldata.getHeroPath()[3] < this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 6]) {
                    this.path_direction = true;
                    break;
                }
                this.path_direction = false;
                break;
            }
            case 3: {
                if (this.moduldata.getHeroPath()[1] > this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 8]) {
                    this.path_direction = true;
                    break;
                }
                this.path_direction = false;
                break;
            }
            case 4: {
                this.path_direction = this.moduldata.getHeroPath()[3] > this.moduldata.getHeroPath()[this.moduldata.getHeroPath().length - 6];
            }
        }
    }

    private void getModulDataAndPlace(Random rndm, SCTileSet tileset, SCModul prev_modul) {
        block0 : switch (this.getModulData(rndm, tileset, prev_modul)) {
            case 1: {
                switch (prev_modul.out_connection) {
                    case 1: {
                        this.ry = 2048;
                        break;
                    }
                    case 2: {
                        this.ry = 1024;
                        break;
                    }
                    case 3: {
                        this.ry = 0;
                        break;
                    }
                    case 4: {
                        this.ry = 3072;
                    }
                }
                break;
            }
            case 2: {
                switch (prev_modul.out_connection) {
                    case 1: {
                        this.ry = 3072;
                        break;
                    }
                    case 2: {
                        this.ry = 2048;
                        break;
                    }
                    case 3: {
                        this.ry = 1024;
                        break;
                    }
                    case 4: {
                        this.ry = 0;
                    }
                }
                break;
            }
            case 3: {
                switch (prev_modul.out_connection) {
                    case 1: {
                        this.ry = 0;
                        break;
                    }
                    case 2: {
                        this.ry = 3072;
                        break;
                    }
                    case 3: {
                        this.ry = 2048;
                        break;
                    }
                    case 4: {
                        this.ry = 1024;
                    }
                }
                break;
            }
            case 4: {
                switch (prev_modul.out_connection) {
                    case 1: {
                        this.ry = 1024;
                        break block0;
                    }
                    case 2: {
                        this.ry = 0;
                        break block0;
                    }
                    case 3: {
                        this.ry = 3072;
                        break block0;
                    }
                    case 4: {
                        this.ry = 2048;
                    }
                }
            }
        }
        this.ry = this.ry + prev_modul.ry & 0xFFF;
        block30 : switch (prev_modul.out_connection) {
            case 1: {
                switch (prev_modul.ry) {
                    case 0: {
                        this.tx = prev_modul.tx - 4096L;
                        this.tz = prev_modul.tz;
                        break;
                    }
                    case 1024: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz + 4096L;
                        break;
                    }
                    case 2048: {
                        this.tx = prev_modul.tx + 4096L;
                        this.tz = prev_modul.tz;
                        break;
                    }
                    case 3072: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz - 4096L;
                    }
                }
                break;
            }
            case 2: {
                switch (prev_modul.ry) {
                    case 0: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz - 4096L;
                        break;
                    }
                    case 1024: {
                        this.tx = prev_modul.tx - 4096L;
                        this.tz = prev_modul.tz;
                        break;
                    }
                    case 2048: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz + 4096L;
                        break;
                    }
                    case 3072: {
                        this.tx = prev_modul.tx + 4096L;
                        this.tz = prev_modul.tz;
                    }
                }
                break;
            }
            case 3: {
                switch (prev_modul.ry) {
                    case 0: {
                        this.tx = prev_modul.tx + 4096L;
                        this.tz = prev_modul.tz;
                        break;
                    }
                    case 1024: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz - 4096L;
                        break;
                    }
                    case 2048: {
                        this.tx = prev_modul.tx - 4096L;
                        this.tz = prev_modul.tz;
                        break;
                    }
                    case 3072: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz + 4096L;
                    }
                }
                break;
            }
            case 4: {
                switch (prev_modul.ry) {
                    case 0: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz + 4096L;
                        break block30;
                    }
                    case 1024: {
                        this.tx = prev_modul.tx + 4096L;
                        this.tz = prev_modul.tz;
                        break block30;
                    }
                    case 2048: {
                        this.tx = prev_modul.tx;
                        this.tz = prev_modul.tz - 4096L;
                        break block30;
                    }
                    case 3072: {
                        this.tx = prev_modul.tx - 4096L;
                        this.tz = prev_modul.tz;
                    }
                }
            }
        }
    }

    private int getModulData(Random rndm, SCTileSet tileset, SCModul prev_modul) {
        int indx = rndm.nextInt(tileset.getModuls().length);
        int edge_indx = rndm.nextInt(4) + 1;
        for (int i = 0; i < tileset.getModuls().length; ++i) {
            this.moduldata = tileset.getModuls()[indx];
            for (int k = 0; k < 4; ++k) {
                switch (edge_indx) {
                    case 1: {
                        if ((this.moduldata.getConnectionInOut() & 1) == 0 || this.moduldata.getConnectionCategoryLeft() != prev_modul.out_categorie || prev_modul.moduldata == this.moduldata) break;
                        if ((this.moduldata.getConnectionInOut() & 0x20) != 0) {
                            this.out_connection = 2;
                            this.out_categorie = this.moduldata.getConnectionCategoryTop();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x40) != 0) {
                            this.out_connection = 3;
                            this.out_categorie = this.moduldata.getConnectionCategoryRight();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x80) != 0) {
                            this.out_connection = 4;
                            this.out_categorie = this.moduldata.getConnectionCategoryBottom();
                        }
                        return 1;
                    }
                    case 2: {
                        if ((this.moduldata.getConnectionInOut() & 2) == 0 || this.moduldata.getConnectionCategoryTop() != prev_modul.out_categorie || prev_modul.moduldata == this.moduldata) break;
                        if ((this.moduldata.getConnectionInOut() & 0x10) != 0) {
                            this.out_connection = 1;
                            this.out_categorie = this.moduldata.getConnectionCategoryLeft();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x40) != 0) {
                            this.out_connection = 3;
                            this.out_categorie = this.moduldata.getConnectionCategoryRight();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x80) != 0) {
                            this.out_connection = 4;
                            this.out_categorie = this.moduldata.getConnectionCategoryBottom();
                        }
                        return 2;
                    }
                    case 3: {
                        if ((this.moduldata.getConnectionInOut() & 4) == 0 || this.moduldata.getConnectionCategoryRight() != prev_modul.out_categorie || prev_modul.moduldata == this.moduldata) break;
                        if ((this.moduldata.getConnectionInOut() & 0x20) != 0) {
                            this.out_connection = 2;
                            this.out_categorie = this.moduldata.getConnectionCategoryTop();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x10) != 0) {
                            this.out_connection = 1;
                            this.out_categorie = this.moduldata.getConnectionCategoryLeft();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x80) != 0) {
                            this.out_connection = 4;
                            this.out_categorie = this.moduldata.getConnectionCategoryBottom();
                        }
                        return 3;
                    }
                    case 4: {
                        if ((this.moduldata.getConnectionInOut() & 8) == 0 || this.moduldata.getConnectionCategoryBottom() != prev_modul.out_categorie || prev_modul.moduldata == this.moduldata) break;
                        if ((this.moduldata.getConnectionInOut() & 0x20) != 0) {
                            this.out_connection = 2;
                            this.out_categorie = this.moduldata.getConnectionCategoryTop();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x40) != 0) {
                            this.out_connection = 3;
                            this.out_categorie = this.moduldata.getConnectionCategoryRight();
                        }
                        if ((this.moduldata.getConnectionInOut() & 0x10) != 0) {
                            this.out_connection = 1;
                            this.out_categorie = this.moduldata.getConnectionCategoryLeft();
                        }
                        return 4;
                    }
                }
                if (++edge_indx <= 4) continue;
                edge_indx = 1;
            }
            if (++indx < tileset.getModuls().length) continue;
            indx = 0;
        }
        return 0;
    }

    private void addStaticMeshes(long tile) {
        int i;
        for (i = 0; this.moduldata.getStaticObjectIds() != null && i < this.moduldata.getStaticObjectIds().length; ++i) {
            AEGeometry tmp_mesh = AEResourceManager.getGeometryResource(this.moduldata.getStaticObjectIds()[i]);
            if (tmp_mesh == null) continue;
            tmp_mesh.setTranslation(this.moduldata.getStaticObjectTrans()[3 * i], this.moduldata.getStaticObjectTrans()[3 * i + 1], this.moduldata.getStaticObjectTrans()[3 * i + 2]);
            tmp_mesh.setRotation(this.moduldata.getStaticObjectRots()[3 * i], this.moduldata.getStaticObjectRots()[3 * i + 1], this.moduldata.getStaticObjectRots()[3 * i + 2]);
            tmp_mesh.setScaling(this.moduldata.getStaticObjectScales()[3 * i], this.moduldata.getStaticObjectScales()[3 * i + 1], this.moduldata.getStaticObjectScales()[3 * i + 2]);
            this.root.addChild(tmp_mesh);
        }
        for (i = 0; this.moduldata.getPointEnemyIds() != null && i < this.moduldata.getPointEnemyIds().length; ++i) {
            SCEnemy pointEnemy = SCEnemyFactory.getPointEnemy(this.moduldata.getPointEnemyIds()[i], this.moduldata.getPointEnemyTrans()[3 * i], this.moduldata.getPointEnemyTrans()[3 * i + 1], this.moduldata.getPointEnemyTrans()[3 * i + 2], this.moduldata.getPointEnemyRots()[3 * i], this.moduldata.getPointEnemyRots()[3 * i + 1], this.moduldata.getPointEnemyRots()[3 * i + 2], this.root, tile);
            if (pointEnemy == null) continue;
            this.enemy_set.addEnemy(pointEnemy);
            this.root.addChild(pointEnemy.getGeometry());
            this.root.addChild(pointEnemy.getExplosion());
        }
    }

    public boolean hasCollide() {
        return false;
    }

    public void release() {
        this.moduldata = null;
        if (this.enemy_set != null) {
            this.enemy_set.removeAllEnemies();
        }
        this.enemy_set = null;
    }

    public void finalRelease() {
        this.release();
        if (this.root != null) {
            this.root.release();
        }
        this.root = null;
    }
}

