/*
 * Decompiled with CFR 0.152.
 */
package ScrollerGame;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AELookAtConstraint;
import AbyssEngine.AEScene;
import AbyssEngine.AETransform;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.grh;
import java.util.Random;

public class SCPathEnemy
implements SCEnemy {
    private static final int STATE_IDLE = 0;
    private static final int STATE_ATTACK = 1;
    private static final int STATE_FLY_ROLL = 2;
    private static final int COME_IN_SPEED = 3500;
    private static final int MIN_ATTACK_TIME = 5000;
    private static final int MAX_ATTACK_TIME = 6000;
    private static final int MIN_IDLE_TIME = 250;
    private static final int MAX_IDLE_TIME = 500;
    private static final int MIN_ROLL_TIME = -1;
    private static final int MAX_ROLL_TIME = 0;
    public AEGraphNode geometry_group;
    public AEGraphNode geometry;
    private AEGraphNode aim_group;
    private static AETransform geometry_transform;
    private int s_path;
    private int speed;
    private int initial_speed;
    private int[] offset;
    private int offset_y_add;
    private int max_x_offset;
    private int min_y_offset;
    private int max_y_offset;
    private int target_x_offset;
    private int target_y_offset;
    private boolean dir_forward;
    private SCWeaponSystem weapon;
    private AEExplosionInterface explosion;
    private int hitradius;
    private int hitpoints;
    private int initial_hitpoints;
    private int[] target_count_array;
    private int target_count_id;
    private long tile;
    private boolean used;
    private int min_attack_time;
    private int max_attack_time;
    private int min_idle_time;
    private int max_idle_time;
    private int min_roll_time;
    private int max_roll_time;
    private int state;
    private static Random rndm;
    private int attack_time;
    private int idle_time;
    private int roll_time;
    private int max_roll;

    public SCPathEnemy(AEGraphNode geometry, int max_x_offset, int min_y_offset, int max_y_offset, int speed, boolean dir_forward, SCWeaponSystem weapon, int hitpoints, int hitradius, AEExplosionInterface explosion, int[] target_count_array, int target_count_id, boolean auto_aiming, int min_attack_time, int max_attack_time, int min_idle_time, int max_idle_time, int min_roll_time, int max_roll_time) {
        if (rndm == null) {
            rndm = new Random();
        }
        if (auto_aiming) {
            this.geometry_group = new AEScene();
            this.aim_group = new AEGroup();
            ((AEGroup)this.geometry_group).addChild(this.aim_group);
            ((AEScene)this.geometry_group).addConstraint(new AELookAtConstraint(SCLevel.getVehicle(), this.aim_group));
        } else {
            this.geometry_group = new AEGroup();
        }
        this.geometry = geometry;
        this.geometry.stopAnim(0);
        this.geometry.setRotation(0, 0, 0);
        ((AEGroup)this.geometry_group).addChild(this.geometry);
        this.dir_forward = dir_forward;
        this.tile = dir_forward ? SCLevel.getCurrentTile() : SCLevel.getCurrentTile() + (long)SCLevel.modul.length - 1L;
        this.offset = new int[2];
        this.max_x_offset = max_x_offset;
        this.offset[0] = rndm.nextInt(max_x_offset << 1) - max_x_offset;
        this.offset[1] = rndm.nextInt(max_y_offset - min_y_offset) + min_y_offset;
        this.min_y_offset = min_y_offset;
        this.max_y_offset = max_y_offset;
        this.initial_speed = this.speed = speed;
        if (geometry_transform == null) {
            geometry_transform = new AETransform();
        }
        this.initial_hitpoints = this.hitpoints = hitpoints;
        this.hitradius = hitradius;
        this.weapon = weapon;
        this.explosion = explosion;
        this.target_count_array = target_count_array;
        this.target_count_id = target_count_id;
        this.used = false;
        SCLevel.modul[(int)(this.tile - SCLevel.getCurrentTile())].getPathSpace(geometry_transform, this.offset, this.s_path, !dir_forward);
        this.geometry_group.setLocalTransform(geometry_transform);
        this.geometry_group.update(false);
        this.offset_y_add = dir_forward ? 512 : 0;
        this.min_attack_time = min_attack_time;
        this.max_attack_time = max_attack_time <= min_attack_time ? min_attack_time + 1 : max_attack_time;
        this.min_idle_time = min_idle_time;
        this.max_idle_time = max_idle_time <= min_idle_time ? min_idle_time + 1 : max_idle_time;
        this.min_roll_time = min_roll_time;
        this.max_roll_time = max_roll_time <= min_roll_time ? min_roll_time + 1 : max_roll_time;
        this.state = 0;
        this.idle_time = rndm.nextInt(max_idle_time - min_idle_time) + min_idle_time;
    }

    public SCPathEnemy(AEGraphNode geometry, int max_x_offset, int min_y_offset, int max_y_offset, int speed, boolean dir_forward, SCWeaponSystem weapon, int hitpoints, int hitradius, AEExplosionInterface explosion, int[] target_count_array, int target_count_id, boolean auto_aiming) {
        this(geometry, max_x_offset, min_y_offset, max_y_offset, speed, dir_forward, weapon, hitpoints, hitradius, explosion, target_count_array, target_count_id, auto_aiming, 5000, 6000, 250, 500, -1, 0);
    }

    public void reinit(int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
        this.hitpoints = this.initial_hitpoints;
        this.speed = this.initial_speed;
        this.geometry.stopAnim(0);
        this.geometry.setRotation(0, 0, 0);
        this.tile = this.dir_forward ? SCLevel.getCurrentTile() : SCLevel.getCurrentTile() + (long)SCLevel.modul.length - 1L;
        this.offset[0] = rndm.nextInt(this.max_x_offset << 1) - this.max_x_offset;
        this.offset[1] = rndm.nextInt(this.max_y_offset - this.min_y_offset) + this.min_y_offset;
        if ((SCLevel.getOffsetX() - this.offset[0] < 0 ? -SCLevel.getOffsetX() + this.offset[0] : SCLevel.getOffsetX() - this.offset[0]) < 300) {
            System.out.println("SCPathEnemy | avoiding collision ...");
            this.offset[0] = SCLevel.getOffsetX() < 0 ? this.max_x_offset : -this.max_x_offset;
        }
        this.s_path = 0;
        SCLevel.getEnemies().addEnemy(this);
        SCLevel.getRenderEnemySet().addEnemy(this);
        this.used = true;
        SCLevel.modul[(int)(this.tile - SCLevel.getCurrentTile())].getPathSpace(geometry_transform, this.offset, this.s_path, !this.dir_forward);
        this.geometry_group.setLocalTransform(geometry_transform);
        this.geometry_group.update(false);
        this.offset_y_add = this.dir_forward ? 512 : 0;
        this.state = 0;
        this.idle_time = rndm.nextInt(this.max_idle_time - this.min_idle_time) + this.min_idle_time;
        if (this.weapon != null) {
            this.weapon.reinit();
        }
    }

    public void update(int elapsed_time) {
        if (this.tile < SCLevel.getCurrentTile() || this.tile >= SCLevel.getCurrentTile() + (long)SCLevel.modul.length) {
            SCLevel.getEnemies().removeEnemy(this);
            SCLevel.getRenderEnemySet().removeEnemy(this);
            this.used = false;
            return;
        }
        int tmp_s = SCLevel.modul[(int)(this.tile - SCLevel.getCurrentTile())].getPathSpace(geometry_transform, this.offset, this.s_path, !this.dir_forward);
        if (tmp_s <= 0) {
            this.s_path = -tmp_s;
            if (this.dir_forward) {
                ++this.tile;
                if (this.tile < SCLevel.getCurrentTile() || this.tile >= SCLevel.getCurrentTile() + (long)SCLevel.modul.length) {
                    SCLevel.getEnemies().removeEnemy(this);
                    SCLevel.getRenderEnemySet().removeEnemy(this);
                    this.used = false;
                    return;
                }
            } else {
                --this.tile;
                if (this.tile < SCLevel.getCurrentTile() || this.tile >= SCLevel.getCurrentTile() + (long)SCLevel.modul.length) {
                    SCLevel.getEnemies().removeEnemy(this);
                    SCLevel.getRenderEnemySet().removeEnemy(this);
                    this.used = false;
                    return;
                }
            }
            SCLevel.modul[(int)(this.tile - SCLevel.getCurrentTile())].getPathSpace(geometry_transform, this.offset, this.s_path, !this.dir_forward);
        }
        this.s_path += elapsed_time * this.speed >> 12;
        if (this.offset_y_add > 0) {
            this.offset_y_add = 3500 * this.offset_y_add >> 12;
        }
        geometry_transform.translate(0, this.offset_y_add, 0);
        int roll_angle = 0;
        switch (this.state) {
            case 0: {
                this.idle_time -= elapsed_time;
                if (this.idle_time >= 0) break;
                this.selectNextState();
                break;
            }
            case 2: {
                roll_angle = (this.roll_time * this.roll_time << 12) / this.max_roll;
                this.roll_time -= elapsed_time;
                if (this.roll_time < 0) {
                    this.geometry.setRotation(0, 0, 0);
                    this.selectNextState();
                    break;
                }
            }
            case 1: {
                if (this.weapon != null && this.aim_group == null) {
                    this.offset[1] = this.offset[1] + ((SCLevel.getOffsetY() - this.offset[1]) * 256 >> 12);
                    int n = this.offset[1] < this.min_y_offset ? this.min_y_offset : (this.offset[1] = this.offset[1] > this.max_y_offset ? this.max_y_offset : this.offset[1]);
                    if (this.dir_forward) {
                        this.offset[0] = this.offset[0] + ((SCLevel.getOffsetX() - this.offset[0]) * 256 >> 12);
                        this.geometry.setRotation(0, (SCLevel.getOffsetX() - this.offset[0]) * 1024 >> 12, ((SCLevel.getOffsetX() - this.offset[0]) * 1024 >> 12) + roll_angle);
                    } else {
                        this.offset[0] = this.offset[0] - ((SCLevel.getOffsetX() + this.offset[0]) * 256 >> 12);
                        this.geometry.setRotation(0, -((SCLevel.getOffsetX() + this.offset[0]) * 1024 >> 12), -((SCLevel.getOffsetX() + this.offset[0]) * 1024 >> 12) + roll_angle);
                    }
                } else {
                    this.offset[1] = this.offset[1] + ((-this.target_y_offset - this.offset[1]) * 128 >> 12);
                    int n = this.offset[1] < this.min_y_offset ? this.min_y_offset : (this.offset[1] = this.offset[1] > this.max_y_offset ? this.max_y_offset : this.offset[1]);
                    if (this.dir_forward) {
                        this.offset[0] = this.offset[0] + ((-this.target_x_offset - this.offset[0]) * 64 >> 12);
                        this.geometry.setRotation(0, (-this.target_x_offset - this.offset[0]) * 512 >> 12, ((-this.target_x_offset - this.offset[0]) * 512 >> 12) + roll_angle);
                    } else {
                        this.offset[0] = this.offset[0] - ((-this.target_x_offset + this.offset[0]) * 64 >> 12);
                        this.geometry.setRotation(0, -((-this.target_x_offset + this.offset[0]) * 512 >> 12), -((-this.target_x_offset + this.offset[0]) * 512 >> 12) + roll_angle);
                    }
                }
                this.attack_time -= elapsed_time;
                if (this.attack_time >= 0 || this.state == 2) break;
                this.geometry.setRotation(0, 0, 0);
                this.selectNextState();
            }
        }
        this.geometry_group.setLocalTransform(geometry_transform);
        if (this.weapon != null) {
            if (this.state == 1 || this.state == 2 && this.hitpoints > 0) {
                if (this.dir_forward && this.aim_group == null) {
                    this.weapon.shootBack(this.geometry);
                } else if (this.aim_group == null) {
                    this.weapon.shoot(this.geometry);
                } else {
                    this.weapon.shoot(this.aim_group);
                }
            }
            this.weapon.update(elapsed_time);
        }
        if (this.isDead()) {
            SCLevel.getEnemies().removeEnemy(this);
            SCLevel.getRenderEnemySet().removeEnemy(this);
            this.used = false;
            return;
        }
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.getParticleSystem().setTranslation(this.geometry.getWorldPositionX(), this.geometry.getWorldPositionY(), this.geometry.getWorldPositionZ());
            this.explosion.update(elapsed_time);
            this.speed = this.speed * 4000 >> 12;
        } else {
            this.speed = this.initial_speed + (this.offset_y_add << 4);
        }
    }

    private void selectNextState() {
        this.state = rndm.nextInt(3);
        switch (this.state) {
            case 0: {
                this.idle_time = rndm.nextInt(this.max_idle_time - this.min_idle_time) + this.min_idle_time;
                break;
            }
            case 1: {
                this.attack_time = rndm.nextInt(this.max_attack_time - this.min_attack_time) + this.min_attack_time;
                if (this.weapon != null && this.aim_group == null) break;
                this.target_x_offset = rndm.nextInt(this.max_x_offset << 1) - this.max_x_offset;
                this.target_y_offset = rndm.nextInt(this.max_y_offset - this.min_y_offset) + this.min_y_offset;
                break;
            }
            case 2: {
                this.roll_time = rndm.nextInt(this.max_roll_time - this.min_roll_time) + this.min_roll_time;
                this.max_roll = this.roll_time * this.roll_time;
            }
        }
    }

    public void applyHitpoints(int hitpoints) {
        if (this.hitpoints <= 0) {
            return;
        }
        this.hitpoints += hitpoints;
        if (this.hitpoints <= 0) {
            this.geometry.playAnim((byte)1);
            if (this.explosion != null) {
                this.explosion.start();
            }
            if (this.target_count_array != null) {
                int n = this.target_count_id;
                this.target_count_array[n] = this.target_count_array[n] + 1;
            }
            ++grh.hit_notify;
            this.state = 0;
            this.idle_time = Integer.MAX_VALUE;
        }
    }

    public int getCurrentX() {
        return this.geometry_group.getPositionX();
    }

    public int getCurrentY() {
        return this.geometry_group.getPositionY();
    }

    public int getCurrentZ() {
        return this.geometry_group.getPositionZ();
    }

    public int getHitRadius() {
        return this.hitradius;
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isDead() {
        return !(this.hitpoints > 0 || this.geometry.isPlaying() || this.explosion != null && this.explosion.isActive() || this.weapon != null && this.weapon.isActive());
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
    }

    public AEGraphNode getGeometry() {
        return this.geometry_group;
    }

    public AEGraphNode getExplosion() {
        return this.explosion == null ? null : this.explosion.getParticleSystem();
    }

    public SCWeaponSystem getWeapon() {
        return this.weapon;
    }

    public void setEnemySet(SCEnemySet enemy_set) {
    }

    public boolean isUsed() {
        return this.used;
    }

    public boolean isHit(long x, long y, long z) {
        if (this.hitpoints <= 0) {
            return false;
        }
        int dx = (int)(x + SCLevel.global_tx - (long)this.geometry_group.getPositionX());
        int dz = (int)(z + SCLevel.global_tz - (long)this.geometry_group.getPositionZ());
        return dx <= this.hitradius && dx >= -this.getHitRadius() && dz <= this.hitradius && dz >= -this.getHitRadius();
    }

    public int getEnemyClassId() {
        return this.target_count_id;
    }

    public void release() {
        this.geometry_group = null;
        this.geometry = null;
        this.aim_group = null;
        geometry_transform = null;
        this.offset = null;
        if (this.weapon != null) {
            this.weapon.release();
        }
        this.weapon = null;
        if (this.explosion != null) {
            this.explosion.release();
        }
        this.explosion = null;
        this.target_count_array = null;
        rndm = null;
    }

    public int getInitialHitpoints() {
        return this.initial_hitpoints;
    }
}

