/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosion;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AEVector3D;
import AppKit.AEMenu;
import AppKit.AEMenuAction;
import AppKit.AEMenuPage;
import AppKit.AEModule;
import AppKit.AESubMenuAction;
import AppKit.AEToggleMenuAction;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCLevel;
import ScrollerGame.SCPlayer;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.GameText;
import contentHeliStrike.HeliStrikeCamera_2;
import contentHeliStrike.MainInstantResults;
import contentHeliStrike.MainMenu;
import contentHeliStrike.MainMissionResults;
import contentHeliStrike.MainMissionWinLoose;
import contentHeliStrike.SCBoatBossEnemy;
import contentHeliStrike.SCBossTileSet1;
import contentHeliStrike.SCBossTileSet1_1;
import contentHeliStrike.SCBossTileSet2;
import contentHeliStrike.SCBossTileSet3;
import contentHeliStrike.SCEnemyFactory;
import contentHeliStrike.SCExplosion;
import contentHeliStrike.SCPlaneBossEnemy;
import contentHeliStrike.SCTankBossEnemy;
import contentHeliStrike.SCTileSet1;
import contentHeliStrike.SCTileSet2;
import contentHeliStrike.SCTileSet3;
import contentHeliStrike.grh;
import contentHeliStrike.menu.MenuButton;
import contentHeliStrike.menu.MenuButtonLayout;
import contentHeliStrike.menu.MenuPage;
import contentHeliStrike.menu.MenuToggleButton;
import contentHeliStrike.menu.SimpleTextBox;
import contentHeliStrike.menu.SoftButton;
import contentHeliStrike.menu.StaticImages;
import contentHeliStrike.menu.TextBox;
import java.util.Random;
import javax.microedition.lcdui.Image;

public class MainGame
extends AEModule {
    public static final long LEVEL_LENGTH = 25L;
    private static final long S_INIT_BOSS = 4L;
    private static final long S_PRE_BOSS = 8L;
    private static final long S_BOSS = 16L;
    private static final long S_WON = 32L;
    private static final long S_LOST = 64L;
    private static final long S_STATS = 128L;
    private int clear_color;
    private Image hud_num;
    private Image hud_shield;
    private Image hud_score;
    private Image demoCounter;
    private int hud_offset;
    private Random rndm;
    private long play_sound_timer;
    private static final long MIN_PLAY_SOUND_TIME = 4000L;
    private static final long MAX_PLAY_SOUND_TIME = 12000L;
    private long shoot_timer;
    private static final long SHOOT_DELAY_TIME = 3000L;
    private AEVector3D tmp;
    private int target_lock_tx;
    private int target_lock_ty;
    private int target_lock_cx;
    private int target_lock_cy;
    private static final long GUN_FIRE_RATE = 120L;
    private boolean nuke_armed;
    public static final int PLAYER_HITPOINTS = 400;
    private static final int PLAYER_COLLISION_DAMAGE = -10;
    private static final int MEDAL_ACCURACY_MIN_G = 2800;
    private static final int MEDAL_ACCURACY_MIN_S = 1900;
    private static final int MEDAL_ACCURACY_MIN_B = 1000;
    private static final int MEDAL_AGILITY_MIN_G = 3000;
    private static final int MEDAL_AGILITY_MIN_S = 2000;
    private static final int MEDAL_AGILITY_MIN_B = 1000;
    private static final int MEDAL_MISSION_MIN_G = 3900;
    private static final int MEDAL_MISSION_MIN_S = 3400;
    private static final int MEDAL_MISSION_MIN_B = 2900;
    private TextBox messageBox;
    private boolean showMessageBox;
    public static final byte POWERUP_WEAPON_TWO = 1;
    public static final byte POWERUP_WEAPON_THREE = 2;
    public static final byte POWERUP_WEAPON_THREE_SPREAD = 3;
    public static final byte POWERUP_WEAPON_FOUR_SPREAD = 4;
    public static final byte POWERUP_HEALTH = 5;
    public static final byte POWERUP_SHIELD = 6;
    public static final byte POWERUP_NUKE = 7;
    private byte powerup_state;
    private long powerup_time;
    private long powerup_blink_time;
    private static final long POWERUP_TIME = 4000L;
    private static final long POWERUP_BLINK_TIME = 250L;
    private Image pu_mg2;
    private Image pu_mg3;
    private Image pu_mg3s;
    private Image pu_mg4s;
    private Image pu_health;
    private Image pu_shield;
    private Image pu_nuke;
    private Image minim_11;
    private Image minim_12;
    private Image minim_13;
    private Image minim_21;
    private Image minim_22;
    private Image minim_23;
    private Image minim_31;
    private Image minim_32;
    private Image minim_33;
    private int medal_accuracy;
    private int medal_agility;
    private int medal_mission;
    private boolean getStats;
    private static final long MULTI_KILL_TIME = 850L;
    private int multi_kill_count;
    private long multi_kill_time;
    private long silo_countdown;
    private static final long SILO_COUNTDOWN = 120000L;
    private boolean missile_started;
    private AEMenu menu;
    private boolean loading = false;
    public static boolean bInGame = false;
    public static MainGame ref;

    public static AEMenuPage getMenuPage() {
        if (MainGame.ref.menu == null) {
            return null;
        }
        return MainGame.ref.menu.getPage();
    }

    public int testSK(int x, int y) {
        AEMenuPage pg = this.menu.getPage();
        if (pg != null) {
            SoftButton sb;
            int k;
            if (pg.soft_button_left != null && pg.soft_button_left.touchSB && (k = (sb = (SoftButton)pg.soft_button_left).testClick(x, y)) != 0) {
                return k;
            }
            if (pg.soft_button_right != null && pg.soft_button_right.touchSB && (k = (sb = (SoftButton)pg.soft_button_right).testClick(x, y)) != 0) {
                return k;
            }
        }
        return 0;
    }

    public void setPowerUp(byte powerup) {
        this.powerup_state = powerup;
        this.powerup_time = 4000L;
        this.powerup_blink_time = 0L;
        if (powerup == 7) {
            this.nuke_armed = true;
        }
    }

    public int onInitialize() {
        ref = this;
        if (!this.loading) {
            SCPlayer cfr_ignored_0 = (SCPlayer)SCLevel.getPlayer();
            SCPlayer.HITRADIUS = 350;
            this.tmp = new AEVector3D();
            AEGeometry heli = AEResourceManager.getGeometryResource(509);
            heli.stopAnim(0);
            heli.setScaling(18000, 18000, 18000);
            AEGeometry rotor = AEResourceManager.getGeometryResource(508);
            rotor.setScaling(18000, 18000, 18000);
            AEGeometry shield = AEResourceManager.getGeometryResource(538);
            shield.setScaling(18000, 18000, 18000);
            AEGeometry nuke = AEResourceManager.getGeometryResource(5002);
            SCLevel.cm = new HeliStrikeCamera_2(heli, rotor, shield, nuke);
            grh.r_renderer.setCamera(SCLevel.cm.getCamera());
            SCLevel.getPlayer().setHitpoints(400);
            ((SCPlayer)SCLevel.getPlayer()).resetStatsTotalHits();
            SCExplosion player_explosion = new SCExplosion(AEResourceManager.getGeometryResource(5001));
            SCLevel.setExplosion(player_explosion);
            AEGeometry gun_fire = AEGeometry.createParticleSystem(128, 80, 96, 96, 112, 100, 80, (byte)2);
            gun_fire.setTexture(AEResourceManager.getTextureResource(2));
            gun_fire.setLayer(1);
            AEExplosion hit_explosion = new AEExplosion(1, AEResourceManager.getTextureResource(2), 128, 96, 48, 128, 80, 1024, 500, 250);
            hit_explosion.getParticleSystem().setLayer(1);
            SCWeaponSystem weapon = new SCWeaponSystem(80, 12000, 2000, 15, 120, gun_fire, grh.r_renderer, hit_explosion);
            weapon.setShootMode(grh.m_WeaponType);
            SCLevel.setWeapon(weapon);
            switch (grh.getLevelType()) {
                case 0: {
                    SCLevel.createLevel(grh.r_level, new SCTileSet1());
                    this.clear_color = 12622948;
                    break;
                }
                case 1: {
                    SCLevel.createLevel(grh.r_level, new SCTileSet2());
                    this.clear_color = 14086899;
                    break;
                }
                case 2: {
                    SCLevel.createLevel(grh.r_level, new SCTileSet3());
                    this.clear_color = 277100;
                }
            }
            try {
                this.hud_num = Image.createImage((String)"/contentHeliStrike/interface/hud/hud_num.png");
                this.hud_shield = Image.createImage((String)"/contentHeliStrike/interface/hud/display_healthlife.png");
                this.hud_score = Image.createImage((String)"/contentHeliStrike/interface/hud/display_score.png");
                this.demoCounter = Image.createImage((String)"/contentHeliStrike/interface/hud/display_democounter.png");
                this.pu_mg2 = Image.createImage((String)"/contentHeliStrike/interface/hud/powerup_mg2.png");
                this.pu_mg3 = Image.createImage((String)"/contentHeliStrike/interface/hud/powerup_mg3.png");
                this.pu_mg3s = Image.createImage((String)"/contentHeliStrike/interface/hud/powerup_mg3s.png");
                this.pu_mg4s = Image.createImage((String)"/contentHeliStrike/interface/hud/powerup_mg4s.png");
                this.pu_health = Image.createImage((String)"/contentHeliStrike/interface/hud/powerup_health.png");
                this.pu_shield = Image.createImage((String)"/contentHeliStrike/interface/hud/powerup_invincible.png");
                this.pu_nuke = Image.createImage((String)"/contentHeliStrike/interface/hud/powerup_nuke.png");
                this.minim_11 = Image.createImage((String)"/contentHeliStrike/interface/medal_accuracy_bronze_s.png");
                this.minim_12 = Image.createImage((String)"/contentHeliStrike/interface/medal_accuracy_silver_s.png");
                this.minim_13 = Image.createImage((String)"/contentHeliStrike/interface/medal_accuracy_gold_s.png");
                this.minim_21 = Image.createImage((String)"/contentHeliStrike/interface/medal_agility_bronze_s.png");
                this.minim_22 = Image.createImage((String)"/contentHeliStrike/interface/medal_agility_silver_s.png");
                this.minim_23 = Image.createImage((String)"/contentHeliStrike/interface/medal_agility_gold_s.png");
                this.minim_31 = Image.createImage((String)"/contentHeliStrike/interface/medal_mission_bronze_s.png");
                this.minim_32 = Image.createImage((String)"/contentHeliStrike/interface/medal_mission_silver_s.png");
                this.minim_33 = Image.createImage((String)"/contentHeliStrike/interface/medal_mission_gold_s.png");
                this.hud_offset = this.hud_shield.getWidth();
                StaticImages.load();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.rndm = new Random();
            this.play_sound_timer = 4000L;
            this.shoot_timer = 0L;
            for (int i = 0; i < grh.r_score.length; ++i) {
                grh.r_score[i] = 0;
            }
            this.powerup_blink_time = 0L;
            this.powerup_time = 0L;
            SCLevel.setPlayerCollisionDamage(-10);
            grh.total_enemies = 0;
            grh.hit_notify = 0;
            this.nuke_armed = false;
            this.getStats = false;
            SCEnemyFactory.preCachePathEnemies(grh.r_level);
            this.messageBox = grh.r_level < 9 ? new TextBox(5, grh.r_h / 3, grh.r_w - 10, grh.r_h - grh.r_h / 3 - 20, GameText.getText(30 + grh.r_level)) : new TextBox(5, grh.r_h / 3, grh.r_w - 10, grh.r_h - grh.r_h / 3 - 20, "");
            this.messageBox.init();
            this.showMessageBox = false;
            this.silo_countdown = 120000L;
            this.missile_started = false;
            this.menu = new AEMenu();
            SoftButton select_button = new SoftButton(null, true, 70);
            MenuPage page = new MenuPage();
            MenuButtonLayout mbl = new MenuButtonLayout();
            mbl.addButton(new MenuButton((AEMenuAction)new AESubMenuAction(this.menu, 4), GameText.getText(64)));
            mbl.addButton(new MenuButton((AEMenuAction)new AESubMenuAction(this.menu, 2), GameText.getText(2)));
            mbl.addButton(new MenuButton((AEMenuAction)new AESubMenuAction(this.menu, 5), GameText.getText(65)));
            mbl.addButton(new MenuButton((AEMenuAction)new AESubMenuAction(this.menu, 1), GameText.getText(5)));
            page.setButtonLayout(mbl);
            class ContinueAction
            implements AEMenuAction {
                public void process() {
                    MainGame.this.changeStatus(0L, 2L);
                }

                public boolean isActive() {
                    return true;
                }
            }
            page.setRightSoftButton(new SoftButton(new ContinueAction(), false, 72));
            this.menu.addMenuPage(page);
            page = new MenuPage();
            mbl = new MenuButtonLayout();
            class NoAction
            implements AEMenuAction {
                public void process() {
                }

                public boolean isActive() {
                    return false;
                }
            }
            mbl.addButton(new MenuButton((AEMenuAction)new NoAction(), GameText.getText(15)));
            class QuitAction
            implements AEMenuAction {
                public void process() {
                    grh.r_midlet.notifyDestroyed();
                }

                public boolean isActive() {
                    return true;
                }
            }
            mbl.addButton(new MenuButton((AEMenuAction)new QuitAction(), GameText.getText(16)));
            mbl.addButton(new MenuButton((AEMenuAction)new AESubMenuAction(this.menu, 0), GameText.getText(17)));
            page.setButtonLayout(mbl);
            page.setRightSoftButton(new SoftButton(new AESubMenuAction(this.menu, 0), false, 72));
            this.menu.addMenuPage(page);
            page = new MenuPage();
            mbl = new MenuButtonLayout();
            class ToggleSoundAction
            implements AEToggleMenuAction {
                public void process() {
                    boolean bl = grh.m_Sound = !grh.m_Sound;
                    if (grh.m_Sound && !grh.r_sound.isMusicPlaying()) {
                        grh.r_sound.playMusic();
                    } else {
                        grh.r_sound.stopMusic();
                    }
                    grh.RecordStoreWrite();
                }

                public boolean isActive() {
                    return true;
                }

                public boolean isToggled() {
                    return grh.m_Sound;
                }
            }
            mbl.addButton(new MenuToggleButton((AEToggleMenuAction)new ToggleSoundAction(), 6));
            if (grh.r_support_vibration.equals("1")) {
                class ToggleVibrationAction
                implements AEToggleMenuAction {
                    public void process() {
                        grh.m_Vibrate = !grh.m_Vibrate;
                        grh.RecordStoreWrite();
                    }

                    public boolean isActive() {
                        return true;
                    }

                    public boolean isToggled() {
                        return grh.m_Vibrate;
                    }
                }
                mbl.addButton(new MenuToggleButton((AEToggleMenuAction)new ToggleVibrationAction(), 7));
            }
            page.setButtonLayout(mbl);
            page.setRightSoftButton(new SoftButton(new AESubMenuAction(this.menu, 0), false, 72));
            this.menu.addMenuPage(page);
            page = new MenuPage();
            mbl = new MenuButtonLayout();
            class MainMenuAction
            implements AEMenuAction {
                public void process() {
                    grh.r_handle.setModule(grh.r_modul[3]);
                }

                public boolean isActive() {
                    return true;
                }
            }
            mbl.addButton(new MenuButton((AEMenuAction)new MainMenuAction(), GameText.getText(64)));
            class RestartGameAction
            implements AEMenuAction {
                public void process() {
                    grh.r_handle.setModule(grh.r_modul[2]);
                }

                public boolean isActive() {
                    return true;
                }
            }
            mbl.addButton(new MenuButton((AEMenuAction)new RestartGameAction(), GameText.getText(65)));
            page.setButtonLayout(mbl);
            this.menu.addMenuPage(page);
            page = new MenuPage();
            mbl = new MenuButtonLayout();
            mbl.addButton(new MenuButton((AEMenuAction)new NoAction(), GameText.getText(87)));
            class AbortGameAction
            implements AEMenuAction {
                public void process() {
                    grh.r_handle.setModule(grh.r_modul[3]);
                }

                public boolean isActive() {
                    return true;
                }
            }
            mbl.addButton(new MenuButton((AEMenuAction)new AbortGameAction(), GameText.getText(16)));
            mbl.addButton(new MenuButton((AEMenuAction)new AESubMenuAction(this.menu, 0), GameText.getText(17)));
            page.setButtonLayout(mbl);
            page.setRightSoftButton(new SoftButton(new AESubMenuAction(this.menu, 0), false, 72));
            this.menu.addMenuPage(page);
            page = new MenuPage();
            mbl = new MenuButtonLayout();
            mbl.addButton(new MenuButton((AEMenuAction)new NoAction(), GameText.getText(87)));
            mbl.addButton(new MenuButton((AEMenuAction)new RestartGameAction(), GameText.getText(16)));
            mbl.addButton(new MenuButton((AEMenuAction)new AESubMenuAction(this.menu, 0), GameText.getText(17)));
            page.setButtonLayout(mbl);
            page.setRightSoftButton(new SoftButton(new AESubMenuAction(this.menu, 0), false, 72));
            this.menu.addMenuPage(page);
            this.loading = true;
            return 100;
        }
        int loading_progress = SCLevel.preCache() + SCEnemyFactory.precachePointEnemies(grh.r_level);
        return loading_progress;
    }

    public void onKeyPress(int key) {
        if ((this.getStatus() & 2L) != 0L) {
            switch (key) {
                case 4: 
                case 32768: {
                    this.menu.selectPrevButton();
                    break;
                }
                case 256: 
                case 65536: {
                    this.menu.selectNextButton();
                    break;
                }
                case 32: 
                case 4096: 
                case 131072: {
                    this.menu.pressLeftSoftButton();
                    this.menu.pressButton();
                    break;
                }
                case 262144: {
                    this.menu.pressRightSoftButton();
                }
            }
        } else {
            switch (key) {
                case 262144: {
                    if ((this.getStatus() & 0x60L) != 0L) break;
                    this.changeStatus(2L, 0L);
                    break;
                }
                case 32: 
                case 4096: 
                case 131072: {
                    if ((this.getStatus() & 0x80L) != 0L && this.messageBox.fadeIn()) {
                        if (grh.r_level < 8) {
                            grh.r_handle.setModule(grh.r_modul[5]);
                            break;
                        }
                        MainMissionWinLoose.hasWon = true;
                        grh.r_handle.setModule(grh.r_modul[8]);
                        break;
                    }
                    if ((this.getStatus() & 0x20L) != 0L && this.messageBox.fadeIn() && !this.getStats) {
                        this.changeStatus(128L, 0L);
                        this.messageBox.setY(10);
                        this.messageBox.setH(grh.r_h - 20);
                        this.messageBox.setText(this.getStatsTable());
                        this.messageBox.init();
                        break;
                    }
                    if ((this.getStatus() & 0x40L) != 0L && grh.r_level > 9 && this.messageBox.fadeIn()) {
                        MainInstantResults.skipUserName = false;
                        grh.r_handle.setModule(grh.r_modul[6]);
                        break;
                    }
                    if ((this.getStatus() & 0x40L) == 0L || !this.messageBox.fadeIn()) break;
                    if (grh.r_level == 8) {
                        MainMissionWinLoose.hasWon = false;
                        grh.r_handle.setModule(grh.r_modul[8]);
                        break;
                    }
                    this.menu.setCurrentMenuPage(3);
                    this.changeStatus(2L, 0L);
                }
            }
        }
    }

    public void onKeyRelease(int key) {
    }

    public void onRelease() {
        this.hud_score = null;
        this.hud_shield = null;
        this.hud_num = null;
        this.demoCounter = null;
        this.pu_nuke = null;
        this.pu_shield = null;
        this.pu_health = null;
        this.pu_mg4s = null;
        this.pu_mg3s = null;
        this.pu_mg3 = null;
        this.pu_mg2 = null;
        this.rndm = null;
        this.tmp = null;
        SCLevel.release();
        SCEnemyFactory.clearCache();
        AEResourceManager.releaseAllResources();
        this.messageBox = null;
        StaticImages.release();
        this.loading = false;
        if (this.menu != null) {
            this.menu.release();
        }
        this.minim_33 = null;
        this.minim_32 = null;
        this.minim_31 = null;
        this.minim_23 = null;
        this.minim_22 = null;
        this.minim_21 = null;
        this.minim_13 = null;
        this.minim_12 = null;
        this.minim_11 = null;
        this.menu = null;
    }

    public void onRender2D() {
        if ((this.getStatus() & 2L) != 0L) {
            StaticImages.drawStatusBar();
            MainMenu.iGeoffState = 1;
            this.menu.draw();
            return;
        }
        MainMenu.iGeoffState = 4;
        if ((SCLevel.isPlayerDead() || this.missile_started) && (this.getStatus() & 0x60L) == 0L) {
            this.changeStatus(64L, 0L);
            SCLevel.cm.playOutro();
            if (grh.r_level < 9) {
                grh.m_WeaponType = 0;
                this.messageBox.setText(48);
            } else {
                this.messageBox.setText(86);
            }
            this.messageBox.init();
            this.messageBox.setY(grh.r_h / 3);
            this.showMessageBox = true;
            grh.r_sound.playSound(10);
        } else if (grh.r_level < 9 && SCLevel.getCurrentTile() > 25L && (this.getStatus() & 4L) == 0L) {
            switch (grh.getLevelType()) {
                case 0: {
                    if (grh.r_level == 8) {
                        SCLevel.changeTileSet(new SCBossTileSet1_1());
                        break;
                    }
                    SCLevel.changeTileSet(new SCBossTileSet1());
                    break;
                }
                case 1: {
                    SCLevel.changeTileSet(new SCBossTileSet2());
                    break;
                }
                case 2: {
                    SCLevel.changeTileSet(new SCBossTileSet3());
                }
            }
            this.changeStatus(4L, 0L);
        } else if (grh.r_level < 9 && SCLevel.getCurrentTile() > 28L && (this.getStatus() & 8L) == 0L) {
            ((HeliStrikeCamera_2)SCLevel.cm).startStageSequenze();
            this.changeStatus(8L, 0L);
            this.messageBox.setText(39 + grh.r_level);
            this.messageBox.init();
            this.messageBox.setY(grh.r_h / 3);
            this.showMessageBox = true;
        } else if (grh.r_level < 9 && SCLevel.getCurrentTile() > 29L && (this.getStatus() & 0x10L) == 0L) {
            this.changeStatus(16L, 0L);
            ((HeliStrikeCamera_2)SCLevel.cm).stopStageSequenze();
            switch (grh.getLevelType()) {
                case 0: {
                    SCTankBossEnemy.enableBoss();
                    break;
                }
                case 1: {
                    SCPlaneBossEnemy.canShoot = true;
                    break;
                }
                case 2: {
                    SCBoatBossEnemy.canShoot = true;
                }
            }
            this.showMessageBox = false;
        } else if (grh.r_level < 9 && (this.getStatus() & 0x10L) != 0L && (this.getStatus() & 0x60L) == 0L) {
            if (SCLevel.getEnemies().isEmpty() || SCLevel.getEnemies().getEnemies()[0].isDead()) {
                this.changeStatus(32L, 0L);
                this.messageBox.setText(49);
                this.messageBox.init();
                this.messageBox.setY(grh.r_h / 3);
                this.showMessageBox = true;
                ((SCPlayer)SCLevel.getPlayer()).setGodMode(true);
                grh.m_WeaponType = SCLevel.getCurrentWeaponType();
            } else {
                SCEnemy boss = SCLevel.getEnemies().getEnemies()[0];
                if (boss != null && boss.getHitpoints() > 0) {
                    this.tmp.set(boss.getCurrentX(), boss.getCurrentY(), boss.getCurrentZ());
                    if (grh.r_renderer.getScreenPosition(this.tmp)) {
                        grh.r_g.setColor(-7829368);
                        grh.r_g.fillRect(this.tmp.x - 10, this.tmp.y - (grh.r_w >> 3), 20, 2);
                        grh.r_g.setColor(-12287);
                        grh.r_g.fillRect(this.tmp.x - 10, this.tmp.y - (grh.r_w >> 3), boss.getHitpoints() * 20 / boss.getInitialHitpoints(), 2);
                    }
                }
            }
        }
        if (grh.r_level < 9) {
            if (this.showMessageBox || SCLevel.getCurrentTile() == 0L) {
                if (!SCLevel.isExplosionPlaying()) {
                    this.messageBox.draw();
                }
                if ((this.getStatus() & 0x80L) != 0L && this.messageBox.fadeIn()) {
                    grh.r_g.setColor(-5767168);
                    grh.r_g.fillRect(10, 17 + 3 * grh.r_font.getHeight(), this.medal_accuracy * (grh.r_w - 20) / 100 - 10, 4);
                    grh.r_g.setColor(-12287);
                    grh.r_g.drawRect(10, 17 + 3 * grh.r_font.getHeight(), grh.r_w - 20, 4);
                    int x1 = 1000 * (grh.r_w - 20) / 4096;
                    int x2 = 1900 * (grh.r_w - 20) / 4096;
                    int x3 = 2800 * (grh.r_w - 20) / 4096;
                    grh.r_g.drawLine(x1, 17 + 3 * grh.r_font.getHeight(), x1, 17 + 3 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawLine(x2, 17 + 3 * grh.r_font.getHeight(), x2, 17 + 3 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawLine(x3, 17 + 3 * grh.r_font.getHeight(), x3, 17 + 3 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawImage(this.minim_11, x1 + (x2 - x1 >> 1) - (this.minim_11.getWidth() >> 1), 4 + 3 * grh.r_font.getHeight(), 0);
                    grh.r_g.drawImage(this.minim_12, x2 + (x3 - x2 >> 1) - (this.minim_12.getWidth() >> 1), 4 + 3 * grh.r_font.getHeight(), 0);
                    grh.r_g.drawImage(this.minim_13, x3 + (grh.r_w - 10 - x3 >> 1) - (this.minim_13.getWidth() >> 1), 4 + 3 * grh.r_font.getHeight(), 0);
                    grh.r_g.setColor(-5767168);
                    grh.r_g.fillRect(10, 17 + 6 * grh.r_font.getHeight(), this.medal_agility * (grh.r_w - 20) / 100 - 10, 4);
                    grh.r_g.setColor(-12287);
                    grh.r_g.drawRect(10, 17 + 6 * grh.r_font.getHeight(), grh.r_w - 20, 4);
                    x1 = 1000 * (grh.r_w - 20) / 4096;
                    x2 = 2000 * (grh.r_w - 20) / 4096;
                    x3 = 3000 * (grh.r_w - 20) / 4096;
                    grh.r_g.drawLine(x1, 17 + 6 * grh.r_font.getHeight(), x1, 17 + 6 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawLine(x2, 17 + 6 * grh.r_font.getHeight(), x2, 17 + 6 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawLine(x3, 17 + 6 * grh.r_font.getHeight(), x3, 17 + 6 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawImage(this.minim_21, x1 + (x2 - x1 >> 1) - (this.minim_21.getWidth() >> 1), 4 + 6 * grh.r_font.getHeight(), 0);
                    grh.r_g.drawImage(this.minim_22, x2 + (x3 - x2 >> 1) - (this.minim_22.getWidth() >> 1), 4 + 6 * grh.r_font.getHeight(), 0);
                    grh.r_g.drawImage(this.minim_23, x3 + (grh.r_w - 10 - x3 >> 1) - (this.minim_23.getWidth() >> 1), 4 + 6 * grh.r_font.getHeight(), 0);
                    grh.r_g.setColor(-5767168);
                    grh.r_g.fillRect(10, 17 + 9 * grh.r_font.getHeight(), this.medal_mission * (grh.r_w - 20) / 100 - 10, 4);
                    grh.r_g.setColor(-12287);
                    grh.r_g.drawRect(10, 17 + 9 * grh.r_font.getHeight(), grh.r_w - 20, 4);
                    x1 = 2900 * (grh.r_w - 20) / 4096;
                    x2 = 3400 * (grh.r_w - 20) / 4096;
                    x3 = 3900 * (grh.r_w - 20) / 4096;
                    grh.r_g.drawLine(x1, 17 + 9 * grh.r_font.getHeight(), x1, 17 + 9 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawLine(x2, 17 + 9 * grh.r_font.getHeight(), x2, 17 + 9 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawLine(x3, 17 + 9 * grh.r_font.getHeight(), x3, 17 + 9 * grh.r_font.getHeight() + 4);
                    grh.r_g.drawImage(this.minim_31, x1 + (x2 - x1 >> 1) - (this.minim_31.getWidth() >> 1), 4 + 9 * grh.r_font.getHeight(), 0);
                    grh.r_g.drawImage(this.minim_32, x2 + (x3 - x2 >> 1) - (this.minim_32.getWidth() >> 1), 4 + 9 * grh.r_font.getHeight(), 0);
                    grh.r_g.drawImage(this.minim_33, x3 + (grh.r_w - 10 - x3 >> 1) - (this.minim_33.getWidth() >> 1), 4 + 9 * grh.r_font.getHeight(), 0);
                }
            } else if (this.messageBox.getY() < grh.r_h) {
                this.messageBox.setY(this.messageBox.getY() + (int)(this.elapsed_time >> 2));
                this.messageBox.draw();
            }
            if (grh.r_level == 8 && SCTankBossEnemy.nukeCountdown && (this.getStatus() & 0x60L) == 0L) {
                if (this.silo_countdown < 0L) {
                    if (!this.missile_started) {
                        SCTankBossEnemy.nukeStart = true;
                        this.missile_started = true;
                    }
                } else {
                    this.silo_countdown -= this.elapsed_time;
                }
                SimpleTextBox.draw(GameText.getText(66) + " " + (int)(this.silo_countdown / 1000L), true, 0, 4, (byte)18);
            }
        } else if (this.showMessageBox) {
            this.messageBox.draw();
        }
        if ((this.getStatus() & 0xE0L) != 0L) {
            MainMenu.iGeoffState = 5;
            StaticImages.drawStatusBar();
            grh.r_g.setColor(0x8B8B8B);
            grh.r_g.drawImage(StaticImages.buttonSelect, 4, grh.r_h - 4 - StaticImages.buttonSelect.getHeight(), 0);
        }
        if (SCLevel.cm.isIngame() && (this.getStatus() & 0xE0L) == 0L) {
            this.drawHUD();
        }
        if (MainMenu.iGeoffState != 5) {
            grh.r_g.drawImage(StaticImages.buttonPause, grh.r_w - 4 - StaticImages.buttonPause.getWidth(), 4, 0);
            if (MainMenu.iTouched == 1) {
                grh.r_g.drawImage(StaticImages.buttonUp, grh.r_w >> 1, 4, 0x10 | 1);
            } else {
                grh.r_g.drawImage(StaticImages.buttonUpTrans, grh.r_w >> 1, 4, 0x10 | 1);
            }
            if (MainMenu.iTouched == 2) {
                grh.r_g.drawImage(StaticImages.buttonFlatDown, grh.r_w >> 1, grh.r_h - 4, 0x20 | 1);
            } else {
                grh.r_g.drawImage(StaticImages.buttonFlatDownTrans, grh.r_w >> 1, grh.r_h - 4, 0x20 | 1);
            }
            if (MainMenu.iTouched == 3) {
                grh.r_g.drawImage(StaticImages.buttonLeft, 4, 420, 0x10 | 4);
            } else {
                grh.r_g.drawImage(StaticImages.buttonLeftTrans, 4, 420, 0x10 | 4);
            }
            if (MainMenu.iTouched == 4) {
                grh.r_g.drawImage(StaticImages.buttonRight, grh.r_w - 4, 420, 0x10 | 8);
            } else {
                grh.r_g.drawImage(StaticImages.buttonRightTrans, grh.r_w - 4, 420, 0x10 | 8);
            }
            if (MainMenu.iTouched == 5) {
                grh.r_g.drawImage(StaticImages.buttonFire, grh.r_w - 4, 280, 0x10 | 8);
            } else {
                grh.r_g.drawImage(StaticImages.buttonFireTrans, grh.r_w - 4, 280, 0x10 | 8);
            }
        }
    }

    public void onRender3D() {
        grh.r_g.setColor(this.clear_color);
        grh.r_g.fillRect(0, 0, grh.r_w, grh.r_h);
        grh.r_device.bind(grh.r_g);
        SCLevel.render();
        ((HeliStrikeCamera_2)SCLevel.cm).smoke_system.render();
        grh.r_renderer.drawLayers(this.ingame_time);
        grh.r_device.unbind(grh.r_g);
    }

    public void onStatusChange(long status_on, long status_off) {
    }

    public void onUpdate() {
        if ((this.getStatus() & 2L) != 0L) {
            StaticImages.elapsed_time = (int)this.elapsed_time;
            return;
        }
        if (SCLevel.cm.isIngame() && (this.getStatus() & 0x60L) == 0L) {
            if ((this.keystate & 0x2010) != 0) {
                SCLevel.cm.moveLeft((int)this.elapsed_time);
            }
            if ((this.keystate & 0x4040) != 0) {
                SCLevel.cm.moveRight((int)this.elapsed_time);
            }
            if ((this.keystate & 0x8004) != 0) {
                SCLevel.cm.moveUp((int)this.elapsed_time);
            }
            if ((this.keystate & 0x10100) != 0) {
                SCLevel.cm.moveDown((int)this.elapsed_time);
            }
        }
        if ((this.keystate & 0x400000) != 0) {
            System.gc();
        }
        this.shoot_timer -= this.elapsed_time;
        if ((this.keystate & 0x1020) != 0 && this.shoot_timer < 0L && SCLevel.cm.isIngame() && (this.getStatus() & 0x60L) == 0L) {
            if (this.nuke_armed) {
                this.nuke_armed = false;
                for (int i = 0; !SCLevel.getEnemies().isEmpty() && i < SCLevel.getEnemies().getEnemies().length; ++i) {
                    SCLevel.getEnemies().getEnemies()[i].applyHitpoints(-1000000);
                }
                ((HeliStrikeCamera_2)SCLevel.cm).enableNuke();
                this.shoot_timer = 3000L;
            } else {
                grh.r_sound.playSound(0);
                this.shoot_timer = 3000L;
                this.play_sound_timer = (long)this.rndm.nextInt(8000) + 4000L;
            }
        }
        if (this.shoot_timer > 1000L) {
            SCLevel.shoot();
        }
        if ((grh.r_level > 8 || SCLevel.getCurrentTile() < 30L) && (this.getStatus() & 0x40L) == 0L) {
            SCLevel.cm.moveForward((int)this.elapsed_time);
        } else {
            SCLevel.cm.moveForward(0);
        }
        SCLevel.update((int)this.elapsed_time);
        this.play_sound_timer -= this.elapsed_time;
        if (this.play_sound_timer < 0L) {
            switch (this.rndm.nextInt(8)) {
                case 0: {
                    grh.r_sound.playSound(9);
                    break;
                }
                case 1: {
                    grh.r_sound.playSound(2);
                    break;
                }
                case 2: {
                    grh.r_sound.playSound(3);
                    break;
                }
                case 3: {
                    grh.r_sound.playSound(4);
                    break;
                }
                case 4: {
                    grh.r_sound.playSound(5);
                    break;
                }
                case 5: {
                    grh.r_sound.playSound(6);
                    break;
                }
                case 6: {
                    grh.r_sound.playSound(7);
                    break;
                }
                case 7: {
                    grh.r_sound.playSound(8);
                }
            }
            this.play_sound_timer = (long)this.rndm.nextInt(8000) + 4000L;
        }
    }

    public void drawHUD() {
        int i;
        if (!SCLevel.getEnemies().isEmpty()) {
            SCEnemy[] enemy = SCLevel.getEnemies().getEnemies();
            for (i = 0; i < enemy.length; ++i) {
                if (enemy[i].getHitpoints() > 0) continue;
                this.tmp.set(enemy[i].getCurrentX(), enemy[i].getCurrentY(), enemy[i].getCurrentZ());
                if (!grh.r_renderer.getScreenPosition(this.tmp)) continue;
                this.drawNumL(grh.SCORE_POINTS[enemy[i].getEnemyClassId()], this.tmp.x - 5, this.tmp.y);
            }
        }
        if (this.hud_offset != 0) {
            this.hud_offset = this.hud_offset * 3072 >> 12;
        }
        grh.r_g.drawImage(this.hud_shield, grh.r_w - this.hud_shield.getWidth() + this.hud_offset, grh.r_h - this.hud_shield.getHeight(), 0);
        grh.r_g.drawImage(this.hud_score, -this.hud_offset, grh.r_h - this.hud_score.getHeight(), 0);
        grh.r_g.setColor(-12287);
        grh.r_g.fillRect(grh.r_w - this.hud_shield.getWidth() + this.hud_offset + 14, grh.r_h - this.hud_shield.getHeight() + 5, SCLevel.getPlayer().getHitpoints() * 31 / 400, 5);
        int score = 0;
        for (i = 0; i < grh.r_score.length; ++i) {
            score += grh.r_score[i] * grh.SCORE_POINTS[i];
        }
        this.drawNumR(score, 59 - this.hud_offset, grh.r_h - 12);
        if (this.powerup_time > 0L) {
            this.powerup_time -= this.elapsed_time;
            this.powerup_blink_time -= this.elapsed_time;
            if (this.powerup_blink_time < 0L) {
                switch (this.powerup_state) {
                    case 1: {
                        grh.r_g.drawImage(this.pu_mg2, grh.r_w - this.pu_mg2.getWidth() - 1, 1, 0);
                        break;
                    }
                    case 2: {
                        grh.r_g.drawImage(this.pu_mg3, grh.r_w - this.pu_mg3.getWidth() - 1, 1, 0);
                        break;
                    }
                    case 3: {
                        grh.r_g.drawImage(this.pu_mg3s, grh.r_w - this.pu_mg3s.getWidth() - 1, 1, 0);
                        break;
                    }
                    case 4: {
                        grh.r_g.drawImage(this.pu_mg4s, grh.r_w - this.pu_mg4s.getWidth() - 1, 1, 0);
                        break;
                    }
                    case 5: {
                        grh.r_g.drawImage(this.pu_health, grh.r_w - this.pu_health.getWidth() - 1, 1, 0);
                        break;
                    }
                    case 6: {
                        grh.r_g.drawImage(this.pu_shield, grh.r_w - this.pu_shield.getWidth() - 1, 1, 0);
                        break;
                    }
                    case 7: {
                        grh.r_g.drawImage(this.pu_nuke, grh.r_w - this.pu_nuke.getWidth() - 1, 1, 0);
                    }
                }
            }
            if (this.powerup_blink_time < -250L) {
                this.powerup_blink_time = 250L;
            }
        }
        if (this.multi_kill_time > 0L) {
            this.multi_kill_time -= this.elapsed_time;
            if (grh.hit_notify > this.multi_kill_count) {
                this.multi_kill_count = grh.hit_notify;
                this.multi_kill_time = 850L;
                grh.r_sound.playSound(10);
            }
        } else {
            if (grh.hit_notify > 0) {
                this.multi_kill_time = 850L;
                grh.r_sound.playSound(10);
            }
            grh.hit_notify = 0;
            this.multi_kill_count = 0;
        }
        switch (this.multi_kill_count) {
            case 0: {
                break;
            }
            case 1: {
                SimpleTextBox.draw(GameText.getText(67), true, 0, 4, (byte)18);
                break;
            }
            case 2: {
                SimpleTextBox.draw(GameText.getText(68), true, 0, 4, (byte)18);
                break;
            }
            default: {
                SimpleTextBox.draw(GameText.getText(69), true, 0, 4, (byte)18);
            }
        }
    }

    private String getStatsTable() {
        int i;
        this.getStats = true;
        int score = 0;
        for (i = 0; i < grh.r_score.length; ++i) {
            score += grh.r_score[i] * grh.SCORE_POINTS[i];
        }
        grh.m_Score[grh.r_level] = score;
        this.medal_accuracy = SCLevel.getWeapon().getAccuracyStats();
        this.medal_agility = (400 + ((SCPlayer)SCLevel.getPlayer()).getStatsTotalHits() << 12) / 400;
        this.medal_agility = this.medal_agility > 0 ? this.medal_agility : 0;
        this.medal_mission = 0;
        for (i = 0; i < grh.r_score.length; ++i) {
            this.medal_mission += grh.r_score[i];
        }
        this.medal_mission = (this.medal_mission << 12) / grh.total_enemies;
        short medal = 0;
        if (this.medal_accuracy > 2800) {
            medal = (short)(medal | 0x100);
        } else if (this.medal_accuracy > 1900) {
            medal = (short)(medal | 0x10);
        } else if (this.medal_accuracy > 1000) {
            medal = (short)(medal | 1);
        }
        if (this.medal_agility > 3000) {
            medal = (short)(medal | 0x200);
        } else if (this.medal_agility > 2000) {
            medal = (short)(medal | 0x20);
        } else if (this.medal_agility > 1000) {
            medal = (short)(medal | 2);
        }
        if (this.medal_mission > 3900) {
            medal = (short)(medal | 0x400);
        } else if (this.medal_mission > 3400) {
            medal = (short)(medal | 0x40);
        } else if (this.medal_mission > 2900) {
            medal = (short)(medal | 4);
        }
        int n = grh.r_level;
        grh.m_Medal[n] = (short)(grh.m_Medal[n] | medal);
        ((MainMissionResults)grh.r_modul[5]).setMedal(medal);
        grh.m_AchievedLevel = grh.m_AchievedLevel < (short)(grh.r_level + 1) ? (short)(grh.r_level + 1) : grh.m_AchievedLevel;
        grh.RecordStoreWrite();
        this.medal_accuracy = (int)((float)this.medal_accuracy / 40.96f);
        this.medal_accuracy = this.medal_accuracy < 100 ? this.medal_accuracy : 100;
        this.medal_agility = (int)((float)this.medal_agility / 40.96f);
        this.medal_agility = this.medal_agility < 100 ? this.medal_agility : 100;
        this.medal_mission = (int)((float)this.medal_mission / 40.96f);
        this.medal_mission = this.medal_mission < 100 ? this.medal_mission : 100;
        return GameText.getText(51) + " " + score + "\n" + GameText.getText(52) + " " + this.medal_accuracy + "%\n\n\n" + GameText.getText(53) + " " + this.medal_agility + "%\n\n\n" + GameText.getText(54) + " " + this.medal_mission + "%\n\n\n";
    }

    public void drawNumR(int num, int x, int y) {
        String str_score = "" + num;
        int x_offset = 0;
        block12: for (int i = str_score.length() - 1; i >= 0; --i) {
            switch (str_score.charAt(i)) {
                case '0': {
                    grh.r_g.drawRegion(this.hud_num, 0, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 6), y, 0);
                    continue block12;
                }
                case '1': {
                    grh.r_g.drawRegion(this.hud_num, 8, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 3), y, 0);
                    continue block12;
                }
                case '2': {
                    grh.r_g.drawRegion(this.hud_num, 16, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 5), y, 0);
                    continue block12;
                }
                case '3': {
                    grh.r_g.drawRegion(this.hud_num, 24, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 5), y, 0);
                    continue block12;
                }
                case '4': {
                    grh.r_g.drawRegion(this.hud_num, 32, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 6), y, 0);
                    continue block12;
                }
                case '5': {
                    grh.r_g.drawRegion(this.hud_num, 40, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 5), y, 0);
                    continue block12;
                }
                case '6': {
                    grh.r_g.drawRegion(this.hud_num, 48, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 6), y, 0);
                    continue block12;
                }
                case '7': {
                    grh.r_g.drawRegion(this.hud_num, 56, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 5), y, 0);
                    continue block12;
                }
                case '8': {
                    grh.r_g.drawRegion(this.hud_num, 64, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 5), y, 0);
                    continue block12;
                }
                case '9': {
                    grh.r_g.drawRegion(this.hud_num, 72, 0, 8, this.hud_num.getHeight(), 0, x + (x_offset -= 6), y, 0);
                }
            }
        }
    }

    public void drawNumL(int num, int x, int y) {
        String str_score = "" + num;
        int x_offset = 0;
        block12: for (int i = 0; i < str_score.length(); ++i) {
            switch (str_score.charAt(i)) {
                case '0': {
                    grh.r_g.drawRegion(this.hud_num, 0, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 6;
                    continue block12;
                }
                case '1': {
                    grh.r_g.drawRegion(this.hud_num, 8, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 3;
                    continue block12;
                }
                case '2': {
                    grh.r_g.drawRegion(this.hud_num, 16, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 5;
                    continue block12;
                }
                case '3': {
                    grh.r_g.drawRegion(this.hud_num, 24, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 5;
                    continue block12;
                }
                case '4': {
                    grh.r_g.drawRegion(this.hud_num, 32, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 6;
                    continue block12;
                }
                case '5': {
                    grh.r_g.drawRegion(this.hud_num, 40, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 5;
                    continue block12;
                }
                case '6': {
                    grh.r_g.drawRegion(this.hud_num, 48, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 6;
                    continue block12;
                }
                case '7': {
                    grh.r_g.drawRegion(this.hud_num, 56, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 5;
                    continue block12;
                }
                case '8': {
                    grh.r_g.drawRegion(this.hud_num, 64, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 5;
                    continue block12;
                }
                case '9': {
                    grh.r_g.drawRegion(this.hud_num, 72, 0, 8, this.hud_num.getHeight(), 0, x + x_offset, y, 0);
                    x_offset += 6;
                }
            }
        }
    }

    public long getIngameTime() {
        return this.ingame_time;
    }
}

