/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;
import AbyssEngine.AEVector3D;

public class AEBoundingSphere {
    public AEVector3D pos;
    public int r;

    public AEBoundingSphere(int x, int y, int z, int r) {
        this.pos = new AEVector3D(x, y, z);
        this.r = r;
    }

    public AEBoundingSphere(AEVector3D pos, int r) {
        this(pos.x, pos.y, pos.z, r);
    }

    public AEBoundingSphere() {
        this(0, 0, 0, 0);
    }

    public AEBoundingSphere(AEBoundingSphere bs) {
        this.pos.x = bs.pos.x;
        this.pos.y = bs.pos.y;
        this.pos.z = bs.pos.z;
        this.r = bs.r;
    }

    public AEBoundingSphere add(AEBoundingSphere bs, AEBoundingSphere result) {
        if (this.r == 0) {
            result.set(bs);
            return result;
        }
        if (bs.r == 0) {
            result.set(this);
            return result;
        }
        int radiusDiff = bs.r - this.r;
        int radiusDiffSqr = radiusDiff * radiusDiff;
        int centerDiffX = bs.pos.x - this.pos.x;
        int centerDiffY = bs.pos.y - this.pos.y;
        int centerDiffZ = bs.pos.z - this.pos.z;
        int LSqr = centerDiffX * centerDiffX + centerDiffY * centerDiffY + centerDiffZ * centerDiffZ;
        if (radiusDiffSqr >= LSqr) {
            if (radiusDiff >= 0) {
                result.set(bs.pos, bs.r);
                return result;
            }
            result.set(this.pos, this.r);
            return result;
        }
        int L = AEMath.sqrt((long)LSqr << 12);
        int t = (int)(((long)((radiusDiff << 12) + L) << 12) / (long)(2 * L));
        result.set(this.pos.x + (int)((long)t * ((long)centerDiffX << 12) >> 24), this.pos.y + (int)((long)t * ((long)centerDiffY << 12) >> 24), this.pos.z + (int)((long)t * ((long)centerDiffZ << 12) >> 24), (L >> 12) + (bs.r + this.r) >> 1);
        return result;
    }

    public void add(AEBoundingSphere bs) {
        this.add(bs, this);
    }

    public void set(AEBoundingSphere bs) {
        this.pos.set(bs.pos);
        this.r = bs.r;
    }

    public void set(int x, int y, int z, int r) {
        this.pos.x = x;
        this.pos.y = y;
        this.pos.z = z;
        this.r = r;
    }

    public void set(AEVector3D pos, int r) {
        this.pos.set(pos);
        this.r = r;
    }

    public String toString() {
        return "AEBoundingSphere | x: " + this.pos.x + " y: " + this.pos.y + " z: " + this.pos.z + " r: " + this.r;
    }
}

