/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEConstraint;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEVector3D;

public class AELookAtConstraint
implements AEConstraint {
    protected AEGraphNode target;
    protected AEGraphNode target_root;
    protected AEGraphNode node;
    protected static AEVector3D tmp1;
    protected static AEVector3D tmp2;
    protected static AEVector3D tmp3;
    protected AEVector3D upVector;
    protected boolean isActive;

    public AELookAtConstraint(AEGraphNode target, AEGraphNode node) {
        this(target, node, null);
    }

    public AELookAtConstraint(AEGraphNode target, AEGraphNode node, AEVector3D upVector) {
        this.target = target;
        this.node = node;
        this.isActive = true;
        this.upVector = upVector;
        if (upVector != null) {
            this.upVector.normalize();
        }
        if (tmp1 == null) {
            tmp1 = new AEVector3D();
        }
        if (tmp2 == null) {
            tmp2 = new AEVector3D();
        }
        if (tmp3 == null) {
            tmp3 = new AEVector3D();
        }
        if (target != null) {
            this.target_root = target;
            while (this.target_root.getParent() != null) {
                this.target_root = this.target_root.getParent();
            }
        }
        AEGraphNode node_root = node;
        while (node_root.getParent() != null) {
            node_root = node_root.getParent();
        }
        if (node_root == this.target_root) {
            this.target_root = null;
        }
    }

    public void setTarget(AEGraphNode target) {
        this.target = target;
    }

    public void setNode(AEGraphNode node) {
        this.node = node;
    }

    public void setUpVector(AEVector3D upVector) {
        this.upVector = upVector;
        if (upVector != null) {
            this.upVector.normalize();
        }
    }

    public AEGraphNode getTarget() {
        return this.target;
    }

    public AEGraphNode getNode() {
        return this.node;
    }

    public void update() {
        if (this.isActive && this.target != null) {
            if (this.target_root != null) {
                this.target_root.update(false);
            }
            tmp1 = this.target.getWorldPosition(tmp1);
            tmp1 = this.node.getParent().getWorldTransform().inverseTransform(tmp1);
            tmp2 = this.node.getPosition(tmp2);
            tmp2.sub(tmp1);
            tmp2.normalize();
            if (this.upVector != null) {
                tmp3.set(this.upVector);
            } else {
                tmp3.set(0, 4096, 0);
            }
            tmp1 = tmp3.cross(tmp2, tmp1);
            tmp1.normalize();
            if (this.upVector != null) {
                tmp2 = tmp1.cross(tmp3, tmp2);
            } else {
                tmp3 = tmp2.cross(tmp1, tmp3);
            }
            this.node.setRotationMatrix(tmp1, tmp3, tmp2);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }
}

