/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AECamera;
import AbyssEngine.AEDevice;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AELayer;
import AbyssEngine.AEVector3D;

public class AERenderer {
    private AEGraphNode root = null;
    private AECamera current_camera = null;
    private AEGraphNode current_camera_root;
    private AELayer[] layer = new AELayer[1];
    private boolean[] layer_clear_enable;
    private AEDevice device;

    public AERenderer(AEDevice device) {
        this.layer[0] = new AELayer();
        this.layer_clear_enable = new boolean[1];
        this.layer_clear_enable[0] = true;
        this.device = device;
    }

    public void setScene(AEGraphNode root) {
        this.root = root;
    }

    public void setCamera(AECamera camera) {
        this.current_camera = camera;
        this.current_camera.setCamera();
        this.current_camera_root = this.current_camera;
        while (this.current_camera_root.getParent() != null) {
            this.current_camera_root = this.current_camera_root.getParent();
        }
    }

    public void render() {
        try {
            if (this.root != null && this.layer != null && this.current_camera != null) {
                this.root.update(false);
                if (this.current_camera_root != null) {
                    this.current_camera_root.update(false);
                } else {
                    this.current_camera.update(false);
                }
                this.root.prerender(this.current_camera, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(AEGraphNode scene) {
        try {
            if (scene != null && this.layer != null && this.current_camera != null) {
                scene.update(false);
                if (this.current_camera_root != null) {
                    this.current_camera_root.update(false);
                } else {
                    this.current_camera.update(false);
                }
                scene.prerender(this.current_camera, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawLayers() {
        for (int i = 0; i < this.layer.length; ++i) {
            this.layer[i].render();
            if (this.layer_clear_enable[i]) {
                this.device.flush();
            }
            this.layer[i].clearCache();
        }
    }

    public void drawLayers(long current_time) {
        for (int i = 0; i < this.layer.length; ++i) {
            this.layer[i].update(current_time);
            this.layer[i].render();
            if (this.layer_clear_enable[i]) {
                this.device.flush();
            }
            this.layer[i].clearCache();
        }
    }

    public void clearLayerCaches() {
        for (int i = 0; i < this.layer.length; ++i) {
            this.layer[i].clearCache();
        }
    }

    public void addLayer(boolean enable_layer_clear) {
        AELayer[] new_layer = new AELayer[this.layer.length + 1];
        System.arraycopy(this.layer, 0, new_layer, 0, this.layer.length);
        new_layer[this.layer.length] = new AELayer();
        this.layer = new_layer;
        boolean[] new_layer_clear_enable = new boolean[this.layer_clear_enable.length + 1];
        System.arraycopy(this.layer_clear_enable, 0, new_layer_clear_enable, 0, this.layer_clear_enable.length);
        new_layer_clear_enable[this.layer_clear_enable.length] = enable_layer_clear;
        this.layer_clear_enable = new_layer_clear_enable;
    }

    public void addLayer() {
        this.addLayer(true);
    }

    public AELayer getLayer(int layer_id) {
        if (layer_id >= this.layer.length) {
            return null;
        }
        return this.layer[layer_id];
    }

    public AELayer[] getLayers() {
        return this.layer;
    }

    public AELayer getDefaultLayer() {
        return this.layer[0];
    }

    public void add2Layer(int id, AEGeometry geometry) {
        this.layer[id].add2Cache(geometry);
    }

    public boolean getScreenPosition(AEVector3D pos) {
        return this.current_camera.getScreenPosition(pos);
    }
}

