/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AETexture;
import AbyssEngine.JSRDevice;
import AbyssEngine.JSRTexture;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public class JSRMesh
extends AEGeometry {
    private int anim_duration;
    private int anim_start_frame;
    private int anim_stop_frame;
    private int anim_current_frame;
    private long anim_start_time;
    private boolean anim_play;
    private byte anim_mode;
    private static Transform tmp_world = new Transform();
    private static float[] tmp_world_value = new float[16];
    private Node[] node_no_transp;
    private Node[] node_transp;
    private static PolygonMode pmNoTransp;
    private static PolygonMode pmTransp;
    private static CompositingMode cm;

    public JSRMesh(String filename, int culling_radius) {
        this.createRenderModes();
        this.loadMeshFromFile(filename);
        this.culling_radius = culling_radius;
    }

    public JSRMesh(JSRMesh mesh) {
        this.createRenderModes();
        this.culling_radius = mesh.culling_radius;
        this.node_no_transp = mesh.node_no_transp;
        this.node_transp = mesh.node_transp;
        this.layer_id = mesh.layer_id;
        this.isVisible = mesh.isVisible;
        this.anim_duration = mesh.anim_duration;
        this.anim_start_frame = mesh.anim_start_frame;
        this.anim_stop_frame = mesh.anim_stop_frame;
        this.anim_current_frame = mesh.anim_current_frame;
        this.anim_start_time = mesh.anim_start_time;
        this.anim_play = mesh.anim_play;
        this.anim_mode = mesh.anim_mode;
    }

    private void createRenderModes() {
        if (pmNoTransp == null) {
            pmNoTransp = new PolygonMode();
            pmNoTransp.setCulling(160);
            pmNoTransp.setShading(164);
        }
        if (pmTransp == null) {
            pmTransp = new PolygonMode();
            pmTransp.setCulling(162);
            pmTransp.setShading(164);
        }
        if (cm == null) {
            cm = new CompositingMode();
            cm.setBlending(64);
            cm.setDepthTestEnable(true);
            cm.setDepthWriteEnable(false);
        }
    }

    private void loadMeshFromFile(String filename) {
        try {
            Object3D[] obj = Loader.load((String)(filename + ".m3g"));
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] instanceof World) {
                    for (int k = 0; k < ((World)obj[i]).getChildCount(); ++k) {
                        Node n = ((World)obj[i]).getChild(k);
                        int node_anim_duration = 0;
                        node_anim_duration = this.getAnimationDuration(n, node_anim_duration);
                        if (n instanceof Group) {
                            if (node_anim_duration == 0) {
                                for (int l = 0; l < ((Group)n).getChildCount(); ++l) {
                                    Node m = ((Group)n).getChild(l);
                                    if (!(m instanceof Mesh)) continue;
                                    Transform wm = new Transform();
                                    m.getCompositeTransform(wm);
                                    ((Group)n).removeChild(m);
                                    m.setTransform(wm);
                                    this.addNode(m);
                                }
                                continue;
                            }
                            this.addNode(n);
                            this.anim_duration = this.anim_duration < node_anim_duration ? node_anim_duration : this.anim_duration;
                            continue;
                        }
                        if (!(n instanceof Mesh)) continue;
                        this.addNode(n);
                        this.anim_duration = this.anim_duration < node_anim_duration ? node_anim_duration : this.anim_duration;
                    }
                    continue;
                }
                if (!(obj[i] instanceof Group)) continue;
                int node_anim_duration = 0;
                if ((node_anim_duration = this.getAnimationDuration((Node)((Group)obj[i]), node_anim_duration)) == 0) {
                    for (int k = 0; k < ((Group)obj[i]).getChildCount(); ++k) {
                        Node n = ((Group)obj[i]).getChild(k);
                        if (!(n instanceof Mesh)) continue;
                        Transform wm = new Transform();
                        n.getCompositeTransform(wm);
                        ((Group)obj[i]).removeChild(n);
                        n.setTransform(wm);
                        this.addNode(n);
                    }
                    continue;
                }
                this.addNode((Node)((Group)obj[i]));
                this.anim_duration = this.anim_duration < node_anim_duration ? node_anim_duration : this.anim_duration;
            }
            if (this.anim_duration != 0) {
                this.anim_start_frame = 0;
                this.anim_stop_frame = this.anim_duration;
                this.anim_current_frame = 0;
                this.anim_start_time = -1L;
                this.anim_play = true;
                this.anim_mode = (byte)2;
            }
        }
        catch (Exception e) {
            this.node_no_transp = null;
            this.node_transp = null;
        }
    }

    private void addNode(Node n) {
        if (this.isTransparent(n)) {
            if (this.node_transp == null) {
                this.node_transp = new Node[1];
                this.node_transp[0] = n;
            } else {
                Node[] new_node_transp = new Node[this.node_transp.length + 1];
                System.arraycopy(this.node_transp, 0, new_node_transp, 0, this.node_transp.length);
                new_node_transp[this.node_transp.length] = n;
                this.node_transp = new_node_transp;
            }
        } else if (this.node_no_transp == null) {
            this.node_no_transp = new Node[1];
            this.node_no_transp[0] = n;
        } else {
            Node[] new_node_no_transp = new Node[this.node_no_transp.length + 1];
            System.arraycopy(this.node_no_transp, 0, new_node_no_transp, 0, this.node_no_transp.length);
            new_node_no_transp[this.node_no_transp.length] = n;
            this.node_no_transp = new_node_no_transp;
        }
    }

    private boolean isTransparent(Node n) {
        block4: {
            block3: {
                if (!(n instanceof Group)) break block3;
                for (int i = 0; i < ((Group)n).getChildCount(); ++i) {
                    Node m = ((Group)n).getChild(i);
                    if (!(m instanceof Mesh)) continue;
                    for (int k = 0; k < ((Mesh)m).getSubmeshCount(); ++k) {
                        Appearance ap = ((Mesh)m).getAppearance(k);
                        Material mat = ap.getMaterial();
                        if (mat == null || mat.getColor(8192) != 65280) continue;
                        return true;
                    }
                }
                break block4;
            }
            if (!(n instanceof Mesh)) break block4;
            for (int i = 0; i < ((Mesh)n).getSubmeshCount(); ++i) {
                Appearance ap = ((Mesh)n).getAppearance(i);
                Material mat = ap.getMaterial();
                if (mat == null || mat.getColor(8192) != 65280) continue;
                return true;
            }
        }
        return false;
    }

    private int getAnimationDuration(Node node, int duration) {
        for (int k = 0; k < node.getAnimationTrackCount(); ++k) {
            KeyframeSequence ks = node.getAnimationTrack(k).getKeyframeSequence();
            if (ks.getDuration() <= duration) continue;
            duration = ks.getDuration();
        }
        if (node instanceof Group) {
            for (int i = 0; i < ((Group)node).getChildCount(); ++i) {
                Node n = ((Group)node).getChild(i);
                for (int k = 0; k < n.getAnimationTrackCount(); ++k) {
                    KeyframeSequence ks = n.getAnimationTrack(k).getKeyframeSequence();
                    if (ks.getDuration() <= duration) continue;
                    duration = ks.getDuration();
                }
                if (!(n instanceof Group)) continue;
                duration = this.getAnimationDuration((Node)((Group)n), duration);
            }
        }
        return duration;
    }

    public void render() {
        block4: {
            if (this.node_no_transp == null) break block4;
            this.render_matrix.getMatrix4x4F(tmp_world_value);
            tmp_world.set(tmp_world_value);
            if (this.anim_duration > 0) {
                for (int i = 0; i < this.node_no_transp.length; ++i) {
                    this.node_no_transp[i].animate(this.anim_current_frame);
                    JSRDevice.device.render(this.node_no_transp[i], tmp_world);
                }
            } else {
                for (int i = 0; i < this.node_no_transp.length; ++i) {
                    JSRDevice.device.render(this.node_no_transp[i], tmp_world);
                }
            }
        }
    }

    public void renderTransp() {
        block4: {
            if (this.node_transp == null) break block4;
            this.render_matrix.getMatrix4x4F(tmp_world_value);
            tmp_world.set(tmp_world_value);
            if (this.anim_duration > 0) {
                for (int i = 0; i < this.node_transp.length; ++i) {
                    this.node_transp[i].animate(this.anim_current_frame);
                    JSRDevice.device.render(this.node_transp[i], tmp_world);
                }
            } else {
                for (int i = 0; i < this.node_transp.length; ++i) {
                    JSRDevice.device.render(this.node_transp[i], tmp_world);
                }
            }
        }
    }

    public void update(long current_time) {
        if (this.anim_play) {
            if (this.anim_start_time == -1L) {
                this.anim_start_time = current_time;
            }
            this.anim_current_frame = this.anim_start_frame + (int)(current_time - this.anim_start_time >> 5);
            if (this.anim_current_frame > this.anim_stop_frame) {
                if (this.anim_mode == 2) {
                    this.anim_current_frame -= (this.anim_stop_frame - this.anim_start_frame) * (this.anim_current_frame / (this.anim_stop_frame - this.anim_start_frame));
                    this.anim_start_time = current_time - (long)(this.anim_current_frame - this.anim_start_frame >> 5);
                } else {
                    this.anim_play = false;
                    this.anim_current_frame = this.anim_stop_frame;
                    this.anim_start_time = -1L;
                }
            }
        }
    }

    public void setAnimRange(int start_frame, int stop_frame) {
        this.anim_start_frame = start_frame >= 0 && start_frame <= this.anim_duration ? start_frame : 0;
        int n = this.anim_stop_frame = stop_frame >= 0 && stop_frame <= this.anim_duration ? stop_frame : this.anim_duration;
        this.anim_current_frame = this.anim_current_frame < start_frame ? start_frame : (this.anim_current_frame > stop_frame ? stop_frame : this.anim_current_frame);
        this.anim_start_time = -1L;
    }

    public void playAnim(byte mode) {
        this.anim_mode = mode;
        this.anim_start_time = -1L;
        this.anim_play = this.anim_duration > 0;
    }

    public void stopAnim() {
        this.anim_play = false;
    }

    public void stopAnim(int frame) {
        this.anim_current_frame = frame >= 0 && frame <= this.anim_duration ? frame : 0;
        this.anim_play = false;
    }

    public boolean isPlaying() {
        return this.anim_play;
    }

    public int getCurrentFrame() {
        return this.anim_current_frame;
    }

    public AEGraphNode copy() {
        return new JSRMesh(this);
    }

    public void setTexture(AETexture texture) {
        int i;
        if (this.node_no_transp != null) {
            for (i = 0; i < this.node_no_transp.length; ++i) {
                this.applyTexture(this.node_no_transp[i], ((JSRTexture)texture).getData(), false);
            }
        }
        if (this.node_transp != null) {
            for (i = 0; i < this.node_transp.length; ++i) {
                this.applyTexture(this.node_transp[i], ((JSRTexture)texture).getData(), true);
            }
        }
    }

    private void applyTexture(Node n, Texture2D[] tex, boolean setTransparent) {
        block13: {
            block12: {
                if (!(n instanceof Mesh)) break block12;
                int user_id = ((Mesh)n).getUserID();
                for (int k = 0; k < ((Mesh)n).getSubmeshCount(); ++k) {
                    Appearance ap = ((Mesh)n).getAppearance(k);
                    if (setTransparent) {
                        ap.setCompositingMode(cm);
                        ap.setPolygonMode(pmTransp);
                    } else {
                        ap.setCompositingMode(null);
                        ap.setPolygonMode(pmNoTransp);
                    }
                    if (ap.getMaterial() != null && ap.getMaterial().getAnimationTrackCount() < 1) {
                        ap.setMaterial(null);
                    }
                    if (ap.getTexture(0) != null && tex != null) {
                        if (ap.getTexture(0).getAnimationTrackCount() > 0 || ap.getMaterial() != null) {
                            if (user_id < tex.length) {
                                ap.getTexture(0).setImage(tex[user_id].getImage());
                            } else {
                                ap.getTexture(0).setImage(tex[0].getImage());
                            }
                        } else if (user_id < tex.length) {
                            ap.setTexture(0, tex[user_id]);
                        } else {
                            ap.setTexture(0, tex[0]);
                        }
                    }
                    ((Mesh)n).setAppearance(k, ap);
                }
                break block13;
            }
            if (!(n instanceof Group)) break block13;
            for (int i = 0; i < ((Group)n).getChildCount(); ++i) {
                Node m = ((Group)n).getChild(i);
                this.applyTexture(m, tex, setTransparent);
            }
        }
    }

    private void printScene(Object3D[] node) {
        for (int i = 0; node != null && i < node.length; ++i) {
            if (!(node[i] instanceof Group) && !(node[i] instanceof World)) continue;
            this.printScene((Group)node[i], 0);
        }
    }

    private void printScene(Node[] node) {
    }

    private void printScene(Group g, int level) {
    }
}

