/*
 * Decompiled with CFR 0.152.
 */
package ScrollerGame;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AETransform;
import ScrollerGame.SCCameraMovement;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCModul;
import ScrollerGame.SCPlayer;
import ScrollerGame.SCTileSet;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.SCEnemyFactory;
import contentHeliStrike.grh;
import java.util.Random;

public class SCLevel {
    private static int current_level;
    private static long current_tile;
    private static Random rndm;
    public static SCModul[] modul;
    public static SCCameraMovement cm;
    private static AEGraphNode sky_box;
    private static AETransform cam_matrix;
    private static int s_cam;
    private static int[] offset;
    private static SCWeaponSystem weapon;
    private static SCWeaponSystem sec_weapon;
    private static SCWeaponSystem trd_weapon;
    private static SCEnemySet enemy_set;
    private static SCEnemySet render_enemy_set;
    private static AEExplosionInterface explosion;
    private static boolean player_dead;
    private static int current_tilt;
    private static int current_strafe;
    private static SCTileSet current_tile_set;
    private static int pre_cache_counter;
    private static int pre_cache_tileset;
    public static long global_tx;
    public static long global_tz;
    private static SCEnemySet player_set;
    private static SCEnemy player;
    private static int collision_damage;
    private static short collision;
    public static final short COLLISION_NONE = 0;
    public static final short COLLISION_LEFT = 1;
    public static final short COLLISION_RIGHT = 2;
    public static final short COLLISION_TOP = 3;
    public static final short COLLISION_BOTTOM = 4;

    public static void init() {
        SCLevel.offset[1] = 0;
        SCLevel.offset[0] = 0;
        s_cam = 0;
        cam_matrix = new AETransform();
        enemy_set = new SCEnemySet();
        player = new SCPlayer();
        player_set = new SCEnemySet();
        player_set.addEnemy(player);
        render_enemy_set = new SCEnemySet();
        player_dead = false;
        collision_damage = 0;
        collision = 0;
    }

    public static void setWeapon(SCWeaponSystem weapon_system) {
        weapon = weapon_system;
        if (weapon != null) {
            weapon.setEnemySet(enemy_set);
        }
    }

    public static SCWeaponSystem getWeapon() {
        return weapon;
    }

    public static void setSecWeapon(SCWeaponSystem sec_weapon_system) {
        sec_weapon = sec_weapon_system;
        if (sec_weapon != null) {
            sec_weapon.setEnemySet(enemy_set);
        }
    }

    public static void setTrdWeapon(SCWeaponSystem trd_weapon_system) {
        trd_weapon = trd_weapon_system;
        if (trd_weapon != null) {
            trd_weapon.setEnemySet(enemy_set);
        }
    }

    public static void setLevel(int level) {
        current_level = level;
        if (rndm == null) {
            rndm = new Random(current_level);
        } else {
            rndm.setSeed(current_level);
        }
    }

    public static void createLevel(int level, SCTileSet tileset) {
        int i;
        pre_cache_counter = 0;
        current_tile = 0L;
        current_tile_set = tileset;
        SCLevel.setLevel(level);
        modul = new SCModul[4];
        SCLevel.modul[0] = new SCModul(rndm, tileset, 0L);
        for (i = 1; i < modul.length; ++i) {
            SCLevel.modul[i] = new SCModul(rndm, tileset, modul[i - 1], i);
            enemy_set.addEnemySet(modul[i].getEnemies());
        }
        global_tx = -modul[0].getTx();
        global_tz = -modul[0].getTz();
        for (i = 0; i < modul.length; ++i) {
            modul[i].replace();
        }
        player_dead = false;
        sky_box = null;
        collision = 0;
        ((SCPlayer)player).setGodMode(false);
        s_cam = 2048;
        s_cam = modul[0].getPathSpace(cam_matrix, offset, s_cam, false);
        cm.getPathRoot().setTranslation(Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE);
        cm.getPathRoot().update(false);
        System.gc();
    }

    public static int preCache() {
        if (current_tile_set == null || current_tile_set.getModuls() == null || pre_cache_counter == current_tile_set.getModuls().length) {
            return 0;
        }
        int[] id = current_tile_set.getModuls()[pre_cache_counter].getStaticObjectIds();
        for (int i = 0; id != null && i < id.length; ++i) {
            AEResourceManager.getGeometryResource(current_tile_set.getModuls()[pre_cache_counter].getStaticObjectIds()[i]);
        }
        return 100 * ++pre_cache_counter / current_tile_set.getModuls().length;
    }

    public static int preCache(SCTileSet[] tileset) {
        int i;
        if (tileset == null || tileset[pre_cache_tileset] == null || tileset[pre_cache_tileset].getModuls() == null) {
            return 0;
        }
        if (pre_cache_counter >= tileset[pre_cache_tileset].getModuls().length) {
            pre_cache_counter = 0;
            if (++pre_cache_tileset >= tileset.length) {
                return 0;
            }
        }
        int[] id = tileset[pre_cache_tileset].getModuls()[pre_cache_counter].getStaticObjectIds();
        for (i = 0; id != null && i < id.length; ++i) {
            AEGeometry aEGeometry = AEResourceManager.getGeometryResource(tileset[pre_cache_tileset].getModuls()[pre_cache_counter].getStaticObjectIds()[i]);
        }
        id = tileset[pre_cache_tileset].getModuls()[pre_cache_counter].getPointEnemyIds();
        for (i = 0; id != null && i < id.length; ++i) {
            SCEnemyFactory.precachePointEnemies(tileset[pre_cache_tileset].getModuls()[pre_cache_counter].getPointEnemyIds()[i]);
        }
        return 100 * ++pre_cache_counter / tileset.length / tileset[pre_cache_tileset].getModuls().length + 100 * pre_cache_tileset / tileset.length;
    }

    public static void setExplosion(AEExplosionInterface player_explosion) {
        explosion = player_explosion;
    }

    public static void setSkyBox(AEGraphNode skybox) {
        sky_box = skybox;
    }

    public static void setPlayerCollisionDamage(int damage) {
        collision_damage = damage;
    }

    public static void update(int elapsed_time) {
        offset[0] = offset[0] + cm.getStepHorizontal();
        offset[1] = offset[1] + cm.getStepVertical();
        SCLevel.offset[1] = offset[1] > 768 ? 768 : (offset[1] < 700 ? 700 : offset[1]);
        collision = 0;
        int last_offset = offset[0];
        int s_tmp = modul[0].getPathSpace(cam_matrix, offset, s_cam, false);
        if (s_tmp <= 0) {
            int i;
            s_cam = -s_tmp;
            enemy_set.removeEnemySet(modul[0].getEnemies());
            modul[0].release();
            SCLevel.modul[0] = null;
            for (i = 1; i < modul.length; ++i) {
                SCLevel.modul[i - 1] = modul[i];
            }
            SCLevel.modul[SCLevel.modul.length - 1] = new SCModul(rndm, current_tile_set, modul[modul.length - 2], current_tile + (long)modul.length - 1L);
            enemy_set.addEnemySet(modul[modul.length - 1].getEnemies());
            global_tx = -modul[0].getTx();
            global_tz = -modul[0].getTz();
            for (i = 0; i < modul.length; ++i) {
                modul[i].replace();
            }
            modul[0].getPathSpace(cam_matrix, offset, s_cam, false);
            ++current_tile;
            SCEnemyFactory.getPathEnemy(current_level);
        }
        if (last_offset > offset[0]) {
            collision = 1;
            offset[0] = offset[0] + 10;
        } else if (last_offset < offset[0]) {
            collision = (short)2;
            offset[0] = offset[0] - 10;
        }
        s_cam += cm.getStepForward();
        cm.getPathRoot().setLocalTransform(cam_matrix);
        cm.getPathRoot().update(false);
        if (player.getHitpoints() <= 0 && !player_dead && cm.isIngame()) {
            player_dead = true;
            if (explosion != null) {
                explosion.start();
            }
            cm.getVehicle().playAnim((byte)1);
        }
        if (weapon != null) {
            weapon.update(elapsed_time);
        }
        if (sec_weapon != null) {
            sec_weapon.update(elapsed_time);
        }
        if (trd_weapon != null) {
            trd_weapon.update(elapsed_time);
        }
        if (explosion != null && explosion.isActive()) {
            explosion.getParticleSystem().setTranslation(cm.getVehicle().getWorldPositionX(), cm.getVehicle().getWorldPositionY(), cm.getVehicle().getWorldPositionZ());
            explosion.update(elapsed_time);
        }
        if (!enemy_set.isEmpty()) {
            enemy_set.update(elapsed_time);
            SCEnemy[] enemy = enemy_set.getEnemies();
            block6: for (int i = 0; enemy != null && i < enemy.length; ++i) {
                switch (enemy[i].getEnemyClassId()) {
                    case 3: 
                    case 9: {
                        if (!enemy[i].isHit((long)SCLevel.getCurrentX() - global_tx, SCLevel.getCurrentY(), (long)SCLevel.getCurrentZ() - global_tz)) continue block6;
                        enemy[i].applyHitpoints(-1000000);
                        player.applyHitpoints(collision_damage);
                        continue block6;
                    }
                    case 10: {
                        if (!enemy[i].isHit((long)SCLevel.getCurrentX() - global_tx, SCLevel.getCurrentY(), (long)SCLevel.getCurrentZ() - global_tz)) continue block6;
                        enemy[i].applyHitpoints(-1000000);
                    }
                }
            }
        }
        cm.update(elapsed_time);
    }

    public static void render() {
        int i;
        if (sky_box != null) {
            grh.r_renderer.render(sky_box);
        }
        grh.r_renderer.render(cm.getPathRoot());
        for (int i2 = 0; i2 < modul.length; ++i2) {
            grh.r_renderer.render(SCLevel.modul[i2].root);
        }
        if (weapon != null) {
            weapon.render();
        }
        if (sec_weapon != null) {
            sec_weapon.render();
        }
        if (trd_weapon != null) {
            trd_weapon.render();
        }
        if (!enemy_set.isEmpty()) {
            SCEnemy[] enemy = enemy_set.getEnemies();
            for (i = 0; i < enemy.length; ++i) {
                if (enemy[i].getWeapon() == null) continue;
                enemy[i].getWeapon().render();
            }
        }
        if (explosion != null && explosion.isActive()) {
            grh.r_renderer.render(explosion.getParticleSystem());
        }
        if (!render_enemy_set.isEmpty()) {
            SCEnemy[] enemy = render_enemy_set.getEnemies();
            for (i = 0; i < enemy.length; ++i) {
                grh.r_renderer.render(enemy[i].getGeometry());
                if (enemy[i].getExplosion() == null) continue;
                grh.r_renderer.render(enemy[i].getExplosion());
            }
        }
    }

    public static void shoot() {
        if (weapon != null) {
            weapon.shoot(cm.getShootNode(0));
        }
    }

    public static void sec_shoot() {
        if (sec_weapon != null) {
            sec_weapon.shoot(cm.getShootNode(1));
        }
    }

    public static void trd_shoot() {
        if (trd_weapon != null) {
            trd_weapon.shoot(cm.getShootNode(2));
        }
    }

    public static void release() {
        if (modul != null) {
            for (int i = 0; i < modul.length; ++i) {
                if (modul[i] == null) continue;
                modul[i].finalRelease();
                SCLevel.modul[i] = null;
            }
        }
        modul = null;
        SCLevel.offset[1] = 0;
        SCLevel.offset[0] = 0;
        s_cam = 0;
        weapon = null;
        sec_weapon = null;
        trd_weapon = null;
        enemy_set.removeAllEnemies();
        render_enemy_set.removeAllEnemies();
        global_tx = 0L;
        global_tz = 0L;
        pre_cache_tileset = 0;
        if (current_tile_set != null) {
            current_tile_set.release();
        }
        current_tile_set = null;
    }

    public static SCEnemySet getEnemies() {
        return enemy_set;
    }

    public static long getCurrentTile() {
        return current_tile;
    }

    public static SCEnemySet getCurrentModulEnemySet() {
        return modul[0].getEnemies();
    }

    public static void changeTileSet(SCTileSet tileset) {
        current_tile_set = tileset;
    }

    public static int getCurrentX() {
        return cm.getVehicle().getWorldPositionX();
    }

    public static int getCurrentY() {
        return cm.getVehicle().getWorldPositionY();
    }

    public static int getCurrentZ() {
        return cm.getVehicle().getWorldPositionZ();
    }

    public static boolean isPlayerDead() {
        return player_dead;
    }

    public static SCEnemy getPlayer() {
        return player;
    }

    public static SCEnemySet getPlayerSet() {
        return player_set;
    }

    public static SCEnemySet getRenderEnemySet() {
        return render_enemy_set;
    }

    public static AEGraphNode getVehicle() {
        return cm.getVehicle();
    }

    public static int getOffsetX() {
        return offset[0];
    }

    public static int getOffsetY() {
        return offset[1];
    }

    public static boolean lastTimeHit() {
        return ((SCPlayer)player).lastTimeHit();
    }

    public static short getCollisionH() {
        return collision;
    }

    public static short getCollisionV() {
        if (offset[1] == 768) {
            return 3;
        }
        if (offset[1] == 700) {
            return 4;
        }
        return 0;
    }

    public static SCWeaponSystem getSecWeapon() {
        return sec_weapon;
    }

    public static boolean isExplosionPlaying() {
        return explosion != null && explosion.isActive();
    }

    public static byte getCurrentWeaponType() {
        return weapon.getShootMode();
    }

    static {
        offset = new int[2];
    }
}

