/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AECamera;
import AbyssEngine.AEEaseInOut;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AEMath;
import ScrollerGame.SCCameraMovement;
import ScrollerGame.SCLevel;
import ScrollerGame.SCPlayer;
import contentHeliStrike.SCSmokeSystem;
import contentHeliStrike.grh;

public class HeliStrikeCamera_2
extends SCCameraMovement {
    private static final int STATE_INTRO = 0;
    private static final int STATE_INGAME = 1;
    private static final int STATE_OUTRO = 2;
    private static final int STATE_MENU = 3;
    private int state;
    private static final long INTRO_TIME = 1024L;
    private static final long OUTRO_TIME = 1024L;
    private long intro_outro_time;
    private static final short S_NOTHING = 0;
    private static final short S_FORWARD = 1;
    private static final short S_BACKWARD = 2;
    private static final short S_LEFT = 4;
    private static final short S_RIGHT = 8;
    private short steer_status = 0;
    private AEGraphNode rotor;
    private AEGraphNode shoot_node;
    private AEGraphNode shield1;
    private AEGraphNode shield2;
    private AEGraphNode nuke;
    public SCSmokeSystem smoke_system;
    private long smoke_emit_delay;
    private static final long SMOKE_EMIT_DELAY = 100L;
    private AEEaseInOut eio_speed;
    private AEEaseInOut eio_strafe;
    private int h_offset;
    private int menu_rotation;
    private long shield_time;
    private static final long SHIELD_TIME = 20000L;

    public HeliStrikeCamera_2(AEGraphNode vehicle_node, AEGraphNode rotor, AEGeometry shield, AEGeometry nuke) {
        this.camera = AECamera.create(grh.r_w, grh.r_h, 500, 256, 16384);
        this.camera.setTranslation(0, 100, 400);
        this.camera.setRotation(-512, 0, 0);
        this.path_group = new AEGroup();
        ((AEGroup)this.path_group).addChild(this.camera);
        this.shoot_node = new AEGroup();
        ((AEGroup)this.path_group).addChild(this.shoot_node);
        this.vehicle_node = vehicle_node;
        this.vehicle_node.stopAnim(0);
        this.rotor = rotor;
        this.rotor.setRotationOrdering((short)4);
        ((AEGroup)this.path_group).addChild(vehicle_node);
        ((AEGroup)this.path_group).addChild(rotor);
        this.nuke = nuke;
        nuke.stopAnim(0);
        ((AEGroup)this.shoot_node).addChild(nuke);
        nuke.setVisible(false);
        this.shield1 = shield;
        this.shield1.stopAnim(0);
        this.shield1.setRotationOrdering((short)3);
        ((AEGroup)this.path_group).addChild(this.shield1);
        this.shield2 = shield.copy();
        this.shield2.setScaling(18000, 18000, 18000);
        this.shield2.stopAnim(0);
        this.shield2.setRotationOrdering((short)3);
        ((AEGroup)this.path_group).addChild(this.shield2);
        this.shield1.setVisible(false);
        this.shield2.setVisible(false);
        this.state = 0;
        this.intro_outro_time = 1024L;
        this.eio_speed = new AEEaseInOut(0, 4096);
        this.eio_speed.increase(1000);
        this.eio_strafe = new AEEaseInOut(-96, 96);
        this.h_offset = 0;
        this.smoke_system = new SCSmokeSystem();
        this.smoke_emit_delay = 100L;
    }

    public void moveForward(int elapsed_time) {
        this.step_forward = (elapsed_time * this.eio_speed.getValue() >> 13) + (elapsed_time >> 1);
    }

    public void moveLeft(int elapsed_time) {
        if (SCLevel.getCollisionH() != 1) {
            this.steer_status = (short)(this.steer_status | 4);
        }
    }

    public void moveRight(int elapsed_time) {
        if (SCLevel.getCollisionH() != 2) {
            this.steer_status = (short)(this.steer_status | 8);
        }
    }

    public void moveUp(int elapsed_time) {
        this.steer_status = (short)(this.steer_status | 1);
    }

    public void moveDown(int elapsed_time) {
        this.steer_status = (short)(this.steer_status | 2);
    }

    public void update(int elapsed_time) {
        if ((this.steer_status & 1) != 0) {
            this.eio_speed.increase(elapsed_time << 1);
        } else if ((this.steer_status & 2) != 0) {
            this.eio_speed.decrease(elapsed_time << 1);
        } else {
            this.eio_speed.decrease(elapsed_time);
        }
        if ((this.steer_status & 8) != 0) {
            this.eio_strafe.decrease(elapsed_time << 2);
        } else if ((this.steer_status & 4) != 0) {
            this.eio_strafe.increase(elapsed_time << 2);
        } else {
            this.eio_strafe.runOut(elapsed_time << 1);
        }
        switch (this.state) {
            case 0: {
                this.intro_outro_time -= (long)(elapsed_time >> 1);
                if (this.intro_outro_time < 0L) {
                    this.state = 1;
                    this.intro_outro_time = 0L;
                }
                this.camera.setTranslation(this.h_offset * 2 / 3, 2500 - (this.eio_speed.getValue() >> 7) - (int)this.intro_outro_time * 9 / 3, (this.eio_speed.getValue() >> 7) + 2000);
                this.camera.setRotation(-470 + (this.eio_speed.getValue() >> 7) + ((int)this.intro_outro_time >> 1), 0, 0);
                break;
            }
            case 2: {
                this.intro_outro_time += (long)(elapsed_time >> 1);
                if (this.intro_outro_time <= 1024L) {
                    this.camera.setTranslation(this.h_offset * 2 / 3, 2500 - (this.eio_speed.getValue() >> 7) - (int)this.intro_outro_time * 9 / 3, (this.eio_speed.getValue() >> 7) + 2000);
                    this.camera.setRotation(-470 + (this.eio_speed.getValue() >> 7) + ((int)this.intro_outro_time >> 1), 0, 0);
                    break;
                }
                this.intro_outro_time = 1024L;
                break;
            }
            case 3: {
                this.menu_rotation += elapsed_time >> 1;
                this.camera.setTranslation(512 * AEMath.sin(this.menu_rotation >> 1) >> 12, 50 - (this.eio_speed.getValue() >> 7), 350 + (this.eio_speed.getValue() >> 7) + (64 * AEMath.sin(this.menu_rotation + 512) >> 12));
                this.camera.setRotation(-128 + (this.eio_speed.getValue() >> 6), 512 * AEMath.sin(this.menu_rotation >> 1) >> 12, 0);
                break;
            }
            default: {
                this.camera.setTranslation(this.h_offset * 2 / 3, 2500 - (this.eio_speed.getValue() >> 7), (this.eio_speed.getValue() >> 7) + 2000);
                this.camera.setRotation(-470 + (this.eio_speed.getValue() >> 7), 0, 0);
            }
        }
        this.h_offset -= this.step_horizontal;
        this.h_offset = this.h_offset < -2048 ? -2048 : (this.h_offset > 2048 ? 2048 : this.h_offset);
        this.vehicle_node.setRotation(-(this.eio_speed.getValue() >> 4), this.eio_strafe.getValue() << 1, this.eio_strafe.getValue() << 2);
        this.rotor.setRotation(-(this.eio_speed.getValue() >> 3), this.rotor.getRotationY() + (elapsed_time << 2) + (this.eio_speed.getValue() >> 6), this.eio_strafe.getValue() << 1);
        this.vehicle_node.setTranslation(this.h_offset, 0, -(this.eio_speed.getValue() >> 2));
        this.rotor.setTranslation(this.h_offset, 0, -(this.eio_speed.getValue() >> 2));
        this.shoot_node.setTranslation(this.h_offset, 0, -(this.eio_speed.getValue() >> 2));
        if (this.shield1.isVisible()) {
            this.shield1.setTranslation(this.h_offset, 0, -(this.eio_speed.getValue() >> 2));
            this.shield1.rotate(-(elapsed_time << 1), elapsed_time >> 2, elapsed_time >> 1);
            this.shield2.setTranslation(this.h_offset, 0, -(this.eio_speed.getValue() >> 2));
            this.shield2.setRotation(this.shield1.getRotationX(), this.shield1.getRotationY(), this.shield1.getRotationZ() + 1024);
            this.shield_time -= (long)elapsed_time;
            if (this.shield_time < 0L) {
                this.shield1.setVisible(false);
                this.shield2.setVisible(false);
                ((SCPlayer)SCLevel.getPlayer()).setGodMode(false);
            }
        }
        if (this.nuke.isVisible() && !this.nuke.isPlaying()) {
            this.nuke.setVisible(false);
        }
        this.step_horizontal = this.eio_strafe.getValue() * elapsed_time >> 6;
        this.steer_status = 0;
        if (SCLevel.getPlayer().getHitpoints() <= 0 && this.rotor.isVisible()) {
            this.rotor.setVisible(false);
        }
        long l = this.smoke_emit_delay = this.smoke_emit_delay >= 0L ? this.smoke_emit_delay - (long)elapsed_time : -1L;
        if (this.smoke_emit_delay < 0L && SCLevel.getPlayer().getHitpoints() < 100 && SCLevel.getPlayer().getHitpoints() > 0) {
            this.smoke_system.emit((long)this.vehicle_node.getWorldPositionX() - SCLevel.global_tx, this.vehicle_node.getWorldPositionY(), (long)this.vehicle_node.getWorldPositionZ() - SCLevel.global_tz);
            this.smoke_emit_delay = 100L;
        }
    }

    public AEGraphNode getShootNode(int id) {
        if (id == 0) {
            return this.shoot_node;
        }
        return this.shoot_node;
    }

    public void playOutro() {
        this.state = 2;
        this.intro_outro_time = 0L;
    }

    public void startStageSequenze() {
        this.state = 2;
        this.intro_outro_time = 0L;
    }

    public void stopStageSequenze() {
        this.state = 0;
    }

    public boolean isIngame() {
        return this.state == 1;
    }

    public int getVelocityVecX() {
        return -((this.path_group.getWorldDirectionX() - this.camera.getWorldDirectionX()) * 200 >> 12);
    }

    public int getVelocityVecY() {
        return this.step_vertical;
    }

    public int getCameraBank() {
        return this.camera.getRotationZ();
    }

    public int getCameraTilt() {
        return this.camera.getRotationX();
    }

    public int getSpeed() {
        return this.eio_speed.getValue();
    }

    public int getDirection() {
        return this.path_group.getRotationY() + this.vehicle_node.getRotationY();
    }

    public AECamera getCamera() {
        return this.camera;
    }

    public void enableMenuMode() {
        this.state = 3;
    }

    public int getStepHorizontal() {
        return 0;
    }

    public AEGraphNode getVehicle() {
        return this.vehicle_node;
    }

    public void enableShield() {
        this.shield1.setVisible(true);
        this.shield2.setVisible(true);
        this.shield_time = 20000L;
        ((SCPlayer)SCLevel.getPlayer()).setGodMode(true);
    }

    public void enableNuke() {
        this.nuke.setVisible(true);
        this.nuke.playAnim((byte)1);
    }
}

