/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosion;
import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AEScene;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCLevel;
import ScrollerGame.SCPathEnemy;
import ScrollerGame.SCStaticEnemyTurret;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.SCBoatBossEnemy;
import contentHeliStrike.SCEnemyWeapon;
import contentHeliStrike.SCExplosion;
import contentHeliStrike.SCHeliEnemy;
import contentHeliStrike.SCHeliRocket;
import contentHeliStrike.SCPlaneBossEnemy;
import contentHeliStrike.SCPowerUp;
import contentHeliStrike.SCTankBossEnemy;
import contentHeliStrike.SCTruckEnemy;
import contentHeliStrike.grh;
import java.util.Random;

public class SCEnemyFactory {
    private static Random rndm = new Random(0L);
    private static int[] cache_id;
    private static SCEnemy[] cache_enemy;
    private static SCEnemy[] cache_path_enemy;
    private static final long POWERUP_START_TILE = 6L;
    private static int pointEnemyLoading;

    public static SCEnemy getPointEnemy(int id, int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
        if (tile < 3L) {
            return null;
        }
        if (id == 10) {
            return SCEnemyFactory.createPointEnemy(id, tx, ty, tz, rx, ry, rz, modul_root, tile);
        }
        if (grh.r_level < 9) {
            if (id < 8) {
                if (id == -1) {
                    id = 3;
                } else {
                    int probability = grh.enemyProbability[grh.r_level][2 * id] + ((int)((tile << 12) / 25L) * (grh.enemyProbability[grh.r_level][2 * id + 1] - grh.enemyProbability[grh.r_level][2 * id]) >> 12);
                    if (rndm.nextInt(100) > probability || tile > 27L) {
                        return null;
                    }
                }
            }
        } else if (id < 8 && (long)rndm.nextInt(40) > tile >> 2) {
            return null;
        }
        if (cache_enemy == null) {
            cache_id = new int[1];
            cache_enemy = new SCEnemy[1];
            SCEnemyFactory.cache_id[0] = id;
            SCEnemyFactory.cache_enemy[0] = SCEnemyFactory.createPointEnemy(id, tx, ty, tz, rx, ry, rz, modul_root, tile);
            ++grh.total_enemies;
            return cache_enemy[0];
        }
        for (int i = 0; i < cache_id.length; ++i) {
            if (id != cache_id[i] || cache_enemy[i].isUsed()) continue;
            cache_enemy[i].reinit(tx, ty, tz, rx, ry, rz, modul_root, tile);
            ++grh.total_enemies;
            return cache_enemy[i];
        }
        int[] new_cache_id = new int[cache_id.length + 1];
        SCEnemy[] new_cache_enemy = new SCEnemy[cache_enemy.length + 1];
        System.arraycopy(cache_enemy, 0, new_cache_enemy, 0, cache_enemy.length);
        new_cache_enemy[SCEnemyFactory.cache_enemy.length] = SCEnemyFactory.createPointEnemy(id, tx, ty, tz, rx, ry, rz, modul_root, tile);
        cache_enemy = new_cache_enemy;
        System.arraycopy(cache_id, 0, new_cache_id, 0, cache_id.length);
        new_cache_id[SCEnemyFactory.cache_id.length] = id;
        cache_id = new_cache_id;
        ++grh.total_enemies;
        return cache_enemy[cache_enemy.length - 1];
    }

    private static SCWeaponSystem getWeapon(int id) {
        AEExplosionInterface hit_explosion = null;
        switch (id) {
            case 1: {
                hit_explosion = new SCExplosion(AEResourceManager.getGeometryResource(5000));
                break;
            }
            default: {
                hit_explosion = new AEExplosion(1, AEResourceManager.getTextureResource(2), 128, 96, 48, 128, 80, 1024, 500, 250);
            }
        }
        hit_explosion.getParticleSystem().setLayer(1);
        switch (id) {
            case 0: {
                AEGeometry gun_fire = AEGeometry.createParticleSystem(128, 96, 96, 112, 112, 100, 5, (byte)2);
                gun_fire.setTexture(AEResourceManager.getTextureResource(2));
                gun_fire.setLayer(1);
                SCEnemyWeapon weapon = new SCEnemyWeapon(5, 5000, 6000, 10, 250, 1000, 1500, 5000, 6000, gun_fire, grh.r_renderer, hit_explosion);
                weapon.setEnemySet(SCLevel.getPlayerSet());
                return weapon;
            }
            case 2: {
                AEGeometry gun_fire = AEGeometry.createParticleSystem(128, 96, 80, 112, 96, 100, 40, (byte)2);
                gun_fire.setTexture(AEResourceManager.getTextureResource(2));
                gun_fire.setLayer(1);
                SCEnemyWeapon weapon = new SCEnemyWeapon(40, 8000, 2000, 15, 250, 1000, 2000, 2000, 3000, gun_fire, grh.r_renderer, hit_explosion);
                weapon.setEnemySet(SCLevel.getPlayerSet());
                switch (grh.r_level) {
                    case 0: 
                    case 3: 
                    case 6: {
                        weapon.setShootMode((byte)1);
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 7: {
                        weapon.setShootMode((byte)2);
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 8: {
                        weapon.setShootMode((byte)2);
                    }
                }
                return weapon;
            }
            case 3: {
                AEGeometry gun_fire = AEGeometry.createParticleSystem(128, 96, 96, 112, 112, 100, 15, (byte)2);
                gun_fire.setTexture(AEResourceManager.getTextureResource(2));
                gun_fire.setLayer(1);
                SCWeaponSystem weapon = new SCWeaponSystem(15, 5000, 6000, 10, 250, gun_fire, grh.r_renderer, hit_explosion);
                weapon.setEnemySet(SCLevel.getPlayerSet());
                return weapon;
            }
            case 4: {
                SCHeliRocket rocket_system = SCHeliRocket.create(1, 4200, 10000, 40, 15000, 512, grh.r_renderer, hit_explosion);
                rocket_system.setTarget(SCLevel.cm.getVehicle());
                rocket_system.setEnemySet(SCLevel.getPlayerSet());
                return rocket_system;
            }
        }
        SCHeliRocket rocket_system = SCHeliRocket.create(1, 4000, 10000, 40, 12000, 512, grh.r_renderer, hit_explosion);
        rocket_system.setTarget(SCLevel.cm.getVehicle());
        rocket_system.setEnemySet(SCLevel.getPlayerSet());
        return rocket_system;
    }

    public static SCEnemy createPointEnemy(int id, int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
        switch (id) {
            case 0: {
                AEGeometry mesh = null;
                AEGeometry mesh_destroyed = null;
                int type = rndm.nextInt(2);
                int hitpoints = 1;
                switch (type) {
                    case 0: {
                        mesh = AEResourceManager.getGeometryResource(531);
                        mesh_destroyed = AEResourceManager.getGeometryResource(532);
                        hitpoints = 150;
                        break;
                    }
                    case 1: {
                        mesh = AEResourceManager.getGeometryResource(527);
                        mesh_destroyed = AEResourceManager.getGeometryResource(528);
                        hitpoints = 100;
                    }
                }
                mesh.setScaling(18000, 18000, 18000);
                mesh_destroyed.setScaling(18000, 18000, 18000);
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5001));
                explosion.getParticleSystem().setLayer(1);
                return new SCStaticEnemyTurret(mesh, new AEGroup(), new AEGroup(), mesh_destroyed, modul_root, tx, ty, tz, rx, ry, rz, hitpoints, 400, explosion, SCEnemyFactory.getWeapon(type), grh.r_score, 0, tile);
            }
            case 7: {
                AEGeometry mesh = AEResourceManager.getGeometryResource(525);
                AEGeometry mesh_destroyed = AEResourceManager.getGeometryResource(526);
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5000));
                explosion.getParticleSystem().setLayer(1);
                mesh.setScaling(18000, 18000, 18000);
                mesh_destroyed.setScaling(18000, 18000, 18000);
                return new SCTruckEnemy(mesh, mesh_destroyed, tx, ty, tz, rx, ry, rz, 10, 280, explosion, grh.r_score, 7, tile);
            }
            case 5: {
                AEGeometry mesh = AEResourceManager.getGeometryResource(536);
                AEGeometry mesh_destroyed = AEResourceManager.getGeometryResource(537);
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5001));
                explosion.getParticleSystem().setLayer(1);
                mesh.setScaling(18000, 18000, 18000);
                mesh_destroyed.setScaling(18000, 18000, 18000);
                return new SCStaticEnemyTurret(mesh, new AEGroup(), new AEGroup(), mesh_destroyed, modul_root, tx, ty, tz, rx, ry, rz, 100, 400, explosion, SCEnemyFactory.getWeapon(0), grh.r_score, 5, tile);
            }
            case 4: {
                AEGeometry mesh = AEResourceManager.getGeometryResource(523);
                AEGeometry mesh_destroyed = AEResourceManager.getGeometryResource(524);
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5000));
                explosion.getParticleSystem().setLayer(1);
                mesh.setScaling(18000, 18000, 18000);
                mesh_destroyed.setScaling(18000, 18000, 18000);
                return new SCStaticEnemyTurret(mesh, new AEGroup(), new AEGroup(), mesh_destroyed, modul_root, tx, ty, tz, rx, ry, rz, 100, 400, explosion, SCEnemyFactory.getWeapon(1), grh.r_score, 4, tile);
            }
            case 3: {
                AEGeometry mesh = null;
                int unit = rndm.nextInt(3);
                switch (unit) {
                    case 0: {
                        mesh = AEResourceManager.getGeometryResource(515);
                        break;
                    }
                    case 1: {
                        mesh = AEResourceManager.getGeometryResource(514);
                        break;
                    }
                    case 2: {
                        mesh = AEResourceManager.getGeometryResource(518);
                    }
                }
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5001));
                explosion.getParticleSystem().setLayer(1);
                mesh.setScaling(18000, 18000, 18000);
                return new SCHeliEnemy(mesh, modul_root, tx, ty, tz, rx, ry, rz, 100, 400, explosion, SCEnemyFactory.getWeapon(3), grh.r_score, 3, tile);
            }
            case 8: {
                switch (grh.r_level) {
                    case 6: 
                    case 7: 
                    case 8: {
                        AEGroup silo = null;
                        SCExplosion silo_explosion = null;
                        AEGroup turret = new AEGroup();
                        AEGeometry mesh = AEResourceManager.getGeometryResource(604);
                        if (grh.r_level != 6) {
                            AEGraphNode extension;
                            if (grh.r_level == 7) {
                                extension = AEResourceManager.getGeometryResource(614);
                                extension.setScaling(18000, 18000, 18000);
                                turret.addChild(extension);
                            } else {
                                silo = new AEGroup();
                                silo.addChild(AEResourceManager.getGeometryResource(41));
                                silo.addChild(AEResourceManager.getGeometryResource(42));
                                silo.addChild(AEResourceManager.getGeometryResource(43));
                                extension = new AEGroup();
                                ((AEGroup)extension).addChild(AEResourceManager.getGeometryResource(614));
                                ((AEGroup)extension).addChild(AEResourceManager.getGeometryResource(615));
                                extension.setScaling(18000, 18000, 18000);
                                turret.addChild(extension);
                            }
                            silo_explosion = new SCExplosion(AEResourceManager.getGeometryResource(5002));
                            silo_explosion.getParticleSystem().setLayer(1);
                        }
                        AEGeometry base2 = AEResourceManager.getGeometryResource(606);
                        AEGeometry cannon = AEResourceManager.getGeometryResource(605);
                        AEGeometry destroyed = AEResourceManager.getGeometryResource(607);
                        SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5000));
                        explosion.getParticleSystem().setLayer(1);
                        mesh.setScaling(18000, 18000, 18000);
                        base2.setScaling(18000, 18000, 18000);
                        cannon.setScaling(18000, 18000, 18000);
                        destroyed.setScaling(18000, 18000, 18000);
                        turret.addChild(base2);
                        SCWeaponSystem[] weapon = null;
                        if (grh.r_level == 6) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2)};
                        } else if (grh.r_level == 7) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2), SCEnemyFactory.getWeapon(1)};
                        } else if (grh.r_level == 8) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2), SCEnemyFactory.getWeapon(1), SCEnemyFactory.getWeapon(4)};
                        }
                        return new SCTankBossEnemy(silo, silo_explosion, mesh, turret, cannon, destroyed, modul_root, tx, ty, tz, rx, ry, rz, 3000, 400, explosion, weapon, grh.r_score, 8, tile);
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        AEGraphNode base = null;
                        if (grh.r_level != 3) {
                            base = new AEGroup();
                            AEGeometry mesh = AEResourceManager.getGeometryResource(601);
                            if (grh.r_level == 5) {
                                ((AEGroup)base).addChild(AEResourceManager.getGeometryResource(613));
                            }
                            ((AEGroup)base).addChild(AEResourceManager.getGeometryResource(612));
                            ((AEGroup)base).addChild(mesh);
                        } else {
                            base = AEResourceManager.getGeometryResource(601);
                        }
                        SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5001));
                        explosion.getParticleSystem().setLayer(1);
                        base.setScaling(18000, 18000, 18000);
                        SCWeaponSystem[] weapon = null;
                        if (grh.r_level == 3) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2)};
                        } else if (grh.r_level == 4) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2), SCEnemyFactory.getWeapon(1)};
                        } else if (grh.r_level == 5) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2), SCEnemyFactory.getWeapon(1), SCEnemyFactory.getWeapon(4)};
                        }
                        return new SCPlaneBossEnemy(base, modul_root, tx, ty, tz, rx, ry, rz, 2500, 400, explosion, weapon, grh.r_score, 8, tile);
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        AEGraphNode base = null;
                        AEGeometry destroyed = AEResourceManager.getGeometryResource(603);
                        if (grh.r_level != 0) {
                            base = new AEGroup();
                            AEGeometry mesh = AEResourceManager.getGeometryResource(602);
                            if (grh.r_level == 2) {
                                ((AEGroup)base).addChild(AEResourceManager.getGeometryResource(611));
                            }
                            ((AEGroup)base).addChild(AEResourceManager.getGeometryResource(610));
                            ((AEGroup)base).addChild(mesh);
                        } else {
                            base = AEResourceManager.getGeometryResource(602);
                        }
                        SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5000));
                        explosion.getParticleSystem().setLayer(1);
                        base.setScaling(8192, 8192, 8192);
                        destroyed.setScaling(8192, 8192, 8192);
                        SCWeaponSystem[] weapon = null;
                        if (grh.r_level == 0) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2)};
                        } else if (grh.r_level == 1) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2), SCEnemyFactory.getWeapon(1)};
                        } else if (grh.r_level == 2) {
                            weapon = new SCWeaponSystem[]{SCEnemyFactory.getWeapon(2), SCEnemyFactory.getWeapon(1), SCEnemyFactory.getWeapon(4)};
                        }
                        return new SCBoatBossEnemy(base, destroyed, modul_root, tx, ty, tz, rx, ry, rz, 1500, 400, explosion, weapon, grh.r_score, 8, tile);
                    }
                }
            }
            case 2: {
                AEGeometry mesh = AEResourceManager.getGeometryResource(533);
                AEGeometry turret = AEResourceManager.getGeometryResource(534);
                AEGeometry mesh_destroyed = AEResourceManager.getGeometryResource(535);
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5000));
                explosion.getParticleSystem().setLayer(1);
                mesh.setScaling(18000, 18000, 18000);
                turret.setScaling(18000, 18000, 18000);
                mesh_destroyed.setScaling(18000, 18000, 18000);
                return new SCStaticEnemyTurret(mesh, new AEGroup(), turret, mesh_destroyed, modul_root, tx, ty, tz, rx, ry, rz, 100, 400, explosion, SCEnemyFactory.getWeapon(1), grh.r_score, 2, tile);
            }
            case 1: {
                AEGeometry mesh = AEResourceManager.getGeometryResource(529);
                AEGeometry mesh_destroyed = AEResourceManager.getGeometryResource(530);
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5001));
                explosion.getParticleSystem().setLayer(1);
                mesh.setScaling(18000, 18000, 18000);
                mesh_destroyed.setScaling(18000, 18000, 18000);
                AEGroup base1 = new AEGroup();
                base1.setTranslation(0, 100, 0);
                AEGroup cannon = new AEGroup();
                cannon.setTranslation(0, 100, 0);
                return new SCStaticEnemyTurret(mesh, base1, cannon, mesh_destroyed, modul_root, tx, ty, tz, rx, ry, rz, 100, 280, explosion, SCEnemyFactory.getWeapon(0), grh.r_score, 1, tile);
            }
            case 10: {
                switch (grh.r_level) {
                    case 0: 
                    case 1: {
                        if (tile == 15L && SCLevel.getCurrentWeaponType() == 0) {
                            return SCEnemyFactory.getPowerUp((byte)1, tx, ty, tz, rx, ry, rz, tile);
                        }
                        return null;
                    }
                    case 2: {
                        if (tile == 15L && SCLevel.getCurrentWeaponType() == 0) {
                            return SCEnemyFactory.getPowerUp((byte)1, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 16L) {
                            return SCEnemyFactory.getPowerUp((byte)2, tx, ty, tz, rx, ry, rz, tile);
                        }
                        return null;
                    }
                    case 3: 
                    case 4: {
                        if (tile == 8L && SCLevel.getCurrentWeaponType() == 0 || tile == 13L && SCLevel.getCurrentWeaponType() <= 1 || tile == 18L && SCLevel.getCurrentWeaponType() <= 2) {
                            return SCEnemyFactory.getPowerUp((byte)1, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 16L) {
                            return SCEnemyFactory.getPowerUp((byte)2, tx, ty, tz, rx, ry, rz, tile);
                        }
                        return null;
                    }
                    case 5: {
                        if (tile == 8L && SCLevel.getCurrentWeaponType() == 0 || tile == 13L && SCLevel.getCurrentWeaponType() <= 1 || tile == 18L && SCLevel.getCurrentWeaponType() <= 2) {
                            return SCEnemyFactory.getPowerUp((byte)1, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 10L || tile == 20L) {
                            return SCEnemyFactory.getPowerUp((byte)2, tx, ty, tz, rx, ry, rz, tile);
                        }
                        return null;
                    }
                    case 6: {
                        if (tile == 6L && SCLevel.getCurrentWeaponType() == 0 || tile == 11L && SCLevel.getCurrentWeaponType() <= 1 || tile == 16L && SCLevel.getCurrentWeaponType() <= 2 || tile == 21L && SCLevel.getCurrentWeaponType() <= 3) {
                            return SCEnemyFactory.getPowerUp((byte)1, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 10L || tile == 20L) {
                            return SCEnemyFactory.getPowerUp((byte)2, tx, ty, tz, rx, ry, rz, tile);
                        }
                        return null;
                    }
                    case 7: {
                        if (tile == 6L && SCLevel.getCurrentWeaponType() == 0 || tile == 11L && SCLevel.getCurrentWeaponType() <= 1 || tile == 16L && SCLevel.getCurrentWeaponType() <= 2 || tile == 21L && SCLevel.getCurrentWeaponType() <= 3) {
                            return SCEnemyFactory.getPowerUp((byte)1, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 8L || tile == 15L || tile == 22L) {
                            return SCEnemyFactory.getPowerUp((byte)2, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 18L) {
                            return SCEnemyFactory.getPowerUp((byte)3, tx, ty, tz, rx, ry, rz, tile);
                        }
                        return null;
                    }
                    case 8: {
                        if (tile == 6L && SCLevel.getCurrentWeaponType() == 0 || tile == 11L && SCLevel.getCurrentWeaponType() <= 1 || tile == 16L && SCLevel.getCurrentWeaponType() <= 2 || tile == 21L && SCLevel.getCurrentWeaponType() <= 3) {
                            return SCEnemyFactory.getPowerUp((byte)1, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 8L || tile == 15L || tile == 22L) {
                            return SCEnemyFactory.getPowerUp((byte)2, tx, ty, tz, rx, ry, rz, tile);
                        }
                        if (tile == 12L || tile == 18L) {
                            return SCEnemyFactory.getPowerUp((byte)3, tx, ty, tz, rx, ry, rz, tile);
                        }
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static SCEnemy getPowerUp(byte type, int tx, int ty, int tz, int rx, int ry, int rz, long tile) {
        switch (type) {
            case 1: {
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(806));
                explosion.getParticleSystem().setLayer(1);
                AEGeometry mesh = AEResourceManager.getGeometryResource(800);
                mesh.setScaling(18000, 18000, 18000);
                return new SCPowerUp(mesh, tx, ty, tz, rx, ry, rz, 300, explosion, 1, tile);
            }
            case 2: {
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(806));
                explosion.getParticleSystem().setLayer(1);
                AEGeometry mesh = AEResourceManager.getGeometryResource(801);
                mesh.setScaling(18000, 18000, 18000);
                return new SCPowerUp(mesh, tx, ty, tz, rx, ry, rz, 300, explosion, 2, tile);
            }
            case 3: {
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(806));
                explosion.getParticleSystem().setLayer(1);
                AEGeometry mesh = AEResourceManager.getGeometryResource(803);
                mesh.setScaling(18000, 18000, 18000);
                return new SCPowerUp(mesh, tx, ty, tz, rx, ry, rz, 300, explosion, 3, tile);
            }
            case 4: {
                SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(806));
                explosion.getParticleSystem().setLayer(1);
                AEGeometry mesh = AEResourceManager.getGeometryResource(805);
                mesh.setScaling(18000, 18000, 18000);
                return new SCPowerUp(mesh, tx, ty, tz, rx, ry, rz, 300, explosion, 4, tile);
            }
        }
        return null;
    }

    public static void preCachePathEnemies(int current_level) {
        switch (current_level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
            case 4: {
                cache_path_enemy = new SCPathEnemy[1];
                break;
            }
            case 6: {
                cache_path_enemy = new SCPathEnemy[3];
                break;
            }
            case 7: {
                cache_path_enemy = new SCPathEnemy[3];
                break;
            }
            case 8: {
                cache_path_enemy = new SCPathEnemy[4];
                break;
            }
            default: {
                cache_path_enemy = new SCPathEnemy[2];
            }
        }
        block12: for (int i = 0; i < cache_path_enemy.length; ++i) {
            SCExplosion explosion = new SCExplosion(AEResourceManager.getGeometryResource(5000));
            explosion.getParticleSystem().setLayer(1);
            switch (i) {
                case 0: {
                    AEGeometry mesh = AEResourceManager.getGeometryResource(516);
                    mesh.setScaling(18000, 18000, 18000);
                    SCEnemyFactory.cache_path_enemy[i] = new SCPathEnemy(mesh, 1024, 700, 768, 1500, false, SCEnemyFactory.getWeapon(0), 100, 200, explosion, grh.r_score, grh.SCORE_POINTS.length - 1, true);
                    continue block12;
                }
                case 1: {
                    AEGeometry mesh = AEResourceManager.getGeometryResource(513);
                    mesh.setScaling(18000, 18000, 18000);
                    SCEnemyFactory.cache_path_enemy[i] = new SCPathEnemy(mesh, 1024, 700, 768, 1500, false, SCEnemyFactory.getWeapon(1), 100, 200, explosion, grh.r_score, grh.SCORE_POINTS.length - 1, true);
                    continue block12;
                }
                case 2: {
                    AEGeometry mesh = AEResourceManager.getGeometryResource(517);
                    mesh.setScaling(18000, 18000, 18000);
                    SCEnemyFactory.cache_path_enemy[i] = new SCPathEnemy(mesh, 1024, 700, 768, 4096, true, SCEnemyFactory.getWeapon(0), 100, 200, explosion, grh.r_score, grh.SCORE_POINTS.length - 1, true, 500, 1000, 10, 20, 1, 1);
                    continue block12;
                }
                default: {
                    AEGeometry mesh = AEResourceManager.getGeometryResource(513);
                    mesh.setScaling(18000, 18000, 18000);
                    SCEnemyFactory.cache_path_enemy[i] = new SCPathEnemy(mesh, 1024, 700, 768, 4096, true, SCEnemyFactory.getWeapon(1), 100, 200, explosion, grh.r_score, grh.SCORE_POINTS.length - 1, true, 500, 1000, 10, 20, 1, 1);
                }
            }
        }
    }

    public static int precachePointEnemies(int current_level) {
        if (current_level > 8) {
            switch (grh.getLevelType()) {
                case 0: {
                    switch (pointEnemyLoading) {
                        case 0: {
                            AEResourceManager.getGeometryResource(529);
                            ++pointEnemyLoading;
                            return 13;
                        }
                        case 1: {
                            AEResourceManager.getGeometryResource(530);
                            ++pointEnemyLoading;
                            return 12;
                        }
                        case 2: {
                            AEResourceManager.getGeometryResource(533);
                            ++pointEnemyLoading;
                            return 11;
                        }
                        case 3: {
                            AEResourceManager.getGeometryResource(534);
                            ++pointEnemyLoading;
                            return 10;
                        }
                        case 4: {
                            AEResourceManager.getGeometryResource(535);
                            ++pointEnemyLoading;
                            return 9;
                        }
                        case 5: {
                            AEResourceManager.getGeometryResource(515);
                            ++pointEnemyLoading;
                            return 8;
                        }
                        case 6: {
                            AEResourceManager.getGeometryResource(514);
                            ++pointEnemyLoading;
                            return 7;
                        }
                        case 7: {
                            AEResourceManager.getGeometryResource(518);
                            ++pointEnemyLoading;
                            return 6;
                        }
                        case 8: {
                            AEResourceManager.getGeometryResource(523);
                            ++pointEnemyLoading;
                            return 5;
                        }
                        case 9: {
                            AEResourceManager.getGeometryResource(524);
                            ++pointEnemyLoading;
                            return 4;
                        }
                        case 10: {
                            AEResourceManager.getGeometryResource(536);
                            ++pointEnemyLoading;
                            return 3;
                        }
                        case 11: {
                            AEResourceManager.getGeometryResource(537);
                            ++pointEnemyLoading;
                            return 2;
                        }
                        case 12: {
                            AEResourceManager.getGeometryResource(525);
                            ++pointEnemyLoading;
                            return 1;
                        }
                        case 13: {
                            AEResourceManager.getGeometryResource(526);
                            ++pointEnemyLoading;
                            return 0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (pointEnemyLoading) {
                        case 0: {
                            AEResourceManager.getGeometryResource(529);
                            ++pointEnemyLoading;
                            return 6;
                        }
                        case 1: {
                            AEResourceManager.getGeometryResource(530);
                            ++pointEnemyLoading;
                            return 5;
                        }
                        case 2: {
                            AEResourceManager.getGeometryResource(515);
                            ++pointEnemyLoading;
                            return 4;
                        }
                        case 3: {
                            AEResourceManager.getGeometryResource(514);
                            ++pointEnemyLoading;
                            return 3;
                        }
                        case 4: {
                            AEResourceManager.getGeometryResource(518);
                            ++pointEnemyLoading;
                            return 2;
                        }
                        case 5: {
                            AEResourceManager.getGeometryResource(525);
                            ++pointEnemyLoading;
                            return 1;
                        }
                        case 6: {
                            AEResourceManager.getGeometryResource(526);
                            ++pointEnemyLoading;
                            return 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (pointEnemyLoading) {
                        case 0: {
                            AEResourceManager.getGeometryResource(531);
                            ++pointEnemyLoading;
                            return 9;
                        }
                        case 1: {
                            AEResourceManager.getGeometryResource(532);
                            ++pointEnemyLoading;
                            return 8;
                        }
                        case 2: {
                            AEResourceManager.getGeometryResource(527);
                            ++pointEnemyLoading;
                            return 7;
                        }
                        case 3: {
                            AEResourceManager.getGeometryResource(528);
                            ++pointEnemyLoading;
                            return 6;
                        }
                        case 4: {
                            AEResourceManager.getGeometryResource(533);
                            ++pointEnemyLoading;
                            return 5;
                        }
                        case 5: {
                            AEResourceManager.getGeometryResource(534);
                            ++pointEnemyLoading;
                            return 4;
                        }
                        case 6: {
                            AEResourceManager.getGeometryResource(535);
                            ++pointEnemyLoading;
                            return 3;
                        }
                        case 7: {
                            AEResourceManager.getGeometryResource(515);
                            ++pointEnemyLoading;
                            return 2;
                        }
                        case 8: {
                            AEResourceManager.getGeometryResource(514);
                            ++pointEnemyLoading;
                            return 1;
                        }
                        case 9: {
                            AEResourceManager.getGeometryResource(518);
                            ++pointEnemyLoading;
                            return 0;
                        }
                    }
                }
            }
            return 0;
        }
        block52: for (int i = 0; i < grh.enemyProbability[current_level].length; i += 2) {
            if (grh.enemyProbability[current_level][i] <= 0 && grh.enemyProbability[current_level][i + 1] <= 0) continue;
            switch (i >> 1) {
                case 0: {
                    AEResourceManager.getGeometryResource(531);
                    AEResourceManager.getGeometryResource(532);
                    AEResourceManager.getGeometryResource(527);
                    AEResourceManager.getGeometryResource(528);
                    continue block52;
                }
                case 1: {
                    AEResourceManager.getGeometryResource(529);
                    AEResourceManager.getGeometryResource(530);
                    continue block52;
                }
                case 2: {
                    AEResourceManager.getGeometryResource(533);
                    AEResourceManager.getGeometryResource(534);
                    AEResourceManager.getGeometryResource(535);
                    continue block52;
                }
                case 3: {
                    AEResourceManager.getGeometryResource(515);
                    AEResourceManager.getGeometryResource(514);
                    AEResourceManager.getGeometryResource(518);
                    continue block52;
                }
                case 4: {
                    AEResourceManager.getGeometryResource(523);
                    AEResourceManager.getGeometryResource(524);
                    continue block52;
                }
                case 5: {
                    AEResourceManager.getGeometryResource(536);
                    AEResourceManager.getGeometryResource(537);
                    continue block52;
                }
                case 6: {
                    continue block52;
                }
                case 7: {
                    AEResourceManager.getGeometryResource(525);
                    AEResourceManager.getGeometryResource(526);
                }
            }
        }
        return 0;
    }

    public static void getPathEnemy(int current_level) {
        if (cache_path_enemy == null) {
            return;
        }
        if (SCLevel.getCurrentTile() > 25L && grh.r_level < 9) {
            return;
        }
        int id = rndm.nextInt(cache_path_enemy.length);
        for (int i = 0; i < cache_path_enemy.length; ++i) {
            if (!cache_path_enemy[id].isUsed()) {
                ++grh.total_enemies;
                cache_path_enemy[id].reinit(0, 0, 0, 0, 0, 0, null, 0L);
                return;
            }
            id = id - 1 < 0 ? cache_path_enemy.length - 1 : id - 1;
        }
    }

    public static void clearCache() {
        int i;
        cache_id = null;
        for (i = 0; cache_enemy != null && i < cache_enemy.length; ++i) {
            cache_enemy[i].release();
            SCEnemyFactory.cache_enemy[i] = null;
        }
        cache_enemy = null;
        for (i = 0; cache_path_enemy != null && i < cache_path_enemy.length; ++i) {
            cache_path_enemy[i].release();
            SCEnemyFactory.cache_path_enemy[i] = null;
        }
        cache_path_enemy = null;
        rndm.setSeed(0L);
        pointEnemyLoading = 0;
    }
}

