/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike.menu;

import AppKit.AEMenuScrollBox;
import contentHeliStrike.GameText;
import contentHeliStrike.grh;
import contentHeliStrike.menu.StaticImages;

public class TextBox
extends AEMenuScrollBox {
    private static final int MARGIN = 5;
    private static final int DOUBLE_MARGIN = 10;
    private static final int EDGE = 4;
    private String[] lines;
    private int textId;
    private int current_cursor;
    private int current_row;
    private int c_height;
    private int scroll;
    private int target_scroll;
    public boolean drawBackground;
    private long type_delay;
    private static final long TYPE_DELAY = 10L;

    public TextBox(int x, int y, int w, int h, String text) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.setText(text);
        this.drawBackground = true;
        this.textId = -1;
    }

    public TextBox(int x, int y, int w, int h, int textId) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.textId = textId;
        this.drawBackground = true;
    }

    public TextBox(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.drawBackground = true;
        this.textId = -1;
    }

    public void setText(String text) {
        this.textId = -1;
        this.lines = TextBox.getLines(text, this.w - 10);
    }

    public void setText(int textId) {
        this.textId = textId;
    }

    public void scrollUp() {
        if (this.target_scroll > 0) {
            this.target_scroll -= grh.r_font.getHeight();
        }
    }

    public void scrollDown() {
        if (this.target_scroll < this.c_height - this.h) {
            this.target_scroll += grh.r_font.getHeight();
        }
    }

    public static String[] getLines(String text, int w) {
        int lineEnd;
        int lineCount = 0;
        int lastSpace = 0;
        int stringWidth = 0;
        int lineStart = 0;
        for (lineEnd = 0; lineEnd < text.length(); ++lineEnd) {
            while (lineEnd < text.length() - 1 && text.charAt(lineEnd) == '\n') {
                stringWidth = 0;
                ++lineCount;
                lineStart = ++lineEnd;
            }
            if (text.charAt(lineEnd) == ' ') {
                lastSpace = lineEnd;
            }
            if ((stringWidth += grh.r_font.stringWidth(text.substring(lineEnd, lineEnd + 1))) < w - 5) continue;
            ++lineCount;
            stringWidth = 0;
            if (lineStart > lastSpace) {
                lineStart = lineEnd;
                continue;
            }
            lineEnd = lineStart = lastSpace + 1;
        }
        if (lineStart < text.length()) {
            ++lineCount;
        }
        String[] result = new String[lineCount];
        lineCount = 0;
        lastSpace = 0;
        stringWidth = 0;
        lineStart = 0;
        for (lineEnd = 0; lineEnd < text.length(); ++lineEnd) {
            if (text.charAt(lineEnd) == '\n' && lineStart < lineEnd) {
                result[lineCount] = text.substring(lineStart, lineEnd);
            }
            while (lineEnd < text.length() - 1 && text.charAt(lineEnd) == '\n') {
                stringWidth = 0;
                lineStart = ++lineEnd;
                result[++lineCount] = "";
            }
            if (text.charAt(lineEnd) == ' ') {
                lastSpace = lineEnd;
            }
            if ((stringWidth += grh.r_font.stringWidth(text.substring(lineEnd, lineEnd + 1))) < w - 5) continue;
            stringWidth = 0;
            if (lineStart > lastSpace) {
                result[lineCount] = text.substring(lineStart, lineEnd);
                lineStart = lineEnd;
            } else {
                result[lineCount] = text.substring(lineStart, lastSpace + 1);
                lineEnd = lineStart = lastSpace + 1;
            }
            ++lineCount;
        }
        if (lineStart < text.length()) {
            result[lineCount] = text.substring(lineStart, text.length());
        }
        return result;
    }

    public void draw() {
        if (this.drawBackground) {
            int x1 = this.x;
            int y1 = this.y;
            int x2 = this.w + this.x;
            int y2 = (this.c_height < this.h ? this.c_height : this.h) + this.y;
            grh.r_g.drawRegion(StaticImages.back, 0, 0, x2 - x1 - 2, y2 - y1, 0, x1 + 1, y1 + 1, 0);
            grh.r_g.setColor(-12287);
            grh.r_g.drawLine(x1 + 4, y1, x2, y1);
            grh.r_g.drawLine(x1, y2, x2 - 4, y2);
            grh.r_g.drawLine(x1, y1 + 4, x1, y2);
            grh.r_g.drawLine(x2, y1, x2, y2 - 4);
            grh.r_g.drawLine(x1, y1 + 4, x1 + 4, y1);
            grh.r_g.drawLine(x2 - 4, y2, x2, y2 - 4);
            grh.r_g.drawLine(x1 - 1, y1 + 4, x1 + 4, y1 - 1);
            grh.r_g.drawLine(x1 - 1, y1 + 4, x1 - 1, y1 + 4 + (this.c_height >> 1));
            grh.r_g.drawLine(x1 + 4, y1 - 1, x1 + 4 + (this.w >> 2), y1 - 1);
            grh.r_g.drawLine(x2 - 4, y2 + 1, x2 + 1, y2 - 4);
            grh.r_g.drawLine(x2 - 4, y2 + 1, x2 - 4 - (this.w >> 2), y2 + 1);
            grh.r_g.drawLine(x2 + 1, y2 - 4, x2 + 1, y2 - 4 - (this.c_height >> 1));
            if (this.target_scroll > 0 || this.target_scroll < this.c_height - this.h) {
                grh.r_g.drawImage(StaticImages.scroll_arrows, x2 - StaticImages.scroll_arrows.getWidth() - 2, y2 - StaticImages.scroll_arrows.getHeight() - 2, 0);
            }
        } else {
            grh.r_g.setColor(-12287);
        }
        if (this.lines == null || this.lines.length == 0) {
            return;
        }
        int font_height = grh.r_font.getHeight();
        this.c_height = font_height + 10;
        int cx = this.x + 5;
        if (this.scroll < this.target_scroll) {
            this.scroll += StaticImages.elapsed_time >> 4;
            if (this.scroll > this.target_scroll) {
                this.scroll = this.target_scroll;
            }
        }
        if (this.scroll > this.target_scroll) {
            this.scroll -= StaticImages.elapsed_time >> 4;
            if (this.scroll < this.target_scroll) {
                this.scroll = this.target_scroll;
            }
        }
        int cy = this.y + 5 - this.scroll;
        boolean current_start = false;
        boolean last_space = false;
        grh.r_g.setClip(this.x, this.y, this.w, this.h);
        for (int i = 0; i < this.current_row; ++i) {
            grh.r_g.drawString(this.lines[i], cx, cy - grh.FONT_CORRECT_Y, 0);
            cy += font_height;
            this.c_height += font_height;
        }
        grh.r_g.drawString(this.lines[this.current_row].substring(0, this.current_cursor), cx, cy - grh.FONT_CORRECT_Y, 0);
        if (this.current_cursor >= this.lines[this.current_row].length()) {
            if (this.current_row < this.lines.length - 1) {
                this.current_cursor = 0;
                ++this.current_row;
            } else {
                this.current_cursor = this.lines[this.current_row].length();
            }
            this.type_delay = 0L;
        } else {
            this.type_delay += (long)StaticImages.elapsed_time;
            this.current_cursor = (int)(this.type_delay / 10L);
            this.current_cursor = this.current_cursor > this.lines[this.current_row].length() ? this.lines[this.current_row].length() : this.current_cursor;
        }
        grh.r_g.setClip(0, 0, grh.r_w, grh.r_h);
    }

    public void init() {
        if (this.textId != -1) {
            this.setText(GameText.getText(this.textId));
        }
        if (this.lines != null) {
            this.current_cursor = 0;
            this.current_row = 0;
        }
        this.type_delay = 0L;
        this.target_scroll = 0;
        this.scroll = 0;
        this.c_height = 0;
    }

    public boolean fadeIn() {
        return this.lines == null || this.current_row == this.lines.length - 1 && this.current_cursor == this.lines[this.lines.length - 1].length();
    }

    public boolean fadeOut() {
        return true;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setH(int h) {
        this.h = h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public void forceFadeIn() {
        if (this.lines != null) {
            this.current_row = this.lines.length - 1;
            this.current_cursor = this.lines[this.lines.length - 1].length();
        }
    }

    public int getScrolling() {
        return this.scroll;
    }
}

