/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.game;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Storage {
    static Storage instance;
    private Hashtable mHashtable;

    public Storage() {
        instance = this;
        this.mHashtable = new Hashtable();
        this.load();
    }

    public String get(String key) {
        return (String)this.mHashtable.get(key);
    }

    public void put(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.mHashtable.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        RecordStore rs = null;
        RecordEnumeration re = null;
        try {
            rs = RecordStore.openRecordStore((String)"recordStore", (boolean)true);
            re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                byte[] raw = re.nextRecord();
                String pref = new String(raw);
                int index = pref.indexOf(124);
                String name = pref.substring(0, index);
                String value = pref.substring(index + 1);
                this.put(name, value);
            }
        }
        catch (Exception e2) {
        }
        finally {
            if (re != null) {
                re.destroy();
            }
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e3) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        RecordStore rs = null;
        RecordEnumeration re = null;
        try {
            rs = RecordStore.openRecordStore((String)"recordStore", (boolean)true);
            re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                rs.deleteRecord(id);
            }
            Enumeration keys = this.mHashtable.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = this.get(key);
                String pref = key + "|" + value;
                byte[] raw = pref.getBytes();
                rs.addRecord(raw, 0, raw.length);
            }
        }
        catch (Exception e2) {
        }
        finally {
            if (re != null) {
                re.destroy();
            }
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e3) {}
            }
        }
    }

    public static void saveData(String key, String value) {
        instance.put(key, value);
        instance.save();
    }

    public static String readData(String key) {
        return instance.get(key);
    }
}

