/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.PlatformService;
import com.renderedideas.superbike3d.Sprite3D;
import com.renderedideas.superbike3d.Sprite3DManager;
import com.renderedideas.superbike3d.Ted;
import com.renderedideas.superbike3d.Utility3D;
import com.renderedideas.superbike3d.models.Model;

public class CopCar
extends Sprite3D {
    final int CHANGELANE_STATE;
    final int ACCELERATE_STATE;
    final int WAIT_STATE;
    final int SPAWN_STATE;
    int currentState2 = 4;
    int nextCurrentState2 = 1;
    float distance;
    int waitForTime;
    long spawnTime;
    int timeToLive;

    CopCar(Model model, int textureIndex, float velocity, int id, int lane, int tp) {
        super(model, textureIndex, velocity, id, lane, tp);
        this.CHANGELANE_STATE = 1;
        this.ACCELERATE_STATE = 2;
        this.WAIT_STATE = 3;
        this.SPAWN_STATE = 4;
        float distance = 0.0f;
        this.waitForTime = 0;
        this.spawnTime = PlatformService.currentTimeMillis();
        this.timeToLive = (5 + PlatformService.nextInt(10)) * 1000;
    }

    boolean update() {
        this.updateFrame();
        if (PlatformService.currentTimeMillis() - this.spawnTime > (long)this.timeToLive) {
            Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, 0.05f);
            this.currentState2 = 1;
            if (Utility3D.getPositionZ(this.transform3d) > Ted.mccc.getCameraZ()) {
                return true;
            }
        }
        Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, Ted.playerSpeed * Ted.deltaTime);
        float frontVehicleSpeed = Ted.sprite3dManager.isVehicleInFront(this, 0.7f);
        if (frontVehicleSpeed != -1.0f) {
            if (this.currentState2 != 1) {
                for (int selectedLaneToMove = 1; selectedLaneToMove <= 4; ++selectedLaneToMove) {
                    if (selectedLaneToMove == this.currentLane || Ted.sprite3dManager.isVehicleAlreadyOnLane(selectedLaneToMove, this) || Math.abs(selectedLaneToMove - this.currentLane) != 1) continue;
                    this.currentState2 = 1;
                    this.turnStarted = 0L;
                    this.totalMoved = 0.0f;
                    this.distance = 0.0f;
                    this.moveToLane = selectedLaneToMove;
                    break;
                }
            }
            if (this.currentState2 != 1) {
                Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, -Ted.playerSpeed * Ted.deltaTime);
                Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, -frontVehicleSpeed * Ted.deltaTime);
            }
        }
        switch (this.currentState2) {
            case 1: {
                if (!this.isRotated) {
                    if (this.moveToLane > this.currentLane) {
                        Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, -5.0f, 0.0f);
                    } else {
                        Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, 5.0f, 0.0f);
                    }
                    this.isRotated = true;
                }
                float move = (float)(this.moveToLane - this.currentLane) * 0.06f;
                Utility3D.postTranslateAboutGlobalAxis(this.transform3d, move * Ted.deltaTime, 0.0f, 0.0f);
                this.totalMoved += move * Ted.deltaTime;
                if (!(Math.abs(this.totalMoved) > 1.0f)) break;
                if (this.moveToLane > this.currentLane) {
                    Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, 5.0f, 0.0f);
                } else {
                    Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, -5.0f, 0.0f);
                }
                this.isRotated = false;
                this.currentLane = this.moveToLane;
                this.currentState2 = 3;
                this.nextCurrentState2 = 2;
                this.waitForTime = PlatformService.nextInt(30);
                break;
            }
            case 2: {
                if (this.distance > 0.0f) {
                    Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, 0.07f);
                    this.distance += 0.07f;
                    if (!(this.distance > 1.7f)) break;
                    this.distance = 0.0f;
                    this.currentState2 = 3;
                    this.nextCurrentState2 = 2;
                    this.waitForTime = 20 + PlatformService.nextInt(20);
                    this.isCollisionEnabled = true;
                    this.forceCount = 0;
                    break;
                }
                if (this.distance != 0.0f || Math.abs(Utility3D.getPositionX(this.transform3d) - Utility3D.getPositionX(Ted.playerSprite3d.transform3d)) < 0.4f) {
                    Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, -0.07f);
                    this.distance += -0.07f;
                    if (!(this.distance <= -0.9f)) break;
                    this.distance = 0.9f;
                    break;
                }
                int selectedLaneToMove = this.currentLane;
                if (Utility3D.getPositionX(this.transform3d) - Utility3D.getPositionX(Ted.playerSprite3d.transform3d) > 0.5f) {
                    selectedLaneToMove = this.currentLane - 1;
                } else if (Utility3D.getPositionX(this.transform3d) - Utility3D.getPositionX(Ted.playerSprite3d.transform3d) < -0.5f) {
                    selectedLaneToMove = this.currentLane + 1;
                }
                if (this.currentLane == selectedLaneToMove) break;
                if (!Ted.sprite3dManager.isVehicleAlreadyOnLane(selectedLaneToMove = this.currentLane - (this.currentLane - selectedLaneToMove) / Math.abs(this.currentLane - selectedLaneToMove), this)) {
                    this.currentState2 = 1;
                    this.totalMoved = 0.0f;
                    this.distance = 0.0f;
                    this.moveToLane = selectedLaneToMove;
                    break;
                }
                this.currentState2 = 3;
                this.nextCurrentState2 = 2;
                this.waitForTime = PlatformService.nextInt(30);
                break;
            }
            case 3: {
                --this.waitForTime;
                if (this.waitForTime > 0) break;
                this.currentState2 = this.nextCurrentState2;
                break;
            }
            case 4: {
                Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, -0.1f);
                if (!(Utility3D.getPositionZ(this.transform3d) < Ted.mccc.getCameraZ() - 3.0f)) break;
                this.currentState2 = 3;
                this.nextCurrentState2 = 2;
                this.waitForTime = 50;
            }
        }
        return false;
    }

    public void updateFrame() {
        if (PlatformService.currentTimeMillis() - this.lastFrameUpdate > 200L) {
            ++this.currentFrame;
            if (this.currentFrame > 1) {
                this.currentFrame = 0;
            }
            this.lastFrameUpdate = PlatformService.currentTimeMillis();
            if (this.currentFrame == 1) {
                this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 8, 3, Sprite3DManager.redLight);
                this.currentFrame = 0;
                this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 8, 3, Sprite3DManager.blueLight_off);
                this.currentFrame = 1;
            } else {
                this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 8, 3, Sprite3DManager.blueLight);
                this.currentFrame = 1;
                this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 8, 3, Sprite3DManager.redLight_off);
                this.currentFrame = 0;
            }
        }
    }

    public int getX() {
        if (this.currentFrame == 1) {
            return 45;
        }
        return 27;
    }
}

