/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.AdManager;
import com.renderedideas.game.Bitmap;
import com.renderedideas.game.GameMIDlet;
import com.renderedideas.game.PlatformService;
import com.renderedideas.game.PrintConsole;
import com.renderedideas.game.Sound;
import com.renderedideas.game.Storage;
import com.renderedideas.superbike3d.FontsBig;
import com.renderedideas.superbike3d.HouseAdCanvas;
import com.renderedideas.superbike3d.MenuCanvas;
import com.renderedideas.superbike3d.MyCanvas;
import com.renderedideas.superbike3d.MyFont;
import com.renderedideas.superbike3d.ScoreCanvas;
import com.renderedideas.superbike3d.SplashCanvas;
import com.renderedideas.superbike3d.SuperCanvas;
import com.renderedideas.superbike3d.Ted;
import javax.microedition.lcdui.Graphics;

public class Game {
    public static Game instance;
    static double xValue;
    static double yValue;
    static double zValue;
    static double minValue;
    static double maxValue;
    public static boolean accelerometerSupported;
    public static boolean accelerometerStarted;
    static int volume;
    static int unlockedLevels;
    static int startLevel;
    static int topScore;
    public static String topName;
    static int width;
    static int height;
    public boolean isLoadingScreen;
    public boolean slowDevice;
    int slowDeviceFpsSamples;
    int slowDeviceFpsSamples2;
    int maxPlayers = 3;
    boolean soundMixing = false;
    public static int loadingCounter;
    public static String[] tips;
    public static int currentTip;
    public static int totalCoins;
    public static int itemSelected;
    public static boolean item1Purchased;
    public static boolean item2Purchased;
    public static boolean item3Purchased;
    static boolean isIAPSupported;
    boolean removeAds = false;
    SuperCanvas splashCanvas;
    SuperCanvas menuCanvas;
    SuperCanvas myCanvas;
    SuperCanvas scoreCanvas;
    SuperCanvas houseAdCanvas;
    static SuperCanvas currentCanvas;
    Sound selectSound;
    Bitmap loadingBitmap;
    public static String startVehicle;

    public Game() {
        instance = this;
        volume = 100;
        unlockedLevels = 1;
        topScore = 0;
        topName = "Player";
        this.isLoadingScreen = false;
        zValue = 0.0;
        yValue = 0.0;
        xValue = 0.0;
        this.slowDeviceFpsSamples = 0;
        this.slowDeviceFpsSamples2 = 0;
        loadingCounter = 0;
        currentTip = 0;
        totalCoins = 0;
        item3Purchased = false;
        item2Purchased = false;
        item1Purchased = false;
    }

    public void loadContent() {
        PlatformService.setFPS(25);
        PlatformService.setBgFPS(25);
        width = PlatformService.getWidth();
        height = PlatformService.getHeight();
        if (Storage.readData("volume") == null) {
            Storage.saveData("volume", volume + "");
            Storage.saveData("unlockedLevels", unlockedLevels + "");
            Storage.saveData("topName", topName + "");
            Storage.saveData("topScore", topScore + "");
            Storage.saveData("slowDevice", "false");
            Storage.saveData("totalCoins", totalCoins + "");
            Storage.saveData("item1Purchased", item1Purchased + "");
            Storage.saveData("item2Purchased", item2Purchased + "");
            Storage.saveData("item3Purchased", item3Purchased + "");
            Storage.saveData("startingHealth", "100");
        }
        unlockedLevels = Integer.parseInt(Storage.readData("unlockedLevels"));
        topName = Storage.readData("topName");
        topScore = Integer.parseInt(Storage.readData("topScore"));
        this.slowDevice = Storage.readData("slowDevice").equals("true");
        totalCoins = Integer.parseInt(Storage.readData("totalCoins"));
        item1Purchased = Storage.readData("item1Purchased").equals("true");
        item2Purchased = Storage.readData("item2Purchased").equals("true");
        item3Purchased = Storage.readData("item3Purchased").equals("true");
        isIAPSupported = false;
        String platform = System.getProperty("microedition.platform");
        if (platform == null) {
            isIAPSupported = false;
        } else if (platform.toLowerCase().indexOf("nokia") == -1) {
            isIAPSupported = false;
        } else if (platform.toLowerCase().indexOf("s60") != -1) {
            isIAPSupported = false;
        }
        if (GameMIDlet.instance.iapProvider == null) {
            isIAPSupported = false;
        }
        this.maxPlayers = Sound.maxPrefetchedPlayers();
        String mixing = System.getProperty("supports.mixing");
        this.soundMixing = mixing != null ? mixing.trim().toLowerCase().equals("true") : false;
        if (this.maxPlayers >= 6 && this.soundMixing) {
            this.selectSound = new Sound(100, "/audio/click", 1);
        }
        new MyFont();
        new FontsBig();
        currentCanvas = this.splashCanvas = new SplashCanvas(instance);
        accelerometerSupported = PlatformService.isAccelerometerAvailable();
    }

    public void unloadContent() {
    }

    public void update(float deltaTime) {
        if (currentCanvas != null) {
            currentCanvas.update(1.0f);
        } else {
            PrintConsole.print("Game.update:->currentCanvas null");
        }
    }

    public void paint(Graphics graphics) {
        if (this.isLoadingScreen) {
            if (this.loadingBitmap == null) {
                this.loadingBitmap = accelerometerSupported ? new Bitmap("help") : new Bitmap("help_keys");
            }
            Bitmap.drawBitmap(graphics, this.loadingBitmap, 0, 0);
            int loadingBarWidth = width * 2 / 3;
            int loadingBarHeight = height / 50;
            Bitmap.fillColor(graphics, width / 2 - loadingBarWidth / 2, height - height / 8 - loadingBarHeight, loadingBarWidth, loadingBarHeight, 211, 52, 39);
            Bitmap.fillColor(graphics, width / 2 - loadingBarWidth / 2 + 1, height - height / 8 - loadingBarHeight + 1, (loadingBarWidth - 2) * loadingCounter / 100, loadingBarHeight - 2, 251, 214, 11);
            if (MyFont.stringWidth(tips[currentTip]) > width) {
                int index = tips[currentTip].length();
                while (MyFont.stringWidth(tips[currentTip].substring(0, index = tips[currentTip].lastIndexOf(32, index))) >= width) {
                    --index;
                }
                MyFont.drawString(tips[currentTip].substring(0, index), graphics, width * 2 / 100, height - height / 8 + loadingBarHeight);
                MyFont.drawString(tips[currentTip].substring(index + 1, tips[currentTip].length()), graphics, width * 2 / 100, height - height / 8 + loadingBarHeight + MyFont.stringHeight() * 5 / 4);
            } else {
                MyFont.drawString(tips[currentTip], graphics, width * 2 / 100, height - height / 10 + loadingBarHeight);
            }
        } else if (currentCanvas != null) {
            currentCanvas.paint(graphics);
        } else {
            PrintConsole.print("Game.paint:->currentCanvas null");
        }
    }

    public void pointerPressed(int xx, int yy) {
        if (currentCanvas != null) {
            currentCanvas.pointerPressed(xx, yy);
        } else {
            PrintConsole.print("Game.pointerPressed:->currentCanvas null");
        }
    }

    public void pointerReleased(int xx, int yy) {
        if (currentCanvas != null) {
            currentCanvas.pointerReleased(xx, yy);
        } else {
            PrintConsole.print("Game.pointerReleased:->currentCanvas null");
        }
    }

    public void pointerDragged(int xx, int yy) {
        if (currentCanvas != null) {
            currentCanvas.pointerDragged(xx, yy);
        } else {
            PrintConsole.print("Game.pointerDragged:->currentCanvas null");
        }
    }

    public void keyPressed(int key) {
        if (currentCanvas != null) {
            currentCanvas.keyPressed(key);
        } else {
            PrintConsole.print("Game.keyPressed:->currentCanvas null");
        }
    }

    public void keyReleased(int key) {
        if (currentCanvas != null) {
            currentCanvas.keyReleased(key);
        } else {
            PrintConsole.print("Game.keyReleased:->currentCanvas null");
        }
    }

    public void keyRepeated(int key) {
        if (currentCanvas != null) {
            currentCanvas.keyRepeated(key);
        } else {
            PrintConsole.print("Game.keyRepeated:->currentCanvas null");
        }
    }

    public void pause() {
        if (currentCanvas != null) {
            currentCanvas.pause();
        } else {
            PrintConsole.print("Game.pause:->currentCanvas null");
        }
    }

    public void resume() {
        if (currentCanvas != null) {
            currentCanvas.resume();
        } else {
            PrintConsole.print("Game.resume:->currentCanvas null");
        }
    }

    public void onBackKey() {
        if (currentCanvas != null) {
            currentCanvas.onBackKey();
        } else {
            PrintConsole.print("Game.onBackKey:->currentCanvas null");
        }
    }

    public void accelerometerData(double x, double y, double z, double min, double max) {
        xValue = x;
        yValue = y;
        zValue = z;
        minValue = min;
        maxValue = max;
    }

    public void handleSwipe(int direction) {
        if (currentCanvas != null) {
            currentCanvas.handleSwipe(direction);
        } else {
            PrintConsole.print("Game.handleSwipe:->currentCanvas null");
        }
    }

    public void userInputReceived(String input) {
        if (input.trim().equals("")) {
            return;
        }
        topName = input;
        topName = topName.replace('|', ' ');
        topName = topName.trim();
        Storage.saveData("topName", topName);
        topScore = (int)Ted.playerScore;
        Storage.saveData("topScore", String.valueOf(topScore));
    }

    public void postScoreToFacebook(int score) {
        PlatformService.openURL("http://renderedideas.com/fbPost/bike3d_score_feed.php?id=de993nla9ndcnadlid&value=" + score + "&user=dnz9ndo4924ddali");
    }

    public void exit() {
        if (AdManager.houseAdLoaded && !AdManager.houseAdURL.equals("noAd")) {
            currentCanvas = this.houseAdCanvas = new HouseAdCanvas(instance);
            this.menuCanvas.deallocate();
            this.menuCanvas = null;
        } else {
            PlatformService.exit();
        }
    }

    public void playSelectSound() {
        if (volume != 0 && this.selectSound != null) {
            this.selectSound.play();
        }
    }

    public void actualDeviceFps(int percent) {
    }

    public void messageBoxComplete() {
        if (itemSelected == -1) {
            return;
        }
        this.slowDevice = true;
        Storage.saveData("slowDevice", "true");
        this.restart();
    }

    public void setMenu_splash(boolean enableSounds) {
        if (!enableSounds) {
            volume = 0;
            Storage.saveData("volume", volume + "");
        }
        currentCanvas = this.menuCanvas = new MenuCanvas(instance);
        this.splashCanvas.deallocate();
        this.splashCanvas = null;
        PlatformService.downloadHouseAd();
    }

    public void play() {
        this.myCanvas = new MyCanvas(instance);
        if (accelerometerSupported && !accelerometerStarted) {
            PlatformService.startAccelerometer();
            accelerometerStarted = true;
        }
        PlatformService.preventScreenSleep();
        currentCanvas = this.myCanvas;
        this.menuCanvas.deallocate();
        this.menuCanvas = null;
        PlatformService.downloadAd();
    }

    public void setScore() {
        currentCanvas = this.scoreCanvas = new ScoreCanvas(instance);
        this.menuCanvas.deallocate();
        this.menuCanvas = null;
    }

    void backToMenu() {
        currentCanvas = null;
        this.myCanvas.deallocate();
        this.myCanvas = null;
        PlatformService.allowScreenSleep();
        currentCanvas = this.menuCanvas = new MenuCanvas(instance);
        PlatformService.showAd();
    }

    void restart() {
        currentCanvas = null;
        this.myCanvas.deallocate();
        this.myCanvas = null;
        this.myCanvas = new MyCanvas(instance);
        if (accelerometerSupported && !accelerometerStarted) {
            PlatformService.startAccelerometer();
            accelerometerStarted = true;
        }
        currentCanvas = this.myCanvas;
    }

    void setMain_score() {
        currentCanvas = this.myCanvas != null ? this.myCanvas : (this.menuCanvas = new MenuCanvas(instance));
        this.scoreCanvas.deallocate();
        this.scoreCanvas = null;
    }

    void setScore_canvas() {
        currentCanvas = this.scoreCanvas = new ScoreCanvas(instance);
    }

    void openIAPStore() {
        this.pause();
        Storage.saveData("totalCoins", totalCoins + "");
        PlatformService.showStore();
    }

    static void buyItem(int itemNumber) {
        if (Game.getCost(itemNumber) > totalCoins) {
            itemSelected = -1;
            if (isIAPSupported) {
                PlatformService.showYesNoDialog("Not enough coins", "You don't have enough coins to buy this item. Do you want to buy more coins?");
            } else {
                PlatformService.showMessageBox("Not enough coins", "You don't have enough coins. Please collect more coins to buy this item.");
            }
            return;
        }
        itemSelected = itemNumber;
        PlatformService.showYesNoDialog("Buy?", "Do you want to buy this item for " + Game.getCost(itemNumber) + "?");
    }

    static int getCost(int itemNumber) {
        switch (itemNumber) {
            case 1: {
                return 2000;
            }
            case 2: {
                return 8000;
            }
            case 3: {
                return 15000;
            }
            case 4: {
                return 5000;
            }
        }
        return 0;
    }

    public void positiveUserSelection() {
        if (this.removeAds) {
            PlatformService.buyGame();
            return;
        }
        if (itemSelected == -1) {
            this.openIAPStore();
        } else {
            Storage.saveData("totalCoins", (totalCoins -= Game.getCost(itemSelected)) + "");
            switch (itemSelected) {
                case 1: {
                    item1Purchased = true;
                    Storage.saveData("item1Purchased", "true");
                    if (this.menuCanvas == null) break;
                    this.menuCanvas.keyPressed(114);
                    break;
                }
                case 2: {
                    item2Purchased = true;
                    Storage.saveData("item2Purchased", "true");
                    if (this.menuCanvas == null) break;
                    this.menuCanvas.keyPressed(114);
                    break;
                }
                case 3: {
                    item3Purchased = true;
                    Storage.saveData("item3Purchased", "true");
                    if (this.menuCanvas == null) break;
                    this.menuCanvas.keyPressed(114);
                    break;
                }
                case 4: {
                    itemSelected = -1;
                    Storage.saveData("startingHealth", Integer.parseInt(Storage.readData("startingHealth")) + 50 + "");
                    if (this.menuCanvas == null) break;
                    this.menuCanvas.keyPressed(114);
                }
            }
        }
    }

    static {
        minValue = -20.0;
        maxValue = 20.0;
        accelerometerSupported = false;
        accelerometerStarted = false;
        tips = new String[]{"Tip: Use nitrous to break road blocks", "Tip: Swipe up for nitrous boost", "Tip: Hitting other vehicles will damage your car", "Tip: Collect coins for exciting stuff", "Tip: Your nitrous fills up automatically", "Tip: Rate this game 5 stars for more cool games", "Like us on facebook: facebook.com/RenderedIdeas", "Tip: Use nitrous carefully", "Tip: Keep changing lanes to evade cops", "Tip: Collect magnets to attract coins", "Tip: Watch out for cops. They will hit you."};
        isIAPSupported = false;
        startVehicle = "taxi";
    }
}

