/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PlatformService;
import com.renderedideas.game.PrintConsole;
import com.renderedideas.game.Storage;
import com.renderedideas.superbike3d.Constant;
import com.renderedideas.superbike3d.FontsBig;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.Map;
import com.renderedideas.superbike3d.Message;
import com.renderedideas.superbike3d.MyFont;
import com.renderedideas.superbike3d.SoundManager;
import com.renderedideas.superbike3d.Sprite3DManager;
import com.renderedideas.superbike3d.SuperCanvas;
import com.renderedideas.superbike3d.Ted;
import com.renderedideas.superbike3d.Utility3D;
import com.renderedideas.superbike3d.models.PlayerBikeModel;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Transform;

public class MyCanvas
extends SuperCanvas {
    public static Game game;
    public int currentScreen;
    public int previousScreen;
    public static final int WEAK_RENDERING_HINTS = 0;
    public static final int STRONG_RENDERING_HINTS = 14;
    public int renderingHints;
    Graphics3D g3d = null;
    Background back = null;
    Background[] backgrounds;
    int backIndex;
    long lastChangeTime = 0L;
    Camera cam = null;
    Transform trCam = new Transform();
    Light light;
    boolean running;
    boolean isRestart;
    String message;
    static Ted mr;
    Bitmap pauseIcon;
    int selector = 1;
    boolean drawBlack = true;
    Bitmap firstAidBitmap;
    Bitmap coinBitmap;

    MyCanvas(Game g) {
        game = g;
        this.loadCamera();
        this.loadBackground();
        this.setUp();
        this.light = new Light();
        this.light.setMode(128);
        this.light.setColor(0xFFFFFF);
        this.light.setIntensity(10.0f);
        this.g3d.addLight(this.light, null);
        mr = new Ted(game, this);
        this.isRestart = false;
        this.running = true;
        this.pauseIcon = new Bitmap("/pause.png");
        this.firstAidBitmap = new Bitmap("/aid_icon.png");
        this.coinBitmap = new Bitmap("/coinIcon.png");
        this.backIndex = 0;
        this.renderingHints = 14;
        if (MyCanvas.game.slowDevice) {
            this.renderingHints = 0;
        }
        this.currentScreen = 403;
    }

    public void update(float deltaTime) {
        if (this.currentScreen == 401) {
            if (mr != null) {
                mr.GameCycle(deltaTime);
                mr.HandleKeys(deltaTime);
            }
        } else if (this.currentScreen == 405) {
            mr.updateDead(deltaTime);
        } else if (this.currentScreen == 406) {
            mr.updateDead(deltaTime);
        } else if (this.currentScreen == 403) {
            if (!MyCanvas.game.isLoadingScreen) {
                MyCanvas.game.isLoadingScreen = true;
                Game.loadingCounter = 0;
                Game.currentTip = PlatformService.nextInt(Game.tips.length);
                return;
            }
            if (!this.isRestart) {
                this.gamestart();
                PlatformService.enableGestures();
                MyCanvas.game.isLoadingScreen = false;
                MyCanvas.game.loadingBitmap = null;
                this.currentScreen = 401;
                SoundManager.play(Constant.BACKGROUNDMUSIC_SOUND);
                this.drawBlack = true;
                Game.loadingCounter = 100;
            } else {
                long before = PlatformService.currentTimeMillis();
                mr.restartLevel();
                if (PlatformService.currentTimeMillis() - before < 2000L) {
                    PlatformService.sleepThread(2000 - (int)(PlatformService.currentTimeMillis() - before));
                }
                MyCanvas.game.isLoadingScreen = false;
                MyCanvas.game.loadingBitmap = null;
                this.currentScreen = 401;
                SoundManager.play(Constant.BACKGROUNDMUSIC_SOUND);
                this.drawBlack = true;
                this.isRestart = false;
            }
        } else if (this.currentScreen != 404 && this.currentScreen == 407) {
            Ted.reviveCounter -= 1.0f * deltaTime;
            if (Ted.reviveCounter <= 0.0f) {
                this.currentScreen = 406;
                Storage.saveData("totalCoins", Game.totalCoins + "");
                Ted.saveMeBitmap = null;
            }
        }
    }

    public void paint(Graphics g) {
        if (this.currentScreen == 401) {
            this.bind3dTarget(g);
            mr.GamePaint(this.g3d);
            this.g3d.releaseTarget();
            for (int i = 0; i < MyCanvas.mr.messages.size(); ++i) {
                Message msg = (Message)MyCanvas.mr.messages.elementAt(i);
                if (msg.scoreStartY > msg.scoreEndY) {
                    FontsBig.drawString(msg.message, g, msg.scoreX - FontsBig.stringWidth(msg.message) / 2, msg.scoreStartY);
                    msg.scoreStartY -= msg.scrollSpeed;
                    continue;
                }
                MyCanvas.mr.messages.removeElementAt(i);
                --i;
            }
            FontsBig.drawString(String.valueOf((int)Ted.playerScore), g, 5, 30);
            if (PlatformService.isTouchSupported()) {
                Bitmap.drawBitmap(g, this.pauseIcon, 5, 2);
            } else {
                Bitmap.drawBitmap(g, this.pauseIcon, Game.width - this.pauseIcon.getWidth() * 2, Game.height - this.pauseIcon.getHeight());
            }
            Bitmap.drawBitmap(g, this.firstAidBitmap, Game.width - this.firstAidBitmap.getWidth(), 5);
            MyFont.drawString(String.valueOf(Ted.playerEnergy), g, Game.width - this.firstAidBitmap.getWidth() - MyFont.stringWidth(Ted.playerEnergy + "."), 12);
            Bitmap.drawBitmap(g, this.coinBitmap, Game.width - this.coinBitmap.getWidth(), 35);
            MyFont.drawString(String.valueOf(Ted.coinsCollected), g, Game.width - this.coinBitmap.getWidth() - MyFont.stringWidth(Ted.coinsCollected + "."), 42);
            if (Ted.reverseCounter > 0 && Ted.reverseCounter % 10 > 5) {
                Bitmap.drawBitmap(g, Ted.reverseIcon, 30 + 32 * Ted.reverseSprite.currentLane, 5);
            }
            Bitmap.drawBitmap(g, Ted.nitrousIcon, Game.width - Ted.nitrousIcon.getWidth(), Game.height / 3);
            Bitmap.fillColor(g, Game.width - Ted.nitrousIcon.getWidth() * Ted.totalNitrous / 100, Game.height / 3 + Ted.nitrousIcon.getHeight(), Ted.nitrousIcon.getWidth() * Ted.totalNitrous / 100, 5, 211, 52, 39);
            Bitmap.fillColor(g, Game.width - Ted.nitrousIcon.getWidth() * Ted.totalNitrous / 100 + 1, Game.height / 3 + Ted.nitrousIcon.getHeight() + 1, (int)((float)(Ted.nitrousIcon.getWidth() * Ted.totalNitrous / 100 - 2) * Ted.nitrousAvailable / (float)Ted.totalNitrous), 3, 251, 214, 11);
        } else if (this.currentScreen == 404) {
            this.bind3dTarget(g);
            mr.drawCountDown(this.g3d);
            this.g3d.releaseTarget();
            if (Ted.countDown == 0) {
                FontsBig.drawString("Go!", g, Game.width / 2 - MyFont.stringWidth("Go!") / 2, Game.height / 3);
            } else {
                FontsBig.drawString(Ted.countDown + "", g, Game.width / 2 - MyFont.stringWidth(Ted.countDown + "") / 2, Game.height / 3);
            }
        } else if (this.currentScreen == 405) {
            this.bind3dTarget(g);
            mr.drawDead(this.g3d);
            this.g3d.releaseTarget();
        } else if (this.currentScreen == 406) {
            this.bind3dTarget(g);
            mr.drawDead(this.g3d);
            this.g3d.releaseTarget();
            Bitmap.drawBitmap(g, new Bitmap("/gameover.png"), 0, 0);
            MyFont.drawString(Game.topName, g, Game.width / 2 - MyFont.stringWidth(Game.topName) / 2, (int)((float)Game.height * 0.17f));
            MyFont.drawString(String.valueOf((int)Ted.playerScore), g, Game.width / 2 - MyFont.stringWidth(String.valueOf((int)Ted.playerScore)) / 2, (int)((float)Game.height * 0.35f));
            if (!PlatformService.isTouchSupported()) {
                this.drawSelector(g);
            }
            MyFont.drawString("Collected:" + Ted.coinsCollected + " Total:" + Game.totalCoins, g, (int)((float)Game.width * 0.15f), (int)((float)Game.height * 0.025f));
        } else if (this.currentScreen == 402) {
            this.bind3dTarget(g);
            mr.GamePaint(this.g3d);
            this.g3d.releaseTarget();
            Bitmap pauseMenu = new Bitmap("/pauseMenu.png");
            Bitmap.drawBitmap(g, pauseMenu, Game.width / 2 - pauseMenu.getWidth() / 2, Game.height / 2 - pauseMenu.getHeight() / 2);
            if (!PlatformService.isTouchSupported()) {
                this.drawSelector(g);
            }
        } else if (this.currentScreen == 407) {
            this.bind3dTarget(g);
            mr.drawDead(this.g3d);
            this.g3d.releaseTarget();
            Bitmap saveMeBitmap = Ted.saveMeBitmap;
            Bitmap.drawBitmap(g, saveMeBitmap, Game.width / 2 - saveMeBitmap.getWidth() / 2, Game.height / 2 - saveMeBitmap.getHeight() / 2);
            Bitmap.fillColor(g, Game.width / 2 - saveMeBitmap.getWidth() / 4, Game.height / 2 + saveMeBitmap.getHeight() * 3 / 10, saveMeBitmap.getWidth() / 2, saveMeBitmap.getHeight() / 20, 0, 109, 5);
            Bitmap.fillColor(g, Game.width / 2 - saveMeBitmap.getWidth() / 4, Game.height / 2 + saveMeBitmap.getHeight() * 3 / 10, Math.min(saveMeBitmap.getWidth() / 2 * (100 - (int)Ted.reviveCounter) / 100, saveMeBitmap.getWidth() / 2), saveMeBitmap.getHeight() / 20, 220, 211, 0);
            MyFont.drawString(String.valueOf(Game.totalCoins), g, Game.width / 2, Game.height / 2 - saveMeBitmap.getHeight() * 33 / 100);
            MyFont.drawString(String.valueOf(Ted.reviveCoinsRequired), g, Game.width / 2, Game.height / 2 + saveMeBitmap.getHeight() * 15 / 100);
            if (!PlatformService.isTouchSupported()) {
                MyFont.drawString("Press 5", g, Game.width / 2 - MyFont.stringWidth("Press 5") / 2, Game.height * 2 / 3);
            }
        }
        if (Ted.buyPrompt) {
            Bitmap.fillColor(g, 0, Game.height / 2, Game.width, Game.height / 2, 0, 115, 5);
            Bitmap.drawBitmap(g, Ted.buyPromptBitmap, Game.width / 2 - Ted.buyPromptBitmap.getWidth() / 2, Game.height - Ted.buyPromptBitmap.getHeight());
            if (Game.totalCoins >= Ted.reviveCoinsRequired) {
                Ted.buyPrompt = false;
                Ted.buyPromptBitmap = null;
                Ted.revive();
            }
        }
    }

    public void keyPressed(int i) {
        if (this.currentScreen == 401) {
            if (i == 116 || i == 107) {
                Game.xValue = 2.5;
            } else if (i == 117 || i == 109) {
                Game.xValue = -2.5;
            } else if (i == 112 || i == 114 || i == 105) {
                this.handleSwipe(120);
            } else if (i == 101 || i == 103 || i == 102) {
                this.pauseGame();
            }
        } else if (this.currentScreen == 402) {
            if (i == 116) {
                --this.selector;
                if (this.selector <= 0) {
                    this.selector = 3;
                }
            } else if (i == 117) {
                ++this.selector;
                if (this.selector > 3) {
                    this.selector = 1;
                }
            } else if (i == 101 || i == 103 || i == 102) {
                this.processSelector();
            }
        } else if (this.currentScreen == 406) {
            if (i == 114 || i == 116) {
                --this.selector;
                if (this.selector <= 0) {
                    this.selector = 5;
                }
            } else if (i == 115 || i == 117) {
                ++this.selector;
                if (this.selector > 5) {
                    this.selector = 1;
                }
            } else if (i == 101 || i == 103 || i == 102) {
                this.processSelector();
            }
        } else if (this.currentScreen == 407) {
            if (i == 108 || i == 103 || i == 101) {
                Ted.revive();
            } else {
                Ted.reviveCounter -= 10.0f;
            }
        }
    }

    public void keyRepeated(int i) {
    }

    public void keyReleased(int i) {
        Game.xValue = 0.0;
        if ((i == 112 || i == 114) && this.currentScreen == 401) {
            Ted.playerTopSpeed = Ted.normalTopSpeed;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pointerPressed(int xx, int yy) {
        if (Ted.buyPrompt) {
            if (xx <= Ted.buyPromptBitmap.getWidth() * 20 / 100) {
                if (yy >= Game.height / 2 - Ted.buyPromptBitmap.getHeight() * 3 / 5) {
                    game.openIAPStore();
                    return;
                }
            }
            if (xx < Ted.buyPromptBitmap.getWidth() * 80 / 100) return;
            if (yy < Game.height / 2 - Ted.buyPromptBitmap.getHeight() * 3 / 5) return;
            Ted.buyPrompt = false;
            Ted.buyPromptBitmap = null;
            Ted.saveMeBitmap = null;
            mr.gameOver();
            return;
        }
        yy = yy * 400 / 640;
        xx = xx * 240 / 360;
        if (this.currentScreen == 401) {
            if (xx <= 50 && yy <= 60) {
                game.playSelectSound();
                this.pauseGame();
                return;
            }
            Ted.playerTopSpeed = Ted.speedUpTopSpeed;
            return;
        }
        if (this.currentScreen == 402) {
            if (xx <= 80 && yy >= 150 && yy <= 250) {
                game.playSelectSound();
                this.resumeGame();
                return;
            }
            if (xx >= 80 && xx <= 160 && yy >= 150 && yy <= 250) {
                game.playSelectSound();
                this.restartGame();
                return;
            }
            if (xx < 160) return;
            if (yy < 150) return;
            if (yy > 250) return;
            game.playSelectSound();
            this.quitGame();
            return;
        }
        if (this.currentScreen == 406) {
            if (xx >= 10 && xx <= 120 && yy >= 270 && yy <= 380) {
                game.playSelectSound();
                this.restartGame();
                return;
            }
            if (xx >= 120 && xx <= 230 && yy >= 270 && yy <= 380) {
                game.playSelectSound();
                this.quitGame();
                return;
            }
            if (xx >= 50 && xx <= 190 && yy >= 155 && yy <= 200) {
                game.playSelectSound();
                game.setScore_canvas();
                return;
            }
            if (xx >= 40 && xx <= 200 && yy >= 50 && yy <= 95) {
                game.playSelectSound();
                PlatformService.getUserInput();
                return;
            }
            if (xx < 50) return;
            if (xx > 190) return;
            if (yy < 205) return;
            if (yy > 255) return;
            game.playSelectSound();
            game.postScoreToFacebook((int)Ted.playerScore);
            return;
        }
        if (this.currentScreen != 407) return;
        yy = yy * 640 / 400;
        xx = xx * 360 / 240;
        if (xx >= Game.width / 2 - Ted.saveMeBitmap.getWidth() / 2) {
            if (xx <= Game.width / 2 + Ted.saveMeBitmap.getWidth() / 2) {
                if (yy >= Game.height / 2 - Ted.saveMeBitmap.getHeight() / 2) {
                    if (yy <= Game.height / 2 + Ted.saveMeBitmap.getHeight() / 2) {
                        Ted.revive();
                        return;
                    }
                }
            }
        }
        Ted.reviveCounter -= 10.0f;
    }

    public void pointerReleased(int xx, int yy) {
        if (this.currentScreen == 401) {
            Ted.playerTopSpeed = Ted.normalTopSpeed;
        }
    }

    public void pointerDragged(int xx, int yy) {
    }

    public void pause() {
        if (this.currentScreen != 403) {
            this.pauseGame();
        }
    }

    public void resume() {
        if (this.previousScreen != 401) {
            this.resumeGame();
        }
    }

    public void onBackKey() {
        if (this.currentScreen == 401) {
            this.pauseGame();
        } else if (this.currentScreen == 402) {
            this.resumeGame();
        }
    }

    public void deallocate() {
        Ted._pMap.tile = null;
        Map.drawn = null;
        Ted._pMap = null;
        Ted.sprite3dManager.removeAllSprites();
        Sprite3DManager.deallocate();
        Ted.sprite3dManager.sprites = null;
        Ted.sprite3dManager = null;
        Ted.currentSideModel = null;
        Ted.roadSprite3d = null;
        MyCanvas.mr.roadTexture = null;
        Ted.playerSprite3d = null;
        SoundManager.removeAll();
        SoundManager.sounds = null;
        MyCanvas.mr.xValue = null;
        Ted.reverseIcon = null;
        Ted.nitrousIcon = null;
        this.light = null;
        this.cam = null;
        this.trCam = null;
        this.g3d = null;
        this.back = null;
        this.pauseIcon = null;
        this.firstAidBitmap = null;
        this.coinBitmap = null;
    }

    public void gamestart() {
        PrintConsole.print("loading..");
        try {
            mr.GameStart();
        }
        catch (Exception e2) {
            PrintConsole.print("Error:MyCanvas:gameStart:" + e2);
        }
    }

    public void loadCamera() {
        this.cam = new Camera();
        float[] camPos = new float[]{0.0f, 8.0f, 0.0f};
        float[] camLook = new float[]{0.0f, 0.0f, -7.0f};
        this.setLookAt(camPos, camLook);
        this.cam.setPerspective(67.0f, 0.6f, 0.1f, 22.0f);
    }

    public void loadBackground() {
        if (MyCanvas.game.slowDevice) {
            String name = "/textures/road_low/";
            if (PlatformService.getTotalMemory() >= 0x380000L) {
                name = "/textures/road/";
            }
            this.backgrounds = new Background[3];
            this.backgrounds[0] = new Background();
            Image2D temp = new Image2D(99, (Object)new Bitmap((String)new StringBuffer().append((String)name).append((String)"1.png").toString()).image);
            this.backgrounds[0].setImage(temp);
            this.backgrounds[1] = new Background();
            temp = new Image2D(99, (Object)new Bitmap((String)new StringBuffer().append((String)name).append((String)"2.png").toString()).image);
            this.backgrounds[1].setImage(temp);
            this.backgrounds[2] = new Background();
            temp = new Image2D(99, (Object)new Bitmap((String)new StringBuffer().append((String)name).append((String)"3.png").toString()).image);
            this.backgrounds[2].setImage(temp);
            return;
        }
        this.back = new Background();
        this.back.setColor(0);
    }

    public void setUp() {
        this.g3d = Graphics3D.getInstance();
    }

    public float getCameraZ() {
        float[] matrix = new float[16];
        this.trCam.get(matrix);
        return matrix[11];
    }

    public void bind3dTarget(Graphics g) {
        this.g3d.bindTarget((Object)g, true, this.renderingHints);
        if (MyCanvas.game.slowDevice) {
            this.g3d.clear(this.backgrounds[this.backIndex]);
            if (Ted.playerSpeed != 0.0f && (this.currentScreen == 401 || this.currentScreen == 405 || this.currentScreen == 406) && (float)(PlatformService.currentTimeMillis() - this.lastChangeTime) > 20.0f / -Ted.playerSpeed) {
                this.lastChangeTime = PlatformService.currentTimeMillis();
                ++this.backIndex;
                if (this.backIndex >= 3) {
                    this.backIndex = 0;
                }
            }
        } else {
            this.g3d.clear(null);
        }
    }

    public void pauseGame() {
        if (this.currentScreen != 402) {
            this.previousScreen = this.currentScreen;
            this.currentScreen = 402;
            this.selector = 1;
            SoundManager.stop(Constant.BACKGROUNDMUSIC_SOUND);
            SoundManager.stop(Constant.COPSIREN_SOUND);
            SoundManager.stop(Constant.COPCHATTER_SOUND);
        }
    }

    public void resumeGame() {
        this.currentScreen = this.previousScreen;
        if (this.currentScreen == 401) {
            SoundManager.play(Constant.BACKGROUNDMUSIC_SOUND);
            if (Ted.totalCopsInScene > 0) {
                SoundManager.play(Constant.COPSIREN_SOUND);
            }
        }
        this.drawBlack = true;
    }

    public void restartGame() {
        this.currentScreen = 403;
        this.isRestart = true;
    }

    public void quitGame() {
        PlatformService.disableGestures();
        game.backToMenu();
    }

    public void drawSelector(Graphics g) {
        if (this.currentScreen == 402) {
            switch (this.selector) {
                case 1: {
                    Bitmap.drawBitmap(g, new Bitmap("/selector"), 0, Game.height / 2 - 7);
                    break;
                }
                case 2: {
                    Bitmap.drawBitmap(g, new Bitmap("/selector"), Game.width / 3, Game.height / 2 - 7);
                    break;
                }
                case 3: {
                    Bitmap.drawBitmap(g, new Bitmap("/selector"), Game.width * 2 / 3, Game.height / 2 - 7);
                }
            }
        }
    }

    private void processSelector() {
        if (this.currentScreen == 402) {
            switch (this.selector) {
                case 1: {
                    game.playSelectSound();
                    this.resumeGame();
                    break;
                }
                case 2: {
                    game.playSelectSound();
                    this.restartGame();
                    break;
                }
                case 3: {
                    game.playSelectSound();
                    this.quitGame();
                }
            }
        } else if (this.currentScreen == 406) {
            switch (this.selector) {
                case 1: {
                    game.playSelectSound();
                    PlatformService.getUserInput();
                    break;
                }
                case 2: {
                    game.playSelectSound();
                    game.setScore_canvas();
                    break;
                }
                case 3: {
                    game.playSelectSound();
                    game.postScoreToFacebook((int)Ted.playerScore);
                    break;
                }
                case 4: {
                    game.playSelectSound();
                    this.restartGame();
                    break;
                }
                case 5: {
                    game.playSelectSound();
                    this.quitGame();
                }
            }
        }
    }

    public void setLookAt(float[] position, float[] look) throws NullPointerException, IllegalArgumentException {
        int i;
        float pos = Utility3D.getPositionZ(this.trCam);
        Utility3D.setTranslateZ(this.trCam, 0.0f);
        position[2] = 0.0f;
        float[] up = new float[]{0.0f, 1.0f, 0.0f};
        float[] lookOrient = new float[3];
        float[] normLook = new float[3];
        float[] normUp = new float[3];
        float[] tempS = new float[3];
        float[] tempU = new float[3];
        float tempValue = 0.0f;
        if (position == null || look == null || up == null) {
            throw new NullPointerException();
        }
        if (position.length != 3 || look.length != 3 || up.length != 3) {
            throw new IllegalArgumentException();
        }
        if (up[0] == 0.0f && up[1] == 0.0f && up[2] == 0.0f) {
            throw new IllegalArgumentException();
        }
        if (position[0] == look[0] && position[1] == look[1] && position[2] == look[2]) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < position.length; ++i) {
            lookOrient[i] = look[i] - position[i];
        }
        tempValue = lookOrient[1] * up[2] - lookOrient[2] * up[1] + (lookOrient[2] * up[0] - lookOrient[0] * up[2]) + (lookOrient[0] * up[1] - lookOrient[1] * up[0]);
        if (tempValue == 0.0f) {
            throw new IllegalArgumentException();
        }
        tempValue = (float)Math.sqrt(lookOrient[0] * lookOrient[0] + lookOrient[1] * lookOrient[1] + lookOrient[2] * lookOrient[2]);
        for (i = 0; i < lookOrient.length; ++i) {
            normLook[i] = lookOrient[i] / tempValue;
        }
        tempValue = (float)Math.sqrt(up[0] * up[0] + up[1] * up[1] + up[2] * up[2]);
        for (i = 0; i < up.length; ++i) {
            normUp[i] = up[i] / tempValue;
        }
        tempS[0] = normLook[1] * normUp[2] - normLook[2] * normUp[1];
        tempS[1] = normLook[2] * normUp[0] - normLook[0] * normUp[2];
        tempS[2] = normLook[0] * normUp[1] - normLook[1] * normUp[0];
        tempU[0] = tempS[1] * normLook[2] - tempS[2] * normLook[1];
        tempU[1] = tempS[2] * normLook[0] - tempS[0] * normLook[2];
        tempU[2] = tempS[0] * normLook[1] - tempS[1] * normLook[0];
        float[] temp = new float[]{tempS[0], tempU[0], -1.0f * normLook[0], position[0], tempS[1], tempU[1], -1.0f * normLook[1], position[1], tempS[2], tempU[2], -1.0f * normLook[2], position[2], 0.0f, 0.0f, 0.0f, 1.0f};
        this.trCam.set(temp);
        Utility3D.setTranslateZ(this.trCam, Utility3D.getPositionZ(this.trCam) + pos);
    }

    public void handleSwipe(int direction) {
        if (direction == 120 && Ted.nitrousAvailable > 20.0f && Ted.nitrousCounter <= 0.0f && this.currentScreen == 401) {
            Ted.nitrousCounter = Ted.nitrousAvailable < 40.0f ? (float)((int)Ted.nitrousAvailable) : 50.0f;
            Ted.slip = 0.03f;
            Ted.nitrousAvailable -= Ted.nitrousCounter;
            Ted.nitrousAppearance = PlatformService.nextInt(3);
            Ted.nitrousTransform.setIdentity();
            if (Ted.playerSprite3d.model instanceof PlayerBikeModel) {
                Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, 0.0f, 0.0f, -MyCanvas.mr.playerRotZ);
                MyCanvas.mr.playerRotZ = 0.0f;
                Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, 0.0f, -MyCanvas.mr.playerRotY, 0.0f);
                MyCanvas.mr.playerRotY = 0.0f;
            }
            SoundManager.play(Constant.SKID_SOUND);
            Ted.playerSpeed = -0.4f;
        }
    }
}

