/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.PlatformService;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.Message;
import com.renderedideas.superbike3d.MyCanvas;
import com.renderedideas.superbike3d.Sprite3DManager;
import com.renderedideas.superbike3d.Ted;
import com.renderedideas.superbike3d.Utility3D;
import com.renderedideas.superbike3d.models.Model;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;

public class Sprite3D {
    public Model model;
    public Transform transform3d;
    public byte textureIndex;
    public float velocity;
    public Mesh mesh;
    public boolean isCollisionEnabled;
    public int id;
    public int currentState;
    public int currentFrame;
    public long lastFrameUpdate;
    public long lastTurnTakenTime;
    public long turnStarted;
    public int currentLane;
    public int moveToLane;
    public int turnProbability;
    public int contextValue;
    public float totalMoved;
    boolean willTurn;
    int reCheckAfter;
    int turnGap;
    boolean isScoreAdded;
    boolean isRotated;
    float forceX;
    float forceZ;
    int forceCount;
    float rotationY;

    Sprite3D(Model model, int textureIndex, float velocity, int id, int lane, int tp) {
        this.model = model;
        this.transform3d = new Transform();
        this.textureIndex = (byte)textureIndex;
        this.velocity = velocity;
        if (this.velocity < Ted.playerTopSpeed) {
            this.velocity = Ted.playerTopSpeed / 2.0f;
        }
        this.isCollisionEnabled = true;
        this.id = id;
        this.isScoreAdded = false;
        this.isRotated = false;
        this.mesh = new Mesh(this.model.vertBuf, this.model.idxBuf, this.model.app[textureIndex]);
        this.mesh.setPickingEnable(false);
        this.currentState = 502;
        this.currentFrame = 0;
        this.currentLane = lane;
        this.turnProbability = tp;
        this.contextValue = 0;
        if (this.turnProbability != -1 && this.turnProbability > PlatformService.nextInt(100)) {
            this.willTurn = true;
            this.reCheckAfter = 25000 / this.turnProbability;
            this.turnGap = 12 + PlatformService.nextInt(9);
        } else {
            this.willTurn = false;
        }
        this.forceZ = 0.0f;
        this.forceX = 0.0f;
        this.forceCount = 0;
        this.rotationY = 0.0f;
    }

    void setLightsOff() {
        this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 3, 4, Sprite3DManager.lights_off);
    }

    boolean update() {
        float frontVehicleSpeed;
        if (this.forceCount > 0) {
            Utility3D.postTranslateAboutGlobalAxis(this.transform3d, this.forceX, 0.0f, this.forceZ);
            --this.forceCount;
            this.forceX -= this.forceX / 10.0f;
            this.forceZ -= this.forceZ / 10.0f;
        }
        float posZ = Utility3D.getPositionZ(this.transform3d);
        float camZ = Ted.mccc.getCameraZ();
        Sprite3D s = this;
        if (posZ + 1.0f > camZ) {
            if (this.currentState == 501) {
                this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 3, 4, Sprite3DManager.lights_off);
            }
            return true;
        }
        if (this.velocity == 0.0f) {
            Utility3D.postTranslateAboutGlobalAxis(s.transform3d, 0.0f, 0.0f, -Ted.playerSpeed * Ted.deltaTime);
        } else {
            Utility3D.postTranslateAboutGlobalAxis(s.transform3d, 0.0f, 0.0f, -s.velocity * Ted.deltaTime);
        }
        if ((this.id == 222 || this.id == 224 || this.id == 227) && posZ + 31.0f > camZ) {
            Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, -this.rotationY, 0.0f);
            Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, Ted.coinRotation, 0.0f);
            this.rotationY = Ted.coinRotation;
            if (this.contextValue == 99) {
                Utility3D.postTranslateAboutGlobalAxis(this.transform3d, -0.3f * Ted.deltaTime, 0.2f * Ted.deltaTime, -0.5f * Ted.deltaTime);
                if (Utility3D.getPositionX(this.transform3d) < -2.5f) {
                    return true;
                }
            } else if (this.id == 222 && Ted.magnetTimer > 0 && camZ - posZ < 10.0f) {
                float difference = Utility3D.getPositionX(this.transform3d) - Utility3D.getPositionX(Ted.playerSprite3d.transform3d);
                if (difference > 0.0f) {
                    Utility3D.postTranslateAboutGlobalAxis(this.transform3d, -0.2f * difference * Ted.deltaTime, 0.0f, 0.0f);
                } else {
                    Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.2f * -difference * Ted.deltaTime, 0.0f, 0.0f);
                }
            }
            return false;
        }
        Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, this.rotationY, 0.0f);
        if (!this.isScoreAdded && Utility3D.getPositionZ(s.transform3d) + 2.0f > Ted.mccc.getCameraZ() && s.turnProbability != -1) {
            int value = (int)(-Ted.playerTopSpeed * 20.0f);
            value -= value % 5;
            MyCanvas.mr.messages.addElement(new Message(String.valueOf(value), 10 + s.currentLane * 50, Game.height - Game.height / 5, Game.height - Game.height * 2 / 6, 2));
            Ted.playerScore += (float)value;
            this.isScoreAdded = true;
        }
        if ((frontVehicleSpeed = Ted.sprite3dManager.isVehicleInFront(this, 0.3f)) != -1.0f) {
            boolean changeLaneSuccess = false;
            if (this.currentLane == this.moveToLane) {
                for (int selectedLaneToMove = 1; selectedLaneToMove <= 4; ++selectedLaneToMove) {
                    if (selectedLaneToMove == this.currentLane || Ted.sprite3dManager.isVehicleAlreadyOnLane(selectedLaneToMove, this) || Math.abs(selectedLaneToMove - this.currentLane) != 1) continue;
                    this.currentState = 501;
                    this.turnStarted = 0L;
                    this.totalMoved = 0.0f;
                    this.moveToLane = selectedLaneToMove;
                    this.willTurn = this.turnProbability / 2 > PlatformService.nextInt(100);
                    changeLaneSuccess = true;
                    break;
                }
            }
            if (!changeLaneSuccess) {
                Utility3D.postTranslateAboutGlobalAxis(s.transform3d, 0.0f, 0.0f, s.velocity * Ted.deltaTime);
                Utility3D.postTranslateAboutGlobalAxis(this.transform3d, 0.0f, 0.0f, -frontVehicleSpeed * Ted.deltaTime);
            }
        }
        if (this.currentState == 502) {
            if (this.willTurn && PlatformService.currentTimeMillis() - this.lastTurnTakenTime > (long)this.reCheckAfter) {
                if (50 > PlatformService.nextInt(100) && Utility3D.getPositionZ(s.transform3d) + (float)this.turnGap > Ted.mccc.getCameraZ()) {
                    int random = 1 + PlatformService.nextInt(4);
                    if (this.currentLane != random && !Ted.sprite3dManager.isVehicleAlreadyOnLane(random = this.currentLane - (this.currentLane - random) / Math.abs(this.currentLane - random), this)) {
                        this.currentState = 501;
                        this.turnStarted = PlatformService.currentTimeMillis();
                        this.totalMoved = 0.0f;
                        this.moveToLane = random;
                        this.willTurn = this.turnProbability / 2 > PlatformService.nextInt(100);
                    }
                } else {
                    this.lastTurnTakenTime = PlatformService.currentTimeMillis();
                    this.reCheckAfter -= 50;
                    if (this.reCheckAfter < 50) {
                        this.reCheckAfter = 50;
                    }
                }
            }
        } else if (this.currentState == 501) {
            this.updateFrame();
            if (this.isRotated || PlatformService.currentTimeMillis() - this.turnStarted > 1000L) {
                if (!this.isRotated) {
                    if (this.moveToLane > this.currentLane) {
                        Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, -5.0f, 0.0f);
                    } else {
                        Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, 5.0f, 0.0f);
                    }
                    this.isRotated = true;
                }
                float move = (float)(this.moveToLane - this.currentLane) * 0.06f;
                Utility3D.postTranslateAboutGlobalAxis(s.transform3d, move * Ted.deltaTime, 0.0f, 0.0f);
                this.totalMoved += move * Ted.deltaTime;
                if (Math.abs(this.totalMoved) > 1.0f) {
                    if (this.moveToLane > this.currentLane) {
                        Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, 5.0f, 0.0f);
                    } else {
                        Utility3D.postRotateAboutLocalAxis(this.transform3d, 0.0f, -5.0f, 0.0f);
                    }
                    this.isRotated = false;
                    this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 3, 4, Sprite3DManager.lights_off);
                    this.currentLane = this.moveToLane;
                    this.currentState = 502;
                    this.lastTurnTakenTime = PlatformService.currentTimeMillis();
                    this.reCheckAfter = 50;
                }
            }
        }
        return false;
    }

    void draw(Graphics3D m3d) {
        m3d.render((Node)this.mesh, this.transform3d);
    }

    public void updateFrame() {
        if (PlatformService.currentTimeMillis() - this.lastFrameUpdate > 200L) {
            ++this.currentFrame;
            if (this.currentFrame > 1) {
                this.currentFrame = 0;
            }
            this.lastFrameUpdate = PlatformService.currentTimeMillis();
            if (this.currentFrame == 1) {
                this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 3, 4, Sprite3DManager.lights);
            } else {
                this.mesh.getAppearance(0).getTexture(0).getImage().set(this.getX(), this.getY(), 3, 4, Sprite3DManager.lights_off);
            }
        }
    }

    public int getX() {
        if (this.moveToLane > this.currentLane) {
            if (this.model == Sprite3DManager.carModel) {
                return 49;
            }
            if (this.model == Sprite3DManager.car2Model) {
                return 58;
            }
            if (this.model == Sprite3DManager.suv1Model) {
                return 59;
            }
            if (this.model == Sprite3DManager.suv2Model) {
                return 59;
            }
            if (this.model == Sprite3DManager.suv3Model) {
                return 61;
            }
            if (this.model == Sprite3DManager.suv4Model) {
                return 22;
            }
            if (this.model == Sprite3DManager.truckModel) {
                return 18;
            }
            if (this.model == Sprite3DManager.copCarModel) {
                return 45;
            }
        } else {
            if (this.model == Sprite3DManager.carModel) {
                return 29;
            }
            if (this.model == Sprite3DManager.car2Model) {
                return 39;
            }
            if (this.model == Sprite3DManager.suv1Model) {
                return 36;
            }
            if (this.model == Sprite3DManager.suv2Model) {
                return 35;
            }
            if (this.model == Sprite3DManager.suv3Model) {
                return 39;
            }
            if (this.model == Sprite3DManager.suv4Model) {
                return 1;
            }
            if (this.model == Sprite3DManager.truckModel) {
                return 36;
            }
            if (this.model == Sprite3DManager.copCarModel) {
                return 27;
            }
        }
        return 0;
    }

    public int getY() {
        if (this.model == Sprite3DManager.carModel) {
            return 51;
        }
        if (this.model == Sprite3DManager.car2Model) {
            return 54;
        }
        if (this.model == Sprite3DManager.suv1Model) {
            return 44;
        }
        if (this.model == Sprite3DManager.suv2Model) {
            return 47;
        }
        if (this.model == Sprite3DManager.suv3Model) {
            return 52;
        }
        if (this.model == Sprite3DManager.suv4Model) {
            return 53;
        }
        if (this.model == Sprite3DManager.truckModel) {
            if (this.moveToLane > this.currentLane) {
                return 19;
            }
            return 10;
        }
        if (this.model == Sprite3DManager.copCarModel) {
            return 2;
        }
        return 0;
    }
}

