/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PlatformService;
import com.renderedideas.game.PrintConsole;
import com.renderedideas.game.Storage;
import com.renderedideas.superbike3d.Constant;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.Map;
import com.renderedideas.superbike3d.MyCanvas;
import com.renderedideas.superbike3d.SoundManager;
import com.renderedideas.superbike3d.Sprite3D;
import com.renderedideas.superbike3d.Sprite3DManager;
import com.renderedideas.superbike3d.Utility3D;
import com.renderedideas.superbike3d.models.Model;
import com.renderedideas.superbike3d.models.PlayerBikeModel;
import java.util.Vector;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;

public class Ted {
    public static Game game;
    static float normalTopSpeed;
    static float speedUpTopSpeed;
    static float playerTopSpeed;
    public static float playerSpeed;
    public static float slip;
    boolean rotateLeft;
    public static Sprite3D playerSprite3d;
    public static Sprite3D roadSprite3d;
    public static Sprite3DManager sprite3dManager;
    public float playerRotX;
    public float playerRotY;
    public float playerRotZ;
    public static float camRot;
    public static boolean drawTunnelForG1;
    public static boolean drawTunnelForG2;
    public static float roadTexStart;
    boolean secondTreeDrawn;
    public static boolean drawBg;
    public static MyCanvas mccc;
    static Map _pMap;
    static float playerScore;
    static int countDown;
    static int countDownX;
    Vector messages;
    int delay;
    float[] xValue;
    int index;
    public static int turnProbability;
    float shadowScale;
    static float roadTextureStart;
    static int roadTextureHeight;
    byte[] roadTexture;
    static float[] lookAt;
    static float[] targetPosition;
    static float[] iterationValue;
    static float[] lookAtIterationValue;
    static float[] newLookAt;
    static int totalCycles;
    static boolean moveCamera;
    float lastTreeAdded;
    public static int playerEnergy;
    static int coinsCollected;
    static float deltaTime;
    static float coinRotation;
    static Model currentSideModel;
    static boolean isNight;
    public static int totalCopsInScene;
    public static int magnetTimer;
    public static boolean reverseDirection;
    public static int reverseCounter;
    public static Sprite3D reverseSprite;
    public static Bitmap reverseIcon;
    public static float nitrousCounter;
    public static int totalNitrous;
    public static int nitrousAppearance;
    public static Transform nitrousTransform;
    public static Bitmap nitrousIcon;
    public static float nitrousAvailable;
    public static String[] appreciateTexts;
    static float reviveCounter;
    static Bitmap saveMeBitmap;
    static Bitmap buyPromptBitmap;
    public static int reviveCoinsRequired;
    public static boolean buyPrompt;

    Ted(Game game, MyCanvas mcc) {
        Ted.game = game;
        mccc = mcc;
    }

    void initialize() {
        lookAt = Utility3D.getVector(0.0f, 0.0f, -8.0f);
        targetPosition = new float[3];
        iterationValue = new float[3];
        lookAtIterationValue = new float[3];
        moveCamera = false;
        playerScore = 0.0f;
        normalTopSpeed = -0.25f;
        speedUpTopSpeed = -1.0f;
        playerTopSpeed = normalTopSpeed;
        playerSpeed = 0.0f;
        slip = 0.0f;
        this.rotateLeft = false;
        this.playerRotZ = 0.0f;
        this.playerRotY = 0.0f;
        this.playerRotX = 0.0f;
        camRot = 0.0f;
        drawTunnelForG2 = false;
        drawTunnelForG1 = false;
        roadTexStart = 0.6f;
        this.secondTreeDrawn = false;
        drawBg = false;
        countDown = 3;
        countDownX = 0;
        this.messages = new Vector();
        this.delay = 3;
        this.xValue = new float[this.delay];
        this.index = 0;
        turnProbability = 50;
        this.shadowScale = 1.0f;
        this.lastTreeAdded = -2.0f;
        playerEnergy = Integer.parseInt(Storage.readData("startingHealth"));
        coinsCollected = 0;
        deltaTime = 1.0f;
        coinRotation = 0.0f;
        isNight = false;
        totalCopsInScene = 0;
        magnetTimer = 0;
        reverseDirection = false;
        reverseCounter = -1;
        nitrousCounter = 0.0f;
        totalNitrous = 100;
        if (Game.startVehicle.equals("car")) {
            totalNitrous = 130;
        } else if (Game.startVehicle.equals("bike")) {
            totalNitrous = 150;
        }
        nitrousAppearance = 0;
        nitrousTransform = new Transform();
        nitrousAvailable = totalNitrous;
        reviveCounter = 3.0f;
        reviveCoinsRequired = 100;
    }

    void GameStart() {
        try {
            this.initialize();
            Game.loadingCounter = 5;
            _pMap = new Map();
            if (!_pMap.LoadMap("map.dat")) {
                PlatformService.errorQuit("can not read mapX.dat");
            }
            Game.loadingCounter = 10;
            boolean bl = isNight = PlatformService.nextInt(100) > 60;
            if (Ted.game.slowDevice) {
                isNight = false;
            }
            sprite3dManager = new Sprite3DManager();
            int random_sideObject = PlatformService.nextInt(3);
            if (isNight) {
                random_sideObject = 1 + PlatformService.nextInt(2);
            }
            switch (random_sideObject) {
                case 0: {
                    currentSideModel = Sprite3DManager.treeModel;
                    break;
                }
                case 1: {
                    currentSideModel = Sprite3DManager.streetLightModel;
                    break;
                }
                case 2: {
                    currentSideModel = Sprite3DManager.globeLightModel;
                }
            }
            if (!Ted.game.slowDevice) {
                roadSprite3d = new Sprite3D(Sprite3DManager.roadModel, 0, 0.0f, 215, -1, -1);
                Ted.roadSprite3d.model.app[0].getPolygonMode().setPerspectiveCorrectionEnable(true);
                Ted.roadSprite3d.transform3d.postTranslate(0.0f, 0.0f, -9.6f);
                Ted.roadSprite3d.transform3d.postScale(5.0f, 6.0f, 10.0f);
                roadTextureStart = 1.0f;
                int random_road = 1 + PlatformService.nextInt(5);
                Game.loadingCounter = 80;
                Bitmap r = null;
                if (isNight) {
                    r = Bitmap.multiplyBitmaps(new Bitmap("/textures/road_texture" + random_road + ".png"), new Bitmap("/textures/glow.png"));
                } else if (currentSideModel == Sprite3DManager.treeModel) {
                    r = Bitmap.combineBitmaps(new Bitmap("/textures/road_texture" + random_road + ".png"), new Bitmap("/textures/shadow_tree.png"));
                } else if (currentSideModel == Sprite3DManager.streetLightModel) {
                    r = Bitmap.combineBitmaps(new Bitmap("/textures/road_texture" + random_road + ".png"), new Bitmap("/textures/shadow_light1.png"));
                } else if (currentSideModel == Sprite3DManager.globeLightModel) {
                    r = Bitmap.combineBitmaps(new Bitmap("/textures/road_texture" + random_road + ".png"), new Bitmap("/textures/shadow_light2.png"));
                }
                roadTextureHeight = r.getHeight();
                roadTextureStart = 0.33f * (float)roadTextureHeight;
                this.roadTexture = Bitmap.getRGB_byte(r);
                this.updateRoad();
            }
            Game.loadingCounter = 90;
            playerSprite3d = new Sprite3D(Sprite3DManager.playerModel, 0, 0.0f, 200, -1, -1);
            Ted.playerSprite3d.transform3d.postTranslate(0.0f, -0.1f, -5.0f);
        }
        catch (Exception e2) {
            PrintConsole.print("error:GameStart:" + e2);
            e2.printStackTrace();
        }
        SoundManager.loadSounds();
        for (int i = 0; i < this.delay; ++i) {
            this.xValue[i] = 0.0f;
        }
        float[] target = new float[]{0.0f, 0.5f, 0.0f};
        if (!Ted.game.slowDevice) {
            this.add2SideObjects(currentSideModel, 5.0f);
        }
        reverseIcon = new Bitmap("/reverseIcon.png");
        nitrousIcon = new Bitmap("/nitrous.png");
        Game.loadingCounter = 95;
    }

    void GamePaint(Graphics3D target) {
        target.setCamera(Ted.mccc.cam, Ted.mccc.trCam);
        if (!Ted.game.slowDevice) {
            Ted.mccc.g3d.render(Ted.roadSprite3d.model.vertBuf, Ted.roadSprite3d.model.idxBuf, Ted.roadSprite3d.model.app[0], Ted.roadSprite3d.transform3d);
        }
        Ted.mccc.g3d.render(Ted.playerSprite3d.model.vertBuf, Ted.playerSprite3d.model.idxBuf, Ted.playerSprite3d.model.app[Ted.playerSprite3d.textureIndex], Ted.playerSprite3d.transform3d);
        if (nitrousCounter > 0.0f) {
            nitrousTransform.set(Ted.playerSprite3d.transform3d);
            if (nitrousCounter < 10.0f) {
                int i = 0;
                while ((float)i < 10.0f - nitrousCounter) {
                    nitrousTransform.postScale(0.9f, 1.0f, 0.7f);
                    ++i;
                }
            }
            if (Ted.playerSprite3d.model instanceof PlayerBikeModel) {
                nitrousTransform.postScale(0.2f, 1.0f, 1.0f);
                Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, -this.playerRotX, 0.0f, 0.0f);
                if (nitrousCounter > 5.0f) {
                    if (this.playerRotX < 70.0f) {
                        this.playerRotX += 10.0f;
                    }
                } else {
                    this.playerRotX -= 10.0f;
                }
                Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, this.playerRotX, 0.0f, 0.0f);
                Ted.mccc.g3d.render(Sprite3DManager.nitrousModel.vertBuf, Sprite3DManager.nitrousModel.idxBuf, Sprite3DManager.nitrousModel.app[nitrousAppearance], nitrousTransform);
            } else {
                Ted.mccc.g3d.render(Sprite3DManager.nitrousModel.vertBuf, Sprite3DManager.nitrousModel.idxBuf, Sprite3DManager.nitrousModel.app[nitrousAppearance], nitrousTransform);
            }
            if ((nitrousCounter -= 0.5f) == 0.0f) {
                Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, -this.playerRotX, 0.0f, 0.0f);
                this.playerRotX = 0.0f;
            }
        } else if (nitrousAvailable < (float)totalNitrous) {
            nitrousAvailable += 0.1f;
        }
        sprite3dManager.drawSprites(target);
    }

    public void updateRoad() {
        Utility3D.postTranslateAboutGlobalAxis(Ted.roadSprite3d.transform3d, 0.0f, 0.0f, playerSpeed * deltaTime);
        roadTextureStart += 26.25f * deltaTime * -playerSpeed;
        if (roadTextureStart >= (float)roadTextureHeight) {
            Ted.roadSprite3d.model.app[0].getTexture(0).getImage().set(0, (int)(roadTextureStart -= (float)roadTextureHeight), roadTextureHeight, roadTextureHeight - (int)roadTextureStart, this.roadTexture);
        } else {
            Ted.roadSprite3d.model.app[0].getTexture(0).getImage().set(0, (int)roadTextureStart, roadTextureHeight, roadTextureHeight - (int)roadTextureStart, this.roadTexture);
            Ted.roadSprite3d.model.app[0].getTexture(0).getImage().set(0, 0, roadTextureHeight, (int)roadTextureStart, this.getArray());
        }
    }

    public byte[] getArray() {
        int width_by_bytesPerPixel = roadTextureHeight * 3;
        byte[] array = new byte[(int)roadTextureStart * width_by_bytesPerPixel];
        System.arraycopy(this.roadTexture, (roadTextureHeight - (int)roadTextureStart) * width_by_bytesPerPixel, array, 0, (int)roadTextureStart * width_by_bytesPerPixel);
        return array;
    }

    void GameCycle(float deltaTimeValue) {
        if (reverseCounter > 0) {
            if (reverseCounter == 1) {
                Ted.reverseSprite.transform3d.postTranslate(0.0f, 0.0f, -15.0f);
                Utility3D.postRotateAboutLocalAxis(Ted.reverseSprite.transform3d, 0.0f, 180.0f, 0.0f);
                Ted.reverseSprite.velocity = -Ted.reverseSprite.velocity;
                Ted.reverseSprite.turnProbability = 0;
                sprite3dManager.addSprite(reverseSprite);
            }
            --reverseCounter;
        }
        --magnetTimer;
        deltaTime = deltaTimeValue;
        if (Game.accelerometerSupported) {
            _pMap.MoveMap(0.85f * -playerSpeed * 2.0f * deltaTime);
        } else {
            _pMap.MoveMap(0.65f * -playerSpeed * 2.0f * deltaTime);
        }
        Utility3D.postTranslateAboutGlobalAxis(Ted.mccc.trCam, 0.0f, 0.0f, playerSpeed * deltaTime);
        this.updateCamera();
        if (!Ted.game.slowDevice) {
            this.updateRoad();
            this.updateSideObjects(currentSideModel, 212);
        }
        Utility3D.postTranslateAboutGlobalAxis(Ted.playerSprite3d.transform3d, 0.0f, 0.0f, playerSpeed * deltaTime);
        sprite3dManager.updateSprites();
        _pMap.UpdateMap();
        playerScore += -playerSpeed * deltaTime;
        sprite3dManager.checkCollision();
        this.shakeCamera();
        if (playerSpeed > playerTopSpeed) {
            playerSpeed -= 0.005f;
        } else if (playerSpeed < playerTopSpeed && nitrousCounter <= 0.0f) {
            playerSpeed += 0.015f;
        }
        this.updateCoin();
    }

    void updateCoin() {
        if ((coinRotation += 10.0f * deltaTime) > 360.0f) {
            coinRotation = 0.0f;
        }
    }

    public void crashed() {
        this.removeAllPlayerRotation();
        SoundManager.remove(Constant.COPCHATTER_SOUND);
        SoundManager.remove(Constant.BACKGROUNDMUSIC_SOUND);
        SoundManager.add(Constant.CRASH_SOUND, 40, "/audio/crash", 1);
        SoundManager.play(Constant.CRASH_SOUND);
        Ted.mccc.currentScreen = 405;
        slip = 0.1f;
    }

    void shakeCamera() {
        if (slip > 0.0f) {
            slip -= 0.005f;
            if (this.rotateLeft) {
                this.rotateLeft = false;
                Utility3D.postRotateAboutLocalAxis(Ted.mccc.trCam, 0.0f, 1.0f, 1.0f);
            } else {
                this.rotateLeft = true;
                Utility3D.postRotateAboutLocalAxis(Ted.mccc.trCam, 0.0f, -1.0f, -1.0f);
            }
        }
    }

    void HandleKeys(float deltaTime) {
        float move2;
        int k;
        this.xValue[this.index] = (float)(Game.xValue / Game.maxValue * 20.0);
        float move = -this.xValue[this.index] * 0.02f * (-playerSpeed * deltaTime * 4.0f);
        if (move > 0.15f) {
            move = 0.15f;
        } else if (move < -0.15f) {
            move = -0.15f;
        }
        if (this.playerRotY > -90.0f && this.playerRotY < 90.0f) {
            if (Math.abs(move) < 0.01f) {
                this.setPlayerRot(0.0f);
            } else {
                this.setPlayerRot(move * 200.0f);
            }
        }
        if (Ted.game.soundMixing && (this.playerRotY > 12.0f || this.playerRotY < -12.0f)) {
            SoundManager.play(Constant.SKID_SOUND);
        }
        if ((k = this.index - (this.delay - 1)) < 0) {
            k += this.delay;
        }
        if ((move2 = -this.xValue[k] * 0.02f * (-playerSpeed * deltaTime * 3.0f)) > 0.2f) {
            move2 = 0.2f;
        } else if (move2 < -0.2f) {
            move2 = -0.2f;
        }
        Utility3D.postTranslateAboutGlobalAxis(Ted.playerSprite3d.transform3d, move2 * 3.0f, 0.0f, 0.0f);
        if (Utility3D.getPositionX(Ted.playerSprite3d.transform3d) > 1.85f) {
            Utility3D.setTranslateX(Ted.playerSprite3d.transform3d, 1.85f);
            this.removeAllPlayerRotation();
            this.playerRotZ = 0.0f;
            this.playerRotY = 0.0f;
        } else if (Utility3D.getPositionX(Ted.playerSprite3d.transform3d) < -1.85f) {
            Utility3D.setTranslateX(Ted.playerSprite3d.transform3d, -1.85f);
            this.removeAllPlayerRotation();
            this.playerRotZ = 0.0f;
            this.playerRotY = 0.0f;
        }
        ++this.index;
        if (this.index >= this.delay) {
            this.index = 0;
        }
    }

    public void removeAllPlayerRotation() {
        Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, 0.0f, -this.playerRotY, 0.0f);
        if (Ted.playerSprite3d.model instanceof PlayerBikeModel) {
            Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, 0.0f, 0.0f, -this.playerRotZ);
        }
    }

    public void setPlayerRot(float angle) {
        if (nitrousCounter > 0.0f && Ted.playerSprite3d.model instanceof PlayerBikeModel) {
            return;
        }
        this.removeAllPlayerRotation();
        if (Ted.playerSprite3d.model instanceof PlayerBikeModel) {
            Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, 0.0f, 0.0f, -angle * 2.0f);
        }
        Utility3D.postRotateAboutLocalAxis(Ted.playerSprite3d.transform3d, 0.0f, -angle / 2.0f, 0.0f);
        this.playerRotY = -angle / 2.0f;
        if (Ted.playerSprite3d.model instanceof PlayerBikeModel) {
            this.playerRotZ = -angle * 2.0f;
        }
    }

    public void restartLevel() {
        sprite3dManager.deallocate();
        SoundManager.removeAll();
        Ted.mccc.trCam.setIdentity();
        float[] camPos = new float[]{0.0f, 8.0f, 0.0f};
        float[] camLook = new float[]{0.0f, 0.0f, -7.0f};
        mccc.setLookAt(camPos, camLook);
        this.GameStart();
    }

    void drawCountDown(Graphics3D target) {
        target.setCamera(Ted.mccc.cam, Ted.mccc.trCam);
        this.GamePaint(target);
        Ted.mccc.g3d.render(Ted.playerSprite3d.model.vertBuf, Ted.playerSprite3d.model.idxBuf, Ted.playerSprite3d.model.app[Ted.playerSprite3d.textureIndex], Ted.playerSprite3d.transform3d);
        sprite3dManager.drawSprites(target);
        _pMap.UpdateMap();
    }

    void updateDead(float deltaTimeValue) {
        Utility3D.postTranslateAboutGlobalAxis(Ted.mccc.trCam, 0.0f, 0.0f, playerSpeed * deltaTime);
        deltaTime = deltaTimeValue;
        this.updateCamera();
        if (!Ted.game.slowDevice) {
            this.updateRoad();
        }
        Ted.playerSprite3d.transform3d.postRotate(5.0f, 0.0f, 1.0f, 0.0f);
        sprite3dManager.updateSprites();
        this.updateCoin();
        this.shakeCamera();
        playerSpeed = playerSpeed < 0.0f ? (playerSpeed += 0.005f) : 0.0f;
        if (Ted.mccc.currentScreen != 406 && playerSpeed >= normalTopSpeed / 2.0f) {
            Ted.setReviveScreen();
        }
    }

    void drawDead(Graphics3D target) {
        this.GamePaint(target);
    }

    static void gameOver() {
        Ted.mccc.currentScreen = 406;
        if ((int)playerScore > Game.topScore) {
            Game.topScore = (int)playerScore;
            Storage.saveData("topScore", String.valueOf(Game.topScore));
        }
        if (Game.topName.equals("Player")) {
            PlatformService.getUserInput();
        }
    }

    static void stateCompleted(Sprite3D sprite) {
    }

    public static void moveCamera(float[] target, int cycles, float[] newLookAtVector) {
        if (Ted.game.slowDevice) {
            return;
        }
        float[] currentPosition = Utility3D.getPosition(Ted.mccc.trCam);
        targetPosition = target;
        totalCycles = cycles;
        newLookAt = newLookAtVector;
        Ted.iterationValue[0] = (target[0] - currentPosition[0]) / (float)cycles;
        Ted.iterationValue[1] = (target[1] - currentPosition[1]) / (float)cycles;
        Ted.iterationValue[2] = target[2] / (float)cycles;
        Ted.lookAtIterationValue[0] = (newLookAt[0] - lookAt[0]) / (float)cycles;
        Ted.lookAtIterationValue[1] = (newLookAt[1] - lookAt[1]) / (float)cycles;
        Ted.lookAtIterationValue[2] = 0.0f;
        moveCamera = true;
    }

    public void updateCamera() {
        if (moveCamera) {
            float[] cameraCurrentPosition = Utility3D.getPosition(Ted.mccc.trCam);
            float[] target = new float[]{cameraCurrentPosition[0] + iterationValue[0], cameraCurrentPosition[1] + iterationValue[1], cameraCurrentPosition[2]};
            if (totalCycles > 0) {
                lookAt[0] = lookAt[0] + lookAtIterationValue[0];
                lookAt[1] = lookAt[1] + lookAtIterationValue[1];
                lookAt[2] = lookAt[2] + lookAtIterationValue[2];
                mccc.setLookAt(target, lookAt);
                --totalCycles;
            } else {
                mccc.setLookAt(targetPosition, lookAt);
                lookAt = newLookAt;
                moveCamera = false;
            }
        }
    }

    public void updateSideObjects(Model model, int id) {
        this.lastTreeAdded += playerSpeed * 0.4f * deltaTime;
        float xPos = 2.2f;
        if (model == Sprite3DManager.globeLightModel) {
            xPos = 2.8f;
        }
        if (this.lastTreeAdded <= -2.0f && this.lastTreeAdded >= -3.0f) {
            Sprite3D sprite3d = new Sprite3D(model, 0, 0.0f, id, 1, -1);
            sprite3d.isCollisionEnabled = false;
            sprite3d.transform3d.postTranslate(-xPos, 0.2f, mccc.getCameraZ() - 17.0f);
            sprite3d.transform3d.postScale(4.0f, 4.0f, 3.0f);
            sprite3dManager.addSprite(sprite3d);
            this.lastTreeAdded += -1.1f;
        } else if (this.lastTreeAdded <= -5.0f) {
            Sprite3D sprite3d = new Sprite3D(model, 0, 0.0f, id, 1, -1);
            sprite3d.isCollisionEnabled = false;
            sprite3d.transform3d.postTranslate(xPos, 0.2f, mccc.getCameraZ() - 17.0f);
            if (model != Sprite3DManager.globeLightModel) {
                sprite3d.transform3d.postRotate(180.0f, 0.0f, 1.0f, 0.0f);
            }
            sprite3d.transform3d.postScale(4.0f, 4.0f, 3.0f);
            sprite3dManager.addSprite(sprite3d);
            this.lastTreeAdded += 5.0f;
        }
    }

    public void add2SideObjects(Model model, float z) {
        float xPos = 2.2f;
        if (model == Sprite3DManager.globeLightModel) {
            xPos = 2.8f;
        }
        Sprite3D sprite3d = new Sprite3D(model, 0, 0.0f, 212, 1, -1);
        sprite3d.isCollisionEnabled = false;
        sprite3d.transform3d.postTranslate(-xPos, 0.2f, z);
        sprite3d.transform3d.postScale(4.0f, 4.0f, 3.0f);
        sprite3dManager.addSprite(sprite3d);
        sprite3d = new Sprite3D(model, 0, 0.0f, 212, 1, -1);
        sprite3d.isCollisionEnabled = false;
        sprite3d.transform3d.postTranslate(xPos, 0.2f, z - 9.5f);
        if (model != Sprite3DManager.globeLightModel) {
            sprite3d.transform3d.postRotate(180.0f, 0.0f, 1.0f, 0.0f);
        }
        sprite3d.transform3d.postScale(4.0f, 4.0f, 3.0f);
        sprite3dManager.addSprite(sprite3d);
    }

    public static void setReviveScreen() {
        if (Game.isIAPSupported || (Game.totalCoins += coinsCollected) >= reviveCoinsRequired) {
            Ted.mccc.currentScreen = 407;
            reviveCounter = 100.0f;
            Ted.freeResources();
            saveMeBitmap = new Bitmap("/saveme.png");
        } else {
            Ted.freeResources();
            Ted.gameOver();
            Storage.saveData("totalCoins", Game.totalCoins + "");
        }
    }

    public static void revive() {
        if (Game.totalCoins >= reviveCoinsRequired) {
            Game.totalCoins -= reviveCoinsRequired;
            Storage.saveData("totalCoins", (Game.totalCoins -= coinsCollected) + "");
            reviveCoinsRequired *= 2;
            playerEnergy = 100;
            Ted.playerSprite3d.transform3d.setIdentity();
            Ted.playerSprite3d.transform3d.postTranslate(0.0f, -0.1f, -5.0f);
            Utility3D.setTranslateZ(Ted.playerSprite3d.transform3d, Utility3D.getPositionZ(Ted.mccc.trCam) - 5.0f);
            MyCanvas.mr.playerRotZ = 0.0f;
            MyCanvas.mr.playerRotY = 0.0f;
            SoundManager.removeAll();
            SoundManager.loadSounds();
            SoundManager.play(Constant.BACKGROUNDMUSIC_SOUND);
            saveMeBitmap = null;
            Ted.reloadResources();
            Ted.mccc.currentScreen = 401;
        } else {
            buyPromptBitmap = new Bitmap("/buyprompt.png");
            buyPrompt = true;
        }
    }

    public static void freeResources() {
    }

    public static void reloadResources() {
    }

    static {
        appreciateTexts = new String[]{"Great!", "Cool!", "Nice!", "Oh..", "Hey!", "Sorry!", "Ha Ha", "Look out", "OMG", "OUCH!", "Oops!"};
        buyPrompt = false;
    }
}

