/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;
import main.ByteBufferedRMSManager;
import main.MyMath;
import main.Symbian;
import main.TData;
import main.TRaceInfo;
import main.Utils;

public class Colisions {
    protected static final boolean SHOW_CONTROLPOINTS = false;
    private static final boolean CREATE_COLISION_INFO_FILE = false;
    private static final String HEADER = "__info__";
    private static final String FILE_COLISION_INFO = "colisioninfo";
    protected Group m_Track;
    protected int m_numControlPoints = 0;
    protected float[] m_controlPoints = null;
    protected float[] m_outControlPoints = null;
    protected float[] m_inControlPoints = null;
    protected float[] m_centerNormalized = null;
    protected float[] m_inoutControlPoints = null;
    protected float[] m_inAng = null;
    protected float[] m_outAng = null;
    protected int[] m_distance = null;
    protected int[] m_acumDistance = null;
    protected World m_World = null;
    protected static final int CP_CENTER = 0;
    protected static final int CP_IN = 1;
    protected static final int CP_OUT = 2;
    protected static final int CP_INOUT = 3;
    protected static final int CP_CENTER_NORM = 4;
    private static final int ID_GCP = 236234086;

    Colisions(World aWorld, TRaceInfo pRaceInfo) {
        this.m_World = aWorld;
        this.m_Track = (Group)Symbian.wworld_findNode((Object3D)aWorld, pRaceInfo.iIDTrack);
        this.loadControlPoints(aWorld, pRaceInfo.iTrack);
    }

    public void reset() {
    }

    private void loadColisionInfo(int p_iTrack) throws IOException {
        int cpIndex;
        int i;
        DataInputStream input = new DataInputStream(((Object)((Object)TData.GetCanvas())).getClass().getResourceAsStream("/colisioninfo" + p_iTrack + ".db"));
        Utils.MovePastHeader(input, HEADER);
        this.m_numControlPoints = input.readInt();
        this.m_inControlPoints = new float[this.m_numControlPoints * 2];
        this.m_outControlPoints = new float[this.m_numControlPoints * 2];
        for (i = 0; i < this.m_numControlPoints; ++i) {
            cpIndex = i * 2;
            this.m_inControlPoints[cpIndex] = input.readFloat();
            this.m_inControlPoints[cpIndex + 1] = input.readFloat();
        }
        for (i = 0; i < this.m_numControlPoints; ++i) {
            cpIndex = i * 2;
            this.m_outControlPoints[cpIndex] = input.readFloat();
            this.m_outControlPoints[cpIndex + 1] = input.readFloat();
        }
        input.close();
    }

    private void saveColisionInfo(int p_iTrack) throws IOException {
        ByteBufferedRMSManager mRMS = new ByteBufferedRMSManager(FILE_COLISION_INFO + p_iTrack, true, true);
        mRMS.addString(HEADER);
        mRMS.addInt(this.m_numControlPoints);
        mRMS.addFloatArray(this.m_inControlPoints, false);
        mRMS.addFloatArray(this.m_outControlPoints, false);
        mRMS.flush();
    }

    private void loadControlPoints(World pWorld, int p_iTrack) {
        try {
            this.loadColisionInfo(p_iTrack);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.precalculateAngles();
    }

    public float getAngle(int type, int cp) {
        if (type == 1) {
            return this.m_inAng[cp];
        }
        return this.m_outAng[cp];
    }

    public float getAngleNext(int type, int cp) {
        if (type == 1) {
            return this.m_inAng[cp == this.m_numControlPoints - 1 ? 0 : cp + 1];
        }
        return this.m_outAng[cp == this.m_numControlPoints - 1 ? 0 : cp + 1];
    }

    protected void precalculateAngles() {
        int i;
        float[] cpNext = new float[2];
        float[] cp = new float[2];
        float[] vCPVector = new float[2];
        Object tst_r = null;
        Object tst = null;
        this.m_controlPoints = new float[this.m_numControlPoints * 2];
        this.m_inoutControlPoints = new float[this.m_numControlPoints * 2];
        this.m_centerNormalized = new float[this.m_numControlPoints * 2];
        for (int i2 = 0; i2 < this.m_numControlPoints; ++i2) {
            int cpIndex = i2 * 2;
            this.m_inoutControlPoints[cpIndex] = this.m_outControlPoints[cpIndex] - this.m_inControlPoints[cpIndex];
            this.m_inoutControlPoints[cpIndex + 1] = this.m_outControlPoints[cpIndex + 1] - this.m_inControlPoints[cpIndex + 1];
            this.m_controlPoints[cpIndex] = (this.m_inControlPoints[cpIndex] + this.m_outControlPoints[cpIndex]) / 2.0f;
            this.m_controlPoints[cpIndex + 1] = (this.m_inControlPoints[cpIndex + 1] + this.m_outControlPoints[cpIndex + 1]) / 2.0f;
        }
        this.m_inAng = new float[this.m_numControlPoints];
        this.m_outAng = new float[this.m_numControlPoints];
        this.m_distance = new int[this.m_numControlPoints];
        this.m_acumDistance = new int[this.m_numControlPoints];
        int previ = 0;
        for (i = 0; i < this.m_numControlPoints; ++i) {
            previ = i - 1;
            if (previ < 0) {
                previ = this.m_numControlPoints - 1;
            }
            this.getControlPoint(1, i, cpNext);
            this.getControlPoint(1, previ, cp);
            MyMath.substract2D(vCPVector, cpNext, cp);
            this.m_inAng[i] = MyMath.angle2D(vCPVector) * 57.29578f;
            if (!(vCPVector[1] < 0.0f)) continue;
            this.m_inAng[i] = 360.0f - this.m_inAng[i];
        }
        for (i = 0; i < this.m_numControlPoints; ++i) {
            previ = i - 1;
            if (previ < 0) {
                previ = this.m_numControlPoints - 1;
            }
            this.getControlPoint(2, i, cpNext);
            this.getControlPoint(2, previ, cp);
            MyMath.substract2D(vCPVector, cpNext, cp);
            this.m_outAng[i] = MyMath.angle2D(vCPVector) * 57.29578f;
            if (!(vCPVector[1] < 0.0f)) continue;
            this.m_outAng[i] = 360.0f - this.m_outAng[i];
        }
        for (i = 0; i < this.m_numControlPoints; ++i) {
            previ = i - 1;
            if (previ < 0) {
                previ = this.m_numControlPoints - 1;
            }
            this.getControlPoint(0, i, cpNext);
            this.getControlPoint(0, previ, cp);
            MyMath.substract2D(vCPVector, cp, cpNext);
            MyMath.normalize2D(vCPVector);
            this.m_centerNormalized[previ * 2] = vCPVector[0];
            this.m_centerNormalized[previ * 2 + 1] = vCPVector[1];
        }
        int iTotalDistance = 0;
        for (int i3 = 0; i3 < this.m_numControlPoints; ++i3) {
            this.getControlPoint(0, i3, cp);
            this.getControlPoint(0, i3 == this.m_numControlPoints - 1 ? 0 : i3 + 1, cpNext);
            MyMath.substract2D(vCPVector, cpNext, cp);
            this.m_distance[i3] = (int)(MyMath.magnitude2D(vCPVector) * 100.0f);
            this.m_acumDistance[i3] = iTotalDistance += this.m_distance[i3];
        }
        vCPVector = null;
        cp = null;
        cpNext = null;
    }

    public void getControlPoint(int type, int id, float[] xy) {
        int pos = id << 1;
        float[] cpArray = null;
        switch (type) {
            case 0: {
                cpArray = this.m_controlPoints;
                break;
            }
            case 1: {
                cpArray = this.m_inControlPoints;
                break;
            }
            case 2: {
                cpArray = this.m_outControlPoints;
                break;
            }
            case 3: {
                cpArray = this.m_inoutControlPoints;
                break;
            }
            case 4: {
                cpArray = this.m_centerNormalized;
            }
        }
        xy[0] = cpArray[pos];
        xy[1] = cpArray[pos + 1];
    }

    public int getNumControlPoints() {
        return this.m_numControlPoints;
    }

    int getDistanceCP(int i) {
        return this.m_distance[i];
    }

    int getAcumDistanceCP(int i) {
        return this.m_acumDistance[i];
    }

    int getTrackDistanceCP() {
        return this.m_acumDistance[this.m_numControlPoints - 1];
    }

    public void destroy() {
        this.m_outAng = null;
        this.m_inAng = null;
        this.m_inoutControlPoints = null;
        this.m_centerNormalized = null;
        this.m_inControlPoints = null;
        this.m_outControlPoints = null;
        this.m_controlPoints = null;
        this.m_acumDistance = null;
        this.m_distance = null;
        this.m_Track = null;
        this.m_World = null;
    }
}

