/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import main.CartoonRacer;
import main.GameSettings;
import main.KeyState;
import main.Platform;
import main.TData;

public abstract class Dialog {
    protected static final int MAX_NUMLINES = 150;
    protected String mText = null;
    protected int mNumLinesInList;
    protected int mNumLinesOnScreen;
    protected int mTextMaxWidth;
    protected int mFirstLineOnScreen = 0;
    protected int[] mLineStart = new int[150];
    protected int[] mLineEnd = new int[150];
    protected Image m_ImageTop = null;
    protected String m_sTitle = null;
    protected int m_iTitlePosY = 0;
    protected int m_iTitlePosX = 0;
    protected int m_iTitleIMGPos_X = 0;
    protected int m_iTitleIMGPos_Y = 0;
    protected Font m_Font = null;
    protected Object m_Parent = null;
    protected int m_iColorTitleText = 8033535;
    protected int m_iColorBodyText = 0xFFFFFF;
    protected int m_iBackColor = 0;
    protected int m_iMaxWidth = 0;
    protected int m_iPosX = 0;
    protected int m_iPosY = 0;
    protected boolean m_Repaint = true;

    public Dialog(Font p_Font, Object p_Parent, Image p_Img, String p_sTitle, String p_sText) {
        this.m_ImageTop = p_Img;
        this.m_Font = p_Font;
        this.m_Parent = p_Parent;
        this.m_sTitle = p_sTitle.toUpperCase();
        this.mText = p_sText;
        this.m_Repaint = true;
        if (p_Img != null) {
            this.m_iTitlePosX = 180;
            this.m_iTitlePosY = p_Img.getHeight();
        } else {
            this.m_iTitlePosX = 180;
            this.m_iTitlePosY = 0;
        }
        if (p_sText.compareTo("") != 0) {
            this.mTextMaxWidth = 344;
            this.mNumLinesOnScreen = 4;
            this.reformatText();
        }
    }

    public void repaint() {
        this.m_Repaint = true;
    }

    public void destroy() {
        this.mLineEnd = null;
        this.mLineStart = null;
    }

    public void setDlgTitleImgPos(int p_Point_X, int p_Point_Y) {
        this.m_iTitleIMGPos_X = p_Point_X;
        this.m_iTitleIMGPos_Y = p_Point_Y;
        this.m_Repaint = true;
    }

    public void addLine(String p_sLine) {
    }

    public void paintTitle(Graphics gc) {
        if (this.m_ImageTop != null) {
            gc.drawImage(this.m_ImageTop, this.m_iTitleIMGPos_X, this.m_iTitleIMGPos_Y, 3);
        }
        if (this.m_sTitle.length() > 0) {
            Font f = gc.getFont();
            gc.setFont(Platform.FONT_DLG_TITLE);
            gc.setColor(this.m_iColorTitleText);
            gc.drawString(this.m_sTitle, this.m_iTitlePosX, this.m_iTitlePosY, 17);
            gc.setFont(f);
        }
    }

    public void paintBody(Graphics gc) {
        int iNumLines;
        if (TData.GetCanvas().getWorld() == null && this.m_Repaint && CartoonRacer.m_Image != null && CartoonRacer.m_Image[1] != null) {
            gc.drawImage(CartoonRacer.m_Image[1], 0, 0, 20);
            this.paintTitle(gc);
        }
        if ((iNumLines = this.mNumLinesInList) > 0) {
            Font f = gc.getFont();
            gc.setFont(this.m_Font);
            int iHeight = this.m_Font.getHeight() + 20;
            int iPosX = this.m_iPosX == 0 ? 180 : this.m_iPosX;
            int iBaseY = this.m_iPosY == 0 ? 320 - (iNumLines * iHeight >> 1) : this.m_iPosY;
            int[] _lStart = this.mLineStart;
            int[] _lEnd = this.mLineEnd;
            String _Text = this.mText;
            Font _Font = this.m_Font;
            int fontheight = _Font.getHeight() + 20;
            int currentY = iBaseY;
            int end = 0;
            int start = 0;
            int iPosX_1 = iPosX + 1;
            int iIndex = 0;
            while (iIndex < iNumLines) {
                int end_start;
                int currentline = this.mFirstLineOnScreen + iIndex;
                if (currentline >= 0 && currentline < this.mNumLinesInList && (end_start = (end = _lEnd[currentline]) - (start = _lStart[currentline])) > 0) {
                    gc.setColor(this.m_iBackColor);
                    gc.drawSubstring(_Text, start, end_start, iPosX_1, currentY, 17);
                    gc.setColor(this.m_iColorBodyText);
                    gc.drawSubstring(_Text, start, end_start, iPosX, currentY, 17);
                }
                ++iIndex;
                currentY += fontheight;
            }
            gc.setFont(f);
        }
        this.m_Repaint = false;
    }

    protected void fire(CartoonRacer pLet) {
        if (GameSettings.m_bSound && Platform.m_bTone) {
            try {
                Manager.playTone((int)85, (int)50, (int)75);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void processKey(CartoonRacer pLet) {
        this.m_Repaint = true;
        if (KeyState.m_ACTION_MENU_SELECT) {
            this.fire(pLet);
        }
    }

    public void paint(Graphics gc) {
        this.paintTitle(gc);
        this.paintBody(gc);
    }

    public void setColorTitleText(int p_color) {
        this.m_iColorTitleText = p_color;
    }

    public void setColorBodyText(int p_color) {
        this.m_iColorBodyText = p_color;
    }

    public void setBackColor(int p_color) {
        this.m_iBackColor = p_color;
    }

    public void setBaseX(int p_ibase) {
        this.m_iPosX = p_ibase;
    }

    public void setBaseY(int p_ibase) {
        this.m_iPosY = p_ibase;
    }

    protected void reformatText() {
        int[] _lStart = this.mLineStart;
        int[] _lEnd = this.mLineEnd;
        String _Text = this.mText;
        Font _Font = this.m_Font;
        int textlenght = this.mText.length();
        boolean finished = false;
        boolean addline = false;
        int nextseparatorPos = 0;
        int newlinePos = 0;
        int spacePos = 0;
        int prevSpacePos = 0;
        int currentLine = 0;
        int newCurrentPos = 0;
        _lStart[0] = 0;
        spacePos = _Text.indexOf(32);
        newlinePos = _Text.indexOf(182);
        if (newlinePos != -1 && (newlinePos < spacePos || spacePos == -1)) {
            spacePos = newlinePos;
            addline = true;
        }
        if (spacePos == -1 && newlinePos == -1) {
            finished = true;
            _lEnd[0] = newCurrentPos += _Text.length();
        } else {
            _lEnd[0] = newCurrentPos += spacePos - prevSpacePos;
        }
        if (addline) {
            _lEnd[currentLine] = newCurrentPos++;
            _lStart[++currentLine] = _lEnd[currentLine] = newCurrentPos;
        }
        while (!finished) {
            int nextWordWidth;
            boolean forceNewLine = false;
            prevSpacePos = spacePos + 1;
            newlinePos = _Text.indexOf(182, prevSpacePos);
            spacePos = _Text.indexOf(32, prevSpacePos);
            if (newlinePos == -1) {
                newlinePos = textlenght;
            }
            if (spacePos == -1) {
                spacePos = textlenght;
            }
            if (newlinePos < spacePos) {
                spacePos = newlinePos;
                forceNewLine = true;
            }
            if (spacePos == textlenght) {
                finished = true;
            }
            boolean iscurrentlinenotempty = newCurrentPos - _lStart[currentLine] > 0;
            int currentLineWidth = 0;
            if (newCurrentPos > _lStart[currentLine]) {
                currentLineWidth = _Font.substringWidth(this.mText, _lStart[currentLine], newCurrentPos - _lStart[currentLine] + 1);
            }
            if (iscurrentlinenotempty) {
                currentLineWidth += _Font.stringWidth(" ");
            }
            if (currentLineWidth + (nextWordWidth = _Font.substringWidth(this.mText, prevSpacePos, spacePos - prevSpacePos)) > this.mTextMaxWidth) {
                _lEnd[currentLine] = newCurrentPos;
                _lStart[++currentLine] = _lEnd[currentLine] = (newCurrentPos = prevSpacePos);
            } else if (iscurrentlinenotempty) {
                ++newCurrentPos;
            }
            _lEnd[currentLine] = newCurrentPos += spacePos - prevSpacePos;
            if (forceNewLine) {
                _lEnd[currentLine] = newCurrentPos++;
                _lStart[++currentLine] = _lEnd[currentLine] = newCurrentPos;
            }
            _lEnd[currentLine] = newCurrentPos;
        }
        this.mNumLinesInList = currentLine + 1;
        if (this.mNumLinesInList > 150) {
            // empty if block
        }
    }

    public abstract void cmdAction(Command var1, CartoonRacer var2);
}

