/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;
import main.CCar;
import main.CCarAI;
import main.CCarBase;
import main.Colisions;
import main.GameSettings;
import main.MyMath;
import main.PowerUp;
import main.Symbian;
import main.TData;
import main.TRaceInfo;
import main.TRaceTimes;
import main.Utils;
import main.Window;
import main.swvVector3D;

public class CLapControl {
    private static final int MAX_CARS = 4;
    private static final int MAX_LAPS = 3;
    private static final int FRAMES_COLISION_COUNTOUT = 10;
    private static final int FRAMES_TURNING_COUNTOUT = 5;
    private int m_iLastCar;
    private int m_iAITurn;
    private int m_iKindOfRace;
    private CCarBase[] m_Car = new CCarBase[4];
    private Window m_Window;
    private World m_World;
    private Colisions m_Colisions;
    private swvVector3D l_vpos = new swvVector3D();
    private swvVector3D l_vpos2 = new swvVector3D();
    private swvVector3D l_vposparent = new swvVector3D();
    private Node[] m_CarDyn = new Node[4];
    private int[] m_LapCounter = new int[4];
    private int[] m_LapTime = new int[12];
    private int[] m_iOrden = new int[4];
    private boolean[] m_isFinished = new boolean[4];
    private Node[] m_NodeGeo;
    private int m_iNumTrozos;
    private int m_iCurrentTrozo;
    private int m_iNextTrozo;
    private int m_iPrevTrozo;
    private Node[] m_NodeTrozo;
    private float[][] m_vPosIni;
    private float[][] m_vPosFin;
    private float[] m_fPosXY_1 = new float[2];
    private float[] m_fPosXY_2 = new float[2];
    private boolean m_bContra = false;
    private boolean m_bNoWayOut = false;
    private boolean m_bNotifyChangeCamera = false;
    private int[] m_iCarPos = new int[]{0, 1, 2, 3};
    private int[] m_iTotalDistan = new int[4];
    private int[] m_iCarPowerUp = new int[]{0, 0, 0, 0};
    private PowerUp m_PowerUps = null;
    private int m_iCross;
    private int m_iColisionFrameCountDown;
    private int m_iBombChaseTimeout;
    private boolean m_bMustStop = false;
    private boolean m_bDrivingBackguards = false;

    CLapControl(Node p_World, Window p_Window, TRaceInfo p_TRaceInfo, Colisions p_Colisiones) {
        this.m_Window = p_Window;
        this.m_World = (World)p_World;
        this.m_Colisions = p_Colisiones;
        this.m_iLastCar = 0;
        for (int iIndex = 0; iIndex < 4; ++iIndex) {
            this.m_Car[iIndex] = null;
            this.m_CarDyn[iIndex] = null;
        }
        this.m_iKindOfRace = p_TRaceInfo.iKindOfRace;
        Node hTrackWorld = (Node)Symbian.wworld_findNode((Object3D)this.m_World, p_TRaceInfo.iIDTrack);
        Node Node1 = (Node)Symbian.wworld_findNode((Object3D)hTrackWorld, 830587653);
        this.m_iNumTrozos = ((Group)Node1).getChildCount();
        if (this.m_iNumTrozos > 3) {
            this.m_NodeTrozo = new Node[this.m_iNumTrozos];
            this.m_NodeGeo = new Node[this.m_iNumTrozos];
            float[] aExtent = new float[3];
            float[] aOrigin = new float[3];
            this.m_vPosIni = new float[this.m_iNumTrozos][2];
            this.m_vPosFin = new float[this.m_iNumTrozos][2];
            for (int iIndex = 0; iIndex < this.m_iNumTrozos; ++iIndex) {
                this.m_NodeTrozo[iIndex] = (Node)Symbian.wworld_findNode((Object3D)Node1, Utils.GenerateID("Trozo" + (iIndex + 1) + "Transform"));
                this.m_NodeGeo[iIndex] = (Node)Symbian.wworld_findNode((Object3D)hTrackWorld, Utils.GenerateID("geo" + (iIndex + 1) + "Transform"));
                Utils.GetBoundingBox(this.m_World, (Object3D)this.m_NodeTrozo[iIndex], aExtent, aOrigin);
                this.m_vPosIni[iIndex][0] = aOrigin[0] - aExtent[0];
                this.m_vPosIni[iIndex][1] = aOrigin[1] - aExtent[1];
                this.m_vPosFin[iIndex][0] = aOrigin[0] + aExtent[0];
                this.m_vPosFin[iIndex][1] = aOrigin[1] + aExtent[1];
            }
        }
        hTrackWorld = null;
        Node1 = null;
        if (this.m_iKindOfRace == 2) {
            try {
                this.m_PowerUps = new PowerUp(p_World, p_TRaceInfo, this.m_Car);
            }
            catch (NullPointerException e) {}
        } else {
            this.m_PowerUps = null;
        }
        this.reset();
    }

    void reset() {
        int iIndex;
        for (iIndex = 0; iIndex < 4; ++iIndex) {
            this.m_LapCounter[iIndex] = -1;
            this.m_isFinished[iIndex] = false;
            this.m_iCarPos[iIndex] = iIndex;
        }
        for (iIndex = 0; iIndex < 12; ++iIndex) {
            this.m_LapTime[iIndex] = 0;
        }
        if (this.m_iNumTrozos > 3) {
            this.m_iCurrentTrozo = 0;
            this.m_iPrevTrozo = this.m_iNumTrozos - 1;
            this.m_iNextTrozo = 1;
            this.visInvisDistancings();
        }
        this.m_bContra = false;
        if (this.m_PowerUps != null) {
            this.m_PowerUps.reset();
        }
        this.m_iColisionFrameCountDown = 0;
        this.m_iCross = 0;
        this.m_iAITurn = 0;
        this.m_bNotifyChangeCamera = false;
        this.m_bMustStop = false;
        this.m_bNoWayOut = false;
    }

    void notifyChangeCamera() {
        this.m_bNotifyChangeCamera = true;
    }

    void setBombChaseTime(int aTime) {
        this.m_iBombChaseTimeout = aTime;
    }

    void addUserCar(CCar p_bike) {
        this.m_Car[0] = p_bike;
        this.m_CarDyn[0] = p_bike.getDynTransform();
        ++this.m_iLastCar;
        if (this.m_PowerUps != null) {
            this.m_PowerUps.setTotalCars(this.m_iLastCar);
        }
    }

    void addAICar(CCarAI p_aibike) {
        if (this.m_iLastCar < 4) {
            this.m_Car[this.m_iLastCar] = p_aibike;
            this.m_CarDyn[this.m_iLastCar] = p_aibike.getDynTransform();
            ++this.m_iLastCar;
            if (this.m_PowerUps != null) {
                this.m_PowerUps.setTotalCars(this.m_iLastCar);
            }
        }
    }

    int getTotalCars() {
        return this.m_iLastCar;
    }

    void visInvisDistancings() {
        Node[] a_NodeTrozo = this.m_NodeTrozo;
        Node[] a_NodeGeo = this.m_NodeGeo;
        for (int aIndex = 0; aIndex < this.m_iNumTrozos; ++aIndex) {
            if (!a_NodeTrozo[aIndex].isRenderingEnabled()) continue;
            a_NodeTrozo[aIndex].setRenderingEnable(false);
            if (a_NodeGeo[aIndex] == null) continue;
            a_NodeGeo[aIndex].setRenderingEnable(false);
        }
        a_NodeTrozo[this.m_iPrevTrozo].setRenderingEnable(true);
        if (a_NodeGeo[this.m_iPrevTrozo] != null) {
            a_NodeGeo[this.m_iPrevTrozo].setRenderingEnable(true);
        }
        a_NodeTrozo[this.m_iCurrentTrozo].setRenderingEnable(true);
        if (a_NodeGeo[this.m_iCurrentTrozo] != null) {
            a_NodeGeo[this.m_iCurrentTrozo].setRenderingEnable(true);
        }
        a_NodeTrozo[this.m_iNextTrozo].setRenderingEnable(true);
        if (a_NodeGeo[this.m_iNextTrozo] != null) {
            a_NodeGeo[this.m_iNextTrozo].setRenderingEnable(true);
        }
    }

    boolean vectorInside(float[] pVector, float[] vPosFin, float[] vPosIni) {
        return !(pVector[1] > vPosFin[1] || pVector[1] < vPosIni[1] || pVector[0] > vPosFin[0]) && !(pVector[0] < vPosIni[0]);
    }

    void manageGeoVisibility(float[] aPos) {
        int p_iAnt = this.m_iCurrentTrozo;
        if (!this.vectorInside(aPos, this.m_vPosFin[this.m_iCurrentTrozo], this.m_vPosIni[this.m_iCurrentTrozo])) {
            this.m_iCurrentTrozo = this.vectorInside(aPos, this.m_vPosFin[this.m_iNextTrozo], this.m_vPosIni[this.m_iNextTrozo]) ? this.m_iNextTrozo : this.m_iPrevTrozo;
            if (this.m_iCurrentTrozo == 0) {
                this.m_iNextTrozo = 1;
                this.m_iPrevTrozo = this.m_iNumTrozos - 1;
            } else if (this.m_iCurrentTrozo >= this.m_iNumTrozos - 1) {
                this.m_iNextTrozo = 0;
                this.m_iPrevTrozo = this.m_iNumTrozos - 2;
            } else {
                this.m_iNextTrozo = this.m_iCurrentTrozo + 1;
                this.m_iPrevTrozo = this.m_iCurrentTrozo - 1;
            }
        }
        if (p_iAnt != this.m_iCurrentTrozo) {
            this.visInvisDistancings();
        }
    }

    int convertCPDistanceToReal(int iDifDist) {
        if (iDifDist > 0) {
            while ((float)iDifDist > (float)this.m_Colisions.getTrackDistanceCP() * 0.5f) {
                iDifDist -= this.m_Colisions.getTrackDistanceCP();
            }
        } else {
            while ((float)iDifDist < -((float)this.m_Colisions.getTrackDistanceCP() * 0.5f)) {
                iDifDist += this.m_Colisions.getTrackDistanceCP();
            }
        }
        return iDifDist;
    }

    void update(int p_ElapsedRaceTime) {
        CCarBase[] aCar = this.m_Car;
        int[] a_Distan = this.m_iTotalDistan;
        int[] a_CarPos = this.m_iCarPos;
        this.m_iAITurn = this.m_iAITurn + 1 < this.m_iLastCar ? ++this.m_iAITurn : 1;
        CCar aUserCar = (CCar)aCar[0];
        boolean bDrivingBackguards = aUserCar.isDrivingBackwards();
        if (this.m_bDrivingBackguards != bDrivingBackguards) {
            this.m_bNotifyChangeCamera = true;
            this.m_bDrivingBackguards = bDrivingBackguards;
        }
        if (this.m_iKindOfRace == 3 && p_ElapsedRaceTime >= this.m_iBombChaseTimeout) {
            for (int i = 0; i < this.m_iLastCar; ++i) {
                this.m_isFinished[i] = true;
                aCar[i].setHasFinishedRace();
            }
            return;
        }
        for (int i = 0; i < this.m_iLastCar; ++i) {
            a_Distan[i] = i == 0 ? (aCar[i].getLap() == 0 ? aCar[i].getCPInLapDistancia() - this.m_Colisions.getTrackDistanceCP() : aCar[i].getCPDistancia()) : aCar[i].getCPDistancia();
            a_CarPos[i] = i;
            if (i == 0) {
                if (this.m_iNumTrozos > 3) {
                    aCar[i].getPosXY(this.m_fPosXY_1);
                    this.manageGeoVisibility(this.m_fPosXY_1);
                }
                if (p_ElapsedRaceTime == 0) {
                    return;
                }
            } else if (i == this.m_iAITurn || this.m_bNotifyChangeCamera) {
                CCarAI aAICar = (CCarAI)aCar[i];
                aAICar.getPosXY(this.m_fPosXY_2);
                aAICar.replacing((int)((this.m_fPosXY_1[0] - this.m_fPosXY_2[0]) * (this.m_fPosXY_1[0] - this.m_fPosXY_2[0]) + (this.m_fPosXY_1[1] - this.m_fPosXY_2[1]) * (this.m_fPosXY_1[1] - this.m_fPosXY_2[1])), this.m_bDrivingBackguards);
                if (i == this.m_iAITurn && this.m_iKindOfRace != 3 || aUserCar.hasTheBomb()) {
                    this.manageAIAbility(aUserCar, aAICar, a_Distan[i], a_Distan[0]);
                }
            }
            if (this.m_iKindOfRace == 3 || this.m_isFinished[i]) continue;
            this.manageLapsAndTimes(i, aCar[i], p_ElapsedRaceTime);
        }
        if (this.m_iLastCar > 1) {
            Utils.burbuja(this.m_iLastCar, true, a_Distan, a_CarPos);
            int iIndexUserCar = 0;
            int iIndexPrev = -1;
            int iIndexNext = -1;
            for (int aIndex = 0; aIndex < this.m_iLastCar; ++aIndex) {
                this.m_Window.setPos(a_CarPos[aIndex], aIndex + 1);
                if (a_CarPos[aIndex] != 0) continue;
                if (aIndex == 0) {
                    iIndexPrev = aIndex + 1;
                } else if (aIndex == this.m_iLastCar - 1) {
                    iIndexNext = aIndex - 1;
                } else {
                    iIndexPrev = aIndex + 1;
                    iIndexNext = aIndex - 1;
                }
                iIndexUserCar = aIndex;
            }
            if (this.m_iKindOfRace == 3) {
                this.manageBombChase(aCar, a_CarPos, a_Distan);
            } else {
                if (this.m_iColisionFrameCountDown > 0) {
                    --this.m_iColisionFrameCountDown;
                }
                for (int iIndex = 0; iIndex < this.m_iLastCar; ++iIndex) {
                    if (a_CarPos[iIndex] == 0 || !(MyMath.fabs(a_Distan[iIndexUserCar] - a_Distan[iIndex]) > (float)this.m_Colisions.getTrackDistanceCP() * 0.5f - (float)(100 * iIndex))) continue;
                    aCar[a_CarPos[iIndex]].forceSpeed(0.0f);
                }
                if (iIndexPrev != -1) {
                    this.manageColisionsWithAI(aUserCar, (CCarAI)aCar[a_CarPos[iIndexPrev]], true, MyMath.fabs(this.convertCPDistanceToReal(a_Distan[iIndexUserCar] - a_Distan[iIndexPrev])));
                }
                if (iIndexNext != -1) {
                    this.manageColisionsWithAI(aUserCar, (CCarAI)aCar[a_CarPos[iIndexNext]], false, MyMath.fabs(this.convertCPDistanceToReal(a_Distan[iIndexUserCar] - a_Distan[iIndexNext])));
                }
                if (this.m_PowerUps != null) {
                    this.managePowerUps(aCar, a_CarPos, a_Distan, p_ElapsedRaceTime);
                }
            }
        }
        if (this.m_bNotifyChangeCamera) {
            this.m_bNotifyChangeCamera = false;
        }
    }

    private void manageColisionsWithAI(CCar aUserCar, CCarAI aAICar, boolean pbDelante, float aDif) {
        if (aDif >= 240.0f) {
            if (MyMath.fabs(aAICar.getProgressDisplacementX()) < 5.0E-4f) {
                aAICar.setProgressDisplacementX(0.0f);
            } else {
                aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() * 0.95f);
            }
        } else {
            float aUserDTC = aUserCar.distanceToCenterTrack();
            float aAIDTC = aAICar.distanceToCenterTrack();
            if (this.m_iKindOfRace != 3 && aDif < 60.0f && MyMath.fabs(aUserDTC - aAIDTC) < 0.15f) {
                if (!pbDelante) {
                    aUserCar.forceSpeed(aAICar.getSpeed() * 0.65f);
                    aAICar.forceSpeed(aAICar.getSpeed() * 0.96f);
                } else {
                    aAICar.forceSpeed(aUserCar.getSpeed() * 0.65f);
                    aUserCar.forceSpeed(aUserCar.getSpeed() * 0.96f);
                }
                if (aAICar.distanceToCenterTrack() < 0.0f) {
                    if (aUserCar.distanceToCenterTrack() < aAICar.distanceToCenterTrack()) {
                        aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() - 0.075f);
                    } else {
                        aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() + 0.075f);
                    }
                } else if (aUserCar.distanceToCenterTrack() > aAICar.distanceToCenterTrack()) {
                    aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() + 0.075f);
                } else {
                    aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() - 0.075f);
                }
                if (GameSettings.m_bVibra && this.m_iColisionFrameCountDown == 0) {
                    aUserCar.vibrate(250);
                }
                TData.GetCanvas().manageInRaceSound(2);
                this.m_iColisionFrameCountDown = 10;
                aUserCar.adjustGear();
            } else if (pbDelante || !pbDelante && aDif < 9.0f) {
                if (!pbDelante && aDif > 4.0f) {
                    aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() * 0.75f);
                } else if (MyMath.fabs(aUserCar.distanceToCenterTrack() - aAICar.distanceToCenterTrack()) < 0.2f) {
                    if (aUserCar.distanceToCenterTrack() < -0.325f) {
                        aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() - 0.035f);
                    } else if (aUserCar.distanceToCenterTrack() > 0.325f) {
                        aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() + 0.035f);
                    } else if (aUserCar.distanceToCenterTrack() > 0.0f) {
                        if (aAICar.distanceToCenterTrack() > aUserCar.distanceToCenterTrack()) {
                            aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() - 0.035f);
                        } else {
                            aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() + 0.035f);
                        }
                    } else if (aAICar.distanceToCenterTrack() < aUserCar.distanceToCenterTrack()) {
                        aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() + 0.035f);
                    } else {
                        aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() - 0.035f);
                    }
                }
            } else if (MyMath.fabs(aAICar.getProgressDisplacementX()) < 5.0E-4f) {
                aAICar.setProgressDisplacementX(0.0f);
            } else {
                aAICar.setProgressDisplacementX(aAICar.getProgressDisplacementX() * 0.95f);
            }
        }
    }

    private void swapTheBomb(CCar aUser, CCarAI aAI) {
        if (GameSettings.m_bVibra) {
            TData.GetDisplay().vibrate(250);
        }
        TData.GetCanvas().manageInRaceSound(2);
        if (aUser.hasTheBomb()) {
            aAI.setRollingOver();
            aAI.setBombed(true);
            aUser.setBombed(false);
        } else {
            aUser.setRollingOver();
            aUser.setBombed(true);
            aAI.setBombed(false);
        }
        this.m_bNoWayOut = false;
    }

    private void manageBombChase(CCarBase[] aCar, int[] a_CarPos, int[] a_Distan) {
        int iDifDist;
        boolean bDesplaX = false;
        CCar aUser = (CCar)aCar[0];
        CCarAI aAI = (CCarAI)aCar[1];
        if (a_CarPos[0] == 0) {
            iDifDist = a_Distan[0] - a_Distan[1];
        } else {
            iDifDist = a_Distan[1] - a_Distan[0];
            while ((float)iDifDist < -((float)this.m_Colisions.getTrackDistanceCP() * 0.5f)) {
                iDifDist += this.m_Colisions.getTrackDistanceCP();
            }
        }
        float aUserDTC = aUser.distanceToCenterTrack();
        float aAIDTC = aAI.distanceToCenterTrack();
        int iDifDistAbs = MyMath.iabs(iDifDist);
        if (!aUser.rollingOver() && !aAI.rollingOver()) {
            if (iDifDistAbs < 1200) {
                if (MyMath.fabs(aUserDTC - aAIDTC) < 0.15f && iDifDistAbs < 60) {
                    this.swapTheBomb(aUser, aAI);
                } else if (aUser.hasTheBomb()) {
                    if (iDifDist > -100) {
                        this.manageColisionsWithAI(aUser, aAI, true, iDifDistAbs);
                    } else if (this.m_iCross != 0) {
                        bDesplaX = true;
                        if (aAIDTC * (float)this.m_iCross < 0.01f) {
                            aAI.setProgressDisplacementX(aAI.getProgressDisplacementX() - 0.04f * (float)this.m_iCross);
                        } else {
                            this.m_iCross = 0;
                        }
                    } else if (MyMath.fabs(aUserDTC - aAIDTC) < 0.2f) {
                        float fDesplaX = iDifDistAbs < 200 ? 0.035f : (iDifDistAbs < 400 ? 0.025f : 0.015f);
                        bDesplaX = true;
                        if (aAIDTC < -0.55f) {
                            this.m_iCross = 1;
                        } else if (aAIDTC > 0.55f) {
                            this.m_iCross = -1;
                        } else if (aAIDTC > aUserDTC) {
                            aAI.setProgressDisplacementX(aAI.getProgressDisplacementX() - fDesplaX);
                        } else {
                            aAI.setProgressDisplacementX(aAI.getProgressDisplacementX() + fDesplaX);
                        }
                    }
                } else {
                    if (aUser.getGear() == 0 || aUser.getSpeed() == 0.0f) {
                        aUser.shiftGearUp();
                    }
                    if (iDifDist < 0 && !this.m_bMustStop) {
                        this.m_bMustStop = true;
                    }
                    if (this.m_bMustStop) {
                        aAI.forceSpeed(0.0f);
                        aAI.setAbility(aAI.getInitialAbility());
                        if (iDifDist > 150) {
                            this.m_bMustStop = false;
                        }
                    } else {
                        float fUserSpeed;
                        if (aAI.getAbility() > aAI.getInitialAbility() + aAI.getIncAbility()) {
                            aAI.setAbility(aAI.getInitialAbility() + aAI.getIncAbility());
                        }
                        if (MyMath.fabs(aUserDTC - aAIDTC) > 0.01f) {
                            float fFactor = iDifDistAbs < 100 ? 0.3f : (iDifDistAbs < 300 ? 0.2f : (iDifDistAbs < 500 ? 0.1f : 0.05f));
                            aAI.setProgressDisplacementX(aAI.getProgressDisplacementX() - (aUserDTC - aAIDTC) * fFactor);
                        }
                        float f = fUserSpeed = aUser.getSpeed() < 5.0f ? 5.0f : aUser.getSpeed();
                        if (!this.m_bNoWayOut && iDifDist < 100) {
                            if (iDifDist < 60) {
                                aAI.forceSpeed(aUser.getSpeed());
                            } else {
                                aAI.forceSpeed(aUser.getSpeed() + 1.0f);
                            }
                        } else if (this.m_bNoWayOut) {
                            if (iDifDist > 100) {
                                if (fUserSpeed > 20.0f) {
                                    aAI.forceSpeed(fUserSpeed + (float)iDifDistAbs * 0.06f);
                                } else {
                                    aAI.forceSpeed(fUserSpeed + (float)iDifDistAbs * 0.1f);
                                }
                            } else {
                                aAI.forceSpeed(fUserSpeed + 5.0f);
                            }
                        } else if (iDifDist > 200) {
                            if (fUserSpeed > 20.0f) {
                                aAI.forceSpeed(fUserSpeed + (float)iDifDistAbs * 0.01f);
                            } else {
                                aAI.forceSpeed(fUserSpeed + (float)iDifDistAbs * 0.02f);
                            }
                            if (aAI.getAbility() < aAI.getInitialAbility() + aAI.getIncAbility() * 0.005f) {
                                aAI.setAbility(aAI.getAbility() + (float)iDifDistAbs * 1.0E-4f);
                            }
                        } else {
                            aAI.setAbility(aAI.getInitialAbility());
                        }
                    }
                }
            } else if (aAI.hasTheBomb()) {
                if (aAI.getSpeed() < aUser.getSpeed()) {
                    aAI.forceSpeed(aUser.getSpeed() * 1.25f);
                }
                aAI.setAbility(aAI.getInitialAbility() * 1.25f);
            }
        } else if (aAI.rollingOver()) {
            if (aAI.getSpeed() > aUser.getSpeed()) {
                aAI.forceSpeed(aUser.getSpeed() * 0.95f);
            } else {
                aAI.forceSpeed(aAI.getSpeed() * 0.95f);
            }
            if (iDifDistAbs > 250) {
                aAI.stopRollingOver();
            }
        } else if (aUser.rollingOver() && iDifDistAbs > 250) {
            aUser.stopRollingOver();
        }
        if (!bDesplaX) {
            if (MyMath.fabs(aAI.getProgressDisplacementX()) > 5.0E-4f) {
                aAI.setProgressDisplacementX(aAI.getProgressDisplacementX() * 0.95f);
            } else {
                aAI.setProgressDisplacementX(0.0f);
            }
        }
    }

    private void manageLapsAndTimes(int i, CCarBase aCar, int p_ElapsedRaceTime) {
        int[] a_LapCounter = this.m_LapCounter;
        int[] a_LapTime = this.m_LapTime;
        if (aCar.getLap() != a_LapCounter[i] && aCar.getLap() > a_LapCounter[i]) {
            a_LapCounter[i] = aCar.getLap();
            int lap = a_LapCounter[i] - 1;
            int bike = i * 3;
            int lap_1 = lap - 1;
            if (lap > 0) {
                a_LapTime[bike + lap_1] = p_ElapsedRaceTime;
                long tot = 0L;
                for (int iii = 0; iii < lap_1; ++iii) {
                    tot += (long)a_LapTime[bike + iii];
                }
                int n = bike + lap_1;
                a_LapTime[n] = (int)((long)a_LapTime[n] - tot);
                if (lap == 3) {
                    this.m_isFinished[i] = true;
                    if (i == 0) {
                        aCar.setHasFinishedRace();
                    }
                }
                if (i == 0 && lap == 2) {
                    ((Node)this.m_World.find(848828591)).setRenderingEnable(false);
                    ((Node)this.m_World.find(714530118)).setRenderingEnable(true);
                }
            }
        }
    }

    private void manageAIAbility(CCar aUserCar, CCarAI AICar, int distAI, int distUser) {
        int iDistance = distUser - distAI;
        int iAbsDistance = MyMath.iabs(iDistance);
        if (iAbsDistance < 4000) {
            if (iAbsDistance > 2000) {
                if (distUser > distAI) {
                    if (AICar.getAbility() > AICar.getInitialAbility() + AICar.getIncAbility()) {
                        AICar.setAbility(AICar.getAbility() + AICar.getIncAbility());
                    } else {
                        if (AICar.getAbility() < AICar.getInitialAbility()) {
                            AICar.setAbility(AICar.getInitialAbility());
                        }
                        AICar.setAbility(AICar.getAbility() + 0.01f);
                    }
                } else if (AICar.getAbility() < AICar.getInitialAbility() - AICar.getDecAbility()) {
                    AICar.setAbility(AICar.getInitialAbility() - AICar.getDecAbility());
                } else {
                    if (AICar.getAbility() > AICar.getInitialAbility()) {
                        AICar.setAbility(AICar.getInitialAbility());
                    }
                    AICar.setAbility(AICar.getAbility() - 0.01f);
                }
            } else {
                AICar.setAbility(AICar.getInitialAbility() + (float)(distUser - distAI) * 2.0E-4f);
                if (AICar.getAbility() > AICar.getInitialAbility() + AICar.getIncAbility()) {
                    AICar.setAbility(AICar.getInitialAbility() + AICar.getIncAbility());
                } else if (AICar.getAbility() < AICar.getInitialAbility() - AICar.getDecAbility()) {
                    AICar.setAbility(AICar.getInitialAbility() - AICar.getDecAbility());
                }
                if (iDistance < 500 && iDistance > -150 && !aUserCar.rollingOver()) {
                    if (AICar.getSpeed() - aUserCar.getSpeed() > 9.0f) {
                        AICar.forceSpeed(aUserCar.getSpeed() + 9.0f);
                    }
                } else if (aUserCar.rollingOver() && AICar.getSpeed() - aUserCar.getSpeed() > 18.0f) {
                    AICar.forceSpeed(aUserCar.getSpeed() + 18.0f);
                }
            }
        } else if (distUser > distAI) {
            if (AICar.getAbility() < AICar.getInitialAbility() + AICar.getIncAbility()) {
                AICar.setAbility(AICar.getInitialAbility() + AICar.getIncAbility() + 0.5f);
            }
        } else {
            AICar.setAbility(AICar.getInitialAbility() - AICar.getDecAbility() - 0.15f);
        }
    }

    private void managePowerUps(CCarBase[] avCar, int[] a_CarPos, int[] a_Distan, int iRaceTime) {
        PowerUp aPoweUps = this.m_PowerUps;
        for (int aIndex = 0; aIndex < this.m_iLastCar; ++aIndex) {
            int i = a_CarPos[aIndex];
            CCarBase aCar = avCar[i];
            if (!aCar.hasPowerUp()) {
                aCar.getPosition(this.l_vpos);
                int iKindOfPowerUp = aPoweUps.pickUp(this.l_vpos.x, this.l_vpos.y, i == 0 ? 0.5f : 1.0f);
                if (iKindOfPowerUp == 0) continue;
                aCar.setPowerUp(iKindOfPowerUp);
                if (i == 0) continue;
                aCar.setUsePowerUp();
                continue;
            }
            if (!aCar.getUsePowerUp()) continue;
            if (aCar.getPowerUp() == 1) {
                if (aCar.rocketInProgress()) continue;
                boolean bTarget = false;
                boolean bLaunchRocket = false;
                int iTagertCar = 0;
                if (i == 0 || (Utils.m_Random.nextInt() & 0xF) > 10) {
                    for (int iIndexTarget = 0; iIndexTarget < this.m_iLastCar; ++iIndexTarget) {
                        float fValue;
                        int j;
                        CCarBase aCarTarget;
                        int iDif;
                        if (iIndexTarget == aIndex || (iDif = (aCarTarget = avCar[j = a_CarPos[iIndexTarget]]).getCPInLapDistancia() - aCar.getCPInLapDistancia()) < 0 || (float)iDif > 700.0f) continue;
                        if (i == 0) {
                            // empty if block
                        }
                        if (!((fValue = (float)iDif * 0.0014285714f) < 1.0f)) continue;
                        float fAngle = MyMath.fabs(aCar.angleToCar(aCarTarget));
                        if (i != 0) {
                            if (!(fAngle < 0.07f)) continue;
                            bLaunchRocket = true;
                            if ((Utils.m_Random.nextInt() & 0xF) <= 3) continue;
                            bTarget = true;
                            iTagertCar = j;
                            break;
                        }
                        if (!(fAngle < 0.054f * (1.25f - fValue))) continue;
                        bTarget = true;
                        iTagertCar = j;
                        break;
                    }
                }
                if (!bTarget && !bLaunchRocket && i != 0) continue;
                if (bTarget) {
                    // empty if block
                }
                TData.GetCanvas().manageInRaceSound(3);
                aPoweUps.launchRocket(i, iTagertCar, bTarget, iRaceTime);
                aCar.powerUpUsed();
                continue;
            }
            if (i != 0 && (Math.abs(Utils.m_Random.nextInt()) & 0xF) != 7) continue;
            aPoweUps.throwOil(i, iRaceTime);
            aCar.powerUpUsed();
        }
        aPoweUps.update(iRaceTime);
        aPoweUps.notify(this.m_Window);
    }

    int getCurrentLap(int p_Car) {
        return this.m_LapCounter[p_Car];
    }

    int getLapTime(int p_Car, int p_Lap) {
        if (p_Lap > 0 && p_Lap <= 3) {
            return this.m_LapTime[p_Car * 3 + (p_Lap - 1)];
        }
        return 0;
    }

    int getTotalTime(int p_Car) {
        int tot = 0;
        for (int i = 0; i < 3; ++i) {
            tot += this.m_LapTime[p_Car * 3 + i];
        }
        return tot;
    }

    synchronized void calculateOrderAndGetRaceTimes(TRaceTimes p_tCarrera) {
        int[] t = new int[4];
        int[] indices = new int[4];
        CCar UserCar = (CCar)this.m_Car[0];
        long iUserTime = this.getTotalTime(0);
        float iUSerDist = UserCar.getCPDistancia();
        int i = this.m_iLastCar;
        while (--i >= 0) {
            long tval = 0L;
            if (this.m_isFinished[i]) {
                tval = this.getTotalTime(i);
            } else if (i > 0) {
                CCarAI AICar = (CCarAI)this.m_Car[i];
                float aidist = AICar.getCPDistancia();
                if (aidist >= iUSerDist) {
                    aidist = iUSerDist - (float)MyMath.iabs(Utils.m_Random.nextInt() & 0xFFF) - 250.0f;
                }
                float iDifDist = iUSerDist - aidist;
                tval = iUserTime + (long)((float)iUserTime * (iDifDist / iUSerDist));
            }
            t[i] = (int)tval;
            indices[i] = i;
        }
        Utils.burbuja(this.m_iLastCar, false, t, indices);
        int[] viPtos = new int[]{10, 6, 3, 1};
        int i2 = this.m_iLastCar;
        while (--i2 >= 0) {
            p_tCarrera.viCarIndex[i2] = indices[i2];
            p_tCarrera.viTimes[i2] = t[i2];
        }
        t = null;
        indices = null;
        viPtos = null;
    }

    public void destroy() {
        int iIndex;
        for (iIndex = 0; iIndex < 4; ++iIndex) {
            this.m_Car[iIndex] = null;
            this.m_CarDyn[iIndex] = null;
        }
        this.m_Car = null;
        this.m_CarDyn = null;
        for (iIndex = 0; iIndex < this.m_iNumTrozos; ++iIndex) {
            this.m_NodeTrozo[iIndex] = null;
            this.m_NodeGeo[iIndex] = null;
        }
        this.m_NodeTrozo = null;
        this.m_NodeGeo = null;
        this.m_vPosIni = null;
        this.m_vPosFin = null;
        this.l_vposparent = null;
        this.l_vpos2 = null;
        this.l_vpos = null;
        this.m_fPosXY_2 = null;
        this.m_fPosXY_1 = null;
        this.m_iTotalDistan = null;
        this.m_iCarPos = null;
        this.m_iOrden = null;
        this.m_LapCounter = null;
        this.m_LapTime = null;
        this.m_isFinished = null;
        if (this.m_PowerUps != null) {
            this.m_PowerUps.destroy();
            this.m_PowerUps = null;
        }
        this.m_Window = null;
        this.m_Colisions = null;
        this.m_World = null;
    }
}

