/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public final class Data {
    public static final byte PERFRAME = 24;
    public static final byte TILESIZE = 24;
    public static final byte POS_X = 0;
    public static final byte POS_Y = 1;
    public static final byte LEV_MAP = 0;
    public static final byte LEV_MAPON = 3;
    public static final byte LEV_FIRE = 5;
    public static final byte LEV_ENEMY = 10;
    public static final byte LEV_ROLEBULLET = 15;
    public static final byte LEV_BULLETGUANG = 20;
    public static final byte LEV_SON = 25;
    public static final byte LEV_ROLE = 30;
    public static final byte LEV_ENEMYBULLET = 35;
    public static final byte LEV_EFFECT = 40;
    public static final byte LEV_ITEM = 45;
    public static final byte LEV_UI = 100;
    public static final byte LEV_TALK = 120;
    public static RoleAllData[] gameRoleData;
    public static RoleAllData[] gameRoleData2;
    public static RoleAllData[] gameRoleData3;
    public static EnemyAllData[] gameEnemyData;
    public static FireAllData[] fireAllData;
    public static PlaneData[] planeData;
    public static MachineAllData[] machineAllData;
    public static ShotAllData[] shotAllData;
    public static BulletAllData[] bulletAllData;
    public static MapAllData[] mapAllData;
    public static AIAllData[] aiAllData;
    public static BombAllData[] bombAllData;
    public static QueueData[] planeQueueAllData;
    public static RankAllData[] rankAllData;
    public static ItemAllData[] itemAllData;
    static final short L_BG = 0;
    static final short L_ROLE = 1000;
    static final short L_EFECT = 2000;
    static final short L_FG = 3000;
    static final short L_MASK = 4000;
    static final short L_INTERFACE = 5000;
    static final short L_TALK = 6000;
    static final short L_INFO = 7000;
    static final short L_MAX = 8000;
    static byte[][][] spriteClipData;
    static byte[][][] spriteFrameData;
    static byte[][][][] spriteMotionData;
    static byte[][][] effectClipData;
    static byte[][][] effectFrameData;
    static byte[][][][] effectMotionData;
    static byte[][][] bulletClipData;
    static byte[][][] bulletFrameData;
    static byte[][][][] bulletMotionData;
    static byte[][][] headClipData;
    static byte[][][] headFrameData;
    static byte[][][][] headMotionData;
    static String[] files;
    static int[] offsetArray;
    static final byte DATA_CLIP = 0;
    static final byte DATA_FRAME = 1;
    static final byte DATA_MOTION = 2;
    static final byte DATA_OFFSET = 3;
    static short curMapFileName;

    public static void initRoleAllData() {
        gameRoleData = new RoleAllData[1];
        Data.gameRoleData[0] = new RoleAllData(0, 0, 30, 18, 25, 15, 55, 50, 0, new short[]{0}, new short[]{0, 1}, new short[]{0});
    }

    public static RoleAllData getRoleAllData(int id, int getRoleAllDataIndex) {
        RoleAllData[] tmpData = getRoleAllDataIndex == 0 ? gameRoleData : (getRoleAllDataIndex == 1 ? gameRoleData2 : gameRoleData3);
        int i = 0;
        while (i < tmpData.length) {
            if (tmpData[i].getId() == id) {
                return tmpData[i];
            }
            ++i;
        }
        return null;
    }

    public static void initEnemyAllData() {
        gameEnemyData = new EnemyAllData[1];
        Data.gameEnemyData[0] = new EnemyAllData(0, 3, 25, 20, 1, new short[]{3}, new short[]{0}, new short[]{0}, new short[]{0}, new short[]{0});
    }

    public static void initFireAllData() {
        fireAllData = new FireAllData[2];
        Data.fireAllData[0] = new FireAllData(0, 16, 0, -15, 15);
        Data.fireAllData[1] = new FireAllData(0, 16, 0, -15, 15);
    }

    public static EnemyAllData getEnemyAllData(int id) {
        int i = 0;
        while (i < gameEnemyData.length) {
            if (gameEnemyData[i].getId() == id) {
                return gameEnemyData[i];
            }
            ++i;
        }
        return null;
    }

    public static void initPlaneData() {
        planeData = new PlaneData[2];
        Data.planeData[0] = new PlaneData(0, 120, 280, 100, 10, 10, 5, 5);
        Data.planeData[1] = new PlaneData(1, 120, 50, 100, 10, 10, 5, 5);
    }

    public static void initMachineAllData() {
        machineAllData = new MachineAllData[1];
        Data.machineAllData[0] = new MachineAllData(0, 0, -5, 0, 0, 0, 0, 10, -1, 10, new short[]{-1});
    }

    public static void initShotAllData() {
        shotAllData = new ShotAllData[ShotScript.shotScript.length];
        int i = 0;
        while (i < ShotScript.shotScript.length) {
            short[] id = new short[ShotScript.shotScript[i].length];
            short[] x = new short[ShotScript.shotScript[i].length];
            short[] y = new short[ShotScript.shotScript[i].length];
            short[] angle = new short[ShotScript.shotScript[i].length];
            short[] speed = new short[ShotScript.shotScript[i].length];
            byte[] delayTime = new byte[ShotScript.shotScript[i].length];
            byte[] maxTime = new byte[ShotScript.shotScript[i].length];
            short[] addSpeed = new short[ShotScript.shotScript[i].length];
            short[] addSpeedMax = new short[ShotScript.shotScript[i].length];
            byte[] isRoleX = new byte[ShotScript.shotScript[i].length];
            int j = 0;
            while (j < ShotScript.shotScript[i].length) {
                id[j] = ShotScript.shotScript[i][j][1];
                x[j] = ShotScript.shotScript[i][j][2];
                y[j] = ShotScript.shotScript[i][j][3];
                angle[j] = ShotScript.shotScript[i][j][4];
                speed[j] = ShotScript.shotScript[i][j][5];
                delayTime[j] = (byte)ShotScript.shotScript[i][j][6];
                maxTime[j] = (byte)ShotScript.shotScript[i][j][7];
                addSpeed[j] = ShotScript.shotScript[i][j][8];
                addSpeedMax[j] = ShotScript.shotScript[i][j][9];
                isRoleX[j] = (byte)ShotScript.shotScript[i][j][10];
                ++j;
            }
            Data.shotAllData[i] = new ShotAllData(i, id, x, y, angle, speed, delayTime, maxTime, addSpeed, addSpeedMax, isRoleX);
            ++i;
        }
    }

    public static void initBulletAllData() {
        bulletAllData = new BulletAllData[9];
        Data.bulletAllData[0] = new BulletAllData(0, 0, 0, 0, 0, 15, 19, 0, -10, 0, 10, 0);
        Data.bulletAllData[1] = new BulletAllData(1, 1, 1, 0, 0, 10, 20, 0, -10, 0, 10, 0);
        Data.bulletAllData[2] = new BulletAllData(2, 2, 1, 0, 0, 15, 14, 0, -10, 0, 10, 0);
        Data.bulletAllData[3] = new BulletAllData(3, 3, 1, 0, 0, 10, 10, 0, -10, 0, 10, 0);
        Data.bulletAllData[4] = new BulletAllData(4, 4, 1, 0, 0, 31, 32, 0, -10, 0, 10, 0);
        Data.bulletAllData[5] = new BulletAllData(5, 5, 1, 0, 0, 9, 9, 0, -10, 0, 10, 0);
        Data.bulletAllData[6] = new BulletAllData(6, 6, 1, 0, 0, 24, 240, 0, 0, 0, 10, 0);
        Data.bulletAllData[7] = new BulletAllData(7, 7, 0, 0, 0, 126, 106, 0, 0, 0, 9, 0);
        Data.bulletAllData[8] = new BulletAllData(8, 4, 1, 0, 0, 31, 32, 0, -10, 0, 10, 10, 120, 0);
    }

    public static void initMapAllData() {
        mapAllData = new MapAllData[6];
        Data.mapAllData[0] = new MapAllData(0, 0, 0, 0, 240, 240, 0, 3, MapAllData.MAP_MOVEDOWN, 0, 0, 0, 10);
        Data.mapAllData[1] = new MapAllData(0, 0, 0, 0, 240, 240, 0, 3, MapAllData.MAP_MOVEDOWN, 3, 0, 0, 10);
        Data.mapAllData[2] = new MapAllData(0, 0, 0, 0, 240, 240, 0, 3, MapAllData.MAP_MOVEDOWN, 7, 0, 0, 10);
        Data.mapAllData[3] = new MapAllData(0, 0, 0, 0, 240, 177, 0, 1, MapAllData.MAP_MOVEDOWN, 14, 0, 0, 10);
        Data.mapAllData[4] = new MapAllData(0, 0, 0, 0, 240, 240, 0, 1, MapAllData.MAP_MOVEDOWN, 9, 0, 0, 10);
    }

    public static void initAIAllData() {
        System.out.println("aaaaaaaaaaa:" + AiScript.aiScript.length);
        aiAllData = new AIAllData[AiScript.aiScript.length];
        int i = 0;
        while (i < AiScript.aiScript.length) {
            Data.aiAllData[i] = new AIAllData(i, AiScript.aiScript[i]);
            ++i;
        }
    }

    public static void initBombAllData() {
        bombAllData = new BombAllData[1];
        Data.bombAllData[0] = new BombAllData(0, new short[]{7, 7, 7, 7, 7, 7}, new short[]{80, 160, 80, 160, 80, 160}, new short[]{280, 280, 180, 180, 80, 80}, new short[]{3, 3, 7, 7, 12, 12});
    }

    public static void initPlaneQueueAllData() {
        planeQueueAllData = new QueueData[1];
        Data.planeQueueAllData[0] = new QueueData(0, new short[]{0, 0, 0, 0, 0}, new byte[]{1, 1, 1, 1, 1}, new short[]{0, -30, -60, -90, -120}, new short[]{0, -30, -60, -90, -120}, new short[0], new short[0]);
    }

    public static QueueData getQueueData(int id) {
        int i = 0;
        while (i < planeQueueAllData.length) {
            if (planeQueueAllData[i].getQueueId() == id) {
                return planeQueueAllData[i];
            }
            ++i;
        }
        return null;
    }

    public static void initRankAllData() {
        rankAllData = new RankAllData[1];
        Data.rankAllData[0] = new RankAllData(0, 120, 30, 0);
    }

    public static void initItemAllData() {
        itemAllData = new ItemAllData[2];
        Data.itemAllData[0] = new ItemAllData(0, 6, 1, 0, 25, 36, 0, 2);
        Data.itemAllData[1] = new ItemAllData(1, 7, 1, 0, 14, 17, 0, 2);
    }

    private static void freeData(Object[] obj) {
        if (obj == null) {
            return;
        }
        int i = 0;
        while (i < obj.length) {
            obj[i] = null;
            ++i;
        }
    }

    static void freeSpriteData() {
        Data.freeData((Object[])spriteClipData);
        Data.freeData((Object[])spriteFrameData);
        Data.freeData((Object[])spriteMotionData);
    }

    static void freeEffectData() {
        Data.freeData((Object[])effectClipData);
        Data.freeData((Object[])effectFrameData);
        Data.freeData((Object[])effectMotionData);
    }

    static void loadSpriteData() {
        DataInputStream is = Tools.openFile("/data/sprite.pak");
        try {
            Data.openPack(is);
            if (spriteClipData == null) {
                int len = Data.getPackLen(files);
                spriteClipData = new byte[len][][];
                spriteFrameData = new byte[len][][];
                spriteMotionData = new byte[len][][][];
            }
            String[] sprite = new String[spriteClipData.length];
            int i = 0;
            while (i < sprite.length) {
                sprite[i] = i + "";
                ++i;
            }
            int[] oIndex = Data.strOrder(files, sprite);
            int skip = 0;
            int i2 = 0;
            while (i2 < oIndex.length) {
                int index = oIndex[i2];
                int pos = Integer.parseInt(files[index]);
                int offset = index == 0 ? 0 : offsetArray[index - 1];
                is.skip(offset - skip);
                Object[] obj = Data.getSpecialData(is);
                Data.spriteClipData[pos] = (byte[][])obj[0];
                Data.spriteFrameData[pos] = (byte[][])obj[1];
                Data.spriteMotionData[pos] = (byte[][][])obj[2];
                skip = offsetArray[index];
                ++i2;
            }
            is.close();
        }
        catch (Exception ex) {
            System.out.println("read sprite.pak error!");
            ex.printStackTrace();
        }
        files = null;
        offsetArray = null;
    }

    static void loadEffData() {
        DataInputStream is = Tools.openFile("/data/effect.pak");
        try {
            Data.openPack(is);
            if (effectClipData == null) {
                int len = Data.getPackLen(files);
                effectClipData = new byte[len][][];
                effectFrameData = new byte[len][][];
                effectMotionData = new byte[len][][][];
            }
            int i = 0;
            while (i < files.length) {
                Object[] obj = Data.getSpecialData(is);
                int index = Integer.parseInt(files[i]);
                Data.effectClipData[index] = (byte[][])obj[0];
                Data.effectFrameData[index] = (byte[][])obj[1];
                Data.effectMotionData[index] = (byte[][][])obj[2];
                ++i;
            }
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        files = null;
        offsetArray = null;
    }

    static void loadBulletData() {
        DataInputStream is = Tools.openFile("/data/bullet.pak");
        try {
            Data.openPack(is);
            if (bulletClipData == null) {
                int len = Data.getPackLen(files);
                bulletClipData = new byte[len][][];
                bulletFrameData = new byte[len][][];
                bulletMotionData = new byte[len][][][];
            }
            int i = 0;
            while (i < files.length) {
                Object[] obj = Data.getSpecialData(is);
                int index = Integer.parseInt(files[i]);
                Data.bulletClipData[index] = (byte[][])obj[0];
                Data.bulletFrameData[index] = (byte[][])obj[1];
                Data.bulletMotionData[index] = (byte[][][])obj[2];
                ++i;
            }
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        files = null;
        offsetArray = null;
    }

    static void loadHeadData(String[] sprite) {
        DataInputStream is = Tools.openFile("/data/head.pak");
        try {
            Data.openPack(is);
            if (headClipData == null) {
                int len = Data.getPackLen(files);
                headClipData = new byte[len][][];
                headFrameData = new byte[len][][];
                headMotionData = new byte[len][][][];
            }
            int[] oIndex = Data.strOrder(files, sprite);
            int skip = 0;
            int i = 0;
            while (i < oIndex.length) {
                int index = oIndex[i];
                int pos = Integer.parseInt(files[index]);
                int offset = index == 0 ? 0 : offsetArray[index - 1];
                is.skip(offset - skip);
                Object[] obj = Data.getSpecialData(is);
                Data.headClipData[pos] = (byte[][])obj[0];
                Data.headFrameData[pos] = (byte[][])obj[1];
                Data.headMotionData[pos] = (byte[][][])obj[2];
                skip = offsetArray[index];
                ++i;
            }
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        files = null;
        offsetArray = null;
    }

    static void loadDB() {
        DataInputStream is = Tools.openFile("/data/db.pak");
        try {
            Data.openPack(is);
            int i = 0;
            while (i < files.length) {
                if (files[i].equals("1_bullet")) {
                    Data.initBullet(is);
                } else if (files[i].equals("2_wuli")) {
                    Data.initPlaneData(is);
                } else if (files[i].equals("4_machine")) {
                    Data.initMachine(is);
                } else if (files[i].equals("5_fire")) {
                    Data.initFire(is);
                } else if (files[i].equals("6_role")) {
                    Data.initRole(is);
                } else if (files[i].equals("7_enemy")) {
                    Data.initEnemy(is);
                } else if (files[i].equals("8_bomb")) {
                    Data.initBomb(is);
                } else if (files[i].equals("9_queue")) {
                    Data.initQueue(is);
                } else if (files[i].equals("91_item")) {
                    Data.initItem(is);
                } else if (files[i].equals("92_role2")) {
                    Data.initRole2(is);
                } else if (files[i].equals("93_role3")) {
                    Data.initRole3(is);
                } else {
                    int offset = i == 0 ? 0 : offsetArray[i - 1];
                    is.skip(offsetArray[i] - offset);
                }
                ++i;
            }
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        files = null;
        offsetArray = null;
    }

    static void initBullet(DataInputStream dis) {
        try {
            short len = dis.readShort();
            Object strBuff = null;
            bulletAllData = new BulletAllData[len];
            int i = 0;
            while (i < bulletAllData.length) {
                Data.bulletAllData[i] = new BulletAllData();
                bulletAllData[i].setBulletId(dis.readShort());
                bulletAllData[i].setBulletImgId(dis.readByte());
                bulletAllData[i].setW(dis.readShort());
                bulletAllData[i].setH(dis.readShort());
                bulletAllData[i].setShotEndId((byte)dis.readShort());
                bulletAllData[i].setShotEndDistance(dis.readShort());
                bulletAllData[i].setBulletIsMirror(dis.readByte());
                bulletAllData[i].setIsDis(dis.readByte());
                bulletAllData[i].setBulletDrawLevel((byte)10);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("bullet data error!");
        }
    }

    static void initShot(DataInputStream dis) {
        int i = 0;
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            shotAllData = new ShotAllData[len];
            System.out.println("bbbbbbbbbbbbbb:" + len);
            i = 0;
            while (i < shotAllData.length) {
                Data.shotAllData[i] = new ShotAllData();
                shotAllData[i].setShotId(dis.readByte());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp3 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp3[j] = (byte)Integer.parseInt(params[j]);
                    ++j;
                }
                shotAllData[i].setBulletId(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j2 = 0;
                while (j2 < params.length) {
                    temp3[j2] = (short)Integer.parseInt(params[j2]);
                    ++j2;
                }
                shotAllData[i].setBulletX(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j3 = 0;
                while (j3 < params.length) {
                    temp3[j3] = (short)Integer.parseInt(params[j3]);
                    ++j3;
                }
                shotAllData[i].setBulletY(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j4 = 0;
                while (j4 < params.length) {
                    temp3[j4] = (short)Integer.parseInt(params[j4]);
                    ++j4;
                }
                shotAllData[i].setShotAngle(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j5 = 0;
                while (j5 < params.length) {
                    temp3[j5] = (short)Integer.parseInt(params[j5]);
                    ++j5;
                }
                shotAllData[i].setShotSpeed(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                byte[] temp2 = new byte[params.length];
                int j6 = 0;
                while (j6 < params.length) {
                    temp2[j6] = (byte)Integer.parseInt(params[j6]);
                    ++j6;
                }
                shotAllData[i].setShotMaxTime(temp2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("shot data error!" + i);
        }
    }

    static void initAi(DataInputStream dis) {
        try {
            short len = dis.readShort();
            Object strBuff = null;
            aiAllData = new AIAllData[len];
            int i = 0;
            while (i < aiAllData.length) {
                Data.aiAllData[i] = new AIAllData();
                aiAllData[i].setAIId(dis.readByte());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ai data error!");
        }
    }

    static void initBomb(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            bombAllData = new BombAllData[len];
            int i = 0;
            while (i < bombAllData.length) {
                Data.bombAllData[i] = new BombAllData();
                bombAllData[i].setBombId(dis.readByte());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp2 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp2[j] = (short)Integer.parseInt(params[j]);
                    ++j;
                }
                bombAllData[i].setBulletId(temp2);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp2 = new short[params.length];
                int j2 = 0;
                while (j2 < params.length) {
                    temp2[j2] = (short)Integer.parseInt(params[j2]);
                    ++j2;
                }
                bombAllData[i].setBombX(temp2);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp2 = new short[params.length];
                int j3 = 0;
                while (j3 < params.length) {
                    temp2[j3] = (short)Integer.parseInt(params[j3]);
                    ++j3;
                }
                bombAllData[i].setBombY(temp2);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp2 = new short[params.length];
                int j4 = 0;
                while (j4 < params.length) {
                    temp2[j4] = (short)Integer.parseInt(params[j4]);
                    ++j4;
                }
                bombAllData[i].setBombTime(temp2);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Box data error!");
        }
    }

    static void initFire(DataInputStream dis) {
        try {
            short len = dis.readShort();
            Object strBuff = null;
            fireAllData = new FireAllData[len];
            int i = 0;
            while (i < fireAllData.length) {
                Data.fireAllData[i] = new FireAllData();
                fireAllData[i].setFireId(dis.readByte());
                fireAllData[i].setFireMode(dis.readByte());
                fireAllData[i].setFireState(dis.readShort());
                fireAllData[i].setFireX(dis.readShort());
                fireAllData[i].setFireY(dis.readShort());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("fire data error!");
        }
    }

    static void initItem(DataInputStream dis) {
        try {
            short len = dis.readShort();
            Object strBuff = null;
            itemAllData = new ItemAllData[len];
            int i = 0;
            while (i < itemAllData.length) {
                Data.itemAllData[i] = new ItemAllData();
                itemAllData[i].setItemId(dis.readByte());
                itemAllData[i].setItemMode(dis.readByte());
                itemAllData[i].setItemModeEnd(dis.readByte());
                itemAllData[i].setItemType(dis.readByte());
                itemAllData[i].setW(dis.readInt());
                itemAllData[i].setH(dis.readInt());
                itemAllData[i].setSpeedX(dis.readByte());
                itemAllData[i].setSpeedY(dis.readByte());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Item data error!");
        }
    }

    static void initQueue(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            planeQueueAllData = new QueueData[len];
            int i = 0;
            while (i < planeQueueAllData.length) {
                Data.planeQueueAllData[i] = new QueueData();
                planeQueueAllData[i].setQueueId(dis.readShort());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp3 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp3[j] = (short)Integer.parseInt(params[j]);
                    ++j;
                }
                planeQueueAllData[i].setQueuePlaneId(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                byte[] temp2 = new byte[params.length];
                int j2 = 0;
                while (j2 < params.length) {
                    temp2[j2] = (byte)Integer.parseInt(params[j2]);
                    ++j2;
                }
                planeQueueAllData[i].setQueuePlaneType(temp2);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j3 = 0;
                while (j3 < params.length) {
                    temp3[j3] = (short)Integer.parseInt(params[j3]);
                    ++j3;
                }
                planeQueueAllData[i].setQueueX(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j4 = 0;
                while (j4 < params.length) {
                    temp3[j4] = (short)Integer.parseInt(params[j4]);
                    ++j4;
                }
                planeQueueAllData[i].setQueueY(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j5 = 0;
                while (j5 < params.length) {
                    temp3[j5] = (short)Integer.parseInt(params[j5]);
                    ++j5;
                }
                planeQueueAllData[i].setQueueWaitTime(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j6 = 0;
                while (j6 < params.length) {
                    temp3[j6] = (short)Integer.parseInt(params[j6]);
                    ++j6;
                }
                planeQueueAllData[i].setQueueDeadID(temp3);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("queue data error!");
        }
    }

    static void initEnemy(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            gameEnemyData = new EnemyAllData[len];
            int i = 0;
            while (i < gameEnemyData.length) {
                Data.gameEnemyData[i] = new EnemyAllData();
                gameEnemyData[i].setId(dis.readShort());
                gameEnemyData[i].setMode(dis.readByte());
                gameEnemyData[i].setW(dis.readInt());
                gameEnemyData[i].setH(dis.readInt());
                gameEnemyData[i].setPlaneData(dis.readInt());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp3 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp3[j] = (short)Integer.parseInt(params[j]);
                    ++j;
                }
                gameEnemyData[i].setPlaneMachine(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j2 = 0;
                while (j2 < params.length) {
                    temp3[j2] = (short)Integer.parseInt(params[j2]);
                    ++j2;
                }
                gameEnemyData[i].setGameAIData(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j3 = 0;
                while (j3 < params.length) {
                    temp3[j3] = (short)Integer.parseInt(params[j3]);
                    ++j3;
                }
                gameEnemyData[i].setFire(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j4 = 0;
                while (j4 < params.length) {
                    temp3[j4] = (short)Integer.parseInt(params[j4]);
                    ++j4;
                }
                gameEnemyData[i].setGameAIDataSecond(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j5 = 0;
                while (j5 < params.length) {
                    temp3[j5] = (short)Integer.parseInt(params[j5]);
                    ++j5;
                }
                gameEnemyData[i].setBombXY(temp3);
                gameEnemyData[i].setScore(dis.readShort());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Enemy data error!");
        }
    }

    static void initMachine(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            machineAllData = new MachineAllData[len];
            int i = 0;
            while (i < machineAllData.length) {
                Data.machineAllData[i] = new MachineAllData();
                machineAllData[i].setMachineID(dis.readShort());
                machineAllData[i].setMachineX(dis.readShort());
                machineAllData[i].setMachineY(dis.readShort());
                machineAllData[i].setMachineSpeedX(dis.readByte());
                machineAllData[i].setMachineSpeedY(dis.readByte());
                machineAllData[i].setMachineAngle(dis.readShort());
                machineAllData[i].setMachineShotID(dis.readShort());
                machineAllData[i].setMachineWaitTime(dis.readByte());
                machineAllData[i].setMachineMode(dis.readByte());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp2 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp2[j] = (short)Integer.parseInt(params[j]);
                    ++j;
                }
                machineAllData[i].setAIData(temp2);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Machine data error!");
        }
    }

    static void initPlaneData(DataInputStream dis) {
        try {
            short len = dis.readShort();
            Object strBuff = null;
            planeData = new PlaneData[len];
            int i = 0;
            while (i < planeData.length) {
                Data.planeData[i] = new PlaneData();
                planeData[i].setPlaneDataId(dis.readByte());
                planeData[i].setPlaneDataHpMax(dis.readInt());
                planeData[i].setPlaneDataAttack(dis.readShort());
                planeData[i].setPlaneDataDefine(dis.readShort());
                planeData[i].setPlaneDataSpeedX(dis.readByte());
                planeData[i].setPlaneDataSpeedY(dis.readByte());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("PlaneData data error!");
        }
    }

    static void initRole(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            gameRoleData = new RoleAllData[len];
            int i = 0;
            while (i < gameRoleData.length) {
                Data.gameRoleData[i] = new RoleAllData();
                gameRoleData[i].setId(dis.readShort());
                gameRoleData[i].setMode(dis.readByte());
                gameRoleData[i].setW(dis.readInt());
                gameRoleData[i].setH(dis.readInt());
                gameRoleData[i].setMapX(dis.readShort());
                gameRoleData[i].setMapY(dis.readShort());
                gameRoleData[i].setMapW(dis.readShort());
                gameRoleData[i].setMapH(dis.readShort());
                gameRoleData[i].setPlaneData(dis.readByte());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp3 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp3[j] = (short)Integer.parseInt(params[j]);
                    ++j;
                }
                gameRoleData[i].setPlaneMachine(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j2 = 0;
                while (j2 < params.length) {
                    temp3[j2] = (short)Integer.parseInt(params[j2]);
                    ++j2;
                }
                gameRoleData[i].setFire(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j3 = 0;
                while (j3 < params.length) {
                    temp3[j3] = (short)Integer.parseInt(params[j3]);
                    ++j3;
                }
                gameRoleData[i].setPlaneMachineFire(temp3);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Role data error!");
        }
    }

    static void initRole2(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            gameRoleData2 = new RoleAllData[len];
            int i = 0;
            while (i < gameRoleData2.length) {
                Data.gameRoleData2[i] = new RoleAllData();
                gameRoleData2[i].setId(dis.readShort());
                gameRoleData2[i].setMode(dis.readByte());
                gameRoleData2[i].setW(dis.readInt());
                gameRoleData2[i].setH(dis.readInt());
                gameRoleData2[i].setMapX(dis.readShort());
                gameRoleData2[i].setMapY(dis.readShort());
                gameRoleData2[i].setMapW(dis.readShort());
                gameRoleData2[i].setMapH(dis.readShort());
                gameRoleData2[i].setPlaneData(dis.readByte());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp3 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp3[j] = (short)Integer.parseInt(params[j]);
                    ++j;
                }
                gameRoleData2[i].setPlaneMachine(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j2 = 0;
                while (j2 < params.length) {
                    temp3[j2] = (short)Integer.parseInt(params[j2]);
                    ++j2;
                }
                gameRoleData2[i].setFire(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j3 = 0;
                while (j3 < params.length) {
                    temp3[j3] = (short)Integer.parseInt(params[j3]);
                    ++j3;
                }
                gameRoleData2[i].setPlaneMachineFire(temp3);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Role data error!");
        }
    }

    static void initRole3(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            gameRoleData3 = new RoleAllData[len];
            int i = 0;
            while (i < gameRoleData3.length) {
                Data.gameRoleData3[i] = new RoleAllData();
                gameRoleData3[i].setId(dis.readShort());
                gameRoleData3[i].setMode(dis.readByte());
                gameRoleData3[i].setW(dis.readInt());
                gameRoleData3[i].setH(dis.readInt());
                gameRoleData3[i].setMapX(dis.readShort());
                gameRoleData3[i].setMapY(dis.readShort());
                gameRoleData3[i].setMapW(dis.readShort());
                gameRoleData3[i].setMapH(dis.readShort());
                gameRoleData3[i].setPlaneData(dis.readByte());
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String temp1 = new String(strBuff, "UTF-8");
                String[] params = Variable.splitString(temp1, ",");
                short[] temp3 = new short[params.length];
                int j = 0;
                while (j < params.length) {
                    temp3[j] = (short)Integer.parseInt(params[j]);
                    ++j;
                }
                gameRoleData3[i].setPlaneMachine(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j2 = 0;
                while (j2 < params.length) {
                    temp3[j2] = (short)Integer.parseInt(params[j2]);
                    ++j2;
                }
                gameRoleData3[i].setFire(temp3);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                temp1 = new String(strBuff, "UTF-8");
                params = Variable.splitString(temp1, ",");
                temp3 = new short[params.length];
                int j3 = 0;
                while (j3 < params.length) {
                    temp3[j3] = (short)Integer.parseInt(params[j3]);
                    ++j3;
                }
                gameRoleData3[i].setPlaneMachineFire(temp3);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Role data error!");
        }
    }

    public static int openPack(DataInputStream is) throws Exception {
        char mark = (char)is.readShort();
        if (mark != 'A') {
            System.out.println("file format error");
            return -1;
        }
        int len = is.readShort();
        files = new String[len];
        offsetArray = new int[len];
        int i = 0;
        while (i < len) {
            int nameLen = is.read();
            byte[] contentBuff = new byte[nameLen];
            is.read(contentBuff);
            Data.files[i] = new String(contentBuff, "UTF-8");
            ++i;
        }
        int i2 = 0;
        while (i2 < len) {
            Data.offsetArray[i2] = is.readInt();
            ++i2;
        }
        return len;
    }

    static int getPackLen(String[] names) {
        int max = 0;
        int i = 0;
        while (i < names.length) {
            int v = Integer.parseInt(names[i]);
            if (v > max) {
                max = v;
            }
            ++i;
        }
        return max + 1;
    }

    static int[] strOrder(String[] modle, String[] str) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < str.length) {
            int j = 0;
            while (j < modle.length) {
                if (Integer.parseInt(modle[j]) == Integer.parseInt(str[i])) {
                    v.addElement("" + j);
                }
                ++j;
            }
            ++i;
        }
        int[] index = new int[v.size()];
        int i2 = 0;
        while (i2 < index.length) {
            index[i2] = Integer.parseInt(v.elementAt(i2).toString());
            ++i2;
        }
        v = null;
        int i3 = 0;
        while (i3 < index.length) {
            int j = i3 + 1;
            while (j < index.length) {
                if (index[i3] > index[j]) {
                    index[i3] = index[i3] ^ index[j];
                    index[j] = index[i3] ^ index[j];
                    index[i3] = index[i3] ^ index[j];
                }
                ++j;
            }
            ++i3;
        }
        return index;
    }

    public static int searchFile(DataInputStream is, String name) {
        try {
            Data.openPack(is);
            int index = -1;
            int i = 0;
            while (i < files.length) {
                if (files[i].equals(name)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return -1;
            }
            int offset = index == 0 ? 0 : offsetArray[index - 1];
            int len = offsetArray[index] - offset;
            is.skip(offset);
            return len;
        }
        catch (Exception ex1) {
            return -1;
        }
    }

    public static Object[] getSpecialData(DataInputStream is) throws Exception {
        int len = is.readByte();
        Object[] obj = new Object[4];
        int i = 0;
        while (i < len) {
            char flag = is.readChar();
            switch (flag) {
                case 'c': {
                    obj[0] = Data.readClipData(is);
                    break;
                }
                case 'f': {
                    obj[1] = Data.readFrameData(is);
                    break;
                }
                case 'm': {
                    obj[2] = Data.readMotionData(is);
                    break;
                }
                case 'o': {
                    obj[3] = Data.readClipData(is);
                }
            }
            ++i;
        }
        return obj;
    }

    static byte[][] readClipData(DataInputStream is) {
        byte[][] clip = null;
        int clipLen = 0;
        int perlen = 0;
        try {
            byte mark = is.readByte();
            perlen = mark == 0 ? 4 : 8;
            clipLen = is.readShort();
            clip = new byte[clipLen][perlen];
            int i = 0;
            while (i < clipLen) {
                int j = 0;
                while (j < perlen) {
                    clip[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("read ClipData error!");
            e.printStackTrace();
        }
        return clip;
    }

    static byte[][] readFrameData(DataInputStream is) {
        byte[][] frame = null;
        try {
            int len = is.readByte();
            frame = new byte[len][];
            int i = 0;
            while (i < len) {
                int gLen = (is.readByte() - 4) * 5 + 4;
                frame[i] = new byte[gLen];
                int j = 0;
                while (j < gLen) {
                    frame[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("read frameData error!");
            e.printStackTrace();
        }
        return frame;
    }

    static byte[][][] readMotionData(DataInputStream is) {
        byte[][][] motion = null;
        int motionLen = 0;
        try {
            motionLen = is.readByte();
            motion = new byte[20][][];
            int i = 0;
            while (i < motionLen) {
                byte st = is.readByte();
                int zs = is.readByte();
                motion[st] = new byte[zs][7];
                int j = 0;
                while (j < zs) {
                    int m = 0;
                    while (m < 7) {
                        motion[st][j][m] = is.readByte();
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("read motionData error!");
            e.printStackTrace();
        }
        return motion;
    }

    static short[][] readArray(String fileName, String name) {
        DataInputStream is = Tools.openFile(fileName);
        if (is == null) {
            try {
                is.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return null;
        }
        int fileLen = Data.searchFile(is, name);
        if (fileLen == -1) {
            return null;
        }
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte();
                dat[i] = new short[gLen];
                int j = 0;
                while (j < gLen) {
                    dat[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    static short[][] readArray(String filePath) {
        DataInputStream dis = Tools.openFile(filePath);
        try {
            if (dis == null) {
                dis.close();
                return null;
            }
            int p0 = dis.readByte();
            int p1 = dis.readByte();
            short[][] temp = new short[p0][p1];
            int i = 0;
            while (i < p0) {
                int j = 0;
                while (j < p1) {
                    temp[i][j] = dis.readShort();
                    ++j;
                }
                ++i;
            }
            dis.close();
            return temp;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static short[] getMIndex() {
        short[] tileIndices = null;
        DataInputStream dis = Tools.openFile("/data/tileIndices.dat");
        try {
            int len = dis.readShort();
            short mapName = -1;
            int curOffset = 0;
            short offset = 0;
            int arrayLen = 0;
            int i = 0;
            while (i < len) {
                mapName = dis.readShort();
                if (curMapFileName == mapName) {
                    curOffset = dis.readShort();
                    arrayLen = curOffset - offset;
                } else {
                    offset = dis.readShort();
                }
                ++i;
            }
            dis.skip((curOffset - arrayLen) * 2);
            tileIndices = new short[arrayLen];
            int i2 = 0;
            while (i2 < arrayLen) {
                tileIndices[i2] = dis.readShort();
                ++i2;
            }
            dis.close();
        }
        catch (Exception ex) {
            System.out.println("tileIndices error!!!!!");
            ex.printStackTrace();
        }
        return tileIndices;
    }
}

