/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;

public final class Script {
    static Event[] events;
    static Event[] gEvents;
    static int initEventIndex;
    static byte[] eventIndex;
    static byte[] gEventIndex;
    static String[] exp;
    static String[] gExp;
    static int[] bInt;
    static int[] gBInt;
    static short[][] array;
    static short[][] gArray;
    static boolean isUserCtrl;
    static int curEvent;
    static int curGEvent;
    static short[][] resData;
    static short[] rankInfo;
    static short[][] enemyInfo;
    static Event[] tmpEvent;
    static byte[] tmpIndex;
    static String[] tmpExp;
    static int[] tmpBInt;
    static short[][] tmpArray;

    public static void free() {
        Script.freeTemp();
        eventIndex = null;
        events = null;
    }

    public static void initScriptVar() {
        int i = 0;
        while (i < Variable.scriptVar.length) {
            Variable.scriptVar[i] = 0;
            ++i;
        }
    }

    public static void runScript() {
        if (GCanvas.systemEvent == 2 || GCanvas.systemEvent == 7 || GCanvas.systemEvent == 1) {
            return;
        }
        if (Event.waitTime > 0) {
            --Event.waitTime;
            return;
        }
        if (curGEvent == -1) {
            Script.runRankScript();
        }
        if (curEvent == -1) {
            Script.runGlobalScript();
        }
    }

    private static void runRankScript() {
        curEvent = -1;
        int i = 0;
        while (i < eventIndex.length) {
            if (Script.events[Script.eventIndex[i]].eventIsAlive) {
                curEvent = i;
                break;
            }
            ++i;
        }
        if (curEvent == -1) {
            int i2 = 0;
            while (i2 < eventIndex.length) {
                events[eventIndex[i2]].run();
                ++i2;
            }
        } else {
            events[eventIndex[curEvent]].run();
        }
    }

    private static void runGlobalScript() {
    }

    public static boolean runInitEvent() {
        if (initEventIndex == -1) {
            return true;
        }
        return events[initEventIndex].runInitEvent();
    }

    public static void loadRes() {
        int i = 0;
        while (i < resData.length) {
            int len = resData[i].length - 1;
            String[] temp = new String[len];
            int j = 0;
            while (j < len) {
                temp[j] = "" + resData[i][j + 1];
                ++j;
            }
            switch (resData[i][0]) {
                case 33: {
                    Data.loadHeadData(temp);
                }
            }
            ++i;
        }
    }

    public static void loadScript(int gameRank) throws Exception {
        isUserCtrl = true;
        eventIndex = null;
        initEventIndex = -1;
        DataInputStream dis = Tools.openFile("/scene/sPackage.dat");
        int fileLen = Data.searchFile(dis, "" + gameRank);
        if (fileLen == -1) {
            dis.close();
            return;
        }
        int resLen = dis.readByte();
        resData = new short[resLen][];
        int i = 0;
        while (i < resLen) {
            int tmpLen = dis.readByte();
            Script.resData[i] = new short[tmpLen];
            int j = 0;
            while (j < tmpLen) {
                Script.resData[i][j] = dis.readShort();
                ++j;
            }
            ++i;
        }
        Script.loadScriptDat(dis, true, true, true);
        eventIndex = tmpIndex;
        exp = tmpExp;
        bInt = tmpBInt;
        array = tmpArray;
        Rank.initRank(rankInfo);
        Rank.initEnemyTeam(enemyInfo);
        events = tmpEvent;
        int i2 = 0;
        while (i2 < events.length) {
            Script.events[i2].dataType = 0;
            events[i2].endInit();
            ++i2;
        }
        dis.close();
        Script.freeTemp();
    }

    public static String[] filter(String[] str) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < str.length) {
            if (!v.contains(str[i])) {
                v.addElement(str[i]);
            }
            ++i;
        }
        Object[] temp = new String[v.size()];
        v.copyInto(temp);
        v = null;
        return temp;
    }

    public static void loadGlobalScript() throws Exception {
        DataInputStream dis = Tools.openFile("/scene/global.dat");
        if (dis == null) {
            dis.close();
            return;
        }
        boolean hasProp = dis.readByte() == 1;
        boolean hasDat = dis.readByte() == 1;
        boolean hasEvent = dis.readByte() == 1;
        Script.loadScriptDat(dis, hasProp, hasDat, hasEvent);
        gExp = tmpExp;
        gBInt = tmpBInt;
        gArray = tmpArray;
        if (hasProp) {
            Engine.initGame(rankInfo);
        }
        if (hasDat) {
            int len = enemyInfo.length;
            String[] names = new String[len];
            short[] levels = new short[len];
            int i = 0;
            while (i < len) {
                names[i] = Variable.getString(enemyInfo[i][0], gExp);
                levels[i] = (short)Variable.getInt(enemyInfo[i][1], gExp, gBInt);
                ++i;
            }
        }
        if (hasEvent) {
            gEvents = tmpEvent;
            int i = 0;
            while (i < gEvents.length) {
                Script.gEvents[i].dataType = 1;
                gEvents[i].endInit();
                ++i;
            }
            gEventIndex = tmpIndex;
        }
        dis.close();
        Script.freeTemp();
    }

    private static void freeTemp() {
        rankInfo = null;
        enemyInfo = null;
        tmpEvent = null;
        tmpIndex = null;
        tmpExp = null;
        tmpBInt = null;
        tmpArray = null;
    }

    private static void loadScriptDat(DataInputStream dis, boolean hasDat1, boolean hasDat2, boolean hasEvent) throws Exception {
        int i;
        int i2;
        int len;
        if (hasDat1) {
            len = 0;
            len = dis.readShort();
            rankInfo = new short[len];
            i2 = 0;
            while (i2 < len) {
                Script.rankInfo[i2] = dis.readShort();
                ++i2;
            }
        }
        if (hasDat2) {
            len = dis.readShort();
            enemyInfo = new short[len][];
            i2 = 0;
            while (i2 < enemyInfo.length) {
                len = dis.readShort();
                Script.enemyInfo[i2] = new short[len];
                int j = 0;
                while (j < enemyInfo[i2].length) {
                    Script.enemyInfo[i2][j] = dis.readShort();
                    ++j;
                }
                ++i2;
            }
        }
        if (hasEvent) {
            len = dis.readShort();
            Vector<String> v = new Vector<String>();
            tmpEvent = new Event[len];
            i = 0;
            while (i < len) {
                Script.tmpEvent[i] = new Event();
                int tLen = dis.readShort();
                Script.tmpEvent[i].prop = new short[tLen];
                int j = 0;
                while (j < tLen) {
                    Script.tmpEvent[i].prop[j] = dis.readShort();
                    ++j;
                }
                int orderLen = dis.readShort();
                short[][] orders = new short[orderLen][];
                int j2 = 0;
                while (j2 < orderLen) {
                    int pLen = dis.readShort();
                    orders[j2] = new short[pLen];
                    int k = 0;
                    while (k < pLen) {
                        orders[j2][k] = dis.readShort();
                        ++k;
                    }
                    ++j2;
                }
                tmpEvent[i].init(orders);
                switch (tmpEvent[i].getInt(Script.tmpEvent[i].prop[0])) {
                    case 0: {
                        initEventIndex = i;
                        break;
                    }
                    case 1: 
                    case 3: {
                        v.addElement("" + i);
                    }
                }
                ++i;
            }
            if (!v.isEmpty()) {
                tmpIndex = new byte[v.size()];
                int i3 = 0;
                while (i3 < tmpIndex.length) {
                    Script.tmpIndex[i3] = Byte.parseByte(v.elementAt(i3).toString());
                    ++i3;
                }
            }
        }
        len = dis.readShort();
        tmpExp = new String[len];
        int i4 = 0;
        while (i4 < len) {
            short bLen = dis.readShort();
            byte[] buff = new byte[bLen];
            dis.read(buff);
            Script.tmpExp[i4] = new String(buff, "UTF-8");
            ++i4;
        }
        len = dis.readShort();
        tmpBInt = new int[len];
        i = 0;
        while (i < len) {
            Script.tmpBInt[i] = dis.readInt();
            ++i;
        }
        len = dis.readShort();
        tmpArray = new short[len][];
        int i5 = 0;
        while (i5 < len) {
            int aLen = dis.readShort();
            Script.tmpArray[i5] = new short[aLen];
            int j = 0;
            while (j < aLen) {
                Script.tmpArray[i5][j] = dis.readShort();
                ++j;
            }
            ++i5;
        }
    }

    /*
     * WARNING - void declaration
     */
    static String loadTxt(String name) {
        InputStream is = "".getClass().getResourceAsStream(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        String strReturn = null;
        byte[] buffer = new byte[2048];
        try {
            int len;
            while ((len = is.read(buffer)) > 0) {
                void var6_6;
                dos.write(buffer, 0, (int)var6_6);
            }
            strReturn = new String(baos.toByteArray(), "UTF-8");
            is.close();
            dos.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strReturn;
    }

    static {
        initEventIndex = -1;
        isUserCtrl = true;
        curEvent = -1;
        curGEvent = -1;
    }
}

