/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Tools {
    static final short GRUOP_MAX = 600;
    static int mapGroup;
    private static Image[][] imgGroup;
    public static final String[] dirNames;
    public static final byte D_DECK = 0;
    public static final byte D_EFFECT = 1;
    public static final byte D_OPEN = 2;
    public static final byte D_SPRITE = 3;
    public static final byte D_GAME = 4;
    public static final byte D_BULLET = 5;
    public static final byte D_MAP = 6;
    public static final byte D_SHANDOW = 7;
    public static final byte D_PUBLIC = 8;
    public static final byte D_MORE = 9;
    public static final byte D_MENUCHOOSE = 10;
    public static final byte D_SUPER = 11;
    public static final byte D_TOUCH = 12;
    public static final byte D_SHOW = 13;
    private static final int MAX_MAP = 5;
    private static int[] anthors;
    public static final byte LEFT_TOP = 0;
    public static final byte LEFT_VCENTER = 1;
    public static final byte LEFT_BOTTOM = 2;
    public static final byte HCENTER_TOP = 3;
    public static final byte HCENTER_VCENTER = 4;
    public static final byte HCENTER_BOTTOM = 5;
    public static final byte RIGHT_TOP = 6;
    public static final byte RIGHT_VCENTER = 7;
    public static final byte RIGHT_BOTTOM = 8;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_HORIZONTAL = 1;
    public static final byte TRANS_VERTICAL = 2;
    public static final byte TRANS_CENTER = 3;
    static String s;
    static byte[] wave;
    public static final byte TYPE_ROUND_RECT = 0;
    public static final byte TYPE_RECT = 1;
    public static final byte TYPE_ARC = 2;
    public static final byte TYPE_LINE = 3;
    public static final byte TYPE_STRING = 4;
    public static final byte TYPE_IMG = 5;
    public static final byte TYPE_NUM = 6;
    public static final byte TYPE_PANE = 7;
    public static final byte TYPE_FRAME = 8;
    public static final byte TYPE_COL_STRING = 9;
    public static final byte TYPE_CHARS = 10;
    public static final byte TYPE_MASK = 11;
    public static final byte TYPE_CHARS2 = 12;
    public static final byte TYPE_MASK_CIRCLE = 13;
    public static final byte TYPE_SCALEIMG = 14;
    public static final byte TYPE_CLIP = 99;
    private static final int MAX = 500;
    private static int curIndex;
    static short max_obj;
    static short[] drawObj;
    private static short[] clipX;
    private static short[] clipY;
    private static short[] clipW;
    private static short[] clipH;
    private static short[] x;
    private static short[] y;
    static short[] drawLevel;
    private static int[] imgIndex;
    private static byte[] anchor;
    private static byte[] trans;
    private static String[] str;
    private static byte[] type;
    private static Vector arrayV;
    private static int[] alf;
    public static final byte ISFILL = 99;
    public static final byte TILE_PASS = 15;
    public static final byte TILE_TOP = 14;
    public static final byte TILE_DECK = 13;
    public static final byte TILE_PASS_DISPEAR = 12;
    public static final byte TILE_LB_PASS_T = 11;
    public static final byte TILE_LB_PASS_B = 10;
    public static final byte TILE_RT_PASS_LR = 9;
    public static final byte TILE_RT_PASS_T = 8;
    public static final byte TILE_RT_PASS_B = 7;
    public static final byte TILE_RB_PASS_LR = 6;
    public static final byte TILE_RB_PASS_T = 5;
    public static final byte TILE_RB_PASS_B = 4;
    public static final byte TILE_NULL = 3;
    public static final byte TILE_LD_REBOUND = 2;
    public static final byte TILE_HIT = 1;
    public static final byte TILE_EMPTY = 0;
    public static final byte MOTION_ID = 0;
    public static final byte MOTION_TRANS = 1;
    public static final byte MOTION_DELAY = 2;
    public static final byte MOTION_OFF_LEFT = 3;
    public static final byte MOTION_OFF_RIGHT = 4;
    public static final byte MOTION_OFF_TOP = 5;
    public static final byte MOTION_OFF_BOTTOM = 6;
    static Random rnd;
    static short[] layer;
    static short[][] group;
    static short[] gIndex;
    private static final int[] SIN;
    private static final int[] TANKK;
    private static final int[] TAN;

    public static DataInputStream openFile(String filePath) {
        InputStream is = "".getClass().getResourceAsStream(filePath);
        if (is == null) {
            return null;
        }
        return new DataInputStream(is);
    }

    public static int getColor(char c) {
        switch (c) {
            case 'A': {
                return 0xFFFFFF;
            }
            case 'B': {
                return 0xFF0000;
            }
            case 'C': {
                return 16740120;
            }
            case 'G': {
                return 65280;
            }
            case 'W': {
                return 15132922;
            }
            case 'Y': {
                return 16179357;
            }
            case 'T': {
                return 0xFFFFFF;
            }
        }
        return 7208956;
    }

    private static Image getImage(int index) {
        int group = index / 600;
        int i = index % 600;
        return Tools.getImage(group, i);
    }

    public static Image getImage(int group, int index) {
        if (imgGroup[group] == null || imgGroup[group][index] == null) {
            return null;
        }
        return imgGroup[group][index];
    }

    private static void drawFrame(Graphics g, int imgIndex, byte[][] frameData, byte[][] imgData, int x, int y, int index, boolean isMirror, int alf) {
        byte[] data = frameData[index];
        int i = 4;
        while (i < data.length) {
            int offX = Tools.bToi(data[i + (isMirror ? 3 : 1)]);
            int offY = Tools.bToi(data[i + 2]);
            int[] cilp = Tools.changeClipData(imgData[data[i]]);
            int clipX = cilp[0];
            int clipY = cilp[1];
            int clipW = cilp[2];
            int clipH = cilp[3];
            Tools.drawClipImage(g, imgIndex, x + offX, y + offY, clipX, clipY, clipW, clipH, (byte)0, isMirror ? data[i + 4] ^ 1 : data[i + 4], alf);
            i += 5;
        }
    }

    public static void loadImages(int dir) {
        System.out.println("\u5168dir====" + dir);
        int imgIndex = 0;
        DataInputStream dis = Tools.openFile("/images/" + dirNames[dir] + ".pak");
        try {
            Data.openPack(dis);
            if (imgGroup[dir] == null) {
                int max = Data.getPackLen(Data.files);
                Tools.imgGroup[dir] = new Image[max];
            }
            int i = 0;
            while (i < Data.files.length) {
                int offset = i == 0 ? 0 : Data.offsetArray[i - 1];
                int len = Data.offsetArray[i] - offset;
                byte[] imgData = new byte[len];
                dis.read(imgData);
                Image img = Image.createImage((byte[])imgData, (int)0, (int)len);
                imgIndex = Integer.parseInt(Data.files[i]);
                Tools.imgGroup[dir][imgIndex] = img;
                ++i;
            }
            dis.close();
        }
        catch (Exception ex) {
            System.out.println("ooooooo:" + imgIndex);
            ex.printStackTrace();
        }
    }

    public static boolean loadImages(int dir, String[] names) {
        System.out.println("\u6563\u7684dir====" + dir);
        DataInputStream dis = Tools.openFile("/images/" + dirNames[dir] + ".pak");
        if (dis == null) {
            return false;
        }
        try {
            int[] oIndex;
            Data.openPack(dis);
            if (imgGroup[dir] == null) {
                int max = Data.getPackLen(Data.files);
                Tools.imgGroup[dir] = new Image[max];
            }
            if ((oIndex = Data.strOrder(Data.files, names)).length == 0) {
                return false;
            }
            int skip = 0;
            int i = 0;
            while (i < oIndex.length) {
                int index = oIndex[i];
                int offset = index == 0 ? 0 : Data.offsetArray[index - 1];
                int len = Data.offsetArray[index] - offset;
                byte[] imgData = new byte[len];
                dis.skip(offset - skip);
                dis.read(imgData);
                Image img = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                int imgIndex = Integer.parseInt(Data.files[index]);
                Tools.imgGroup[dir][imgIndex] = img;
                skip = Data.offsetArray[index];
                ++i;
            }
            dis.close();
        }
        catch (Exception ex) {
            System.out.println("ooooooo:" + names);
            ex.printStackTrace();
        }
        return true;
    }

    public static Image createImage(String path) {
        try {
            return Image.createImage((String)path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void removeImage(int group, int index) {
        if (group >= imgGroup.length || index >= imgGroup[group].length) {
            System.out.println("removeImage error!");
            return;
        }
        Tools.imgGroup[group][index] = null;
    }

    public static void removeImageGroup(int group) {
        Tools.imgGroup[group] = null;
        System.gc();
        System.out.println("removeImageGroup==" + group);
    }

    public static void removeAllImage() {
        int i = 0;
        while (i < imgGroup.length) {
            Tools.imgGroup[i] = null;
            ++i;
        }
    }

    public static void addClip(int x, int y, int w, int h, int drawLevel) {
        Tools.setDrawData((byte)99, x, y, 0, 0, w, h, drawLevel, 0, (byte)0, 0, null);
    }

    public static void addString(String str1, int x, int y, byte anchor, int color, int drawLevel) {
        Tools.setDrawData((byte)4, x, y, 0, 0, 0, 0, drawLevel, color, anchor, 0, str1);
    }

    public static void addChars(char[][] chars, int x, int y, int offX, int offY, int max, byte anchor, int drawLevel) {
        int cIndex = Tools.addCharArray(chars);
        Tools.setDrawData((byte)10, x, y, 0, chars[0].length, offX, offY, drawLevel, cIndex, anchor, max, null);
    }

    public static void addChars2(char[][] chars, int x, int y, int offX, int offY, int max, byte anchor, int drawLevel) {
        int cIndex = Tools.addCharArray(chars);
        Tools.setDrawData((byte)12, x, y, 0, chars[0].length, offX, offY, drawLevel, cIndex, anchor, max, null);
    }

    public static void addChars(char[][] chars, int x, int y, int offX, int offY, int start, int end, int max, byte anchor, int drawLevel) {
        int cIndex = Tools.addCharArray(chars);
        Tools.setDrawData((byte)10, x, y, start, end, offX, offY, drawLevel, cIndex, anchor, max, null);
    }

    public static void addARC(int x, int y, int w, int h, int rw, int rh, boolean isFill, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x, y, w, h, anchor)) {
            Tools.setDrawData((byte)2, x, y, rw, rh, w, h, drawLevel, color, anchor, Tools.getIsFill(isFill), null);
        }
    }

    public static void addRoundRect(int x, int y, int w, int h, int rw, int rh, boolean isFill, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x, y, w, h, anchor)) {
            Tools.setDrawData((byte)0, x, y, rw, rh, w, h, drawLevel, color, anchor, Tools.getIsFill(isFill), null);
        }
    }

    public static void addNum(int num, int path, int imgIndex, int x, int y, int length, int space, byte anchor, int drawLevel) {
        int index = path * 600 + imgIndex;
        Tools.setDrawData((byte)6, x, y, index, 0, space, length, drawLevel, num, anchor, 0, null);
    }

    public static void addAlfNum(int num, int path, int imgIndex, int x, int y, int length, int space, byte anchor, int drawLevel) {
        int index = path * 600 + imgIndex;
        Tools.setDrawData((byte)6, x, y, index, 0, space, length, drawLevel, num, anchor, 0, null);
    }

    public static int getImageColor(Image img, int x, int y) {
        int[] p = new int[1];
        img.getRGB(p, 0, 1, x, y, 1, 1);
        return p[0];
    }

    private static void drawPane(Graphics g, int imgIndex, int x, int y, int w, int h, boolean isFill) {
        Image img = Tools.getImage(imgIndex);
        if (isFill) {
            int col = Tools.getImageColor(img, 0, 0);
            g.setColor(col);
            g.fillRect(x + 3, y + 3, w - 6, h - 6);
        }
        int tileH = img.getHeight();
        int lenw = (w - tileH - 1) / tileH;
        int lenh = (h - tileH - 1) / tileH;
        int i = 0;
        while (i < lenw) {
            Tools.drawClipImage(g, imgIndex, x + tileH + i * tileH, y, tileH, 0, tileH, tileH, (byte)0, 0, 0);
            Tools.drawClipImage(g, imgIndex, x + tileH + i * tileH, y + h - tileH, tileH, 0, tileH, tileH, (byte)0, 2, 0);
            ++i;
        }
        int i2 = 0;
        while (i2 < lenh) {
            Tools.drawClipImage(g, imgIndex, x, y + tileH + i2 * tileH, tileH * 2, 0, tileH, tileH, (byte)0, 0, 0);
            Tools.drawClipImage(g, imgIndex, x + w - tileH, y + tileH + i2 * tileH, tileH * 2, 0, tileH, tileH, (byte)0, 1, 0);
            ++i2;
        }
        Tools.drawClipImage(g, imgIndex, x, y, 0, 0, tileH, tileH, (byte)0, 3, 0);
        Tools.drawClipImage(g, imgIndex, x + w - tileH, y, 0, 0, tileH, tileH, (byte)0, 2, 0);
        Tools.drawClipImage(g, imgIndex, x, y + h - tileH, 0, 0, tileH, tileH, (byte)0, 1, 0);
        Tools.drawClipImage(g, imgIndex, x + w - tileH, y + h - tileH, 0, 0, tileH, tileH, (byte)0, 0, 0);
    }

    public static void addPane(int path, int imgIndex, int x, int y, int w, int h, boolean isFill, int drawLevel) {
        int index = path * 600 + imgIndex;
        Tools.setDrawData((byte)7, x, y, 0, 0, w, h, drawLevel, index, (byte)0, Tools.getIsFill(isFill), null);
    }

    public static void addFrame(int path, int imgIndex, byte[][] frameData, byte[][] imgData, int x, int y, int frameindex, boolean isMirror, byte anchor, int drawLevel) {
        int index = path * 600 + imgIndex;
        int frame = Tools.addImgArray(frameData);
        int clip = Tools.addImgArray(imgData);
        Tools.setDrawData((byte)8, x, y, frame, clip, frameindex, 0, drawLevel, index, anchor, isMirror ? 1 : 0, null);
    }

    public static void addAlfFrame(int path, int imgIndex, byte[][] frameData, byte[][] imgData, int x, int y, int frameindex, boolean isMirror, byte anchor, int drawLevel, int alf) {
        int index = path * 600 + imgIndex;
        int frame = Tools.addImgArray(frameData);
        int clip = Tools.addImgArray(imgData);
        Tools.setAlfDrawData((byte)8, x, y, frame, clip, frameindex, 0, drawLevel, index, anchor, isMirror ? 1 : 0, alf);
    }

    public static void addFrame(int path, int imgIndex, short[][] frameData, byte[][] imgData, int x, int y, int frameindex, boolean isMirror, byte anchor, int drawLevel) {
        int index = path * 600 + imgIndex;
        int frame = Tools.addImgArray(frameData);
        int clip = Tools.addImgArray(imgData);
        Tools.setDrawData((byte)8, x, y, frame, clip, frameindex, 0, drawLevel, index, anchor, isMirror ? 1 : 0, null);
    }

    private static byte getIsFill(boolean isFill) {
        return isFill ? (byte)99 : -1;
    }

    public static void addLine(int x, int y, int w, int h, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x, y, w, h, anchor)) {
            Tools.setDrawData((byte)3, x, y, 0, 0, w, h, drawLevel, color, anchor, 0, null);
        }
    }

    public static void addRect(int x, int y, int w, int h, boolean isFill, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x, y, w, h, anchor)) {
            Tools.setDrawData((byte)1, x, y, 0, 0, w, h, drawLevel, color, anchor, Tools.getIsFill(isFill), null);
        }
    }

    public static void addMask(int x, int y, int w, int h, int alpha, int drawLevel) {
        if (Tools.isDraw(x, y, w, h, (byte)0)) {
            Tools.setDrawData((byte)11, x, y, 0, 0, w, h, drawLevel, alpha, (byte)0, Tools.getIsFill(true), null);
        }
    }

    public static void addMaskCircle(int x, int y, int r, int alpha, int drawLevel) {
        Tools.setDrawData((byte)13, x - r, y - r, 0, 0, r, r, drawLevel, alpha, (byte)0, Tools.getIsFill(true), null);
    }

    public static void addColorString(String str, int x, int y, byte anchor, int rgbRound, int rgb, int drawLevel) {
        short rgbRound1 = (short)(rgbRound >> 16 & 0xFFFF);
        short rgbRound2 = (short)(rgbRound & 0xFFFF);
        Tools.setDrawData((byte)9, x, y, rgbRound1, rgbRound2, 0, 0, drawLevel, rgb, anchor, 0, str);
    }

    public static void addImage(int path, int imgIndex, int x, int y, byte anchor, byte trans, int drawLevel) {
        int ch;
        int index = path * 600 + imgIndex;
        int cw = Tools.getImage(index).getWidth();
        if (Tools.isDraw(x, y, cw, ch = Tools.getImage(index).getHeight(), anchor)) {
            Tools.setDrawData((byte)5, x, y, 0, 0, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addZoomImage(int path, int imgIndex, int x, int y, int scales1, int scales2, byte anchor, byte trans, int drawLevel) {
        int index = path * 600 + imgIndex;
        Tools.setDrawData((byte)14, x, y, -1, -1, scales1, scales2, drawLevel, index, anchor, trans, null);
    }

    public static void addImage(int path, int imgIndex, int x, int y, int clipX, int clipY, int clipW, int clipH, byte anchor, byte trans, int drawLevel) {
        int index = path * 600 + imgIndex;
        int cw = clipW;
        int ch = clipH;
        if (Tools.isDraw(x, y, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x, y, clipX, clipY, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addImage(int path, int imgIndex, int x, int y, byte[] clipRect, byte anchor, byte trans, int drawLevel) {
        int index = path * 600 + imgIndex;
        int[] clip = Tools.changeClipData(clipRect);
        int cx = clip[0];
        int cy = clip[1];
        int cw = clip[2];
        int ch = clip[3];
        if (Tools.isDraw(x, y, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x, y, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addAlfImage(int path, int imgIndex, int x, int y, byte anchor, byte trans, int drawLevel, int alf) {
        int ch;
        int index = path * 600 + imgIndex;
        int cw = Tools.getImage(index).getWidth();
        if (Tools.isDraw(x, y, cw, ch = Tools.getImage(index).getHeight(), anchor)) {
            Tools.setAlfDrawData((byte)5, x, y, 0, 0, cw, ch, drawLevel, index, anchor, trans, alf);
        }
    }

    public static void addAlfImage(int path, int imgIndex, int x, int y, byte[] clipRect, byte anchor, byte trans, int drawLevel, int alf) {
        int index = path * 600 + imgIndex;
        int[] clip = Tools.changeClipData(clipRect);
        int cx = clip[0];
        int cy = clip[1];
        int cw = clip[2];
        int ch = clip[3];
        if (Tools.isDraw(x, y, cw, ch, anchor)) {
            Tools.setAlfDrawData((byte)5, x, y, cx, cy, cw, ch, drawLevel, index, anchor, trans, alf);
        }
    }

    public static void addAlfImage(int path, int imgIndex, int x, int y, int clipX, int clipY, int clipW, int clipH, byte anchor, byte trans, int drawLevel, int alf) {
        int index = path * 600 + imgIndex;
        int cw = clipW;
        int ch = clipH;
        if (Tools.isDraw(x, y, cw, ch, anchor)) {
            Tools.setAlfDrawData((byte)5, x, y, clipX, clipY, cw, ch, drawLevel, index, anchor, trans, alf);
        }
    }

    public static void addImage(int path, int imgIndex, int x, int y, short[] clipRect, byte anchor, byte trans, int drawLevel) {
        int index = path * 600 + imgIndex;
        short cx = clipRect[0];
        short cy = clipRect[1];
        short cw = clipRect[2];
        short ch = clipRect[3];
        if (Tools.isDraw(x, y, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x, y, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addImage(int path, int imgIndex, int x, int y, int[] clipRect, byte anchor, byte trans, int drawLevel) {
        int index = path * 600 + imgIndex;
        int cx = clipRect[0];
        int cy = clipRect[1];
        int cw = clipRect[2];
        int ch = clipRect[3];
        if (Tools.isDraw(x, y, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x, y, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addGridImage(int path, int imgIndex, int x, int y, int allCol, int allRow, int col, int row, byte anchor, byte trans, int drawLevel) {
        int index = path * 600 + imgIndex;
        int tempW = Tools.getImage(index).getWidth();
        int tempH = Tools.getImage(index).getHeight();
        int cw = tempW / allCol;
        int ch = tempH / allRow;
        int cx = cw * col;
        int cy = ch * row;
        if (Tools.isDraw(x, y, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x, y, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void drawWaveNum(int num, int imgDir, int imgid, int x, int y, int cilpW, int cilpH, int space, int waveInterval, int drawlever, int index) {
        int number = num;
        int seat = Tools.getDigitCounter(number) - 1;
        int totalSeat = Tools.getDigitCounter(number) - 1;
        int step = 0;
        while (seat >= 0) {
            byte addy = wave[Math.min(Math.max(index - (totalSeat - seat) * waveInterval, 0), wave.length - 1)];
            Tools.addImage(imgDir, imgid, x + step, y + addy, number / Tools.square(10, seat) * cilpW, 0, cilpW, cilpH, (byte)2, (byte)0, drawlever);
            number %= Tools.square(10, seat);
            --seat;
            step += cilpW + space;
        }
        ++index;
    }

    public static void drawClipImage(Graphics g, int index, int x, int y, int clipX, int clipY, int clipW, int clipH, byte anchor, int trans, int alf) {
        Image img = Tools.getImage(index);
        if (clipX == -1 && clipY == -1) {
            img = Tools.scaleImage(img, clipW, clipH);
            clipX = 0;
            clipY = 0;
            clipW = img.getWidth();
            clipH = img.getHeight();
        }
        if (alf != 0) {
            img = Tools.alfImage(img, alf);
        }
        if (img == null) {
            return;
        }
        int mode = 0;
        switch (trans) {
            case 1: {
                mode = 2;
                break;
            }
            case 2: {
                mode = 1;
                break;
            }
            case 3: {
                mode = 3;
            }
        }
        if (clipW <= 0 || clipH <= 0 || clipX < 0 || clipY < 0) {
            return;
        }
        if (clipX + clipW > img.getWidth()) {
            clipW = img.getWidth() - clipX;
        }
        if (clipY + clipH > img.getHeight()) {
            clipH = img.getHeight() - clipY;
        }
        g.drawRegion(img, clipX, clipY, clipW, clipH, mode, x, y, anthors[anchor]);
    }

    public static void drawColorString(Graphics g, String string, int x, int y, byte anchor, int color) {
        switch (anchor) {
            case 1: {
                y += GCanvas.strHeight / 2;
                anchor = (byte)2;
                break;
            }
            case 4: {
                y += GCanvas.strHeight / 2;
                anchor = (byte)5;
                break;
            }
            case 7: {
                y += GCanvas.strHeight / 2;
                anchor = (byte)8;
            }
        }
        g.setColor(color);
        g.drawString(string, x, y, anthors[anchor]);
    }

    public static final boolean isDraw(int dx, int dy, int dw, int dh, byte anchor) {
        switch (anchor) {
            case 0: {
                if (dx - Map.setOffX > -dw && dx - Map.setOffX < 240 || dy - Map.setOffY <= -dh || dy - Map.setOffY >= 320) break;
                return false;
            }
            case 2: {
                if (dx - Map.setOffX > -dw && dx - Map.setOffX < 240 || dy - Map.setOffY <= 0 || dy - Map.setOffY >= 320 + dh) break;
                return false;
            }
        }
        return true;
    }

    private static void setIndex() {
        short s = max_obj;
        max_obj = (short)(s + 1);
        Tools.drawObj[s] = (short)curIndex;
        if (++curIndex == 500) {
            curIndex = 0;
        }
    }

    private static int addImgArray(byte[][] array) {
        arrayV.addElement(array);
        return arrayV.size() - 1;
    }

    private static int addImgArray(short[][] array) {
        arrayV.addElement(array);
        return arrayV.size() - 1;
    }

    private static int addCharArray(char[][] array) {
        arrayV.addElement(array);
        return arrayV.size() - 1;
    }

    private static void setDrawData(byte type, int x, int y, int cx, int cy, int cw, int ch, int drawLevel, int imgIndex, byte anchor, int trans, String str) {
        Tools.type[Tools.curIndex] = type;
        Tools.clipX[Tools.curIndex] = (short)cx;
        Tools.clipY[Tools.curIndex] = (short)cy;
        Tools.clipW[Tools.curIndex] = (short)cw;
        Tools.clipH[Tools.curIndex] = (short)ch;
        Tools.x[Tools.curIndex] = (short)x;
        Tools.y[Tools.curIndex] = (short)y;
        Tools.drawLevel[Tools.curIndex] = (short)drawLevel;
        Tools.imgIndex[Tools.curIndex] = imgIndex;
        Tools.anchor[Tools.curIndex] = anchor;
        Tools.trans[Tools.curIndex] = (byte)trans;
        Tools.str[Tools.curIndex] = str;
        Tools.setIndex();
    }

    private static void setAlfDrawData(byte type, int x, int y, int cx, int cy, int cw, int ch, int drawLevel, int imgIndex, byte anchor, int trans, int color) {
        Tools.type[Tools.curIndex] = type;
        Tools.clipX[Tools.curIndex] = (short)cx;
        Tools.clipY[Tools.curIndex] = (short)cy;
        Tools.clipW[Tools.curIndex] = (short)cw;
        Tools.clipH[Tools.curIndex] = (short)ch;
        Tools.x[Tools.curIndex] = (short)x;
        Tools.y[Tools.curIndex] = (short)y;
        Tools.drawLevel[Tools.curIndex] = (short)drawLevel;
        Tools.imgIndex[Tools.curIndex] = imgIndex;
        Tools.anchor[Tools.curIndex] = anchor;
        Tools.trans[Tools.curIndex] = (byte)trans;
        Tools.alf[Tools.curIndex] = color;
        Tools.setIndex();
    }

    public static void drawMe(Graphics g, int index) {
        int endx = x[index] - Map.setOffX;
        int endy = y[index] - Map.setOffY;
        switch (type[index]) {
            case 7: {
                Tools.drawPane(g, imgIndex[index], endx, endy, clipW[index], clipH[index], trans[index] == 99);
                break;
            }
            case 2: {
                int y = endy;
                short rw = clipX[index];
                short rh = clipY[index];
                short w = clipW[index];
                short h = clipH[index];
                if (anchor[index] != 0) {
                    y = endy - h;
                }
                g.setColor(imgIndex[index]);
                if (trans[index] == 99) {
                    g.fillArc(endx, y, (int)w, (int)h, (int)rw, (int)rh);
                    break;
                }
                g.drawArc(endx, y, (int)w, (int)h, (int)rw, (int)rh);
                break;
            }
            case 14: {
                Tools.drawClipImage(g, imgIndex[index], endx, endy, -1, -1, clipW[index], clipH[index], anchor[index], trans[index], alf[index]);
                break;
            }
            case 5: {
                Tools.drawClipImage(g, imgIndex[index], endx, endy, clipX[index], clipY[index], clipW[index], clipH[index], anchor[index], trans[index], alf[index]);
                Tools.alf[index] = 0;
                break;
            }
            case 11: {
                short w = clipW[index];
                short h = clipH[index];
                int[] rgbdata = new int[w];
                int i = 0;
                while (i < rgbdata.length) {
                    rgbdata[i] = imgIndex[index];
                    ++i;
                }
                g.drawRGB(rgbdata, 0, 0, endx, endy, (int)w, (int)h, true);
                break;
            }
            case 13: {
                short w = clipW[index];
                short h = clipH[index];
                int[] rgbCircleData = Tools.getCircleAry(w, imgIndex[index]);
                g.drawRGB(rgbCircleData, 0, 2 * w, endx, endy, w * 2, h * 2, true);
                break;
            }
            case 1: {
                int y = endy;
                short w = clipW[index];
                short h = clipH[index];
                if (anchor[index] == 2) {
                    y = endy - h;
                }
                g.setColor(imgIndex[index]);
                if (trans[index] == 99) {
                    if (w == 1) {
                        g.drawLine(endx, y, endx, y + h);
                    } else if (h == 1) {
                        g.drawLine(endx, y, endx + w, y);
                    }
                    g.fillRect(endx, y, (int)w, (int)h);
                    break;
                }
                g.drawRect(endx, y, (int)w, (int)h);
                break;
            }
            case 0: {
                int y = endy;
                short rw = clipX[index];
                short rh = clipY[index];
                short w = clipW[index];
                short h = clipH[index];
                if (anchor[index] == 2) {
                    y = endy - h;
                }
                g.setColor(imgIndex[index]);
                if (trans[index] == 99) {
                    g.fillRoundRect(endx, y, (int)w, (int)h, (int)rw, (int)rh);
                    break;
                }
                g.drawRoundRect(endx, y, (int)w, (int)h, (int)rw, (int)rh);
                break;
            }
            case 4: {
                Tools.drawColorString(g, str[index], endx, endy, anchor[index], imgIndex[index]);
                Tools.str[index] = null;
                break;
            }
            case 6: {
                int number = imgIndex[index];
                short img = clipX[index];
                short spacing = clipW[index];
                short count = clipH[index];
                Tools.drawNum(g, number, img, endx, endy, spacing, count, anchor[index]);
                break;
            }
            case 8: {
                byte[][] frameDat = (byte[][])arrayV.elementAt(clipX[index]);
                byte[][] clipDat = (byte[][])arrayV.elementAt(clipY[index]);
                short frameindex = clipW[index];
                boolean isMirror = trans[index] == 1;
                short[] size = Tools.getFrameSize(frameDat[frameindex]);
                short offX = 0;
                int offY = 0;
                switch (anchor[index]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        offY = size[1] / 2;
                        break;
                    }
                    case 2: {
                        offY = size[1];
                        break;
                    }
                    case 6: {
                        offX = size[0];
                        break;
                    }
                    case 7: {
                        offX = size[0];
                        offY = size[1] / 2;
                        break;
                    }
                    case 8: {
                        offX = size[0];
                        offY = size[1];
                    }
                }
                Tools.drawFrame(g, imgIndex[index], frameDat, clipDat, endx - offX, endy - offY, frameindex, isMirror, alf[index]);
                Tools.alf[index] = 0;
                break;
            }
            case 9: {
                int sx = endx;
                int sy = endy + (anchor[index] == 4 ? GCanvas.strHeight / 2 : 0);
                int rgb = clipX[index] << 16 | clipY[index];
                Tools.drawColorString(g, str[index], sx + 1, sy, anchor[index], rgb);
                Tools.drawColorString(g, str[index], sx + 1, sy + 1, anchor[index], rgb);
                Tools.drawColorString(g, str[index], sx, sy + 1, anchor[index], rgb);
                Tools.drawColorString(g, str[index], sx, sy, anchor[index], imgIndex[index]);
                Tools.str[index] = null;
                break;
            }
            case 10: {
                char[][] chars = (char[][])arrayV.elementAt(imgIndex[index]);
                int charAnchor = anthors[anchor[index]];
                short offX = clipW[index];
                short offY = clipH[index];
                int start = clipX[index];
                short end = clipY[index];
                byte max = trans[index];
                int len = chars[0].length;
                int charW = Math.min(len, max) * offX - (offX - GCanvas.strHeight);
                int sx = endx;
                if (Tools.checkAnthor(charAnchor, 1)) {
                    sx -= charW / 2;
                }
                int i = start;
                while (i < end) {
                    g.setColor(Tools.getColor(chars[1][i]));
                    g.drawChar(chars[0][i], sx + (i - start) % max * offX, endy + (i - start) / max * offY, 0x10 | 4);
                    ++i;
                }
                break;
            }
            case 12: {
                char[][] chars = (char[][])arrayV.elementAt(imgIndex[index]);
                int charAnchor = anthors[anchor[index]];
                short offX = clipW[index];
                short offY = clipH[index];
                int start = clipX[index];
                short end = clipY[index];
                byte max = trans[index];
                int len = chars[0].length;
                int charW = Math.min(len, max) * offX - (offX - GCanvas.strHeight);
                int sx = endx;
                if (Tools.checkAnthor(charAnchor, 1)) {
                    sx -= charW / 2;
                }
                int i = start;
                while (i < end) {
                    g.setColor(Tools.getColor(chars[1][i]));
                    g.drawChar(chars[0][i], sx - (i - start) / max * offX, endy + (i - start) % max * offY, 0x10 | 4);
                    ++i;
                }
                break;
            }
            case 99: {
                g.setClip(endx, endy, (int)clipW[index], (int)clipH[index]);
            }
        }
    }

    private static boolean checkAnthor(int anchor, int dir) {
        switch (dir) {
            case 4: {
                return (anchor >> 2 & 1) == 1;
            }
            case 1: {
                return (anchor & 1) == 1;
            }
            case 8: {
                return (anchor >> 3 & 1) == 1;
            }
            case 16: {
                return (anchor >> 4 & 1) == 1;
            }
            case 2: {
                return (anchor >> 1 & 1) == 1;
            }
            case 32: {
                return (anchor >> 5 & 1) == 1;
            }
        }
        return false;
    }

    private static short[] getFrameSize(byte[] dat) {
        short[] size = new short[]{(short)(Tools.bToi(dat[0]) << 8 | Tools.bToi(dat[1])), (short)(Tools.bToi(dat[2]) << 8 | Tools.bToi(dat[3]))};
        return size;
    }

    public static int conversionRatio(int vaule, int ratio) {
        return Math.max(0, vaule * ratio / 100);
    }

    public static int simpleFormula(int base, int up, int level) {
        return up * level + base;
    }

    public static byte limit(int value) {
        return (byte)Math.max(0, Math.min(value, 100));
    }

    public static int getDigitCounter(int num) {
        int digitCounter = 0;
        while (num > 0) {
            num /= 10;
            ++digitCounter;
        }
        return digitCounter;
    }

    private static void drawNum(Graphics g, int number, int imgIndex, int x, int y, int spacing, int count, byte anthor) {
        int digitCounter = 0;
        int[] digits = new int[10];
        do {
            digits[digitCounter] = number % 10;
            ++digitCounter;
        } while ((number /= 10) > 0);
        int numWidth = Tools.getImage(imgIndex).getWidth() / count;
        int numHeight = Tools.getImage(imgIndex).getHeight();
        switch (anthor) {
            case 0: 
            case 1: 
            case 2: {
                int i = digitCounter - 1;
                while (i >= 0) {
                    Tools.drawClipImage(g, imgIndex, x, y, digits[i] * numWidth, 0, numWidth, numHeight, anthor, 0, 0);
                    --i;
                    x += spacing + numWidth;
                }
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                int i = 0;
                while (i <= digitCounter - 1) {
                    Tools.drawClipImage(g, imgIndex, x, y, digits[i] * numWidth, 0, numWidth, numHeight, anthor, 0, 0);
                    ++i;
                    x -= spacing + numWidth;
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                x -= (numWidth + spacing) * (digitCounter - 1) / 2;
                int i = digitCounter - 1;
                while (i >= 0) {
                    Tools.drawClipImage(g, imgIndex, x, y, digits[i] * numWidth, 0, numWidth, numHeight, anthor, 0, 0);
                    --i;
                    x += spacing + numWidth;
                }
                break;
            }
        }
    }

    public static boolean getProperties(short val, byte bit) {
        return (val >> bit & 1) == 1;
    }

    public short setProperties(short value, int pos) {
        return (short)(value | 1 << pos);
    }

    static void createImage(String[][] mName) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < mName.length) {
            int len = mName[i].length;
            Tools.imgGroup[Tools.mapGroup + i] = new Image[len];
            int j = 0;
            while (j < len) {
                String name = mName[i][j];
                if (!v.contains(name)) {
                    v.addElement(name);
                }
                ++j;
            }
            ++i;
        }
        Object[] names = new String[v.size()];
        v.copyInto(names);
        v = null;
        DataInputStream dis = Tools.openFile("/images/tile.pak");
        try {
            Data.openPack(dis);
            int[] oIndex = Data.strOrder(Data.files, (String[])names);
            int skip = 0;
            int i2 = 0;
            while (i2 < oIndex.length) {
                int index = oIndex[i2];
                int offset = index == 0 ? 0 : Data.offsetArray[index - 1];
                int len = Data.offsetArray[index] - offset;
                byte[] imgData = new byte[len];
                dis.skip(offset - skip);
                dis.read(imgData);
                Image img = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                Tools.setMapImage(mName, Data.files[oIndex[i2]], img);
                skip = Data.offsetArray[index];
                ++i2;
            }
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setMapImage(String[][] mName, String curName, Image img) {
        int i = 0;
        while (i < mName.length) {
            int j = 0;
            while (j < mName[i].length) {
                if (curName.equals(mName[i][j])) {
                    Tools.imgGroup[Tools.mapGroup + i][j] = img;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static int bToi(int byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public static boolean percent(int per) {
        int rnd = Tools.nextInt(0, 99);
        return rnd < per;
    }

    public static final long sqrt(long v) {
        if (v > 0L) {
            long c;
            v *= 10000L;
            long r = 10000L;
            while ((r = (v / r + r) / 2L) < (c = r)) {
            }
            return c;
        }
        return 0L;
    }

    static int square(int base, int exponent) {
        int pro = 1;
        int i = 0;
        while (i < exponent) {
            pro *= base;
            ++i;
        }
        return pro;
    }

    public static boolean hit(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        if (w1 == 0 || h1 == 0 || w2 == 0 || h2 == 0) {
            return false;
        }
        return x1 < x2 + w2 && x2 < x1 + w1 && (y1 -= h1) < (y2 -= h2) + h2 && y2 < y1 + h1;
    }

    public static boolean hit2(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        if (w1 == 0 || h1 == 0 || w2 == 0 || h2 == 0) {
            return false;
        }
        return x1 + w1 >= x2 && x1 <= x2 + w2 && y1 <= y2 + h2 && y1 + h1 >= y2;
    }

    static int getMotionValue(byte[] motion, int index) {
        switch (index) {
            case 0: {
                return Tools.bToi(motion[0]);
            }
            case 1: {
                return motion[1] & 3;
            }
            case 2: {
                int v1 = motion[1] >> 2 & 0x3F;
                int v2 = v1 & 0x1F;
                return (v1 >> 5 & 1) == 0 ? v2 : -v2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                long d1 = Tools.bToi(motion[2]);
                long d2 = Tools.bToi(motion[3]);
                long d3 = Tools.bToi(motion[4]);
                long d4 = Tools.bToi(motion[5]);
                long d5 = Tools.bToi(motion[6]);
                long temp = d1 << 32 | d2 << 24 | d3 << 16 | d4 << 8 | d5;
                int tmp = (int)(temp >> 30 - (index - 3) * 10 & 0x3FFL);
                return (tmp & 0x200) == 0 ? tmp & 0x1FF : -(tmp & 0x1FF);
            }
        }
        System.out.println("getMotionValue error!");
        return Integer.MAX_VALUE;
    }

    static int getMotionValue(short[] motion, int index) {
        switch (index) {
            case 0: {
                return Tools.bToi(motion[0]);
            }
            case 1: {
                return motion[1] & 3;
            }
            case 2: {
                int v1 = motion[1] >> 2 & 0x3F;
                int v2 = v1 & 0x1F;
                return (v1 >> 5 & 1) == 0 ? v2 : -v2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                long d1 = Tools.bToi(motion[2]);
                long d2 = Tools.bToi(motion[3]);
                long d3 = Tools.bToi(motion[4]);
                long d4 = Tools.bToi(motion[5]);
                long d5 = Tools.bToi(motion[6]);
                long temp = d1 << 32 | d2 << 24 | d3 << 16 | d4 << 8 | d5;
                int tmp = (int)(temp >> 30 - (index - 3) * 10 & 0x3FFL);
                return (tmp & 0x200) == 0 ? tmp & 0x1FF : -(tmp & 0x1FF);
            }
        }
        System.out.println("getMotionValue error!");
        return Integer.MAX_VALUE;
    }

    public static int nextInt(int n) {
        return Math.abs(rnd.nextInt()) % (n + 1);
    }

    public static int nextInt(int n, int m) {
        if (n == m) {
            return n;
        }
        if (n > m) {
            int temp = n;
            n = m;
            m = temp;
        }
        return Math.abs(rnd.nextInt()) % (m - n + 1) + n;
    }

    static void drawAll(Graphics g) {
        Tools.sort();
        int i = 0;
        while (i < group.length) {
            int j = 0;
            while (j < gIndex[i]) {
                Tools.drawMe(g, group[i][j]);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < gIndex.length) {
            Tools.gIndex[i2] = 0;
            ++i2;
        }
        max_obj = 0;
        arrayV.removeAllElements();
    }

    private static void sort() {
        int i = 0;
        while (i < max_obj) {
            int j = layer.length - 1;
            while (j >= 0) {
                if (drawLevel[drawObj[i]] >= layer[j]) {
                    Tools.group[j][Tools.gIndex[j]] = drawObj[i];
                    int n = j;
                    gIndex[n] = (short)(gIndex[n] + 1);
                    break;
                }
                --j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < group.length) {
            Tools.sortIngroup(group[i2], gIndex[i2]);
            ++i2;
        }
    }

    private static void sortIngroup(short[] array, int max) {
        int i = 1;
        while (i < max) {
            if (drawLevel[array[i]] < drawLevel[array[i - 1]]) {
                short temp = array[i];
                int j = i - 1;
                do {
                    array[j + 1] = array[j];
                } while (--j >= 0 && drawLevel[temp] < drawLevel[array[j]]);
                array[j + 1] = temp;
            }
            ++i;
        }
    }

    public static int fac(int num, int baseNum) {
        int numAbs = Math.abs(num);
        int beishu = numAbs / baseNum;
        int moshu = numAbs % baseNum;
        return (beishu + (moshu >= baseNum / 2 ? 1 : 0)) * baseNum * (num > 0 ? 1 : -1);
    }

    public static int distance(int x1, int y1, int x2, int y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    static byte getNumberLength(int number) {
        if (number == 0) {
            return 1;
        }
        byte count = 0;
        do {
            count = (byte)(count + 1);
        } while ((number /= 10) != 0);
        return count;
    }

    static void slipnum(int number, int[] slipNum) {
        int tempnumber = number;
        int count = 0;
        while (tempnumber > 0) {
            slipNum[count] = tempnumber % 10;
            tempnumber /= 10;
            count = (byte)(count + 1);
        }
    }

    public static void getChangeString(String str, char[][] outPut) {
        int strLen;
        int tempLen = strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (str.charAt(i) == '#' && str.charAt(i + 1) != '\u952e') {
                tempLen -= 2;
            }
            ++i;
        }
        outPut[0] = new char[tempLen];
        outPut[1] = new char[tempLen];
        tempLen = 0;
        int col = 65;
        int i2 = 0;
        while (i2 < strLen) {
            char c = str.charAt(i2);
            if (c == '#' && str.charAt(i2 + 1) != '\u952e') {
                col = str.charAt(++i2);
            } else {
                outPut[0][tempLen] = c;
                outPut[1][tempLen] = col;
                ++tempLen;
            }
            ++i2;
        }
    }

    private static int[] getCircleAry(int r, int alpha) {
        int[] aryTmp = new int[4 * r * r];
        int i = 0;
        while (i < 4 * r * r) {
            int x = i / (2 * r);
            int y = i % (2 * r);
            int iSum = (r - x) * (r - x) + (r - y) * (r - y);
            aryTmp[i] = iSum > r * r ? 0xFF0000 : alpha;
            ++i;
        }
        return aryTmp;
    }

    public static short[] deleteArray(short[] array, byte position) {
        short[] t_array = null;
        if (array.length <= 0) {
            return t_array;
        }
        t_array = new short[array.length - 1];
        int temp = 0;
        int i = 0;
        while (i < array.length) {
            if (i != position) {
                t_array[temp] = array[i];
                ++temp;
            }
            ++i;
        }
        return t_array;
    }

    public static short[] addArray(short[] array, byte position, short value) {
        short[] t_array = new short[array.length + 1];
        int temp = 0;
        int i = 0;
        while (i < t_array.length) {
            if (i == position) {
                t_array[temp] = value;
                if (++temp < t_array.length) {
                    t_array[temp] = array[i];
                    ++temp;
                }
            } else if (temp < t_array.length) {
                t_array[temp] = array[i];
                ++temp;
            }
            ++i;
        }
        return t_array;
    }

    public static void exchangeArrayValue(short[] array1, byte position1, short[] array2, byte position2) {
        short tempHeroId = array1[position1];
        array1[position1] = array2[position2];
        array2[position2] = tempHeroId;
    }

    public static boolean inArea(int[] area, int[] ponit) {
        return ponit[0] > area[0] && ponit[0] < area[0] + area[2] && ponit[1] > area[1] && ponit[1] < area[1] + area[3];
    }

    public static boolean rectAndCircle(int[] rect, int[] circle) {
        int[][] point = new int[][]{{rect[0], rect[1]}, {rect[0] + rect[2], rect[1]}, {rect[0], rect[1] + rect[3]}, {rect[0] + rect[2], rect[1] + rect[3]}, {rect[0] + rect[2] / 2, rect[1] + rect[3] / 2}};
        int i = 0;
        while (i < point.length) {
            int iSum = (circle[0] - point[i][0]) * (circle[0] - point[i][0]) + (circle[1] - point[i][1]) * (circle[1] - point[i][1]);
            if (iSum < circle[2] * circle[2]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean rectAndRect(int ex, int ey, int fx, int fy, int range) {
        int[] p = new int[]{ex, ey};
        int[][] area = new int[][]{{fx - Map.tileWidth / 2 - range, fy - Map.tileHight / 2, range, Map.tileHight}, {fx - Map.tileWidth / 2, fy + Map.tileHight / 2, Map.tileWidth, range}, {fx + Map.tileWidth / 2, fy - Map.tileHight / 2, range, Map.tileHight}, {fx - Map.tileWidth / 2, fy - Map.tileHight / 2 - range, Map.tileWidth, range}};
        int i = 0;
        while (i < area.length) {
            if (Tools.inArea(area[i], p)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addMaskString(String[] str, int x, int y, int num, int rowH, int[] color, int drawLev) {
        int tempH = 0;
        int tempW = num * 20;
        int tempX = 0;
        int tempY = 0;
        int temp_x = 10;
        int temp_y = 10;
        int tempRowH = 0;
        int i = 0;
        while (i < str.length) {
            String tempstr = str[i];
            tempH = tempstr.length() % num != 0 ? (tempH += (tempstr.length() / num + 1) * GCanvas.strHeight) : (tempH += tempstr.length() / num * GCanvas.strHeight);
            ++i;
        }
        tempY = y - tempH / 2 < 0 ? 0 : (y + tempH / 2 > Map.setOffY + Map.screenHeight ? Map.screenHeight - tempH : y - tempH / 2);
        tempX = x < Map.setOffX + Map.screenWidth / 2 ? x + temp_x + 70 : x - tempW - temp_x;
        Tools.addMask(tempX - 2, tempY - 2, tempW + 4, tempH + 4, -1157627904, drawLev);
        int i2 = 0;
        while (i2 < str.length) {
            int row = Tools.drawString(str[i2], num, color[i2], drawLev, tempX, tempY, tempRowH);
            tempRowH += GCanvas.strHeight * row;
            ++i2;
        }
    }

    public static int drawString(String str, int num, int color, int drawLev, int tempX, int tempY, int tempRowH) {
        char[][] strInfo = new char[2][];
        Tools.getChangeString(str, strInfo);
        int len = strInfo[0].length;
        int row = len / num + (len % num == 0 ? 0 : 1);
        int k = 0;
        while (k < row) {
            int j = 0;
            while (k * num + j < len && j < num) {
                Tools.addString(strInfo[0][k * num + j] + "", tempX + j * 20, tempY + tempRowH + GCanvas.strHeight * k, (byte)0, color, drawLev);
                ++j;
            }
            ++k;
        }
        return row;
    }

    public static final Image alfImage(Image img, int alf) {
        int imgW = img.getWidth();
        int imgH = img.getHeight();
        int[] RGBData = new int[imgW * imgH];
        img.getRGB(RGBData, 0, imgW, 0, 0, imgW, imgH);
        int i = 0;
        while (i < RGBData.length) {
            int n = i++;
            RGBData[n] = RGBData[n] & alf;
        }
        Image o_Img = Image.createRGBImage((int[])RGBData, (int)imgW, (int)imgH, (boolean)true);
        return o_Img;
    }

    public static Image scaleImage(Image src, int scales1, int scales2) {
        Image desImg = null;
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcBuf = new int[srcW * srcH];
        int desW = srcW * scales1 / scales2;
        int desH = srcH * scales1 / scales2;
        src.getRGB(srcBuf, 0, srcW, 0, 0, srcW, srcH);
        int[] tabY = new int[desH];
        int[] tabX = new int[desW];
        int sb = 0;
        int db = 0;
        int tems = 0;
        int temd = 0;
        int distance = srcH > desH ? srcH : desH;
        int i = 0;
        while (i <= distance) {
            tabY[db] = sb++;
            temd += desH;
            if ((tems += srcH) > distance) {
                tems -= distance;
            }
            if (temd > distance) {
                temd -= distance;
                ++db;
            }
            ++i;
        }
        sb = 0;
        db = 0;
        tems = 0;
        temd = 0;
        distance = srcW > desW ? srcW : desW;
        int i2 = 0;
        while (i2 <= distance) {
            tabX[db] = (short)sb;
            temd += desW;
            if ((tems += srcW) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd > distance) {
                temd -= distance;
                ++db;
            }
            ++i2;
        }
        int[] desBuf = new int[desW * desH];
        int dx = 0;
        int dy = 0;
        int sy = 0;
        int oldy = -1;
        int i3 = 0;
        while (i3 < desH) {
            if (oldy == tabY[i3]) {
                System.arraycopy(desBuf, dy - desW, desBuf, dy, desW);
            } else {
                dx = 0;
                int j = 0;
                while (j < desW) {
                    desBuf[dy + dx] = srcBuf[sy + tabX[j]];
                    ++dx;
                    ++j;
                }
                sy += (tabY[i3] - oldy) * srcW;
            }
            oldy = tabY[i3];
            dy += desW;
            ++i3;
        }
        desImg = Image.createRGBImage((int[])desBuf, (int)desW, (int)desH, (boolean)true);
        return desImg;
    }

    static int[] changeClipData(byte[] clip) {
        int[] newCilp;
        block3: {
            block2: {
                newCilp = new int[4];
                if (clip.length != 4) break block2;
                int i = 0;
                while (i < newCilp.length) {
                    newCilp[i] = Tools.bToi(clip[i]);
                    ++i;
                }
                break block3;
            }
            if (clip.length != 8) break block3;
            int i = 0;
            while (i < newCilp.length) {
                newCilp[i] = (Tools.bToi(clip[i * 2]) << 8) + Tools.bToi(clip[i * 2 + 1]);
                ++i;
            }
        }
        return newCilp;
    }

    static byte getQD(int x1, int y1, int x2, int y2) {
        if (x2 > x1) {
            return (byte)(y2 > y1 ? 4 : 1);
        }
        return (byte)(y2 > y1 ? 3 : 2);
    }

    static int[] getPonitFromRect(int[] rect, int[] p) {
        if (Tools.inArea(rect, p)) {
            return p;
        }
        if (p[0] <= rect[0]) {
            if (p[1] >= rect[1] + rect[3]) {
                return new int[]{rect[0], rect[1] + rect[3]};
            }
            if (p[1] <= rect[1]) {
                return new int[]{rect[0], rect[1]};
            }
            return new int[]{rect[0], p[1]};
        }
        if (p[0] >= rect[0] + rect[2]) {
            if (p[1] >= rect[1] + rect[3]) {
                return new int[]{rect[0] + rect[2], rect[1] + rect[3]};
            }
            if (p[1] <= rect[1]) {
                return new int[]{rect[0] + rect[2], rect[1]};
            }
            return new int[]{rect[0] + rect[2], p[1]};
        }
        if (p[1] >= rect[1] + rect[3]) {
            return new int[]{p[0], rect[1] + rect[3]};
        }
        if (p[1] <= rect[1]) {
            return new int[]{p[0], rect[1]};
        }
        return p;
    }

    public static String[] cilpString(String str, int maxChar) {
        int len = str.length() / maxChar + (str.length() % maxChar == 0 ? 0 : 1);
        String[] data = new String[len];
        int i = 0;
        while (i < len) {
            data[i] = str.substring(i * maxChar, Math.min(i * maxChar + maxChar, str.length()));
            ++i;
        }
        return data;
    }

    public static int sin(int angle) {
        angle += 3600;
        if ((angle %= 360) <= 90) {
            return SIN[angle];
        }
        if (angle <= 180) {
            return SIN[180 - angle];
        }
        if (angle <= 270) {
            return -SIN[angle - 180];
        }
        return -SIN[360 - angle];
    }

    public static int cos(int angle) {
        angle += 3600;
        if ((angle %= 360) <= 90) {
            return Tools.sin(90 - angle);
        }
        if (angle <= 180) {
            return -Tools.sin(angle - 90);
        }
        if (angle <= 270) {
            return -Tools.sin(270 - angle);
        }
        return Tools.sin(angle - 270);
    }

    public static int getTan(int k) {
        try {
            if (k >= TANKK[TANKK.length - 1]) {
                return 90;
            }
            int i = 0;
            while (i < TANKK.length) {
                if (i == TANKK.length - 1) {
                    return 90;
                }
                if (k < TANKK[i]) {
                    if (k - TANKK[i] > TANKK[i + 1] - k) {
                        return TAN[i + 1];
                    }
                    return TAN[i];
                }
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("aaaaaaaaaa:" + k + " ");
        }
        return 0;
    }

    public static int tan(int x, int y, int x2, int y2) {
        if (Math.abs(x - x2) == 0) {
            if (y < y2) {
                return 0;
            }
            return 180;
        }
        int k = Math.abs(y - y2) * 100 / Math.abs(x - x2);
        if (x > x2 && y <= y2) {
            return 90 - Tools.getTan(k);
        }
        if (x >= x2 && y > y2) {
            return Tools.getTan(k) + 90;
        }
        if (x < x2 && y >= y2) {
            return 270 - Tools.getTan(k);
        }
        if (x <= x2 && y < y2) {
            return Tools.getTan(k) + 270;
        }
        return 180;
    }

    public static String[] changeString(String str, int maxChar) {
        int len = str.length() / maxChar + (str.length() % maxChar == 0 ? 0 : 1);
        String[] data = new String[len];
        int i = 0;
        while (i < len) {
            data[i] = str.substring(i * maxChar, Math.min(i * maxChar + maxChar, str.length()));
            ++i;
        }
        return data;
    }

    static {
        dirNames = new String[]{"deck", "effect", "open", "sprite", "game", "bullet", "map", "shandow", "public", "more", "menuchoose", "super", "touch", "show"};
        mapGroup = dirNames.length;
        imgGroup = new Image[mapGroup + 5][];
        anthors = new int[]{20, 5, 36, 17, 3, 33, 24, 10, 40};
        s = "a";
        wave = new byte[]{0, -6, -10, -11, -12, -11, -10, -6, 0};
        curIndex = 0;
        max_obj = 0;
        drawObj = new short[500];
        clipX = new short[500];
        clipY = new short[500];
        clipW = new short[500];
        clipH = new short[500];
        x = new short[500];
        y = new short[500];
        drawLevel = new short[500];
        imgIndex = new int[500];
        anchor = new byte[500];
        trans = new byte[500];
        str = new String[500];
        type = new byte[500];
        arrayV = new Vector();
        alf = new int[500];
        rnd = new Random();
        layer = new short[]{0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000};
        group = new short[layer.length][1000];
        gIndex = new short[layer.length];
        SIN = new int[]{0, 1143, 2287, 3429, 4571, 5711, 6850, 7986, 9120, 10252, 11380, 12504, 13625, 14742, 15854, 16961, 18064, 19160, 20251, 21336, 22414, 23486, 24550, 25606, 26655, 27696, 28729, 29752, 30767, 31772, Short.MAX_VALUE, 33753, 34728, 35693, 36647, 37589, 38521, 39440, 40347, 41243, 42125, 42995, 43852, 44695, 45525, 46340, 47142, 47929, 48702, 49460, 50203, 50931, 51643, 52339, 53019, 53683, 54331, 54963, 55577, 56175, 56755, 57319, 57864, 58393, 58903, 59395, 59870, 60326, 60763, 61183, 61583, 61965, 62328, 62672, 62997, 63302, 63589, 63856, 64103, 64331, 64540, 64729, 64898, 65047, 65176, 65286, 65376, 65446, 65496, 65526, 65536};
        TANKK = new int[]{0, 1, 3, 5, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 53, 55, 57, 60, 62, 64, 67, 70, 72, 75, 78, 80, 83, 86, 90, 93, 96, 99, 103, 107, 111, 115, 119, 123, 127, 132, 137, 142, 148, 153, 160, 166, 173, 180, 188, 196, 205, 214, 224, 235, 247, 260, 274, 290, 307, 327, 348, 373, 401, 433, 470, 514, 567, 631, 711, 814, 951, 1143, 1430, 1908, 2863, 5728};
        TAN = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89};
    }
}

