/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class Level {
    static final int MAX_FIGURES = 25;
    static int TIME_TO_NEXT_ROW = 20000;
    static int TIME_TO_MOVE_ANCHOR = 18000;
    static int MAX_NUBERS_OF_LEVELS = 50;
    boolean bArcadeMode;
    int iLevelNum;
    int iLevelTimer;
    int iTimeToAction;
    int iTimeToActionInit;
    int iTimeToActionDelay;
    int iTypeOfBackground = 0;
    boolean bRefreshStatusBar;
    boolean bRefreshStatusScore;
    boolean bRefreshStatusPerls;
    Player player;
    Perls perls;
    int iPerlWidth;
    int iPerlWidth2;
    int[] figType = new int[25];
    static byte[] figState;
    static byte[] figRes1;
    static byte[] figRes2;
    static byte[] figRes3;
    static byte[] figRes4;
    static int[] figRes5;
    static int[] figRes6;
    static int[] figRes7;
    static int[] figRes8;
    int idx_star;
    int idx_hedgegog;
    int idx_octopus;
    int idx_fish;
    int iSelectedFlag;
    int iSelectedLevel;
    int[] iaLevelScore = null;
    int[] iaLevelBonus = null;
    int[] iaLevelTime = null;
    int[] iaLevelPerls = null;
    byte[] baLevelLock = null;
    byte[] baLevelMedal = null;
    byte[] baLevelPlayed = null;
    byte[] baAchievements = null;
    int iLastPerlsTop;
    boolean bFinaleNextRow;
    long lArcadeTotalTime;
    long lArcadeBubbles;
    long lArcadeTotalBubbles;
    int iArcadePlayedTimes;
    int iArcadeTopScore;
    long lStoryTotalTime;
    boolean bStoryCompleted;
    int iShrimpHits;
    int iArcadePerlsLeft;
    int iArcadeLevel;
    Vector vecStatsLeft;
    Vector vecStatsRight;
    RecordStore rsobj_loadsave = null;
    int iStatusColor1;
    int iStatusColor2;
    int iStatusColor3;
    int iStatusColor4;
    int[] iaTimeBarColors = new int[]{14510384, 15956289, 0xF9966F};
    boolean bRefreshStatusBarOverride = true;
    int[] mapX = new int[]{253, 214, 156, 119, 91, 73, 116, 190, 263, 330, 363, 345, 278, 221, 166, 122, 141, 201, 268, 330, 340};
    int[] mapY = new int[]{6, 90, 130, 185, 263, 200, 311, 330, 335, 351, 287, 401, 439, 471, 494, 421, 547, 577, 596, 595, 503};
    int buoyDepth = 0;

    Level() {
        Debug.trace("Level() - in");
        this.iaLevelScore = new int[MAX_NUBERS_OF_LEVELS];
        this.iaLevelBonus = new int[MAX_NUBERS_OF_LEVELS];
        this.iaLevelTime = new int[MAX_NUBERS_OF_LEVELS];
        this.iaLevelPerls = new int[MAX_NUBERS_OF_LEVELS];
        this.baLevelLock = new byte[MAX_NUBERS_OF_LEVELS];
        this.baLevelMedal = new byte[MAX_NUBERS_OF_LEVELS];
        this.baLevelPlayed = new byte[MAX_NUBERS_OF_LEVELS];
        this.baAchievements = new byte[12];
        this.vecStatsLeft = X.canvas.vecStatsLeft;
        this.vecStatsRight = X.canvas.vecStatsRight;
        this.createObjects();
        this.bArcadeMode = false;
        this.loadGame("STATS", true);
        this.updateLevelLocks();
        Debug.trace("Level() - out");
    }

    void createObjects() {
        this.player = new Player();
        this.perls = new Perls();
        this.figType = new int[25];
        figState = new byte[25];
        figRes1 = new byte[25];
        figRes2 = new byte[25];
        figRes3 = new byte[25];
        figRes4 = new byte[25];
        figRes5 = new int[25];
        figRes6 = new int[25];
        figRes7 = new int[25];
        figRes8 = new int[25];
        GameDef.octopusBounce = figRes1;
        GameDef.hedgegogBounce = figRes1;
        GameDef.figFrame = figRes1;
        GameDef.figOffs = figRes2;
        GameDef.figStateTimer = figRes5;
        GameDef.figAngle = figRes6;
        GameDef.figCol = figRes3;
        GameDef.figRow = figRes4;
        GameDef.figDepth = figRes5;
        GameDef.figPerl = figRes6;
        GameDef.figSpeed = figRes7;
        GameDef.figPosX = figRes8;
    }

    void resetStory() {
        int i;
        Debug.trace("Level.resetStory() - in");
        this.iSelectedFlag = 0;
        this.iSelectedLevel = 0;
        for (i = this.iaLevelScore.length - 1; i >= 0; --i) {
            this.iaLevelScore[i] = 0;
            this.iaLevelBonus[i] = 0;
            this.iaLevelTime[i] = -1;
            this.iaLevelPerls[i] = 0;
            this.baLevelLock[i] = 0;
            this.baLevelMedal[i] = -1;
            this.baLevelPlayed[i] = 0;
        }
        for (i = this.baAchievements.length - 1; i >= 0; --i) {
            this.baAchievements[i] = 0;
        }
        this.updateLevelLocks();
        this.lStoryTotalTime = 0L;
        this.bStoryCompleted = false;
        this.saveGame("STATS", true);
        Debug.trace("Level.resetStory() - out");
    }

    void resetStats() {
        Debug.trace("Level.resetStats() - in");
        this.resetStory();
        this.lArcadeBubbles = 0L;
        this.lArcadeTotalBubbles = 0L;
        this.lArcadeTotalTime = 0L;
        this.iArcadePlayedTimes = 0;
        this.iArcadeTopScore = 0;
        this.saveGame("STATS", true);
        Debug.trace("Level.resetStats() - out");
    }

    void updateLevelLocks() {
        int i;
        int cnt = 0;
        int iUnlock = 0;
        for (i = 0; i < 10; ++i) {
            this.baLevelLock[i] = i < 3 ? (byte)0 : 1;
        }
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i] <= 0 || this.baLevelPlayed[i] >= 100) continue;
            this.baLevelLock[i] = 0;
            ++cnt;
            iUnlock = i;
        }
        if (cnt >= 3) {
            this.baLevelLock[iUnlock + 1] = 0;
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 10] <= 0 || this.baLevelPlayed[i + 10] >= 100) continue;
            ++cnt;
        }
        for (i = 5; i >= 4; --i) {
            this.baLevelLock[i + 10] = (byte)(cnt < 4 ? 1 : 0);
        }
        for (i = 7; i >= 6; --i) {
            this.baLevelLock[i + 10] = (byte)(cnt < 6 ? 1 : 0);
        }
        for (i = 9; i >= 8; --i) {
            this.baLevelLock[i + 10] = (byte)(cnt < 8 ? 1 : 0);
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 20] <= 0 || this.baLevelPlayed[i + 20] >= 100) continue;
            ++cnt;
        }
        for (i = 5; i >= 3; --i) {
            this.baLevelLock[i + 20] = (byte)(cnt < 3 ? 1 : 0);
        }
        for (i = 9; i >= 6; --i) {
            this.baLevelLock[i + 20] = (byte)(cnt < 6 ? 1 : 0);
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 30] <= 0 || this.baLevelPlayed[i + 30] >= 100) continue;
            ++cnt;
        }
        this.baLevelLock[32] = (byte)(cnt < 2 ? 1 : 0);
        for (i = 5; i >= 3; --i) {
            this.baLevelLock[i + 30] = (byte)(cnt < 3 ? 1 : 0);
        }
        this.baLevelLock[36] = (byte)(cnt < 6 ? 1 : 0);
        this.baLevelLock[37] = (byte)(cnt < 7 ? 1 : 0);
        for (i = 9; i >= 8; --i) {
            this.baLevelLock[i + 30] = (byte)(cnt < 8 ? 1 : 0);
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 30] <= 0 || this.baLevelPlayed[i + 40] >= 100) continue;
            ++cnt;
        }
        this.baLevelLock[32] = (byte)(cnt < 2 ? 1 : 0);
        for (i = 5; i >= 3; --i) {
            this.baLevelLock[i + 40] = (byte)(cnt < 3 ? 1 : 0);
        }
        this.baLevelLock[36] = (byte)(cnt < 6 ? 1 : 0);
        this.baLevelLock[37] = (byte)(cnt < 7 ? 1 : 0);
        for (i = 9; i >= 8; --i) {
            this.baLevelLock[i + 30] = (byte)(cnt < 8 ? 1 : 0);
        }
    }

    void destroy() {
        Debug.trace("Level.destroy() - in");
        this.saveGame("STATS", true);
        this.figType = null;
        figState = null;
        figRes1 = null;
        figRes2 = null;
        figRes3 = null;
        figRes4 = null;
        figRes5 = null;
        figRes6 = null;
        figRes7 = null;
        figRes8 = null;
        this.iaLevelScore = null;
        this.iaLevelBonus = null;
        this.iaLevelTime = null;
        this.iaLevelPerls = null;
        this.baLevelLock = null;
        this.baLevelMedal = null;
        this.baLevelPlayed = null;
        this.baAchievements = null;
        this.player = null;
        this.perls.destroy();
        this.perls = null;
        System.gc();
        Debug.trace("Level.destroy() - out");
    }

    void incPoppedBubbles(int inc) {
        if (this.bArcadeMode) {
            ++this.lArcadeBubbles;
            ++this.lArcadeTotalBubbles;
        } else {
            int n = this.iLevelNum;
            this.iaLevelPerls[n] = this.iaLevelPerls[n] + inc;
        }
    }

    void saveGameStats(DataOutputStream data) {
        try {
            int i;
            data.writeLong(this.lArcadeTotalTime);
            data.writeLong(this.lArcadeTotalBubbles);
            data.writeInt(this.iArcadePlayedTimes);
            data.writeInt(this.iArcadeTopScore);
            data.writeLong(this.lStoryTotalTime);
            data.writeBoolean(this.bStoryCompleted);
            data.writeInt(this.iSelectedFlag);
            data.writeInt(this.iSelectedLevel);
            for (i = this.iaLevelScore.length - 1; i >= 0; --i) {
                data.writeInt(this.iaLevelScore[i]);
                data.writeInt(this.iaLevelBonus[i]);
                data.writeInt(this.iaLevelTime[i]);
                data.writeInt(this.iaLevelPerls[i]);
                data.writeByte(this.baLevelLock[i]);
                data.writeByte(this.baLevelMedal[i]);
                data.writeByte(this.baLevelPlayed[i]);
            }
            for (i = this.baAchievements.length - 1; i >= 0; --i) {
                data.writeByte(this.baAchievements[i]);
            }
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void saveGameArcade(DataOutputStream data) {
        try {
            data.writeInt(this.iLevelNum);
            data.writeInt(this.iLevelTimer);
            data.writeInt(this.iTimeToActionInit);
            data.writeInt(this.iTimeToAction);
            data.writeInt(this.iTimeToActionDelay);
            for (int i = 0; i < 25; ++i) {
                data.writeInt(this.figType[i]);
                data.writeByte(figState[i]);
                data.writeByte(figRes1[i]);
                data.writeByte(figRes2[i]);
                data.writeByte(figRes3[i]);
                data.writeByte(figRes4[i]);
                data.writeInt(figRes5[i]);
                data.writeInt(figRes6[i]);
                data.writeInt(figRes7[i]);
                data.writeInt(figRes8[i]);
            }
            data.writeInt(this.idx_star);
            data.writeInt(this.idx_hedgegog);
            data.writeInt(this.idx_octopus);
            data.writeInt(this.idx_fish);
            data.writeInt(this.iLastPerlsTop);
            data.writeInt(this.iShrimpHits);
            this.perls.save(data);
            this.player.save(data);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void loadGameArcade(DataInputStream data) {
        try {
            this.iLevelNum = data.readInt();
            this.iLevelTimer = data.readInt();
            this.iTimeToActionInit = data.readInt();
            this.iTimeToAction = data.readInt();
            this.iTimeToActionDelay = data.readInt();
            for (int i = 0; i < 25; ++i) {
                this.figType[i] = data.readInt();
                Level.figState[i] = data.readByte();
                Level.figRes1[i] = data.readByte();
                Level.figRes2[i] = data.readByte();
                Level.figRes3[i] = data.readByte();
                Level.figRes4[i] = data.readByte();
                Level.figRes5[i] = data.readInt();
                Level.figRes6[i] = data.readInt();
                Level.figRes7[i] = data.readInt();
                Level.figRes8[i] = data.readInt();
            }
            this.idx_star = data.readInt();
            this.idx_hedgegog = data.readInt();
            this.idx_octopus = data.readInt();
            this.idx_fish = data.readInt();
            this.iLastPerlsTop = data.readInt();
            this.iShrimpHits = data.readInt();
            this.perls.load(data);
            this.player.load(data);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
            this.resetStats();
        }
    }

    void loadGameStats(DataInputStream data) {
        try {
            int i;
            this.lArcadeTotalTime = data.readLong();
            this.lArcadeTotalBubbles = data.readLong();
            this.iArcadePlayedTimes = data.readInt();
            this.iArcadeTopScore = data.readInt();
            this.lStoryTotalTime = data.readLong();
            this.bStoryCompleted = data.readBoolean();
            this.iSelectedFlag = data.readInt();
            this.iSelectedLevel = data.readInt();
            for (i = this.iaLevelScore.length - 1; i >= 0; --i) {
                this.iaLevelScore[i] = data.readInt();
                this.iaLevelBonus[i] = data.readInt();
                this.iaLevelTime[i] = data.readInt();
                this.iaLevelPerls[i] = data.readInt();
                this.baLevelLock[i] = data.readByte();
                this.baLevelMedal[i] = data.readByte();
                this.baLevelPlayed[i] = data.readByte();
            }
            for (i = this.baAchievements.length - 1; i >= 0; --i) {
                this.baAchievements[i] = data.readByte();
            }
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
            this.resetStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(String rstoreName, boolean bStats) {
        Debug.trace("Level.saveGame(" + (bStats ? "STATS" : "") + ") - in");
        Level.deleteSavedGame(rstoreName);
        try {
            this.rsobj_loadsave = RecordStore.openRecordStore((String)rstoreName, (boolean)true);
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(array);
            if (bStats) {
                this.saveGameStats(data);
            } else {
                this.saveGameArcade(data);
            }
            this.rsobj_loadsave.addRecord(array.toByteArray(), 0, array.toByteArray().length);
            this.rsobj_loadsave.closeRecordStore();
        }
        catch (Exception ex) {
            Debug.trace(ex.toString());
            Level.deleteSavedGame(rstoreName);
        }
        finally {
            if (this.rsobj_loadsave != null) {
                try {
                    this.rsobj_loadsave.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        Debug.trace("Level.saveGame() - out");
    }

    public static void deleteSavedGame(String rstoreName) {
        Debug.trace("Level.deleteSavedGame(boolean) - in");
        try {
            RecordStore.deleteRecordStore((String)rstoreName);
        }
        catch (Exception ex) {
            Debug.trace(ex.toString());
        }
        Debug.trace("Level.deleteSavedGame(boolean) - out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadGame(String rstoreName, boolean bStats) {
        Debug.trace("Level.loadGame(" + (bStats ? "STATS" : "") + ") - in");
        boolean bLoaded = false;
        try {
            this.rsobj_loadsave = RecordStore.openRecordStore((String)rstoreName, (boolean)false);
            RecordEnumeration enumr = this.rsobj_loadsave.enumerateRecords(null, null, false);
            int i = enumr.nextRecordId();
            byte[] record = this.rsobj_loadsave.getRecord(i);
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(record));
            if (bStats) {
                this.loadGameStats(data);
            } else {
                this.loadGameArcade(data);
            }
            this.rsobj_loadsave.closeRecordStore();
        }
        catch (Exception ex) {
            Debug.trace(ex.toString());
            this.resetStats();
        }
        finally {
            if (this.rsobj_loadsave != null) {
                try {
                    this.rsobj_loadsave.closeRecordStore();
                }
                catch (Exception ex) {}
            }
            this.rsobj_loadsave = null;
            System.gc();
        }
        Debug.trace("Level.loadGame(" + (bStats ? "STATS" : "") + ") - out");
        return bLoaded;
    }

    int getTrophyScore(int iTrophy) {
        switch (iTrophy) {
            case 0: {
                return 100;
            }
            case 1: {
                return 500;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 200;
            }
            case 4: {
                return 100;
            }
            case 5: {
                return 200;
            }
            case 6: {
                return 500;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 250;
            }
            case 9: {
                return 500;
            }
            case 10: {
                return 500;
            }
            case 11: {
                return 1000;
            }
        }
        return 0;
    }

    int totalScore() {
        int iTotalScore = 0;
        for (int i = 39; i >= 0; --i) {
            iTotalScore += this.iaLevelScore[i];
        }
        if (this.bStoryCompleted) {
            int len = X.canvas.iaRadiusTrophies.length;
            for (int i = 0; i < len; ++i) {
                if (this.baAchievements[i] != 1) continue;
                iTotalScore += this.getTrophyScore(i);
            }
        }
        return iTotalScore;
    }

    int totalTime() {
        int iTotalTime = 0;
        for (int i = 39; i >= 0; --i) {
            iTotalTime += this.iaLevelTime[i];
        }
        return iTotalTime;
    }

    int totalPerls() {
        int iTotalPerls = 0;
        for (int i = 39; i >= 0; --i) {
            iTotalPerls += this.iaLevelPerls[i];
        }
        return iTotalPerls;
    }

    int getMedals(int bMedal) {
        int iTotalMedals = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.baLevelMedal[i] != bMedal) continue;
            ++iTotalMedals;
        }
        return iTotalMedals;
    }

    int getFinishedLevels() {
        int iTotalCompleted = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.baLevelPlayed[i] <= 0 || this.baLevelPlayed[i] >= 100) continue;
            ++iTotalCompleted;
        }
        return iTotalCompleted;
    }

    int getCompletition() {
        int iTotalCompleted = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.iaLevelScore[i] <= 0) continue;
            ++iTotalCompleted;
        }
        return 10 * iTotalCompleted / 4;
    }

    boolean testAchievement(int iType) {
        Debug.trace("Level.testAchievement() - in");
        System.out.println("typ: " + iType);
        if (this.bArcadeMode) {
            return false;
        }
        if (this.baAchievements[iType] != 1) {
            this.baAchievements[iType] = 1;
            this.saveGame("STATS", true);
            X.canvas.iAchievementDelay = 1000;
            X.canvas.iAchievementIdx = iType;
            X.canvas.sAchievementTitle = X.texts.getString("AC_UNLOCKED");
            Debug.trace("Level.testAchievement() - out 1");
            return true;
        }
        Debug.trace("Level.testAchievement() - out 2");
        return false;
    }

    void init() {
        Debug.trace("Level.init() - in");
        this.lArcadeBubbles = 0L;
        this.iTimeToActionInit = 0;
        this.perls.init();
        this.reset();
        Debug.trace("Level.init() - out");
    }

    void reset() {
        this.perls.reset();
        this.player.reset();
        this.iPerlWidth = Resources.sprPerlsWidth;
        this.iPerlWidth2 = Resources.sprPerlsWidth / 2;
        X.canvas.resetScoreLabels();
        WholeGame.particles.resetParticles();
        this.bRefreshStatusBar = true;
    }

    void initTime() {
        if (this.bArcadeMode) {
            this.iLevelTimer = 0;
            this.setTimeToAction(this.getTimeToAction());
            return;
        }
        this.iTimeToActionInit = 1000;
        switch (this.iLevelNum) {
            case 10: 
            case 11: 
            case 12: {
                this.iLevelTimer = 0;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.iLevelTimer = 60000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 22: {
                this.iLevelTimer = 60000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 29: {
                this.iLevelTimer = 30000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 13: 
            case 14: 
            case 36: {
                this.iLevelTimer = 30000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.iLevelTimer = 0;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 44: {
                this.iLevelTimer = 180000;
                this.setTimeToAction(5000);
                break;
            }
            case 45: {
                this.iLevelTimer = 240000;
                this.setTimeToAction(7000);
                break;
            }
            default: {
                this.iLevelTimer = 0;
            }
        }
    }

    void initFigures() {
        int fidx;
        int i;
        int tmp2;
        int tmp;
        int cnt;
        Debug.trace("Level.initFigures() - in");
        Arrays.resetIntsArray(this.figType);
        this.idx_fish = -1979;
        this.idx_star = Arrays.addIntToArray(this.figType, 4);
        this.idx_octopus = Arrays.addIntToArray(this.figType, 2);
        GameDef.figAngle[this.idx_star] = 0;
        GameDef.figFrame[this.idx_star] = 0;
        Level.figState[this.idx_star] = 0;
        Level.figState[this.idx_octopus] = 0;
        GameDef.figFrame[this.idx_octopus] = 0;
        if (this.iLevelNum > 12 && this.iLevelNum < 15) {
            cnt = 2 * GameDef._WIDTH / (Resources.sprFishBlueWidth + Resources.sprFishBlueWidth / 5);
            tmp = 200 / cnt;
            tmp2 = tmp / 2;
            for (i = -100; i < 100; i += tmp) {
                fidx = Arrays.addIntToArray(this.figType, 16);
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figDepth[fidx] = 10;
                GameDef.figSpeed[fidx] = 2;
                GameDef.figFrame[fidx] = 0;
                fidx = Arrays.addIntToArray(this.figType, 17);
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figDepth[fidx] = 10 + Resources.sprFishBlueHeight * 3 / 2;
                GameDef.figSpeed[fidx] = 1;
                GameDef.figFrame[fidx] = 0;
                if (this.iLevelNum != 14) continue;
                fidx = Arrays.addIntToArray(this.figType, 13);
                GameDef.figFrame[fidx] = 0;
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figDepth[fidx] = 10 + Resources.sprFishBlueHeight * 4;
                GameDef.figSpeed[fidx] = -1;
            }
        }
        if (this.iLevelNum == 20 || this.iLevelNum == 21) {
            for (int i2 = 0; i2 < 360; i2 += 90) {
                fidx = Arrays.addIntToArray(this.figType, 23);
                GameDef.figOffs[fidx] = (byte)i2;
                GameDef.figAngle[fidx] = i2;
                GameDef.figSpeed[fidx] = 1;
                GameDef.figFrame[fidx] = 0;
            }
        }
        if (this.iLevelNum == 22) {
            cnt = 2 * GameDef._WIDTH / (Resources.sprFishBlueWidth + Resources.sprFishBlueWidth / 5);
            tmp = 200 / cnt;
            tmp2 = tmp / 2;
            for (i = -100; i < 100; i += tmp) {
                fidx = Arrays.addIntToArray(this.figType, 13);
                GameDef.figFrame[fidx] = 0;
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figDepth[fidx] = 10 + Resources.sprFishBlueHeight * 4;
                GameDef.figSpeed[fidx] = -1;
            }
        }
        Debug.trace("Level.initFigures() - out");
    }

    void prepareBackround(int iBackNum) {
        switch (iBackNum) {
            case 0: {
                this.iStatusColor1 = 9952004;
                this.iStatusColor2 = 9417984;
                this.iStatusColor3 = 5865984;
                this.iStatusColor4 = 0xFEFBFB;
                Resources.loadBackgroundImage("/b1.png");
                break;
            }
            case 1: {
                this.iStatusColor1 = 16571172;
                this.iStatusColor2 = 16560932;
                this.iStatusColor3 = 14716441;
                this.iStatusColor4 = 0xFCFAFA;
                Resources.loadBackgroundImage("/b2.png");
                break;
            }
            case 2: {
                this.iStatusColor1 = 16546190;
                this.iStatusColor2 = 15096433;
                this.iStatusColor3 = 13389924;
                this.iStatusColor4 = 0xFCFAFA;
                Resources.loadBackgroundImage("/b3.png");
                break;
            }
            case 3: {
                this.iStatusColor1 = 16548691;
                this.iStatusColor2 = 16277299;
                this.iStatusColor3 = 13582103;
                this.iStatusColor4 = 0xFCFAFA;
                Resources.loadBackgroundImage("/b4.png");
                break;
            }
            case 4: {
                this.iStatusColor1 = 16548691;
                this.iStatusColor2 = 16277299;
                this.iStatusColor3 = 13582103;
                this.iStatusColor4 = 0xFCFAFA;
                Resources.loadBackgroundImage("/b5.png");
            }
        }
    }

    void prepareLevel() {
        Debug.trace("Level.prepareLevel() - in");
        this.iLevelNum = this.iSelectedFlag * 10 + this.iSelectedLevel;
        this.iShrimpHits = 0;
        this.bFinaleNextRow = false;
        this.prepareBackround(this.iLevelNum / 10);
        this.iTypeOfBackground = this.iLevelNum / 10;
        this.perls.prepareLevel(this.iLevelNum);
        this.initTime();
        this.initFigures();
        X.canvas.resetScoreLabels();
        X.canvas.resetCongratLabels();
        System.out.println("--------------------------- iLevelNum: " + this.iLevelNum);
        this.iaLevelScore[this.iLevelNum] = 0;
        this.iaLevelBonus[this.iLevelNum] = 0;
        this.iaLevelTime[this.iLevelNum] = 0;
        this.iaLevelPerls[this.iLevelNum] = 0;
        this.baLevelMedal[this.iLevelNum] = -1;
        Debug.trace("Level.prepareLevel() - out");
    }

    void prepareArcade() {
        Debug.trace("Level.prepareArcade() - in");
        this.iLevelNum = 0;
        this.iShrimpHits = 0;
        this.bFinaleNextRow = false;
        this.iArcadePerlsLeft = 50;
        this.iArcadeLevel = 0;
        this.prepareBackround(0);
        this.perls.prepareArcade();
        this.initTime();
        this.initFigures();
        X.canvas.resetScoreLabels();
        X.canvas.resetCongratLabels();
        Debug.trace("Level.prepareArcade() - out");
    }

    int getTimeToAction() {
        if (this.bArcadeMode) {
            int iMul1 = 2;
            iMul1 += (this.iLevelNum + 1) / 2;
            int iLineDec = 4;
            if ((iLineDec -= (this.iLevelNum + 1) / 5) < 2) {
                iLineDec = 2;
            }
            if (this.perls.iPerlsLeft < iMul1 * this.perls.iPerlsInLine && this.perls.getLastRowForAdd() < this.perls.iTotalLines - iLineDec) {
                return 100;
            }
            int iSpeed = 15000 - this.iLevelNum / 10 * 300 - this.iLevelNum % 10 * 150;
            return iSpeed;
        }
        if (this.perls.iLevelType == 5) {
            return TIME_TO_MOVE_ANCHOR;
        }
        switch (this.iLevelNum) {
            case 3: {
                return 10000;
            }
            case 4: 
            case 5: {
                return 15000;
            }
            case 6: 
            case 7: {
                return 15000;
            }
            case 10: 
            case 11: {
                return 15000;
            }
            case 12: 
            case 13: {
                return 25000;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 10000;
            }
            case 38: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 3 && this.perls.iPerlsLeft < this.perls.iTotalLines / 6 * 5 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 12000;
            }
            case 39: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 2 && this.perls.iPerlsLeft < this.perls.iTotalLines / 5 * 4 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 18000;
            }
            case 44: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 3 && this.perls.iPerlsLeft < this.perls.iTotalLines / 6 * 5 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 12000;
            }
            case 45: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 2 && this.perls.iPerlsLeft < this.perls.iTotalLines / 5 * 4 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 18000;
            }
        }
        return TIME_TO_NEXT_ROW;
    }

    void setTimeToAction(int iTime) {
        this.iTimeToActionInit = this.iTimeToAction = iTime;
        this.iLastPerlsTop = this.perls.iTop;
        this.iTimeToActionDelay = 0;
    }

    void incTimeToAction(int inc) {
        this.iTimeToAction += inc;
        if (this.iTimeToAction > this.iTimeToActionInit) {
            this.iTimeToAction = this.iTimeToActionInit;
        }
    }

    void updateFigures() {
        block8: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 5: {
                    if (GameDef.figOffs[i] < 125) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + GameDef.figSpeed[i]);
                        continue block8;
                    }
                    this.figType[i] = -1979;
                    continue block8;
                }
                case 23: {
                    if (GameDef.figAngle[i] < 360) {
                        int n = i;
                        GameDef.figAngle[n] = GameDef.figAngle[n] + GameDef.figSpeed[i];
                        continue block8;
                    }
                    GameDef.figAngle[i] = 0;
                    continue block8;
                }
                case 16: 
                case 17: {
                    if (GameDef.figOffs[i] < 100) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + GameDef.figSpeed[i]);
                        continue block8;
                    }
                    GameDef.figOffs[i] = -100;
                    continue block8;
                }
                case 13: {
                    if (GameDef.figOffs[i] > -100) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + GameDef.figSpeed[i]);
                        continue block8;
                    }
                    GameDef.figOffs[i] = 100;
                    continue block8;
                }
                case 6: 
                case 7: {
                    if (!this.perls.bFailed) {
                        this.perls.addPerlOnTop(GameDef.figCol[i]);
                        if (this.iLevelNum > 37) {
                            this.perls.addPerlOnTop(GameDef.figCol[i]);
                        }
                    }
                    if (GameDef.figOffs[i] < 100) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + 3);
                        continue block8;
                    }
                    this.perls.bNoScoreForShakenPerls = true;
                    this.perls.shakePerls();
                    this.figType[i] = -1979;
                    this.idx_fish = -1979;
                    continue block8;
                }
                case 2: {
                    if (this.perls.bDangerousState) {
                        if (figState[this.idx_octopus] != 0) continue block8;
                        WholeGame.sounds.playSound(1, 7, 10);
                        Level.figState[this.idx_octopus] = 2;
                        GameDef.figStateTimer[this.idx_octopus] = 1000;
                        continue block8;
                    }
                    if (figState[this.idx_octopus] != 2) continue block8;
                    Level.figState[this.idx_octopus] = 0;
                }
            }
        }
    }

    void paintFiguresBackground(Graphics g) {
        Sprite spr = null;
        for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 2: {
                    spr = Resources.sprOct1;
                    if (figState[i] == 1) {
                        spr = Resources.sprOct2;
                        spr.setFrame(Math.abs(GameDef.figStateTimer[i] % 19 / 5));
                        if (GameDef.figStateTimer[i] > 0) {
                            int n = i;
                            GameDef.figStateTimer[n] = GameDef.figStateTimer[n] - 1;
                        } else {
                            Level.figState[i] = 0;
                        }
                    } else if (figState[i] == 2 && Resources.sprOct3 != null) {
                        spr = Resources.sprOct3;
                        spr.setFrame(Math.abs(GameDef.figStateTimer[i] % 14 / 5));
                        if (GameDef.figStateTimer[i] > 0) {
                            int n = i;
                            GameDef.figStateTimer[n] = GameDef.figStateTimer[n] - 1;
                        } else {
                            Level.figState[i] = 0;
                        }
                    } else {
                        spr.setFrame(Math.abs(GameDef.octopusBounce[i] / 5));
                        if (GameDef.octopusBounce[i] < 14) {
                            int n = i;
                            GameDef.octopusBounce[n] = (byte)(GameDef.octopusBounce[n] + 1);
                        } else {
                            GameDef.octopusBounce[i] = -14;
                        }
                    }
                    spr.setPosition(70, 600 + Math.abs(GameDef.octopusBounce[i] / 5));
                    spr.paint(g);
                }
            }
        }
    }

    int testFigureHit(int x, int y) {
        block5: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 5: {
                    int ypos;
                    int dy;
                    int width = Resources.sprShrimpWidth;
                    int height = Resources.sprShrimpHeight;
                    int xpos = GameDef.barValue(GameDef.figOffs[i], 100, Defines.WIDTH);
                    int pxpos = xpos - this.iPerlWidth2;
                    int dx = x - (xpos -= width - this.iPerlWidth / 4 * 3);
                    if (dx < this.iPerlWidth2 || dx > width - this.iPerlWidth2 || (dy = y - (ypos = GameDef.figDepth[i])) < this.iPerlWidth2 || dy > height - this.iPerlWidth2) continue block5;
                    int scoreinc = 20;
                    if (GameDef.figPerl[i] != -1979) {
                        WholeGame.particles.createBubbles(pxpos, y);
                        WholeGame.particles.createBubbles(pxpos, y);
                        GameDef.figPerl[i] = -1979;
                        int pidx = WholeGame.particles.createParticle(pxpos, y, 0, 4, 0, 1, 0, 0);
                        if (pidx != -1) {
                            WholeGame.particles.partSprite[pidx] = Resources.sprPerls;
                            WholeGame.particles.partFrame[pidx] = 16;
                            WholeGame.particles.partLife[pidx] = 14;
                        }
                        scoreinc *= 2;
                    }
                    ++this.iShrimpHits;
                    if (this.iShrimpHits == 5) {
                        this.testAchievement(6);
                    }
                    GameDef.figSpeed[i] = 3;
                    WholeGame.sounds.playSound(1, 8, 10);
                    this.player.incScore(scoreinc);
                    X.canvas.createScoreLabel(x, y, scoreinc);
                    return i;
                }
                case 23: {
                    int dy;
                    int width = Resources.sprHed1Width;
                    int height = Resources.sprHed1Height;
                    int xpos = GameDef._WIDTH / 2 + (Common.COS(GameDef.figAngle[i]) * ((GameDef._WIDTH - Resources.sprHed1Width) / 2) >> 8) - Resources.sprHed1Width / 2;
                    int ypos = Common.SIN(GameDef.figAngle[i]) * (GameDef._WIDTH / 2) >> 8;
                    int dx = x - xpos;
                    if (dx < this.iPerlWidth2 || dx > width - this.iPerlWidth2 || (dy = y - ypos) < this.iPerlWidth2 || dy > height - this.iPerlWidth2) continue block5;
                    WholeGame.particles.createBubbles(x, y);
                    this.player.incScore(-5);
                    X.canvas.createScoreLabel(x, y, -5);
                    WholeGame.vibrate(60);
                    return i;
                }
                case 6: 
                case 7: 
                case 13: 
                case 16: 
                case 17: {
                    int dx;
                    int xpos;
                    boolean bBlueFish = this.figType[i] == 6 || this.figType[i] == 16;
                    int ypos = GameDef.figDepth[i];
                    if (this.figType[i] == 13) {
                        ypos += Math.abs(GameDef.figFrame[i] / 3);
                    }
                    int height = Resources.sprFishBlueHeight;
                    int width = Resources.sprFishBlueWidth;
                    if (this.figType[i] == 13) {
                        width = Resources.sprHed1Width;
                        height = Resources.sprHed1Height;
                    }
                    int h2 = height / 2;
                    int w2 = width / 2;
                    int dy = y - (ypos + h2);
                    if (dy > this.iPerlWidth2 || dy < -this.iPerlWidth2 || (dx = x - ((xpos = GameDef.figPosX[i]) + w2)) > w2 || dx < -w2) continue block5;
                    WholeGame.particles.createBubbles(x, y);
                    if (this.figType[i] == 13) {
                        WholeGame.vibrate(60);
                        this.player.incScore(-5);
                        X.canvas.createScoreLabel(x, y, -5);
                    } else {
                        this.incPoppedBubbles(1);
                        WholeGame.vibrate(30);
                        this.perls.incMultiplier();
                        for (int ii = 0; ii < width; ii += 4) {
                            WholeGame.particles.createBubbles(x + ii, y + Common.getRandomInt(4));
                        }
                        int iScore = 2;
                        if (this.figType[i] == 6 || this.figType[i] == 16) {
                            iScore = 5;
                        }
                        if (this.perls.iMultiplierVal > 1) {
                            X.canvas.createScoreLabel(x, y, this.perls.iMultiplierVal, iScore);
                        } else {
                            X.canvas.createScoreLabel(x, y, iScore);
                        }
                        this.player.incScore(iScore * this.perls.iMultiplierVal);
                        this.figType[i] = -1979;
                        int cnt = 0;
                        int len = this.figType.length;
                        for (int ii = len - 1; ii >= 0 && cnt == 0; --ii) {
                            if (this.figType[ii] == -1979 || this.figType[ii] != 17 && this.figType[ii] != 16) continue;
                            ++cnt;
                        }
                        if (cnt == 0) {
                            this.testAchievement(10);
                        }
                    }
                    return i;
                }
            }
        }
        return -1;
    }

    void paintFiguresForeground(Graphics g) {
        Sprite spr = null;
        block14: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 23: {
                    spr = Resources.sprHed1;
                    int xpos = GameDef._WIDTH / 2 + (Common.COS(GameDef.figAngle[i]) * ((GameDef._WIDTH - Resources.sprHed1Width) / 2) >> 8) - Resources.sprHed1Width / 2;
                    int ypos = Common.SIN(GameDef.figAngle[i]) * (GameDef._WIDTH / 2) >> 8;
                    spr.setPosition(xpos, ypos);
                    spr.paint(g);
                    continue block14;
                }
                case 5: {
                    int x = GameDef.barValue(GameDef.figOffs[i], 100, GameDef._WIDTH);
                    int dspx = WholeGame.level.perls.iLeft - this.iPerlWidth2;
                    int col = (x - dspx) / this.iPerlWidth;
                    if (col == GameDef.figCol[i] && GameDef.figPerl[i] != -1979) {
                        g.setColor(0xFF0000);
                        if (WholeGame.level.perls.canAddPerl(GameDef.figRow[i] + 1, GameDef.figCol[i])) {
                            WholeGame.level.perls.addPerl(GameDef.figRow[i] + 1, GameDef.figCol[i], GameDef.figPerl[i]);
                            GameDef.figPerl[i] = -1979;
                        }
                    }
                    spr = Resources.sprShrimp;
                    spr.setFrame(Math.abs(GameDef.figFrame[i] / 2));
                    spr.setPosition(x - Resources.sprShrimpWidth + this.iPerlWidth / 4 * 3, GameDef.figDepth[i]);
                    spr.paint(g);
                    if (GameDef.figOffs[i] % 4 == 0) {
                        WholeGame.particles.createBubbles(x - Resources.sprShrimpWidth / 2, GameDef.figDepth[i] + 30);
                    }
                    if (GameDef.figPerl[i] != -1979) {
                        spr = Resources.sprPerls;
                        spr.setFrame(GameDef.figPerl[i]);
                        spr.setPosition(x - this.iPerlWidth2, GameDef.figDepth[i]);
                        spr.paint(g);
                    }
                    if (GameDef.figFrame[i] < 7) {
                        int n = i;
                        GameDef.figFrame[n] = (byte)(GameDef.figFrame[n] + 1);
                        continue block14;
                    }
                    GameDef.figFrame[i] = -7;
                    continue block14;
                }
                case 6: 
                case 7: 
                case 13: 
                case 16: 
                case 17: {
                    boolean bBlueFish = this.figType[i] == 6 || this.figType[i] == 16;
                    int x = GameDef.barValue(GameDef.figOffs[i], 100, GameDef._WIDTH);
                    int y = GameDef.figDepth[i];
                    if (bBlueFish) {
                        x = GameDef._WIDTH - x;
                    }
                    int dspx = WholeGame.level.perls.iLeft - this.iPerlWidth2;
                    GameDef.figCol[i] = (byte)((x - dspx) / this.iPerlWidth);
                    if (this.figType[i] == 13) {
                        spr = Resources.sprHed1;
                        spr.setFrame(0);
                        y += Math.abs(GameDef.figFrame[i] / 3);
                    } else {
                        spr = bBlueFish ? Resources.sprFishBlue : Resources.sprFishRed;
                        spr.setFrame(Math.abs(GameDef.figFrame[i] / 3));
                    }
                    GameDef.figPosX[i] = x -= bBlueFish ? Resources.sprFishBlueWidth : 0;
                    spr.setPosition(x, y);
                    spr.paint(g);
                    if (GameDef.figFrame[i] < 5) {
                        int n = i;
                        GameDef.figFrame[n] = (byte)(GameDef.figFrame[n] + 1);
                        continue block14;
                    }
                    GameDef.figFrame[i] = -5;
                    continue block14;
                }
                case 4: {
                    int frame = GameDef.figFrame[i] / 2;
                    int xpos = GameDef._WIDTH - Resources.sprStar1Width;
                    int ypos = GameDef._HEIGHT - Resources.sprStar1Height;
                    spr = Resources.sprStar1;
                    spr.setPosition(xpos, ypos);
                    spr.setFrame(frame);
                    spr.paint(g);
                    this.perls.updatePreparedPerl();
                    spr = Resources.sprPerls;
                    int v = WholeGame.level.perls.iPreparedPerl;
                    boolean bPointer = v >= 600 && v < 700;
                    boolean bBomb = v >= 700 && v < 800;
                    boolean bStop = v >= 800 && v < 900;
                    v = WholeGame.level.perls.getPerlVal(WholeGame.level.perls.iPreparedPerl);
                    spr.setFrame(v);
                    if (figState[i] == 0 || figState[i] == 3) {
                        switch (frame) {
                            case 0: {
                                xpos += 80;
                                ypos -= 15;
                                break;
                            }
                            case 1: {
                                xpos += 80;
                                ypos -= 15;
                                break;
                            }
                            case 2: {
                                xpos += 60;
                                ypos -= 10;
                                break;
                            }
                            case 3: {
                                xpos += 50;
                                ypos -= 5;
                                break;
                            }
                            case 4: {
                                xpos += 45;
                                ypos += 0;
                                break;
                            }
                            case 5: {
                                xpos += 2;
                                ypos += 5;
                            }
                        }
                        spr.setPosition(xpos, ypos);
                        spr.paint(g);
                        if (bPointer) {
                            Sprite sprP = Resources.sprPtr;
                            sprP.setPosition(xpos, ypos);
                            sprP.setFrame(Math.abs((int)(WholeGame.lRunCounter % 12L) / 4));
                            sprP.paint(g);
                        }
                        if (bBomb) {
                            spr.setFrame(14);
                            spr.paint(g);
                        }
                        if (bStop) {
                            spr.setFrame(12);
                            spr.paint(g);
                        }
                        if (figState[i] != 3) continue block14;
                        WholeGame.particles.createBubbles(xpos + this.iPerlWidth2, ypos + this.iPerlWidth2);
                        if (GameDef.figFrame[i] < 11) {
                            int n = i;
                            GameDef.figFrame[n] = (byte)(GameDef.figFrame[n] + 1);
                            continue block14;
                        }
                        Level.figState[i] = 4;
                        continue block14;
                    }
                    if (figState[i] != 4) continue block14;
                    xpos = 290 + (Common.COS(GameDef.figAngle[i]) * 67 >> 8);
                    ypos = 650 + (Common.SIN(GameDef.figAngle[i]) * 45 >> 8);
                    spr.setPosition(xpos, ypos);
                    spr.paint(g);
                    WholeGame.particles.createBubbles(xpos + this.iPerlWidth2, ypos + this.iPerlWidth2);
                    if (GameDef.figAngle[i] < 180) {
                        int n = i;
                        GameDef.figAngle[n] = GameDef.figAngle[n] + 20;
                        continue block14;
                    }
                    GameDef.figFrame[i] = 0;
                    Level.figState[i] = 0;
                    WholeGame.level.player.initPerl(WholeGame.level.perls.iPreparedPerl);
                    WholeGame.level.perls.prepareNextPerl();
                }
            }
        }
    }

    int statItemToShow(int iLevel) {
        switch (iLevel) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 43: 
            case 44: {
                return 0;
            }
            case 13: 
            case 14: {
                return 2;
            }
        }
        return 1;
    }

    boolean objectiveCompleted() {
        if (this.bArcadeMode) {
            return false;
        }
        switch (this.iLevelNum) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.perls.iActivePerlsCount == 0 && this.perls.iStackedPerlsCount == 0 && X.canvas.iActiveScoreLabels == 0 && !this.perls.bFailed;
            }
            case 29: {
                return this.iLevelTimer <= 0;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return this.iLevelTimer <= 0;
            }
            case 13: 
            case 14: {
                int cnt = 0;
                int len = this.figType.length;
                for (int ii = len - 1; ii >= 0 && cnt == 0; --ii) {
                    if (this.figType[ii] == -1979 || this.figType[ii] != 17 && this.figType[ii] != 16) continue;
                    ++cnt;
                }
                return this.iLevelTimer <= 0 || cnt == 0;
            }
            case 44: 
            case 45: {
                return this.iLevelTimer <= 0;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                return this.perls.iZumaPerlsCount == 0 && this.perls.iStackedPerlsCount == 0 && X.canvas.iActiveScoreLabels == 0;
            }
        }
        Debug.trace("level " + this.iLevelNum + " -> Level.objectiveCompleted() not defined");
        return false;
    }

    boolean objectiveFailed() {
        if (this.perls.bFailed) {
            return WholeGame.particles.activeParticles() == 0;
        }
        return false;
    }

    void updateTime() {
        if (this.bArcadeMode) {
            this.iLevelTimer += 30;
            return;
        }
        switch (this.iLevelNum) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 44: 
            case 45: {
                this.iLevelTimer -= 30;
                break;
            }
            default: {
                this.iLevelTimer += 30;
            }
        }
    }

    void updateActions() {
        if (this.iTimeToActionDelay > 0) {
            this.iTimeToActionDelay -= 30;
            return;
        }
        if (this.bArcadeMode) {
            this.iTimeToAction -= 30;
            if (this.iTimeToAction < 0 && this.player.perlSpd == 0) {
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlRowOnTop();
            }
            if (this.iArcadePerlsLeft <= 0 && !this.perls.bFailed) {
                this.iArcadePerlsLeft = 50 + this.iLevelNum * 10;
                X.canvas.createCongratLabel(0, 0, Resources.sprLabelLevelUp);
                ++this.iLevelNum;
                WholeGame.level.bRefreshStatusPerls = true;
                int iCnt = 4 + this.iLevelNum % 10 / 3;
                Arrays.resetIntsArray(this.perls.iaPerlsInGame);
                Arrays.resetIntsArray(this.perls.iaPerlsOnStart);
                for (int i = 0; i < iCnt; ++i) {
                    Arrays.addIntToArray(this.perls.iaPerlsInGame, i);
                    Arrays.addIntToArray(this.perls.iaPerlsOnStart, i);
                }
            }
            return;
        }
        switch (this.iLevelNum) {
            case 6: 
            case 7: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction >= 0 || this.player.perlSpd != 0) break;
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlOnBottom();
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 44: 
            case 45: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction >= 0 || this.player.perlSpd != 0) break;
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlRowOnTop();
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction < 0 && this.player.perlSpd == 0) {
                    this.setTimeToAction(this.getTimeToAction());
                    break;
                }
                this.perls.iTop = this.iLastPerlsTop + GameDef.barValue(this.getTimeToAction() - this.iTimeToAction, this.getTimeToAction(), this.perls.iPerlWidth);
                if (WholeGame.lRunCounter % 3L != 0L) break;
                this.perls.updateDangerousState();
                break;
            }
        }
    }

    byte getMedal(int iLevel) {
        switch (iLevel) {
            case 0: {
                if (this.iaLevelScore[iLevel] >= 750) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 1: {
                if (this.iaLevelScore[iLevel] >= 650) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 2: {
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 3: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 4: {
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 5: {
                if (this.iaLevelScore[iLevel] >= 350) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 250) {
                    return 1;
                }
                return 2;
            }
            case 6: {
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 7: {
                if (this.iaLevelScore[iLevel] >= 550) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 8: {
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 9: {
                if (this.iaLevelScore[iLevel] >= 900) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 1;
                }
                return 2;
            }
            case 10: {
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 11: {
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 12: {
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 23: {
                if (this.iaLevelScore[iLevel] >= 400) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 300) {
                    return 1;
                }
                return 2;
            }
            case 24: {
                if (this.iaLevelScore[iLevel] >= 650) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 15: {
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 16: {
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 450) {
                    return 1;
                }
                return 2;
            }
            case 17: {
                if (this.iaLevelScore[iLevel] >= 550) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 18: {
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 19: {
                if (this.iaLevelScore[iLevel] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 180) {
                    return 1;
                }
                return 2;
            }
            case 20: {
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 21: {
                if (this.iaLevelScore[iLevel] >= 430) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 370) {
                    return 1;
                }
                return 2;
            }
            case 22: {
                if (this.iaLevelScore[iLevel] >= 450) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 370) {
                    return 1;
                }
                return 2;
            }
            case 13: {
                if (this.iaLevelScore[iLevel] >= 140) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 110) {
                    return 1;
                }
                return 2;
            }
            case 14: {
                if (this.iaLevelScore[iLevel] >= 150) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 115) {
                    return 1;
                }
                return 2;
            }
            case 25: {
                if (this.iaLevelScore[iLevel] >= 250) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 200) {
                    return 1;
                }
                return 2;
            }
            case 26: {
                if (this.iaLevelScore[iLevel] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 180) {
                    return 1;
                }
                return 2;
            }
            case 27: {
                if (this.iaLevelScore[iLevel] >= 300) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 250) {
                    return 1;
                }
                return 2;
            }
            case 28: {
                if (this.iaLevelScore[iLevel] >= 290) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 240) {
                    return 1;
                }
                return 2;
            }
            case 29: {
                if (this.iaLevelScore[iLevel] >= 900) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 30: {
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 31: {
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 380) {
                    return 1;
                }
                return 2;
            }
            case 32: {
                if (this.iaLevelScore[iLevel] >= 450) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 33: {
                if (this.iaLevelScore[iLevel] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 180) {
                    return 1;
                }
                return 2;
            }
            case 34: {
                if (this.iaLevelScore[iLevel] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 140) {
                    return 1;
                }
                return 2;
            }
            case 35: {
                if (this.iaLevelScore[iLevel] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 140) {
                    return 1;
                }
                return 2;
            }
            case 36: {
                if (this.iaLevelScore[iLevel] >= 900) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 37: {
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 38: {
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 1;
                }
                return 2;
            }
            case 39: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 40: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 41: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 42: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 43: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 44: {
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 1;
                }
                return 2;
            }
            case 45: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 46: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 47: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 48: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 49: {
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 600) {
                    return 1;
                }
                return 2;
            }
        }
        return 2;
    }

    int timeBonus(int iLevel) {
        switch (iLevel) {
            case 0: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 1: {
                if (this.iaLevelTime[iLevel] >= 80000) break;
                return 150;
            }
            case 2: {
                if (this.iaLevelTime[iLevel] >= 80000) break;
                return 150;
            }
            case 3: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 8: {
                if (this.iaLevelTime[iLevel] >= 55000) break;
                return 150;
            }
            case 9: {
                if (this.iaLevelTime[iLevel] >= 65000) break;
                return 150;
            }
            case 10: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 11: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 12: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 13: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 14: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 15: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 16: {
                if (this.iaLevelTime[iLevel] >= 65000) break;
                return 150;
            }
            case 17: {
                if (this.iaLevelTime[iLevel] >= 70000) break;
                return 150;
            }
            case 18: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 19: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 20: {
                if (this.iaLevelTime[iLevel] >= 200000) break;
                return 150;
            }
            case 21: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 22: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 23: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 25: {
                if (this.iaLevelTime[iLevel] >= 100000) break;
                return 150;
            }
            case 26: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 27: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 28: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 29: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 30: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 31: {
                if (this.iaLevelTime[iLevel] >= 140000) break;
                return 150;
            }
            case 32: {
                if (this.iaLevelTime[iLevel] >= 110000) break;
                return 150;
            }
            case 33: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 34: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 35: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 37: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
        }
        return 0;
    }

    void onArcadeRestart() {
        Debug.trace("Level.onArcadeRestart() - in");
        this.lArcadeTotalTime += (long)this.iLevelTimer;
        ++this.iArcadePlayedTimes;
        this.saveGame("STATS", true);
        Level.deleteSavedGame("ARCADE");
        Debug.trace("Level.onArcadeRestart() - out");
    }

    void onStoryRestart(boolean bFailed) {
        Debug.trace("Level.onStoryRestart() - in");
        this.iaLevelPerls[this.iLevelNum] = 0;
        this.iaLevelScore[this.iLevelNum] = 0;
        if (bFailed) {
            this.baLevelPlayed[this.iLevelNum] = 100;
        } else if (this.baLevelPlayed[this.iLevelNum] == 100) {
            this.baLevelPlayed[this.iLevelNum] = 2;
        } else {
            int n = this.iLevelNum;
            this.baLevelPlayed[n] = (byte)(this.baLevelPlayed[n] + 1);
        }
        this.saveGame("STATS", true);
        Debug.trace("Level.onStoryRestart() - out");
    }

    void update() {
        if (this.objectiveFailed()) {
            if (this.bArcadeMode) {
                if (this.player.iScore > this.iArcadeTopScore) {
                    this.iArcadeTopScore = this.player.iScore;
                }
                this.onArcadeRestart();
                X.canvas.setMode(19);
                return;
            }
            this.onStoryRestart(true);
            X.canvas.setMode(22);
            return;
        }
        if (this.objectiveCompleted()) {
            int iTimeBonus;
            System.out.println("::::::::::::::::::::::::::::::::::: ------");
            System.out.println("pred odomknutim: " + this.iLevelNum);
            this.iaLevelBonus[this.iLevelNum] = 0;
            this.iaLevelScore[this.iLevelNum] = this.player.iScore;
            this.iaLevelTime[this.iLevelNum] = this.iLevelTimer;
            this.baLevelMedal[this.iLevelNum] = this.getMedal(this.iLevelNum);
            int n = this.iLevelNum;
            this.baLevelPlayed[n] = (byte)(this.baLevelPlayed[n] + 1);
            if (this.baLevelPlayed[this.iLevelNum] == 1) {
                int n2 = this.iLevelNum;
                this.iaLevelScore[n2] = this.iaLevelScore[n2] + 100;
                int n3 = this.iLevelNum;
                this.iaLevelBonus[n3] = this.iaLevelBonus[n3] + 100;
            }
            if ((iTimeBonus = this.timeBonus(this.iLevelNum)) > 0) {
                int n4 = this.iLevelNum;
                this.iaLevelScore[n4] = this.iaLevelScore[n4] + iTimeBonus;
                int n5 = this.iLevelNum;
                this.iaLevelBonus[n5] = this.iaLevelBonus[n5] + iTimeBonus;
            }
            System.out.println("po odomknuti iLevelNum: " + this.iLevelNum);
            this.updateLevelLocks();
            ++this.iSelectedLevel;
            if (this.iSelectedLevel > 9) {
                this.iSelectedLevel = 0;
                ++this.iSelectedFlag;
                if (this.iSelectedFlag > 4) {
                    this.iSelectedFlag = 4;
                    this.bStoryCompleted = true;
                }
            }
            this.saveGame("STATS", true);
            X.canvas.setMode(21);
            return;
        }
        this.player.update();
        this.perls.update();
        this.updateFigures();
        this.updateActions();
        this.updateTime();
    }

    void nextPerl() {
        this.player.playerBounces = 0;
        GameDef.figAngle[this.idx_star] = 105;
        Level.figState[this.idx_star] = 3;
        GameDef.figFrame[this.idx_star] = 0;
        WholeGame.level.perls.bNextPerlReady = false;
    }

    void addPerlRowOnTop() {
        Debug.trace("addPerlRowOnTop() - in");
        for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            if (this.figType[i] == 6) {
                return;
            }
            if (this.figType[i] != 7) continue;
            return;
        }
        if (this.iLevelNum > 37) {
            this.idx_fish = this.bFinaleNextRow ? Arrays.addIntToArray(this.figType, 6) : Arrays.addIntToArray(this.figType, 7);
            this.bFinaleNextRow = !this.bFinaleNextRow;
        } else {
            this.idx_fish = Arrays.addIntToArray(this.figType, Common.getRandomUInt(100) % 2 == 0 ? 6 : 7);
        }
        Debug.trace("created : " + this.idx_fish);
        GameDef.figOffs[this.idx_fish] = 0;
        GameDef.figCol[this.idx_fish] = -1;
        GameDef.figFrame[this.idx_fish] = 0;
        GameDef.figDepth[this.idx_fish] = Resources.sprFishBlueHeight / 4;
        WholeGame.level.perls.resetPerlAdd();
        Debug.trace("addPerlRowOnTop() - out");
    }

    void addPerlOnBottom() {
        Debug.trace("addPerlOnBottom() - in");
        for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979 || this.figType[i] != 5) continue;
            return;
        }
        int fidx = Arrays.addIntToArray(this.figType, 5);
        GameDef.figFrame[fidx] = 0;
        GameDef.figOffs[fidx] = 0;
        GameDef.figRow[fidx] = (byte)WholeGame.level.perls.getLastRowForAdd();
        if (GameDef.figRow[fidx] < 0) {
            this.figType[fidx] = -1979;
            return;
        }
        GameDef.figDepth[fidx] = (GameDef.figRow[fidx] + 1) * this.iPerlWidth + WholeGame.level.perls.iTop;
        GameDef.figCol[fidx] = (byte)WholeGame.level.perls.getColForAdd(GameDef.figRow[fidx]);
        GameDef.figPerl[fidx] = Arrays.intInArray(this.perls.iaPerlsInGame, Common.getRandomUInt(Arrays.intsInArray(this.perls.iaPerlsInGame)));
        if ((this.iLevelNum == 25 || this.iLevelNum == 26 || this.iLevelNum == 27 || this.iLevelNum == 28) && Common.getRandomUInt(100) < 60) {
            GameDef.figPerl[fidx] = 9;
        }
        GameDef.figSpeed[fidx] = 1;
        Debug.trace("addPerlOnBottom() - out");
    }

    int paintStatusBarNumbers(Graphics g, int xpos, boolean bAlignRight) {
        int width = (WholeGame.stringBuffer.length() + 2) * Resources.imgScoreFontWidth - 2;
        if (bAlignRight) {
            xpos -= width;
        }
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        g.setColor(16776173);
        g.fillRect(xpos, 1, width, Resources.imgScoreFontHeight + 1);
        g.setColor(this.iStatusColor3);
        g.drawRect(xpos, 1, 1, Resources.imgScoreFontHeight + 1);
        g.drawRect(xpos + width - 1, 1, 1, Resources.imgScoreFontHeight + 1);
        Texts.drawNumbers(g, Resources.imgScoreFont, WholeGame.stringBuffer.toString(), xpos + Resources.imgScoreFontWidth, 2);
        return width;
    }

    int paintStatusBarTime(Graphics g, int xpos, boolean bAlignRight) {
        int width = (WholeGame.stringBuffer.length() + 2) * Resources.imgScoreFontWidth - 2;
        if (bAlignRight) {
            xpos -= width;
        }
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        g.setColor(16776173);
        g.fillRect(xpos, 1, width, Resources.imgScoreFontHeight + 1);
        if (this.iTimeToActionDelay > 0) {
            g.setColor(65280);
            g.fillRect(xpos, 1, width, Resources.imgScoreFontHeight + 1);
        } else if (this.perls.iLevelType == 1) {
            if (this.iTimeToActionInit > 3000) {
                int idx = GameDef.barValue(this.iTimeToAction, this.iTimeToActionInit, 2);
                if (idx < 0) {
                    idx = 0;
                }
                if (idx > 2) {
                    idx = 2;
                }
                g.setColor(this.iaTimeBarColors[idx]);
            }
            g.fillRect(xpos, 1, GameDef.barValue(this.iTimeToAction, this.iTimeToActionInit, width), Resources.imgScoreFontHeight + 1);
        }
        g.setColor(this.iStatusColor3);
        g.drawRect(xpos, 1, 1, Resources.imgScoreFontHeight + 1);
        g.drawRect(xpos + width - 1, 1, 1, Resources.imgScoreFontHeight + 1);
        Texts.drawNumbers(g, Resources.imgScoreFont, WholeGame.stringBuffer.toString(), xpos + Resources.imgScoreFontWidth, 2);
        return width;
    }

    void timeToStringBuffer(long timer) {
        long secs = timer / 1000L;
        long mins = secs / 60L;
        WholeGame.stringBuffer.setLength(0);
        WholeGame.stringBuffer.append(secs %= 60L);
        if (WholeGame.stringBuffer.length() < 2) {
            WholeGame.stringBuffer.insert(0, '0');
        }
        WholeGame.stringBuffer.insert(0, ':');
        WholeGame.stringBuffer.insert(0, mins);
        if (mins < 10L) {
            WholeGame.stringBuffer.insert(0, '0');
        }
    }

    boolean flagCanBeSelected() {
        return this.getFinishedLevels() >= this.iSelectedFlag * 10;
    }

    void paintStatusBar(Graphics g) {
        if (!(this.bRefreshStatusBarOverride || WholeGame.lRunCounter % 3L == 0L || WholeGame.mode != 18 && WholeGame.mode != 20)) {
            return;
        }
        this.bRefreshStatusBarOverride = false;
        this.iStatusColor1 = 8373244;
        this.iStatusColor2 = 7916543;
        this.iStatusColor3 = 10020607;
        this.iStatusColor4 = 0xF4FCFC;
        if (this.bRefreshStatusBar) {
            g.setClip(0, 0, GameDef._WIDTH, Resources.iStatusHeight);
            boolean ypos = false;
            g.setColor(this.iStatusColor1);
            g.fillRect(0, 0, GameDef._WIDTH, Resources.iStatusHeight + 2);
            g.setColor(this.iStatusColor2);
            g.fillRect(0, Resources.iStatusHeight32, GameDef._WIDTH, Resources.iStatusHeight3);
            g.setColor(this.iStatusColor4);
            g.fillRect(0, Resources.iStatusHeight - 1, GameDef._WIDTH, 1);
            g.setColor(this.iStatusColor3);
            g.drawRect(0, 0, GameDef._WIDTH, Resources.iStatusHeight);
        }
        int xpos = 0;
        if (this.bRefreshStatusScore || this.bRefreshStatusBar) {
            WholeGame.stringBuffer.setLength(0);
            WholeGame.stringBuffer.append(this.player.iScore);
            while (WholeGame.stringBuffer.length() < 6) {
                WholeGame.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            xpos = 4 + this.paintStatusBarNumbers(g, 4, false);
            this.bRefreshStatusScore = false;
        }
        if (this.bRefreshStatusBar || WholeGame.lRunCounter % 5L == 0L) {
            this.timeToStringBuffer(this.iLevelTimer);
            xpos = this.iTimeToActionInit > 0 ? (xpos += 4 + this.paintStatusBarTime(g, xpos + 4, false)) : (xpos += 4 + this.paintStatusBarNumbers(g, xpos + 4, false));
        }
        if (this.bArcadeMode && (this.bRefreshStatusPerls || this.bRefreshStatusBar)) {
            WholeGame.stringBuffer.setLength(0);
            WholeGame.stringBuffer.append(this.iArcadePerlsLeft);
            while (WholeGame.stringBuffer.length() < 5) {
                WholeGame.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            xpos += 4 + this.paintStatusBarNumbers(g, 4 + xpos, false);
            WholeGame.stringBuffer.setLength(0);
            WholeGame.stringBuffer.append(this.iLevelNum + 1);
            while (WholeGame.stringBuffer.length() < 2) {
                WholeGame.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            xpos += 4 + this.paintStatusBarNumbers(g, 4 + xpos, false);
            this.bRefreshStatusPerls = false;
        }
        int iMultiplierLeft = xpos + 4;
        WholeGame.stringBuffer.setLength(0);
        WholeGame.stringBuffer.append(this.perls.iMultiplierVal);
        if (WholeGame.stringBuffer.length() < 2) {
            WholeGame.stringBuffer.insert(0, '0');
        }
        xpos = GameDef._WIDTH - 8 - this.paintStatusBarNumbers(g, GameDef._WIDTH - 4, true);
        if (this.perls.iLevelType != 3) {
            g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
            int width = xpos - iMultiplierLeft;
            int height = Resources.imgScoreFontHeight;
            int ypos = 2;
            g.setColor(26973);
            g.fillRect(xpos -= width, ypos, width, height);
            int wb = GameDef.barValue(this.perls.iMultiplierTime, this.perls.getMultiplierTime(), width);
            g.setColor(7208935);
            g.fillRect(xpos, ypos, wb, height);
            g.setColor(16710636);
            g.fillRect(xpos, ypos + 2, wb, height - 2);
            g.setColor(this.iStatusColor3);
            g.drawRect(xpos, ypos, width, height - 1);
        }
    }

    void paintGame(Graphics g) {
        int iStatusTop = Resources.iStatusHeight + 1;
        g.setClip(0, iStatusTop, GameDef._WIDTH, GameDef._HEIGHT - iStatusTop);
        if (Resources.imgBackground != null) {
            g.drawImage(Resources.imgBackground, GameDef._WIDTH / 2, GameDef._HEIGHT, 33);
        } else {
            int iY = 575 + Resources.sprSas1Height / 3;
            g.setColor(Resources.iBackColor);
            g.fillRect(0, iY, GameDef._WIDTH, GameDef._HEIGHT - iY);
        }
        this.paintBorders(g);
        this.paintFiguresBackground(g);
        this.player.paint(g);
        this.perls.paint(g);
        this.player.paintPerl(g);
        this.paintFiguresForeground(g);
        WholeGame.particles.paintParticles(g);
        X.canvas.paintScoreLabels(g);
        X.canvas.paintCongratLabels(g);
        this.paintStatusBar(g);
    }

    void paintLevelSelection(Graphics g) {
        if (Resources.imgMap != null) {
            g.drawImage(Resources.imgMap, 0, 0, 20);
        } else {
            g.setColor(7208423);
            g.fillRect(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        }
        Sprite spr1 = Resources.sprFlags;
        Sprite spr2 = Resources.sprBuoys;
        int len = this.mapX.length;
        int iFinishedLevels = this.getFinishedLevels();
        for (int i = 0; i < len; ++i) {
            if (i % 5 == 0) {
                if (iFinishedLevels < i / 5 * 10) {
                    spr1.setFrame(0);
                } else {
                    spr1.setFrame(i / 5 + 1);
                }
                spr1.setPosition(this.mapX[i], this.mapY[i]);
                spr1.paint(g);
                if (i / 5 == this.iSelectedFlag && this.buoyDepth < 0) {
                    g.drawImage(Resources.imgFlagFr, this.mapX[i] - 2, this.mapY[i] - 2, 20);
                }
            } else {
                int dspy = 0;
                if (iFinishedLevels < i) {
                    spr2.setFrame(0);
                } else {
                    if (i < 10) {
                        spr2.setFrame(2);
                    } else {
                        spr2.setFrame(1);
                    }
                    dspy = Math.abs(this.buoyDepth / 40) * (i % 2 == 0 ? 1 : -1);
                }
                spr2.setPosition(this.mapX[i], this.mapY[i] + dspy);
                spr2.paint(g);
            }
            if (this.buoyDepth < 120) {
                ++this.buoyDepth;
                continue;
            }
            this.buoyDepth = -120;
        }
    }

    void updateLevelInfo() {
        int levelBase = this.iSelectedFlag * 10;
        int iLevel = levelBase + this.iSelectedLevel;
        this.vecStatsLeft.removeAllElements();
        this.vecStatsRight.removeAllElements();
        if (this.baLevelPlayed[iLevel] == 100) {
            this.vecStatsLeft.addElement(X.texts.getString("LEVELFAILED"));
            this.vecStatsRight.addElement("");
        } else if (this.baLevelPlayed[iLevel] > 0) {
            this.vecStatsLeft.addElement(X.texts.getString("LSCORE"));
            this.vecStatsRight.addElement("" + this.iaLevelScore[iLevel]);
            int iItemToShow = this.statItemToShow(iLevel);
            if (iItemToShow == 0) {
                this.vecStatsLeft.addElement(X.texts.getString("LBUBBLES"));
                this.vecStatsRight.addElement("" + this.iaLevelPerls[iLevel]);
            } else if (iItemToShow == 2) {
                this.vecStatsLeft.addElement(X.texts.getString("LFISHES"));
                this.vecStatsRight.addElement("" + this.iaLevelPerls[iLevel]);
            } else {
                this.timeToStringBuffer(this.iaLevelTime[iLevel]);
                this.vecStatsLeft.addElement(X.texts.getString("LTIME"));
                this.vecStatsRight.addElement(WholeGame.stringBuffer.toString());
            }
            if (this.iaLevelScore[iLevel] > 0) {
                this.vecStatsLeft.addElement(X.texts.getString("LMEDAL"));
                this.vecStatsRight.addElement("#m" + this.baLevelMedal[iLevel]);
            }
        } else {
            this.vecStatsLeft.addElement(X.texts.getString("NOT_PLAYED"));
            this.vecStatsRight.addElement("");
        }
        this.vecStatsLeft.addElement(X.texts.getString("TOTSCORE"));
        this.vecStatsRight.addElement("" + this.totalScore());
        X.canvas.calculateStatsWidths();
    }

    void paintLevelDetails(Graphics g) {
        int i;
        Texts.setFontSize(GameDef.FONT_MENU);
        System.out.println("tu to ide");
        int iLines = 3;
        int iLineHeight = Texts.iFontHeight + 2;
        int borderWidth = Resources.sprBtnRed.getWidth();
        int borderHeight = Resources.sprBtnRed.getWidth();
        int iLineGap = 2;
        int gap = 3;
        int width = 5 * Resources.imgBtnSqrWidth + 6 * gap + 2 * borderWidth;
        int height = 2 * Resources.imgBtnSqrWidth + 2 * borderHeight + 3 * iLineGap;
        int iLeft = (GameDef._WIDTH - width) / 2;
        int levelBase = this.iSelectedFlag * 10;
        int iTop = iLeft;
        int iWidth = GameDef._WIDTH - 2 * iLeft;
        if (X.canvas.menuState != 0) {
            iTop -= iLeft + height - GameDef.barValue(X.canvas.iarrElasticMovement[X.canvas.menuAnimOffs], 100, iLeft + height);
        }
        g.setColor(15128735);
        X.canvas.paintGuiRect(g, Resources.sprBtnRed, iLeft, iTop, width, height, 4);
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        int ypos = iTop + borderHeight + gap;
        int xpos = iLeft + borderWidth + gap;
        for (i = 0; i < 5; ++i) {
            if (this.baLevelLock[levelBase + i] != 0) {
                g.drawImage(Resources.imgBtnSqrGr, xpos, ypos, 20);
            } else {
                g.drawImage(Resources.imgBtnSqr, xpos, ypos, 20);
                this.paintLevelIcon(g, xpos, ypos, levelBase + i);
            }
            if (i == this.iSelectedLevel && this.buoyDepth < 0) {
                g.drawImage(Resources.imgBtnSqrFr, xpos - 1, ypos - 1, 20);
            }
            xpos += Resources.imgBtnSqrWidth + gap;
        }
        ypos += Resources.imgBtnSqrWidth + gap;
        xpos = iLeft + borderWidth + gap;
        for (i = 0; i < 5; ++i) {
            if (this.baLevelLock[levelBase + 5 + i] != 0) {
                g.drawImage(Resources.imgBtnSqrGr, xpos, ypos, 20);
            } else {
                g.drawImage(Resources.imgBtnSqr, xpos, ypos, 20);
                this.paintLevelIcon(g, xpos, ypos, levelBase + 5 + i);
            }
            if (i + 5 == this.iSelectedLevel && this.buoyDepth < 0) {
                g.drawImage(Resources.imgBtnSqrFr, xpos - 1, ypos - 1, 20);
            }
            xpos += Resources.imgBtnSqrWidth + gap;
        }
        iLines = 3;
        iTop = iLeft + height + 1;
        height = X.canvas.calcStatsHeight();
        if (X.canvas.menuState != 0) {
            iTop += height - GameDef.barValue(X.canvas.iarrElasticMovement[X.canvas.menuAnimOffs], 100, height);
        }
        g.setColor(15128735);
        X.canvas.paintGuiRect(g, Resources.sprBtnRed, iLeft, iTop, width, height, 4);
        int w = Resources.sprBtnRed.getWidth();
        if (X.canvas.menuState == 0) {
            int pw = Resources.sprBtnRed.getWidth();
            int py = iTop + Resources.sprBtnRed.getHeight();
            int len = this.vecStatsLeft.size();
            for (int i2 = 0; i2 < len; ++i2) {
                py += X.canvas.paintStatsLine(g, this.vecStatsLeft.elementAt(i2).toString(), this.vecStatsRight.elementAt(i2).toString(), iLeft + pw, py, width - 2 * pw, iLineHeight) + iLineGap;
            }
        }
    }

    void paintLevelIcon(Graphics g, int xpos, int ypos, int level) {
        int dspxBigC = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsBgWidth) / 2;
        int dspyBigC = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsBgHeight) / 2;
        int dspxSmallC = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlWidth) / 2;
        int dspySmallC = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlHeight) / 2;
        int dspxSmallR = Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlWidth;
        int dspySmallB = Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlHeight;
        Sprite sprBig = Resources.sprBtnIcnsBg;
        Sprite sprSmall = Resources.sprBtnIcnsSml;
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 23: 
            case 24: {
                sprBig.setFrame(1);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 4: {
                sprSmall.setFrame(2);
                sprSmall.setPosition(xpos + dspxSmallC, ypos + dspySmallC);
                sprSmall.paint(g);
                break;
            }
            case 5: {
                sprSmall.setFrame(3);
                sprSmall.setPosition(xpos + dspxSmallC, ypos + dspySmallC);
                sprSmall.paint(g);
                break;
            }
            case 6: 
            case 7: {
                sprBig.setFrame(4);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                sprBig.setFrame(10);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 13: 
            case 14: {
                sprBig.setFrame(9);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                sprBig.setFrame(0);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                sprBig.setFrame(4);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                sprBig.setFrame(2);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                sprBig.setFrame(6);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                sprBig.setFrame(3);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 44: {
                sprBig.setFrame(8);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 45: {
                sprBig.setFrame(9);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                sprBig.setFrame(5);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
            }
        }
        switch (level) {
            case 29: {
                sprSmall.setFrame(4);
                sprSmall.setPosition(xpos, ypos + Resources.sprBtnIcnsSmlHeight / 3);
                sprSmall.paint(g);
                sprSmall.setPosition(xpos + dspxSmallR, ypos);
                sprSmall.paint(g);
                sprSmall.setFrame(5);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                sprSmall.setFrame(4);
                sprSmall.setPosition(xpos + dspxSmallC, ypos + dspySmallB);
                sprSmall.paint(g);
            }
        }
        switch (level) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 42: 
            case 47: 
            case 48: 
            case 49: {
                sprSmall.setFrame(0);
                sprSmall.setPosition(xpos + dspySmallB, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 6: {
                sprSmall.setFrame(3);
                sprSmall.setPosition(xpos + dspySmallB, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 7: {
                sprSmall.setFrame(2);
                sprSmall.setPosition(xpos + dspySmallB, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 12: {
                sprSmall.setFrame(3);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 14: {
                sprSmall.setFrame(1);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 18: {
                sprSmall.setFrame(1);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 19: {
                sprSmall.setFrame(9);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 32: {
                sprSmall.setFrame(8);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 40: {
                sprSmall.setFrame(5);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 41: {
                sprSmall.setFrame(5);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
                sprSmall.setFrame(0);
                sprSmall.setPosition(xpos + dspySmallB, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 43: {
                sprSmall.setFrame(9);
                sprSmall.setPosition(xpos + dspySmallC, ypos + dspySmallB);
                sprSmall.paint(g);
            }
        }
        switch (level) {
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 17: 
            case 27: 
            case 42: 
            case 48: 
            case 49: {
                sprSmall.setFrame(0);
                sprSmall.setPosition(xpos, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 20: {
                sprSmall.setFrame(4);
                sprSmall.setPosition(xpos + dspxSmallC, ypos + dspySmallC);
                sprSmall.paint(g);
                sprSmall.setFrame(1);
                sprSmall.setPosition(xpos + dspySmallC, ypos);
                sprSmall.paint(g);
                sprSmall.setPosition(xpos + dspySmallB, ypos + dspySmallB);
                sprSmall.paint(g);
                sprSmall.setPosition(xpos, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 21: {
                sprBig.setFrame(1);
                sprBig.setPosition(xpos + dspxBigC, ypos + dspyBigC);
                sprBig.paint(g);
                sprSmall.setFrame(1);
                sprSmall.setPosition(xpos + dspySmallC, ypos);
                sprSmall.paint(g);
                sprSmall.setPosition(xpos + dspySmallB, ypos + dspySmallB);
                sprSmall.paint(g);
                sprSmall.setPosition(xpos, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 22: {
                sprSmall.setFrame(4);
                sprSmall.setPosition(xpos + dspxSmallC, ypos + dspySmallC);
                sprSmall.paint(g);
                sprSmall.setFrame(1);
                sprSmall.setPosition(xpos + dspySmallC, ypos);
                sprSmall.paint(g);
                sprSmall.setPosition(xpos + dspySmallB, ypos + dspySmallB);
                sprSmall.paint(g);
                sprSmall.setFrame(3);
                sprSmall.setPosition(xpos, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 23: {
                sprSmall.setFrame(2);
                sprSmall.setPosition(xpos, ypos + dspySmallB);
                sprSmall.paint(g);
                break;
            }
            case 24: {
                sprSmall.setFrame(3);
                sprSmall.setPosition(xpos, ypos + dspySmallB);
                sprSmall.paint(g);
            }
        }
        switch (level) {
            case 3: 
            case 11: 
            case 49: {
                sprSmall.setFrame(0);
                sprSmall.setPosition(xpos + dspxSmallC, ypos);
                sprSmall.paint(g);
            }
        }
    }

    void paintBorders(Graphics g) {
        int iStatusTop = Resources.iStatusHeight + 1;
        g.setClip(0, iStatusTop, GameDef._WIDTH, GameDef._HEIGHT - iStatusTop);
        Sprite spr = Resources.sprBorders;
        int w = spr.getWidth();
        int h = spr.getHeight();
        int x1 = this.perls.iLeft - w;
        x1 = x1 > 0 ? 0 : x1;
        int x2 = this.perls.iRight;
        x2 = x2 + w < GameDef._WIDTH ? GameDef._WIDTH - w : x2;
        int ypos = 0;
        do {
            spr.setFrame(0);
            spr.setPosition(x1, ypos);
            spr.paint(g);
            spr.setFrame(1);
            spr.setPosition(x2, ypos);
            spr.paint(g);
        } while ((ypos += h) < GameDef._HEIGHT);
    }

    void paint(Graphics g) {
        switch (WholeGame.mode) {
            case 11: {
                this.paintLevelSelection(g);
                X.canvas.updateMenuAnimation();
                X.canvas.paintLeftButton(g, Resources.sprBtnRed, X.texts.getHashedString("MENU"), 4);
                break;
            }
            case 12: {
                System.out.println("test test");
                this.paintLevelSelection(g);
                this.paintLevelDetails(g);
                X.canvas.updateMenuAnimation();
                X.canvas.paintLeftButton(g, Resources.sprBtnRed, X.texts.getHashedString("BACK"), 4);
                if (this.baLevelLock[this.iSelectedFlag * 10 + this.iSelectedLevel] != 0) break;
                X.canvas.paintRightButton(g, Resources.sprBtnRed, X.texts.getHashedString("PLAY"), 4);
                break;
            }
            case 13: {
                System.out.println("test test 2 a tal ");
                this.paintLevelSelection(g);
                X.canvas.paintSimpleText(g, Resources.sprBtnRed);
                X.canvas.updateMenuAnimation();
                X.canvas.paintLeftButton(g, Resources.sprBtnRed, X.texts.getHashedString("BACK"), 4);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                this.paintGame(g);
            }
        }
    }
}

