/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Bubbles {
    private static final boolean USE_GRAPHICS = false;
    private static int BUBBLE_NULL = -10000;
    private static int BUBBLE_NUM_MAX = 20;
    private static int[] mBubbleX;
    private static int[] mBubbleY;
    private static int[] mBubbleTime;
    private static int[] mBubbleMinY;
    private static int mSpeedX;
    private static int mSpeedY;
    private static SpriteObject smBubbleAnim;
    private Random rand;
    private int mTimeElapsed = 0;
    private static final int MIN_DELTA_TIME = 50;

    public Bubbles(int n, int n2, int n3) {
        this.init();
        mSpeedX = n3;
        mSpeedY = -Math.abs(n);
    }

    public static void loadResources() {
    }

    public static void freeAll() {
        mBubbleX = null;
        mBubbleY = null;
        System.gc();
    }

    public void init() {
        if (mBubbleX == null) {
            mBubbleX = new int[BUBBLE_NUM_MAX];
            mBubbleY = new int[BUBBLE_NUM_MAX];
            mBubbleMinY = new int[BUBBLE_NUM_MAX];
            mBubbleTime = new int[BUBBLE_NUM_MAX];
        }
        if (this.rand == null) {
            this.rand = new Random(System.currentTimeMillis());
        }
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < BUBBLE_NUM_MAX; ++i) {
            Bubbles.mBubbleX[i] = BUBBLE_NULL;
            Bubbles.mBubbleY[i] = BUBBLE_NULL;
            Bubbles.mBubbleTime[i] = 0;
        }
    }

    public void addBubble(int n, int n2) {
        for (int i = 0; i < BUBBLE_NUM_MAX; ++i) {
            if (mBubbleX[i] != BUBBLE_NULL) continue;
            Bubbles.mBubbleX[i] = n;
            Bubbles.mBubbleY[i] = n2;
            Bubbles.mBubbleTime[i] = 0;
            Bubbles.mBubbleMinY[i] = n2 - 15;
            break;
        }
    }

    public void logicUpdate(int n) {
        this.mTimeElapsed += n;
        if (this.mTimeElapsed < 50) {
            return;
        }
        for (int i = 0; i < BUBBLE_NUM_MAX; ++i) {
            if (mBubbleX[i] == BUBBLE_NULL) continue;
            int n2 = i;
            mBubbleX[n2] = mBubbleX[n2] + (1 - this.rand.nextInt(3)) * mSpeedX;
            int n3 = i;
            mBubbleY[n3] = mBubbleY[n3] + mSpeedY;
            int n4 = i;
            mBubbleTime[n4] = mBubbleTime[n4] + this.mTimeElapsed;
        }
        this.mTimeElapsed = 0;
    }

    public void doDraw(Graphics graphics, int n, int n2) {
        for (int i = 0; i < BUBBLE_NUM_MAX; ++i) {
            if (mBubbleX[i] == BUBBLE_NULL) continue;
            int n3 = mBubbleX[i] + n;
            int n4 = mBubbleY[i] + n2;
            if (n3 < -Toolkit.getScreenWidth() || n3 > 2 * Toolkit.getScreenWidth()) {
                Bubbles.mBubbleX[i] = BUBBLE_NULL;
                continue;
            }
            if (mBubbleTime[i] > 2000) {
                Bubbles.mBubbleX[i] = BUBBLE_NULL;
                continue;
            }
            int n5 = 144;
            int n6 = 192;
            int n7 = 240;
            int n8 = 64;
            int n9 = 112;
            int n10 = 240;
            int n11 = n5 + (n8 - n5) * mBubbleTime[i] / 2000;
            int n12 = n6 + (n9 - n6) * mBubbleTime[i] / 2000;
            int n13 = n7 + (n10 - n7) * mBubbleTime[i] / 2000;
            graphics.setColor((n11 << 16) + (n12 << 8) + n13);
            int n14 = 9 - 9 * mBubbleTime[i] / 2000;
            graphics.drawArc(n3 + n14 / 2, n4 + n14 / 2, n14, n14, 0, 360);
        }
    }
}

