/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class ParticleEngine {
    static final int TYPE_REGULAR = 0;
    static final int TYPE_UNIFORM_MOVE = 1;
    static final int TYPE_DECREMENTAL_MOVE = 2;
    static final int TYPE_INCREMENTAL_MOVE = 3;
    static final int MAX_PARTICLES = 256;
    static final int FP_PRECISSION = 10;
    static final int PHYSICS_SHIFT = 4;
    static final int DELTATIME_SHIFT = 10;
    static int physicsGravity = 5120;
    static int[] particleTTL = new int[256];
    static int[] particleTTLMax = new int[256];
    static int[] particleWeight = new int[256];
    static SpriteObject[] particleSprite = new SpriteObject[256];
    static int[] particleStartX = new int[256];
    static int[] particleStartY = new int[256];
    static int[] particleXf = new int[256];
    static int[] particleYf = new int[256];
    static int[] particleXs = new int[256];
    static int[] particleYs = new int[256];
    static int[] particleW = new int[256];
    static int[] particleH = new int[256];
    static int[] particleType = new int[256];
    static int[] particleEffect = new int[256];
    static int[] particleColor = new int[256];

    public static void setGravity(int n) {
        physicsGravity = n;
    }

    public static int particleAdd(SpriteObject spriteObject, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        for (n10 = 0; n10 < 256 && particleTTL[n10] > 0; ++n10) {
        }
        if (n10 == 256) {
            return -1;
        }
        ParticleEngine.particleTTL[n10] = n6;
        ParticleEngine.particleTTLMax[n10] = n6;
        ParticleEngine.particleStartX[n10] = n;
        ParticleEngine.particleStartY[n10] = n2;
        ParticleEngine.particleXf[n10] = n << 10;
        ParticleEngine.particleYf[n10] = n2 << 10;
        ParticleEngine.particleXs[n10] = n3;
        ParticleEngine.particleYs[n10] = n4;
        ParticleEngine.particleW[n10] = n8;
        ParticleEngine.particleH[n10] = n9;
        ParticleEngine.particleType[n10] = n5;
        ParticleEngine.particleWeight[n10] = n7;
        ParticleEngine.particleColor[n10] = 0xA0A0A0;
        ParticleEngine.particleSprite[n10] = spriteObject;
        return n10;
    }

    public static void particleSetPosition(int n, int n2, int n3) {
        ParticleEngine.particleStartX[n] = n2;
        ParticleEngine.particleStartY[n] = n3;
        ParticleEngine.particleXf[n] = n2 << 10;
        ParticleEngine.particleYf[n] = n3 << 10;
    }

    public static void particleSetEffect(int n, int n2) {
        ParticleEngine.particleEffect[n] = n2;
    }

    public static void particleSetEffect(int n, int n2, int n3) {
        ParticleEngine.particleEffect[n] = n2;
        ParticleEngine.particleColor[n] = n3;
    }

    public static void logicUpdate(int n) {
        for (int i = 0; i < 256; ++i) {
            if (particleTTL[i] <= 0) continue;
            switch (particleType[i]) {
                case 1: {
                    int n2 = particleStartX[i];
                    int n3 = particleStartY[i];
                    ParticleEngine.particleXf[i] = n2 + (particleXs[i] - n2) * (particleTTLMax[i] - particleTTL[i]) / particleTTLMax[i];
                    ParticleEngine.particleYf[i] = n3 + (particleYs[i] - n3) * (particleTTLMax[i] - particleTTL[i]) / particleTTLMax[i];
                    ParticleEngine.particleXf[i] = particleXf[i] << 10;
                    ParticleEngine.particleYf[i] = particleYf[i] << 10;
                    int n4 = i;
                    particleTTL[n4] = particleTTL[n4] - n;
                    break;
                }
                case 2: {
                    int n2 = particleXf[i] >> 10;
                    int n3 = particleYf[i] >> 10;
                    ParticleEngine.particleXf[i] = n2 + (particleXs[i] - n2) * (particleTTLMax[i] - particleTTL[i]) / particleTTLMax[i];
                    ParticleEngine.particleYf[i] = n3 + (particleYs[i] - n3) * (particleTTLMax[i] - particleTTL[i]) / particleTTLMax[i];
                    ParticleEngine.particleXf[i] = particleXf[i] << 10;
                    ParticleEngine.particleYf[i] = particleYf[i] << 10;
                    int n5 = i;
                    particleTTL[n5] = particleTTL[n5] - n;
                    break;
                }
                case 3: {
                    int n2 = particleXf[i] >> 10;
                    int n3 = particleYf[i] >> 10;
                    ParticleEngine.particleXf[i] = n2 + (particleXs[i] - n2) * particleTTLMax[i] / (1 + particleTTL[i]);
                    ParticleEngine.particleYf[i] = n3 + (particleYs[i] - n3) * particleTTLMax[i] / (1 + particleTTL[i]);
                    ParticleEngine.particleXf[i] = particleXf[i] << 10;
                    ParticleEngine.particleYf[i] = particleYf[i] << 10;
                    int n6 = i;
                    particleTTL[n6] = particleTTL[n6] - n;
                    break;
                }
                default: {
                    int n7 = i;
                    particleXf[n7] = particleXf[n7] + (particleXs[i] * n >> 4);
                    int n8 = i;
                    particleYf[n8] = particleYf[n8] + (particleYs[i] * n >> 4);
                    int n9 = i;
                    particleYs[n9] = particleYs[n9] + ((physicsGravity * particleWeight[i] >> 4) * n >> 10);
                }
            }
            if (particleSprite[i] == null) continue;
            particleSprite[i].logicUpdate(n);
        }
    }

    public static void particleDraw(Graphics graphics, int n, int n2) {
        for (int i = 0; i < 256; ++i) {
            if (particleTTL[i] <= 0) continue;
            graphics.setColor(particleColor[i]);
            int n3 = particleXf[i] >> 10;
            int n4 = particleYf[i] >> 10;
            n3 += n;
            n4 += n2;
            if (particleSprite[i] != null) {
                particleSprite[i].draw(graphics, n3, n4);
                continue;
            }
            graphics.fillRect(n3 -= particleW[i] >> 1, n4 -= particleH[i] >> 1, particleW[i], particleH[i]);
        }
    }

    public static void cleanParticles() {
        if (particleTTL != null) {
            for (int i = 0; i < 256; ++i) {
                ParticleEngine.particleTTL[i] = 0;
            }
        }
    }
}

