/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Physics {
    private static final boolean DEBUG_PHYSICS_DRAW_IS_ENABLED = false;
    final int maxParticles;
    int pIdx = 0;
    int numParticles = 0;
    boolean[] pActive = new boolean[100];
    public float[] pX = new float[100];
    public float[] pY = new float[100];
    float[] ppX = new float[100];
    float[] ppY = new float[100];
    float[] pfX = new float[100];
    float[] pfY = new float[100];
    float[] pM = new float[100];
    float[] pdX = new float[100];
    float[] pdY = new float[100];
    final int maxConstraints;
    int cIdx = 0;
    int numConstraints = 0;
    boolean[] cActive = new boolean[100];
    int[] cpA = new int[100];
    int[] cpB = new int[100];
    float[] cL = new float[100];
    float[] cE = new float[100];

    public Physics() {
        this.maxParticles = 100;
        this.maxConstraints = 100;
    }

    public void init() {
        int n;
        for (n = 0; n < 100; ++n) {
            this.pActive[n] = false;
        }
        this.pIdx = 0;
        this.numParticles = 0;
        for (n = 0; n < 100; ++n) {
            this.cActive[n] = false;
        }
        this.cIdx = 0;
        this.numConstraints = 0;
    }

    public void draw(Graphics graphics, int n, int n2) {
    }

    int addParticle(float f, float f2, float f3) {
        this.pActive[this.pIdx] = true;
        this.pX[this.pIdx] = f;
        this.pY[this.pIdx] = f2;
        this.ppX[this.pIdx] = f;
        this.ppY[this.pIdx] = f2;
        this.pfX[this.pIdx] = 0.0f;
        this.pfY[this.pIdx] = 0.0f;
        this.setParticleDrag(this.pIdx, 0.0f, 0.0f);
        this.pM[this.pIdx] = f3 == 0.0f ? 0.0f : 1.0f / f3;
        ++this.pIdx;
        return this.pIdx - 1;
    }

    void processParticleDrag(int n) {
        this.ppX[n] = this.pX[n] + (this.ppX[n] - this.pX[n]) * this.pdX[n];
        this.ppY[n] = this.pY[n] + (this.ppY[n] - this.pY[n]) * this.pdY[n];
    }

    void setParticleDrag(int n, float f, float f2) {
        this.pdX[n] = f;
        this.pdY[n] = f2;
    }

    void setParticleVelocity(int n, float f, float f2) {
        this.ppX[n] = this.pX[n] - f;
        this.ppY[n] = this.pY[n] - f2;
    }

    void addParticleVelocity(int n, float f, float f2) {
        int n2 = n;
        this.ppX[n2] = this.ppX[n2] - f;
        int n3 = n;
        this.ppY[n3] = this.ppY[n3] - f2;
    }

    void setParticleForce(int n, float f, float f2) {
        this.pfX[n] = f;
        this.pfY[n] = f2;
    }

    void setParticlePosition(int n, float f, float f2) {
        this.pX[n] = f;
        this.pY[n] = f2;
    }

    void forceParticlePosition(int n, float f, float f2) {
        this.pX[n] = f;
        this.pY[n] = f2;
        this.ppX[n] = f;
        this.ppY[n] = f2;
    }

    void integrateParticleSystem(float f) {
        float f2 = f * f;
        for (int i = 0; i < 100; ++i) {
            if (!this.pActive[i] || this.pM[i] == 0.0f) continue;
            float f3 = this.pX[i];
            float f4 = this.pY[i];
            float f5 = -(this.pX[i] - this.ppX[i]) * (1.0f / this.pM[i]) * this.pdX[i];
            float f6 = -(this.pY[i] - this.ppY[i]) * (1.0f / this.pM[i]) * this.pdY[i];
            float f7 = this.pfX[i] + f5 / f2;
            float f8 = this.pfY[i] + f6 / f2;
            float f9 = f7 * this.pM[i];
            float f10 = f8 * this.pM[i];
            int n = i;
            this.pX[n] = this.pX[n] + (this.pX[i] - this.ppX[i] + f9 * f2);
            int n2 = i;
            this.pY[n2] = this.pY[n2] + (this.pY[i] - this.ppY[i] + f10 * f2);
            this.ppX[i] = f3;
            this.ppY[i] = f4;
        }
    }

    int addDistanceConstraint(int n, int n2, float f, float f2) {
        this.cActive[this.cIdx] = true;
        this.cpA[this.cIdx] = n;
        this.cpB[this.cIdx] = n2;
        this.cL[this.cIdx] = f;
        this.cE[this.cIdx] = f2;
        ++this.cIdx;
        return this.cIdx - 1;
    }

    void updateDistanceConstraintsSystem(int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = 100;
            int n4 = 1;
            if (i % 2 == 0) {
                n2 = 99;
                n3 = -1;
                n4 = -1;
            }
            for (int j = n2; j != n3; j += n4) {
                if (!this.cActive[j]) continue;
                int n5 = this.cpA[j];
                int n6 = this.cpB[j];
                if (!this.pActive[n5] || !this.pActive[n6] || this.pM[n5] == 0.0f && this.pM[n6] == 0.0f) continue;
                float f = this.pX[n6] - this.pX[n5];
                float f2 = this.pY[n6] - this.pY[n5];
                float f3 = (float)Math.sqrt(f * f + f2 * f2);
                if (f3 == 0.0f) {
                    f = 0.0f;
                    f2 = 0.0f;
                } else {
                    f /= f3;
                    f2 /= f3;
                }
                if (this.pM[n5] == 0.0f) {
                    this.setParticlePosition(n6, this.pX[n5] + f * this.cL[j], this.pY[n5] + f2 * this.cL[j]);
                    continue;
                }
                if (this.pM[n6] == 0.0f) {
                    this.setParticlePosition(n5, this.pX[n6] - f * this.cL[j], this.pY[n6] - f2 * this.cL[j]);
                    continue;
                }
                float f4 = (f3 - this.cL[j]) * 0.5f;
                float f5 = f * f4 * this.cE[j];
                float f6 = f2 * f4 * this.cE[j];
                float f7 = this.pM[n5] / (this.pM[n5] + this.pM[n6]);
                float f8 = 1.0f - f7;
                this.setParticlePosition(n5, this.pX[n5] + f5 * f7, this.pY[n5] + f6 * f7);
                this.setParticlePosition(n6, this.pX[n6] - f5 * f8, this.pY[n6] - f6 * f8);
            }
        }
    }

    void setGravity(float f) {
        for (int i = 0; i < 100; ++i) {
            if (!this.pActive[i]) continue;
            this.pfY[i] = this.pM[i] != 0.0f ? 1.0f / this.pM[i] * f : 0.0f;
            this.pfX[i] = 0.0f;
        }
    }

    public static int distance(int n, int n2) {
        int n3 = (n = Math.abs(n)) > (n2 = Math.abs(n2)) ? n + ((n2 >>= 3) + n2 + n2) : n2 + ((n >>= 3) + n + n);
        return n3;
    }

    public static float distance(float f, float f2, float f3, float f4) {
        return (float)Math.sqrt((f - f3) * (f - f3) + (f2 - f4) * (f2 - f4));
    }
}

