/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class PhysicsFP {
    private static final boolean DEBUG_PHYSICS_DRAW_IS_ENABLED = false;
    final int maxParticles;
    int pIdx = 0;
    int numParticles = 0;
    boolean[] pActive = new boolean[100];
    public int[] pX = new int[100];
    public int[] pY = new int[100];
    int[] ppX = new int[100];
    int[] ppY = new int[100];
    int[] pfX = new int[100];
    int[] pfY = new int[100];
    int[] pM = new int[100];
    int[] pdX = new int[100];
    int[] pdY = new int[100];
    final int maxConstraints;
    int cIdx = 0;
    int numConstraints = 0;
    boolean[] cActive = new boolean[100];
    int[] cpA = new int[100];
    int[] cpB = new int[100];
    int[] cL = new int[100];
    int[] cE = new int[100];

    public PhysicsFP() {
        this.maxParticles = 100;
        this.maxConstraints = 100;
    }

    public void init() {
        int n;
        for (n = 0; n < 100; ++n) {
            this.pActive[n] = false;
        }
        this.pIdx = 0;
        this.numParticles = 0;
        for (n = 0; n < 100; ++n) {
            this.cActive[n] = false;
        }
        this.cIdx = 0;
        this.numConstraints = 0;
    }

    public void draw(Graphics graphics, int n, int n2) {
    }

    int addParticle(int n, int n2, int n3) {
        this.pActive[this.pIdx] = true;
        this.pX[this.pIdx] = n;
        this.pY[this.pIdx] = n2;
        this.ppX[this.pIdx] = n;
        this.ppY[this.pIdx] = n2;
        this.pfX[this.pIdx] = 0;
        this.pfY[this.pIdx] = 0;
        this.setParticleDrag(this.pIdx, 0, 0);
        this.pM[this.pIdx] = n3 == 0 ? 0 : FP.inv(n3);
        ++this.pIdx;
        return this.pIdx - 1;
    }

    void processParticleDrag(int n) {
        this.ppX[n] = this.pX[n] + FP.mul(this.ppX[n] - this.pX[n], this.pdX[n]);
        this.ppY[n] = this.pY[n] + FP.mul(this.ppY[n] - this.pY[n], this.pdY[n]);
    }

    void setParticleDrag(int n, int n2, int n3) {
        this.pdX[n] = n2;
        this.pdY[n] = n3;
    }

    void setParticleVelocity(int n, int n2, int n3) {
        this.ppX[n] = this.pX[n] - n2;
        this.ppY[n] = this.pY[n] - n3;
    }

    void addParticleVelocity(int n, int n2, int n3) {
        int n4 = n;
        this.ppX[n4] = this.ppX[n4] - n2;
        int n5 = n;
        this.ppY[n5] = this.ppY[n5] - n3;
    }

    void setParticleForce(int n, int n2, int n3) {
        this.pfX[n] = n2;
        this.pfY[n] = n3;
    }

    void setParticlePosition(int n, int n2, int n3) {
        this.pX[n] = n2;
        this.pY[n] = n3;
    }

    void forceParticlePosition(int n, int n2, int n3) {
        this.pX[n] = n2;
        this.pY[n] = n3;
        this.ppX[n] = n2;
        this.ppY[n] = n3;
    }

    void integrateParticleSystem(int n) {
        int n2 = FP.pow2(n);
        for (int i = 0; i < 100; ++i) {
            if (!this.pActive[i] || this.pM[i] == 0) continue;
            int n3 = this.pX[i];
            int n4 = this.pY[i];
            int n5 = -FP.mul(this.pX[i] - this.ppX[i], FP.div(this.pdX[i], this.pM[i]));
            int n6 = -FP.mul(this.pY[i] - this.ppY[i], FP.div(this.pdY[i], this.pM[i]));
            int n7 = this.pfX[i] + FP.div(n5, n2);
            int n8 = this.pfY[i] + FP.div(n6, n2);
            int n9 = FP.mul(n7, this.pM[i]);
            int n10 = FP.mul(n8, this.pM[i]);
            int n11 = i;
            this.pX[n11] = this.pX[n11] + (this.pX[i] - this.ppX[i] + FP.mul(n9, n2));
            int n12 = i;
            this.pY[n12] = this.pY[n12] + (this.pY[i] - this.ppY[i] + FP.mul(n10, n2));
            this.ppX[i] = n3;
            this.ppY[i] = n4;
        }
    }

    int addDistanceConstraint(int n, int n2, int n3, int n4) {
        this.cActive[this.cIdx] = true;
        this.cpA[this.cIdx] = n;
        this.cpB[this.cIdx] = n2;
        this.cL[this.cIdx] = n3;
        this.cE[this.cIdx] = n4;
        ++this.cIdx;
        return this.cIdx - 1;
    }

    void updateDistanceConstraintsSystem(int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = 100;
            int n4 = 1;
            if (i % 2 == 0) {
                n2 = 99;
                n3 = -1;
                n4 = -1;
            }
            for (int j = n2; j != n3; j += n4) {
                if (!this.cActive[j]) continue;
                int n5 = this.cpA[j];
                int n6 = this.cpB[j];
                if (!this.pActive[n5] || !this.pActive[n6] || this.pM[n5] == 0 && this.pM[n6] == 0) continue;
                int n7 = this.pX[n6] - this.pX[n5];
                int n8 = this.pY[n6] - this.pY[n5];
                int n9 = PhysicsFP.distance(n7, n8);
                if (n9 == 0) {
                    n7 = 0;
                    n8 = 0;
                } else {
                    n7 = FP.div(n7, n9);
                    n8 = FP.div(n8, n9);
                }
                if (this.pM[n5] == 0) {
                    this.setParticlePosition(n6, this.pX[n5] + FP.mul(n7, this.cL[j]), this.pY[n5] + FP.mul(n8, this.cL[j]));
                    continue;
                }
                if (this.pM[n6] == 0) {
                    this.setParticlePosition(n5, this.pX[n6] - FP.mul(n7, this.cL[j]), this.pY[n6] - FP.mul(n8, this.cL[j]));
                    continue;
                }
                int n10 = (n9 - this.cL[j]) / 2;
                int n11 = FP.mul(FP.mul(n7, n10), this.cE[j]);
                int n12 = FP.mul(FP.mul(n8, n10), this.cE[j]);
                int n13 = FP.div(this.pM[n5], this.pM[n5] + this.pM[n6]);
                int n14 = 262144 - n13;
                this.setParticlePosition(n5, this.pX[n5] + FP.mul(n11, n13), this.pY[n5] + FP.mul(n12, n13));
                this.setParticlePosition(n6, this.pX[n6] - FP.mul(n11, n14), this.pY[n6] - FP.mul(n12, n14));
            }
        }
    }

    void setGravity(int n) {
        for (int i = 0; i < 100; ++i) {
            if (!this.pActive[i] || this.pM[i] == 0) continue;
            this.pfY[i] = FP.div(n, this.pM[i]);
        }
    }

    public static int distance(int n, int n2) {
        int n3 = (n = Math.abs(n)) > (n2 = Math.abs(n2)) ? n + ((n2 >>= 3) + n2 + n2) : n2 + ((n >>= 3) + n + n);
        return n3;
    }

    public static int distance(int n, int n2, int n3, int n4) {
        return PhysicsFP.distance(n3 - n, n4 - n2);
    }
}

