/*
 * Decompiled with CFR 0.152.
 */
package simple.audio;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import simple.audio.AudioSystem;

public class AudioPlayer {
    String strResourceName = "";
    private Player pPlayer = null;
    private VolumeControl pVolumeControl = null;
    private int iVolume = 255;
    private long lMediaTime = 0L;

    AudioPlayer(AudioSystem pAudioSystem) {
    }

    protected void finalize() throws Throwable {
        if (this.pPlayer == null) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        this.pPlayer.deallocate();
        this.pPlayer = null;
        this.pVolumeControl = null;
    }

    public String getResourceName() {
        return this.strResourceName;
    }

    private String getAudioFileMIME(String strResourceName) {
        int iDotIndex = strResourceName.lastIndexOf(46);
        String sExt = strResourceName.substring(iDotIndex + 1).toUpperCase();
        if (sExt.compareTo("MID") == 0) {
            return "audio/midi";
        }
        if (sExt.compareTo("MMF") == 0) {
            return "application/x-smaf";
        }
        if (sExt.compareTo("AMR") == 0) {
            return "audio/amr";
        }
        if (sExt.compareTo("WAV") == 0) {
            return "audio/wav";
        }
        return "audio/wav";
    }

    public void loadAudioData(String strResourceName) {
        try {
            String strMIME = this.getAudioFileMIME(strResourceName);
            this.pPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(strResourceName), (String)strMIME);
            this.strResourceName = strResourceName;
        }
        catch (MediaException e) {
            this.pPlayer = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.pPlayer = null;
            e.printStackTrace();
        }
    }

    public void setVolume(int iVolume) {
        System.out.println("> simple.audio.AudioPlayer.setVolume(" + iVolume + ")");
        this.iVolume = iVolume;
        if (this.pPlayer == null) {
            return;
        }
        if (this.pVolumeControl == null) {
            this.pVolumeControl = (VolumeControl)this.pPlayer.getControl("VolumeControl");
        }
        if (this.pVolumeControl != null) {
            this.pVolumeControl.setLevel(iVolume * 100000 / 255 / 1000);
        }
        System.out.println("< simple.audio.AudioPlayer.setVolume()");
    }

    public int getVolume() {
        return this.iVolume;
    }

    public void rewind() {
        if (this.pPlayer == null) {
            return;
        }
        this.setPosition(0L);
    }

    public void setPosition(long lPosition) {
        this.lMediaTime = lPosition * 1000L;
        try {
            if (this.pPlayer.getState() == 100) {
                this.pPlayer.realize();
            }
            this.pPlayer.setMediaTime(this.lMediaTime);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public boolean isPlaying() {
        if (this.pPlayer == null) {
            return false;
        }
        return this.pPlayer.getState() == 400;
    }

    public void play(int iLoops) {
        if (this.pPlayer == null) {
            return;
        }
        this.pPlayer.setLoopCount(iLoops);
        try {
            if (this.pPlayer.getState() == 100) {
                this.pPlayer.realize();
            }
            this.setVolume(this.iVolume);
            this.pPlayer.setMediaTime(this.lMediaTime);
            this.pPlayer.start();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.pPlayer == null) {
            return;
        }
        try {
            this.pPlayer.stop();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void mute() {
        if (this.pPlayer == null) {
            return;
        }
        if (this.pVolumeControl == null) {
            this.pVolumeControl = (VolumeControl)this.pPlayer.getControl("VolumeControl");
        }
        if (this.pVolumeControl != null) {
            this.pVolumeControl.setMute(true);
        }
    }

    public void unmute() {
        if (this.pPlayer == null) {
            return;
        }
        if (this.pVolumeControl == null) {
            this.pVolumeControl = (VolumeControl)this.pPlayer.getControl("VolumeControl");
        }
        if (this.pVolumeControl != null) {
            this.pVolumeControl.setMute(false);
        }
    }
}

