/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.Light;
import com.mascotcapsule.micro3d.v3.Texture;

public class Effect3D {
    public static final int NORMAL_SHADING = 0;
    public static final int TOON_SHADING = 1;
    Light light;
    Texture texture;
    int shading;
    int toonHigh;
    int toonLow;
    int toonThreshold;
    boolean isTransparency;

    public Effect3D() {
        this.shading = 0;
        this.isTransparency = true;
    }

    public Effect3D(Light light, int n2, boolean bl2, Texture texture) {
        this.setShadingType(n2);
        this.setSphereTexture(texture);
        this.setLight(light);
        this.isTransparency = bl2;
    }

    public final Light getLight() {
        return this.light;
    }

    public final int getShading() {
        return this.shading;
    }

    public final int getShadingType() {
        return this.shading;
    }

    public final Texture getSphereMap() {
        return this.texture;
    }

    public final Texture getSphereTexture() {
        return this.texture;
    }

    public final int getThreshold() {
        return this.toonThreshold;
    }

    public final int getThresholdHigh() {
        return this.toonHigh;
    }

    public final int getThresholdLow() {
        return this.toonLow;
    }

    public final int getToonHigh() {
        return this.toonHigh;
    }

    public final int getToonLow() {
        return this.toonLow;
    }

    public final int getToonThreshold() {
        return this.toonThreshold;
    }

    public final boolean isSemiTransparentEnabled() {
        return this.isTransparency;
    }

    public final boolean isTransparency() {
        return this.isTransparency;
    }

    public final void setLight(Light light) {
        this.light = light;
    }

    public final void setSemiTransparentEnabled(boolean bl2) {
        this.isTransparency = bl2;
    }

    public final void setShading(int n2) {
        this.setShadingType(n2);
    }

    public final void setShadingType(int n2) {
        if ((n2 & 0xFFFFFFFE) != 0) {
            throw new IllegalArgumentException();
        }
        this.shading = n2;
    }

    public final void setSphereMap(Texture texture) {
        this.setSphereTexture(texture);
    }

    public final void setSphereTexture(Texture texture) {
        if (texture != null && texture.isForModel) {
            throw new IllegalArgumentException();
        }
        this.texture = texture;
    }

    public final void setThreshold(int n2, int n3, int n4) {
        this.setToonParams(n2, n3, n4);
    }

    public final void setToonParams(int n2, int n3, int n4) {
        if ((n2 & 0xFFFFFF00 | n3 & 0xFFFFFF00 | n4 & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException();
        }
        this.toonThreshold = n2;
        this.toonHigh = n3;
        this.toonLow = n4;
    }

    public final void setTransparency(boolean bl2) {
        this.isTransparency = bl2;
    }
}

