/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ITypeInfo;
import com.sun.jna.platform.win32.COM.ITypeLib;
import com.sun.jna.platform.win32.COM.TypeComp;
import com.sun.jna.platform.win32.COM.TypeInfo;
import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLib;
import com.sun.jna.platform.win32.COM.TypeLibUtil$FindName;
import com.sun.jna.platform.win32.COM.TypeLibUtil$IsName;
import com.sun.jna.platform.win32.COM.TypeLibUtil$TypeLibDoc;
import com.sun.jna.platform.win32.Guid$CLSID$ByReference;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.OaIdl$MEMBERID;
import com.sun.jna.platform.win32.OaIdl$TLIBATTR;
import com.sun.jna.platform.win32.OaIdl$TYPEKIND;
import com.sun.jna.platform.win32.OaIdl$TYPEKIND$ByReference;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes$BSTRByReference;
import com.sun.jna.platform.win32.WTypes$LPOLESTR;
import com.sun.jna.platform.win32.WinDef$BOOLByReference;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$LCID;
import com.sun.jna.platform.win32.WinDef$UINT;
import com.sun.jna.platform.win32.WinDef$ULONG;
import com.sun.jna.platform.win32.WinDef$USHORTByReference;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.PointerByReference;

public class TypeLibUtil {
    public static final OleAuto OLEAUTO = OleAuto.INSTANCE;
    private ITypeLib typelib;
    private WinDef$LCID lcid = Kernel32.INSTANCE.GetUserDefaultLCID();
    private String name;
    private String docString;
    private int helpContext;
    private String helpFile;

    public TypeLibUtil(String string, int n2, int n3) {
        Guid$CLSID$ByReference guid$CLSID$ByReference = new Guid$CLSID$ByReference();
        WinNT$HRESULT winNT$HRESULT = Ole32.INSTANCE.CLSIDFromString(string, guid$CLSID$ByReference);
        COMUtils.checkRC(winNT$HRESULT);
        PointerByReference pointerByReference = new PointerByReference();
        winNT$HRESULT = OleAuto.INSTANCE.LoadRegTypeLib(guid$CLSID$ByReference, n2, n3, this.lcid, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        this.typelib = new TypeLib(pointerByReference.getValue());
        this.initTypeLibInfo();
    }

    public TypeLibUtil(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.LoadTypeLib(string, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        this.typelib = new TypeLib(pointerByReference.getValue());
        this.initTypeLibInfo();
    }

    private void initTypeLibInfo() {
        TypeLibUtil$TypeLibDoc typeLibUtil$TypeLibDoc = this.getDocumentation(-1);
        this.name = typeLibUtil$TypeLibDoc.getName();
        this.docString = typeLibUtil$TypeLibDoc.getDocString();
        this.helpContext = typeLibUtil$TypeLibDoc.getHelpContext();
        this.helpFile = typeLibUtil$TypeLibDoc.getHelpFile();
    }

    public int getTypeInfoCount() {
        return this.typelib.GetTypeInfoCount().intValue();
    }

    public OaIdl$TYPEKIND getTypeInfoType(int n2) {
        OaIdl$TYPEKIND$ByReference oaIdl$TYPEKIND$ByReference = new OaIdl$TYPEKIND$ByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetTypeInfoType(new WinDef$UINT((long)n2), oaIdl$TYPEKIND$ByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return oaIdl$TYPEKIND$ByReference;
    }

    public ITypeInfo getTypeInfo(int n2) {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetTypeInfo(new WinDef$UINT((long)n2), pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeInfo(pointerByReference.getValue());
    }

    public TypeInfoUtil getTypeInfoUtil(int n2) {
        return new TypeInfoUtil(this.getTypeInfo(n2));
    }

    public OaIdl$TLIBATTR getLibAttr() {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetLibAttr(pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new OaIdl$TLIBATTR(pointerByReference.getValue());
    }

    public TypeComp GetTypeComp() {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetTypeComp(pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeComp(pointerByReference.getValue());
    }

    public TypeLibUtil$TypeLibDoc getDocumentation(int n2) {
        WTypes$BSTRByReference wTypes$BSTRByReference = new WTypes$BSTRByReference();
        WTypes$BSTRByReference wTypes$BSTRByReference2 = new WTypes$BSTRByReference();
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference();
        WTypes$BSTRByReference wTypes$BSTRByReference3 = new WTypes$BSTRByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.GetDocumentation(n2, wTypes$BSTRByReference, wTypes$BSTRByReference2, winDef$DWORDByReference, wTypes$BSTRByReference3);
        COMUtils.checkRC(winNT$HRESULT);
        TypeLibUtil$TypeLibDoc typeLibUtil$TypeLibDoc = new TypeLibUtil$TypeLibDoc(wTypes$BSTRByReference.getString(), wTypes$BSTRByReference2.getString(), winDef$DWORDByReference.getValue().intValue(), wTypes$BSTRByReference3.getString());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference.getValue());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference2.getValue());
        OLEAUTO.SysFreeString(wTypes$BSTRByReference3.getValue());
        return typeLibUtil$TypeLibDoc;
    }

    public TypeLibUtil$IsName IsName(String string, int n2) {
        WTypes$LPOLESTR wTypes$LPOLESTR = new WTypes$LPOLESTR(string);
        WinDef$ULONG winDef$ULONG = new WinDef$ULONG((long)n2);
        WinDef$BOOLByReference winDef$BOOLByReference = new WinDef$BOOLByReference();
        WinNT$HRESULT winNT$HRESULT = this.typelib.IsName(wTypes$LPOLESTR, winDef$ULONG, winDef$BOOLByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return new TypeLibUtil$IsName(wTypes$LPOLESTR.getValue(), winDef$BOOLByReference.getValue().booleanValue());
    }

    public TypeLibUtil$FindName FindName(String string, int n2, short s2) {
        Pointer pointer = Ole32.INSTANCE.CoTaskMemAlloc(((long)string.length() + 1L) * (long)Native.WCHAR_SIZE);
        WTypes$LPOLESTR wTypes$LPOLESTR = new WTypes$LPOLESTR(pointer);
        wTypes$LPOLESTR.setValue(string);
        WinDef$ULONG winDef$ULONG = new WinDef$ULONG((long)n2);
        WinDef$USHORTByReference winDef$USHORTByReference = new WinDef$USHORTByReference(s2);
        Pointer[] pointerArray = new Pointer[s2];
        OaIdl$MEMBERID[] oaIdl$MEMBERIDArray = new OaIdl$MEMBERID[s2];
        WinNT$HRESULT winNT$HRESULT = this.typelib.FindName(wTypes$LPOLESTR, winDef$ULONG, pointerArray, oaIdl$MEMBERIDArray, winDef$USHORTByReference);
        COMUtils.checkRC(winNT$HRESULT);
        TypeLibUtil$FindName typeLibUtil$FindName = new TypeLibUtil$FindName(wTypes$LPOLESTR.getValue(), pointerArray, oaIdl$MEMBERIDArray, winDef$USHORTByReference.getValue().shortValue());
        Ole32.INSTANCE.CoTaskMemFree(pointer);
        return typeLibUtil$FindName;
    }

    public void ReleaseTLibAttr(OaIdl$TLIBATTR oaIdl$TLIBATTR) {
        this.typelib.ReleaseTLibAttr(oaIdl$TLIBATTR);
    }

    public WinDef$LCID getLcid() {
        return this.lcid;
    }

    public ITypeLib getTypelib() {
        return this.typelib;
    }

    public String getName() {
        return this.name;
    }

    public String getDocString() {
        return this.docString;
    }

    public int getHelpContext() {
        return this.helpContext;
    }

    public String getHelpFile() {
        return this.helpFile;
    }
}

