/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$LUID;
import com.sun.jna.platform.win32.WinNT$LUID_AND_ATTRIBUTES;
import com.sun.jna.platform.win32.WinNT$TOKEN_PRIVILEGES;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.platform.win32.Winsvc$ENUM_SERVICE_STATUS;
import com.sun.jna.platform.win32.Winsvc$SC_ACTION;
import com.sun.jna.platform.win32.Winsvc$SC_ACTION$ByReference;
import com.sun.jna.platform.win32.Winsvc$SERVICE_FAILURE_ACTIONS;
import com.sun.jna.platform.win32.Winsvc$SERVICE_FAILURE_ACTIONS$ByReference;
import com.sun.jna.platform.win32.Winsvc$SERVICE_FAILURE_ACTIONS_FLAG;
import com.sun.jna.platform.win32.Winsvc$SERVICE_STATUS;
import com.sun.jna.platform.win32.Winsvc$SERVICE_STATUS_PROCESS;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.util.List;

public class W32Service
implements Closeable {
    Winsvc.SC_HANDLE _handle = null;

    public W32Service(Winsvc.SC_HANDLE sC_HANDLE) {
        this._handle = sC_HANDLE;
    }

    @Override
    public void close() {
        if (this._handle != null) {
            if (!Advapi32.INSTANCE.CloseServiceHandle(this._handle)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this._handle = null;
        }
    }

    private void addShutdownPrivilegeToProcess() {
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        WinNT$LUID winNT$LUID = new WinNT$LUID();
        Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 32, winNT$HANDLEByReference);
        Advapi32.INSTANCE.LookupPrivilegeValue("", "SeShutdownPrivilege", winNT$LUID);
        WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(1);
        winNT$TOKEN_PRIVILEGES.Privileges[0] = new WinNT$LUID_AND_ATTRIBUTES(winNT$LUID, new WinDef$DWORD(2L));
        Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES, winNT$TOKEN_PRIVILEGES.size(), null, new IntByReference());
    }

    public void setFailureActions(List list2, int n2, String string, String string2) {
        Winsvc$SERVICE_FAILURE_ACTIONS$ByReference winsvc$SERVICE_FAILURE_ACTIONS$ByReference = new Winsvc$SERVICE_FAILURE_ACTIONS$ByReference();
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.dwResetPeriod = n2;
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpRebootMsg = string;
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpCommand = string2;
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.cActions = list2.size();
        winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpsaActions = new Winsvc$SC_ACTION$ByReference();
        Winsvc$SC_ACTION[] winsvc$SC_ACTIONArray = (Winsvc$SC_ACTION[])winsvc$SERVICE_FAILURE_ACTIONS$ByReference.lpsaActions.toArray(list2.size());
        boolean bl2 = false;
        int n3 = 0;
        for (Winsvc$SC_ACTION winsvc$SC_ACTION : list2) {
            if (!bl2 && winsvc$SC_ACTION.type == 2) {
                this.addShutdownPrivilegeToProcess();
                bl2 = true;
            }
            winsvc$SC_ACTIONArray[n3].type = winsvc$SC_ACTION.type;
            winsvc$SC_ACTIONArray[n3].delay = winsvc$SC_ACTION.delay;
            ++n3;
        }
        if (!Advapi32.INSTANCE.ChangeServiceConfig2(this._handle, 2, winsvc$SERVICE_FAILURE_ACTIONS$ByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    private Pointer queryServiceConfig2(int n2) {
        IntByReference intByReference = new IntByReference();
        Advapi32.INSTANCE.QueryServiceConfig2(this._handle, n2, Pointer.NULL, 0, intByReference);
        Memory memory = new Memory(intByReference.getValue());
        if (!Advapi32.INSTANCE.QueryServiceConfig2(this._handle, n2, memory, intByReference.getValue(), new IntByReference())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return memory;
    }

    public Winsvc$SERVICE_FAILURE_ACTIONS getFailureActions() {
        Pointer pointer = this.queryServiceConfig2(2);
        Winsvc$SERVICE_FAILURE_ACTIONS winsvc$SERVICE_FAILURE_ACTIONS = new Winsvc$SERVICE_FAILURE_ACTIONS(pointer);
        return winsvc$SERVICE_FAILURE_ACTIONS;
    }

    public void setFailureActionsFlag(boolean bl2) {
        Winsvc$SERVICE_FAILURE_ACTIONS_FLAG winsvc$SERVICE_FAILURE_ACTIONS_FLAG = new Winsvc$SERVICE_FAILURE_ACTIONS_FLAG();
        int n2 = winsvc$SERVICE_FAILURE_ACTIONS_FLAG.fFailureActionsOnNonCrashFailures = bl2 ? 1 : 0;
        if (!Advapi32.INSTANCE.ChangeServiceConfig2(this._handle, 4, winsvc$SERVICE_FAILURE_ACTIONS_FLAG)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public boolean getFailureActionsFlag() {
        Pointer pointer = this.queryServiceConfig2(4);
        Winsvc$SERVICE_FAILURE_ACTIONS_FLAG winsvc$SERVICE_FAILURE_ACTIONS_FLAG = new Winsvc$SERVICE_FAILURE_ACTIONS_FLAG(pointer);
        return winsvc$SERVICE_FAILURE_ACTIONS_FLAG.fFailureActionsOnNonCrashFailures != 0;
    }

    public Winsvc$SERVICE_STATUS_PROCESS queryStatus() {
        IntByReference intByReference = new IntByReference();
        Advapi32.INSTANCE.QueryServiceStatusEx(this._handle, 0, null, 0, intByReference);
        Winsvc$SERVICE_STATUS_PROCESS winsvc$SERVICE_STATUS_PROCESS = new Winsvc$SERVICE_STATUS_PROCESS(intByReference.getValue());
        if (!Advapi32.INSTANCE.QueryServiceStatusEx(this._handle, 0, winsvc$SERVICE_STATUS_PROCESS, winsvc$SERVICE_STATUS_PROCESS.size(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return winsvc$SERVICE_STATUS_PROCESS;
    }

    public void startService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 4) {
            return;
        }
        if (!Advapi32.INSTANCE.StartService(this._handle, 0, null)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 4) {
            throw new RuntimeException("Unable to start the service");
        }
    }

    public void stopService() {
        this.stopService(30000L);
    }

    void stopService(long l2) {
        long l3 = System.currentTimeMillis();
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 1) {
            return;
        }
        Winsvc$SERVICE_STATUS winsvc$SERVICE_STATUS = new Winsvc$SERVICE_STATUS();
        if (!Advapi32.INSTANCE.ControlService(this._handle, 1, winsvc$SERVICE_STATUS)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        while (winsvc$SERVICE_STATUS.dwCurrentState != 1) {
            try {
                Thread.sleep(winsvc$SERVICE_STATUS.dwWaitHint);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            if (!Advapi32.INSTANCE.QueryServiceStatus(this._handle, winsvc$SERVICE_STATUS)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            if (System.currentTimeMillis() - l3 <= l2) continue;
            throw new RuntimeException(String.format("Service stop exceeded timeout time of %d ms", l2));
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 1) {
            throw new RuntimeException("Unable to stop the service");
        }
    }

    public void continueService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 4) {
            return;
        }
        if (!Advapi32.INSTANCE.ControlService(this._handle, 3, new Winsvc$SERVICE_STATUS())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 4) {
            throw new RuntimeException("Unable to continue the service");
        }
    }

    public void pauseService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 7) {
            return;
        }
        if (!Advapi32.INSTANCE.ControlService(this._handle, 2, new Winsvc$SERVICE_STATUS())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 7) {
            throw new RuntimeException("Unable to pause the service");
        }
    }

    public void waitForNonPendingState() {
        Winsvc$SERVICE_STATUS_PROCESS winsvc$SERVICE_STATUS_PROCESS = this.queryStatus();
        int n2 = winsvc$SERVICE_STATUS_PROCESS.dwCheckPoint;
        int n3 = Kernel32.INSTANCE.GetTickCount();
        while (this.isPendingState(winsvc$SERVICE_STATUS_PROCESS.dwCurrentState)) {
            if (winsvc$SERVICE_STATUS_PROCESS.dwCheckPoint != n2) {
                n2 = winsvc$SERVICE_STATUS_PROCESS.dwCheckPoint;
                n3 = Kernel32.INSTANCE.GetTickCount();
            }
            if (Kernel32.INSTANCE.GetTickCount() - n3 > winsvc$SERVICE_STATUS_PROCESS.dwWaitHint) {
                throw new RuntimeException("Timeout waiting for service to change to a non-pending state.");
            }
            int n4 = winsvc$SERVICE_STATUS_PROCESS.dwWaitHint / 10;
            if (n4 < 1000) {
                n4 = 1000;
            } else if (n4 > 10000) {
                n4 = 10000;
            }
            try {
                Thread.sleep(n4);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            winsvc$SERVICE_STATUS_PROCESS = this.queryStatus();
        }
    }

    private boolean isPendingState(int n2) {
        switch (n2) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public Winsvc.SC_HANDLE getHandle() {
        return this._handle;
    }

    public Winsvc$ENUM_SERVICE_STATUS[] enumDependentServices(int n2) {
        IntByReference intByReference = new IntByReference(0);
        IntByReference intByReference2 = new IntByReference(0);
        Advapi32.INSTANCE.EnumDependentServices(this._handle, n2, Pointer.NULL, 0, intByReference, intByReference2);
        int n3 = Kernel32.INSTANCE.GetLastError();
        if (n3 != 234) {
            throw new Win32Exception(n3);
        }
        Memory memory = new Memory(intByReference.getValue());
        boolean bl2 = Advapi32.INSTANCE.EnumDependentServices(this._handle, n2, memory, (int)memory.size(), intByReference, intByReference2);
        if (!bl2) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (intByReference2.getValue() == 0) {
            return new Winsvc$ENUM_SERVICE_STATUS[0];
        }
        Winsvc$ENUM_SERVICE_STATUS winsvc$ENUM_SERVICE_STATUS = (Winsvc$ENUM_SERVICE_STATUS)Structure.newInstance(Winsvc$ENUM_SERVICE_STATUS.class, memory);
        winsvc$ENUM_SERVICE_STATUS.read();
        return (Winsvc$ENUM_SERVICE_STATUS[])winsvc$ENUM_SERVICE_STATUS.toArray(intByReference2.getValue());
    }
}

