/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.m3g;

import emulator.Emulator;
import emulator.custom.CustomJarResources;
import emulator.graphics3D.m3g.AdlerInputStream;
import emulator.graphics3D.m3g.CountedInputStream;
import emulator.graphics3D.m3g.PeekInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Inflater;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.InputConnection;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.AnimationTrack;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.MorphingMesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.SkinnedMesh;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.Transformable;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class M3GLoader {
    static final byte[] a = new byte[]{-85, 74, 83, 82, 49, 56, 52, -69, 13, 10, 26, 10};
    static final byte[] b = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final Boolean a = new Boolean(false);
    private static final Boolean b = new Boolean(true);
    private Vector a;
    private Vector b;
    private Vector c;
    private Vector d = null;
    private String a;
    private String b;
    private int a;
    private boolean a = new Vector();
    private boolean b = new Vector();

    public static Object3D[] load(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            return new M3GLoader().a(string);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static Object3D[] load(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            return new M3GLoader().a(byArray, n2);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private M3GLoader() {
        this.c = new Vector();
    }

    private M3GLoader(Vector vector2, String string) {
        this.c = new Vector();
        this.b = string;
        this.c = vector2;
    }

    private Object3D[] a(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.a(string)) {
            throw new IOException("Reference loop detected.");
        }
        this.a = string;
        this.c.addElement(string);
        PeekInputStream peekInputStream = new PeekInputStream(this.b(string), 12);
        int n2 = M3GLoader.f(peekInputStream);
        peekInputStream.rewind();
        Object3D[] object3DArray = this.a(peekInputStream, n2);
        this.c.removeElement(string);
        return object3DArray;
    }

    private Object3D[] a(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Resource byte array is null.");
        }
        int n3 = M3GLoader.a(byArray, n2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, byArray.length - n2);
        return this.a(byteArrayInputStream, n3);
    }

    private Object3D[] a(InputStream inputStream, int n2) {
        if (n2 == 1) {
            return this.b(inputStream);
        }
        if (n2 == 2) {
            return M3GLoader.a(inputStream);
        }
        throw new IOException("File not recognized.");
    }

    private static Object3D[] a(InputStream inputStream) {
        return new Object3D[]{new Image2D(100, Image.createImage(inputStream))};
    }

    private Object3D[] b(InputStream inputStream) {
        inputStream.skip(a.length);
        while (this.a(inputStream)) {
            ++this.a;
        }
        return this.a();
    }

    private boolean a(InputStream inputStream) {
        long l2;
        if (this.a > 1 && this.b && !this.a) {
            throw new IOException("No external sections (" + this.a + ").");
        }
        AdlerInputStream adlerInputStream = new AdlerInputStream(inputStream);
        int n2 = M3GLoader.a(adlerInputStream);
        if (n2 == -1) {
            return false;
        }
        if (this.a == 0 && n2 != 0) {
            throw new IOException("Compressed header (" + this.a + ").");
        }
        long l3 = M3GLoader.a(adlerInputStream);
        long l4 = M3GLoader.a(adlerInputStream);
        CountedInputStream countedInputStream = null;
        if (n2 == 0) {
            countedInputStream = adlerInputStream;
            if (l4 != l3 - 13L) {
                Emulator.getEmulator().getLogStream().println("M3GLoader: Section length mismatch!!!");
                return false;
            }
        } else {
            if (n2 != 1) {
                Emulator.getEmulator().getLogStream().println("M3GLoader: Unrecognized compression schemeh(" + n2 + ")!!!");
                return false;
            }
            byte[] byArray = new byte[(int)l3 - 13];
            adlerInputStream.read(byArray);
            byte[] byArray2 = new byte[(int)l4];
            M3GLoader.a(byArray, byArray2);
            countedInputStream = new CountedInputStream(new ByteArrayInputStream(byArray2));
        }
        ((CountedInputStream)countedInputStream).resetCounter();
        while ((long)((CountedInputStream)countedInputStream).getCounter() < l4) {
            this.a(this.a(countedInputStream));
        }
        if ((long)((CountedInputStream)countedInputStream).getCounter() != l4) {
            Emulator.getEmulator().getLogStream().println("M3GLoader: Section length mismatch!!!");
            return false;
        }
        long l5 = adlerInputStream.getChecksum();
        if (l5 != (l2 = M3GLoader.a(adlerInputStream))) {
            throw new IOException("Checksum is wrong (" + this.a + ").");
        }
        return true;
    }

    private Object3D a(CountedInputStream countedInputStream) {
        int n2 = M3GLoader.a(countedInputStream);
        long l2 = M3GLoader.a(countedInputStream);
        long l3 = (long)countedInputStream.getCounter() + l2;
        Object3D object3D = null;
        switch (n2) {
            case 0: {
                if (this.a != 0) {
                    throw new IOException("Header in wrong section (" + this.a + ").");
                }
                this.a((InputStream)countedInputStream);
                break;
            }
            case 1: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 2: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 3: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 4: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 5: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 6: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 7: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 8: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 9: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 10: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 11: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 12: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 13: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 14: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 15: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 16: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 17: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 18: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 19: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 20: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 21: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 22: {
                object3D = this.a((InputStream)countedInputStream);
                break;
            }
            case 255: {
                if (this.a != 1) {
                    throw new IOException("External reference in wrong section (" + this.a + ").");
                }
                if (!this.b) {
                    throw new IOException("External links in self contained file (" + this.a + ").");
                }
                String string = M3GLoader.a(countedInputStream);
                this.a = true;
                object3D = new M3GLoader(this.c, this.a).a(string)[0];
                break;
            }
            default: {
                throw new IOException("Unrecognized object type " + n2 + " (" + this.a + ").");
            }
        }
        if (l3 != (long)countedInputStream.getCounter()) {
            throw new IOException("Object length mismatch (" + this.a + ").");
        }
        this.b(object3D);
        return object3D;
    }

    private void a(Object3D object3D) {
        if (object3D != null) {
            this.a.addElement(object3D);
            this.b.addElement(a);
        }
    }

    private Object3D a(int n2) {
        if (n2 == 0) {
            return null;
        }
        if (n2 >= 2 && n2 - 2 < this.a.size()) {
            this.b.setElementAt(b, n2 - 2);
            return (Object3D)this.a.elementAt(n2 - 2);
        }
        throw new IllegalArgumentException("Invalid reference index (" + this.a + ").");
    }

    private Object3D[] a() {
        Vector vector2 = new Vector();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (this.b.elementAt(i2) != a) continue;
            vector2.addElement(this.a.elementAt(i2));
        }
        Object3D[] object3DArray = new Object3D[vector2.size()];
        for (int i3 = 0; i3 < vector2.size(); ++i3) {
            object3DArray[i3] = (Object3D)vector2.elementAt(i3);
        }
        return object3DArray;
    }

    private void a(InputStream inputStream) {
        byte[] byArray = new byte[2];
        inputStream.read(byArray);
        this.b = M3GLoader.b(inputStream);
        M3GLoader.a(inputStream);
        M3GLoader.a(inputStream);
        if (byArray[0] != 1 || byArray[1] != 0) {
            throw new IOException("Invalid file version (" + this.a + ").");
        }
        M3GLoader.a(inputStream);
    }

    private void a(Object3D object3D, InputStream inputStream) {
        object3D.setUserID((int)M3GLoader.a(inputStream));
        long l2 = M3GLoader.a(inputStream);
        this.d = new Vector();
        while (l2-- > 0L) {
            AnimationTrack animationTrack = (AnimationTrack)this.a(inputStream);
            if (animationTrack == null) {
                throw new NullPointerException();
            }
            this.d.addElement(animationTrack);
        }
        long l3 = M3GLoader.a(inputStream);
        if (l3 != 0L) {
            Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
            while (l3-- > 0L) {
                int n2 = (int)M3GLoader.a(inputStream);
                byte[] byArray = new byte[(int)M3GLoader.a(inputStream)];
                inputStream.read(byArray);
                hashtable.put(new Integer(n2), byArray);
            }
            object3D.setUserObject(hashtable);
        }
    }

    private void a(Transformable transformable, InputStream inputStream) {
        this.a((Object3D)transformable, inputStream);
        if (M3GLoader.b(inputStream)) {
            transformable.setTranslation(M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream));
            transformable.setScale(M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream));
            transformable.setOrientation(M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        }
        if (M3GLoader.b(inputStream)) {
            transformable.setTransform(M3GLoader.a(inputStream));
        }
    }

    private void a(Node node, InputStream inputStream) {
        this.a((Transformable)node, inputStream);
        node.setRenderingEnable(M3GLoader.b(inputStream));
        node.setPickingEnable(M3GLoader.b(inputStream));
        node.setAlphaFactor((float)M3GLoader.a(inputStream) / 255.0f);
        node.setScope((int)M3GLoader.a(inputStream));
        if (M3GLoader.b(inputStream)) {
            int n2 = M3GLoader.a(inputStream);
            int n3 = M3GLoader.a(inputStream);
            int n4 = (int)M3GLoader.a(inputStream);
            int n5 = (int)M3GLoader.a(inputStream);
            node.setAlignment((Node)this.a(n4), n2, (Node)this.a(n5), n3);
        }
    }

    private void a(Group group, InputStream inputStream) {
        this.a((Node)group, inputStream);
        int n2 = (int)M3GLoader.a(inputStream);
        while (n2-- > 0) {
            group.addChild((Node)this.a(inputStream));
        }
    }

    private void b(Object3D object3D) {
        if (this.d != null && object3D != null) {
            for (int i2 = 0; i2 < this.d.size(); ++i2) {
                object3D.addAnimationTrack((AnimationTrack)this.d.elementAt(i2));
            }
            this.d = null;
        }
    }

    private AnimationController a(InputStream inputStream) {
        AnimationController animationController = new AnimationController();
        this.a(animationController, inputStream);
        float f2 = M3GLoader.a(inputStream);
        float f3 = M3GLoader.a(inputStream);
        animationController.setActiveInterval(M3GLoader.c(inputStream), M3GLoader.c(inputStream));
        float f4 = M3GLoader.a(inputStream);
        int n2 = M3GLoader.c(inputStream);
        animationController.setPosition(f4, n2);
        animationController.setSpeed(f2, n2);
        animationController.setWeight(f3);
        return animationController;
    }

    private AnimationTrack a(InputStream inputStream) {
        AnimationController animationController = new AnimationController();
        this.a(animationController, inputStream);
        KeyframeSequence keyframeSequence = (KeyframeSequence)this.a(inputStream);
        AnimationController animationController2 = (AnimationController)this.a(inputStream);
        int n2 = (int)M3GLoader.a(inputStream);
        AnimationTrack animationTrack = new AnimationTrack(keyframeSequence, n2);
        M3GLoader.a(animationController, animationTrack);
        animationTrack.setController(animationController2);
        return animationTrack;
    }

    private Appearance a(InputStream inputStream) {
        Appearance appearance = new Appearance();
        this.a(appearance, inputStream);
        appearance.setLayer(M3GLoader.a(inputStream));
        appearance.setCompositingMode((CompositingMode)this.a(inputStream));
        appearance.setFog((Fog)this.a(inputStream));
        appearance.setPolygonMode((PolygonMode)this.a(inputStream));
        appearance.setMaterial((Material)this.a(inputStream));
        int n2 = (int)M3GLoader.a(inputStream);
        for (int i2 = 0; i2 < n2; ++i2) {
            Texture2D texture2D = (Texture2D)this.a(inputStream);
            if (texture2D == null) {
                throw new IOException("Null texture reference");
            }
            appearance.setTexture(i2, texture2D);
        }
        return appearance;
    }

    private Background a(InputStream inputStream) {
        Background background = new Background();
        this.a(background, inputStream);
        background.setColor(M3GLoader.d(inputStream));
        Image2D image2D = (Image2D)this.a(inputStream);
        background.setImage(image2D);
        background.setImageMode(M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        background.setCrop(M3GLoader.c(inputStream), M3GLoader.c(inputStream), M3GLoader.c(inputStream), M3GLoader.c(inputStream));
        background.setDepthClearEnable(M3GLoader.b(inputStream));
        background.setColorClearEnable(M3GLoader.b(inputStream));
        return background;
    }

    private Camera a(InputStream inputStream) {
        Camera camera = new Camera();
        this.a(camera, inputStream);
        int n2 = M3GLoader.a(inputStream);
        if (n2 == 48) {
            camera.setGeneric(M3GLoader.a(inputStream));
        } else if (n2 == 50) {
            camera.setPerspective(M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        } else {
            if (n2 != 49) {
                throw new IOException("Projection type not recognized: " + n2 + "(" + this.a + ").");
            }
            camera.setParallel(M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        }
        return camera;
    }

    private CompositingMode a(InputStream inputStream) {
        CompositingMode compositingMode = new CompositingMode();
        this.a(compositingMode, inputStream);
        compositingMode.setDepthTestEnable(M3GLoader.b(inputStream));
        compositingMode.setDepthWriteEnable(M3GLoader.b(inputStream));
        compositingMode.setColorWriteEnable(M3GLoader.b(inputStream));
        compositingMode.setAlphaWriteEnable(M3GLoader.b(inputStream));
        compositingMode.setBlending(M3GLoader.a(inputStream));
        compositingMode.setAlphaThreshold((float)M3GLoader.a(inputStream) / 255.0f);
        compositingMode.setDepthOffset(M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        return compositingMode;
    }

    private Fog a(InputStream inputStream) {
        Fog fog = new Fog();
        this.a(fog, inputStream);
        fog.setColor(M3GLoader.e(inputStream));
        fog.setMode(M3GLoader.a(inputStream));
        if (fog.getMode() == 80) {
            fog.setDensity(M3GLoader.a(inputStream));
        } else if (fog.getMode() == 81) {
            fog.setLinear(M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        }
        return fog;
    }

    private Group a(InputStream inputStream) {
        Group group = new Group();
        this.a(group, inputStream);
        return group;
    }

    private Image2D a(InputStream inputStream) {
        Image2D image2D;
        AnimationController animationController = new AnimationController();
        this.a(animationController, inputStream);
        int n2 = M3GLoader.a(inputStream);
        boolean bl2 = M3GLoader.b(inputStream);
        int n3 = (int)M3GLoader.a(inputStream);
        int n4 = (int)M3GLoader.a(inputStream);
        Image2D image2D2 = null;
        if (bl2) {
            image2D = new Image2D(n2, n3, n4);
        } else {
            byte[] byArray = new byte[(int)M3GLoader.a(inputStream)];
            if (byArray.length > 0) {
                inputStream.read(byArray);
            }
            byte[] byArray2 = new byte[(int)M3GLoader.a(inputStream)];
            inputStream.read(byArray2);
            image2D = byArray.length != 0 ? new Image2D(n2, n3, n4, byArray2, byArray) : new Image2D(n2, n3, n4, byArray2);
        }
        image2D2 = image2D;
        M3GLoader.a(animationController, image2D2);
        return image2D2;
    }

    private KeyframeSequence a(InputStream inputStream) {
        AnimationController animationController = new AnimationController();
        this.a(animationController, inputStream);
        int n2 = M3GLoader.a(inputStream);
        int n3 = M3GLoader.a(inputStream);
        int n4 = M3GLoader.a(inputStream);
        int n5 = (int)M3GLoader.a(inputStream);
        int n6 = (int)M3GLoader.a(inputStream);
        int n7 = (int)M3GLoader.a(inputStream);
        int n8 = (int)M3GLoader.a(inputStream);
        int n9 = (int)M3GLoader.a(inputStream);
        KeyframeSequence keyframeSequence = new KeyframeSequence(n9, n8, n2);
        M3GLoader.a(animationController, keyframeSequence);
        keyframeSequence.setRepeatMode(n3);
        keyframeSequence.setDuration(n5);
        keyframeSequence.setValidRange(n6, n7);
        float[] fArray = new float[n8];
        if (n4 == 0) {
            for (int i2 = 0; i2 < n9; ++i2) {
                int n10 = M3GLoader.c(inputStream);
                for (int i3 = 0; i3 < n8; ++i3) {
                    fArray[i3] = M3GLoader.a(inputStream);
                }
                keyframeSequence.setKeyframe(i2, n10, fArray);
            }
        } else {
            int n11;
            if (n4 != 1 && n4 != 2) {
                throw new IOException("Encoding not recognized: " + n4 + "(" + this.a + ").");
            }
            float[] fArray2 = new float[n8];
            float[] fArray3 = new float[n8];
            for (n11 = 0; n11 < n8; ++n11) {
                fArray2[n11] = M3GLoader.a(inputStream);
            }
            for (n11 = 0; n11 < n8; ++n11) {
                fArray3[n11] = M3GLoader.a(inputStream);
            }
            for (n11 = 0; n11 < n9; ++n11) {
                int n12;
                int n13;
                int n14 = M3GLoader.c(inputStream);
                if (n4 == 1) {
                    for (n13 = 0; n13 < n8; ++n13) {
                        n12 = M3GLoader.a(inputStream);
                        fArray[n13] = fArray2[n13] + fArray3[n13] * (float)n12 / 255.0f;
                    }
                } else {
                    for (n13 = 0; n13 < n8; ++n13) {
                        n12 = M3GLoader.b(inputStream);
                        fArray[n13] = fArray2[n13] + fArray3[n13] * (float)n12 / 65535.0f;
                    }
                }
                keyframeSequence.setKeyframe(n11, n14, fArray);
            }
        }
        return keyframeSequence;
    }

    private Light a(InputStream inputStream) {
        Light light = new Light();
        this.a(light, inputStream);
        light.setAttenuation(M3GLoader.a(inputStream), M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        light.setColor(M3GLoader.e(inputStream));
        light.setMode(M3GLoader.a(inputStream));
        light.setIntensity(M3GLoader.a(inputStream));
        light.setSpotAngle(M3GLoader.a(inputStream));
        light.setSpotExponent(M3GLoader.a(inputStream));
        return light;
    }

    private Material a(InputStream inputStream) {
        Material material = new Material();
        this.a(material, inputStream);
        material.setColor(1024, M3GLoader.e(inputStream));
        material.setColor(2048, M3GLoader.d(inputStream));
        material.setColor(4096, M3GLoader.e(inputStream));
        material.setColor(8192, M3GLoader.e(inputStream));
        material.setShininess(M3GLoader.a(inputStream));
        material.setVertexColorTrackingEnable(M3GLoader.b(inputStream));
        return material;
    }

    private Mesh a(InputStream inputStream) {
        Group group = new Group();
        this.a((Node)group, inputStream);
        VertexBuffer vertexBuffer = (VertexBuffer)this.a(inputStream);
        int n2 = (int)M3GLoader.a(inputStream);
        IndexBuffer[] indexBufferArray = new IndexBuffer[n2];
        Appearance[] appearanceArray = new Appearance[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexBufferArray[i2] = (IndexBuffer)this.a(inputStream);
            appearanceArray[i2] = (Appearance)this.a(inputStream);
        }
        Mesh mesh = new Mesh(vertexBuffer, indexBufferArray, appearanceArray);
        M3GLoader.a(group, (Node)mesh);
        return mesh;
    }

    private MorphingMesh a(InputStream inputStream) {
        int n2;
        Mesh mesh = this.a(inputStream);
        int n3 = (int)M3GLoader.a(inputStream);
        VertexBuffer[] vertexBufferArray = new VertexBuffer[n3];
        float[] fArray = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            vertexBufferArray[n2] = (VertexBuffer)this.a(inputStream);
            fArray[n2] = M3GLoader.a(inputStream);
        }
        n2 = mesh.getSubmeshCount();
        IndexBuffer[] indexBufferArray = new IndexBuffer[n2];
        Appearance[] appearanceArray = new Appearance[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexBufferArray[i2] = mesh.getIndexBuffer(i2);
            appearanceArray[i2] = mesh.getAppearance(i2);
        }
        MorphingMesh morphingMesh = new MorphingMesh(mesh.getVertexBuffer(), vertexBufferArray, indexBufferArray, appearanceArray);
        M3GLoader.a(mesh, morphingMesh);
        morphingMesh.setWeights(fArray);
        return morphingMesh;
    }

    private PolygonMode a(InputStream inputStream) {
        PolygonMode polygonMode = new PolygonMode();
        this.a(polygonMode, inputStream);
        polygonMode.setCulling(M3GLoader.a(inputStream));
        polygonMode.setShading(M3GLoader.a(inputStream));
        polygonMode.setWinding(M3GLoader.a(inputStream));
        polygonMode.setTwoSidedLightingEnable(M3GLoader.b(inputStream));
        polygonMode.setLocalCameraLightingEnable(M3GLoader.b(inputStream));
        polygonMode.setPerspectiveCorrectionEnable(M3GLoader.b(inputStream));
        return polygonMode;
    }

    private SkinnedMesh a(InputStream inputStream) {
        Mesh mesh = this.a(inputStream);
        Group group = (Group)this.a(inputStream);
        int n2 = mesh.getSubmeshCount();
        IndexBuffer[] indexBufferArray = new IndexBuffer[n2];
        Appearance[] appearanceArray = new Appearance[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexBufferArray[i2] = mesh.getIndexBuffer(i2);
            appearanceArray[i2] = mesh.getAppearance(i2);
        }
        SkinnedMesh skinnedMesh = new SkinnedMesh(mesh.getVertexBuffer(), indexBufferArray, appearanceArray, group);
        M3GLoader.a(mesh, skinnedMesh);
        int n3 = (int)M3GLoader.a(inputStream);
        while (n3-- > 0) {
            Node node = (Node)this.a(inputStream);
            int n4 = (int)M3GLoader.a(inputStream);
            int n5 = (int)M3GLoader.a(inputStream);
            int n6 = M3GLoader.c(inputStream);
            skinnedMesh.addTransform(node, n6, n4, n5);
        }
        return skinnedMesh;
    }

    private Sprite3D a(InputStream inputStream) {
        Group group = new Group();
        this.a((Node)group, inputStream);
        Image2D image2D = (Image2D)this.a(inputStream);
        Appearance appearance = (Appearance)this.a(inputStream);
        boolean bl2 = M3GLoader.b(inputStream);
        Sprite3D sprite3D = new Sprite3D(bl2, image2D, appearance);
        M3GLoader.a(group, sprite3D);
        sprite3D.setCrop(M3GLoader.c(inputStream), M3GLoader.c(inputStream), M3GLoader.c(inputStream), M3GLoader.c(inputStream));
        return sprite3D;
    }

    private Texture2D a(InputStream inputStream) {
        Group group = new Group();
        this.a((Transformable)group, inputStream);
        Texture2D texture2D = new Texture2D((Image2D)this.a(inputStream));
        M3GLoader.a((Transformable)group, texture2D);
        texture2D.setBlendColor(M3GLoader.e(inputStream));
        texture2D.setBlending(M3GLoader.a(inputStream));
        texture2D.setWrapping(M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        texture2D.setFiltering(M3GLoader.a(inputStream), M3GLoader.a(inputStream));
        return texture2D;
    }

    private TriangleStripArray a(InputStream inputStream) {
        AnimationController animationController = new AnimationController();
        this.a(animationController, inputStream);
        int n2 = M3GLoader.a(inputStream);
        int n3 = 0;
        int[] nArray = null;
        switch (n2) {
            case 0: {
                n3 = (int)M3GLoader.a(inputStream);
                break;
            }
            case 1: {
                n3 = M3GLoader.a(inputStream);
                break;
            }
            case 2: {
                n3 = M3GLoader.b(inputStream);
                break;
            }
            case 128: {
                int n4;
                nArray = new int[(int)M3GLoader.a(inputStream)];
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    nArray[n4] = (int)M3GLoader.a(inputStream);
                }
                break;
            }
            case 129: {
                int n4;
                nArray = new int[(int)M3GLoader.a(inputStream)];
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    nArray[n4] = M3GLoader.a(inputStream);
                }
                break;
            }
            case 130: {
                int n4;
                nArray = new int[(int)M3GLoader.a(inputStream)];
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    nArray[n4] = M3GLoader.b(inputStream);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid TriangleStripArray encoding (" + this.a + ").");
            }
        }
        int[] nArray2 = new int[(int)M3GLoader.a(inputStream)];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = (int)M3GLoader.a(inputStream);
        }
        TriangleStripArray triangleStripArray = null;
        triangleStripArray = n2 != 0 && n2 != 1 && n2 != 2 ? new TriangleStripArray(nArray, nArray2) : new TriangleStripArray(n3, nArray2);
        M3GLoader.a(animationController, triangleStripArray);
        return triangleStripArray;
    }

    private VertexArray a(InputStream inputStream) {
        AnimationController animationController = new AnimationController();
        this.a(animationController, inputStream);
        int n2 = M3GLoader.a(inputStream);
        int n3 = M3GLoader.a(inputStream);
        int n4 = M3GLoader.a(inputStream);
        int n5 = M3GLoader.b(inputStream);
        if (n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException("Invalid VertexArray encoding (" + this.a + ").");
        }
        VertexArray vertexArray = new VertexArray(n5, n3, n2);
        int[] nArray = new int[n3];
        if (n2 == 1) {
            byte[] byArray = new byte[n3];
            if (n4 == 0) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        byArray[i3] = (byte)M3GLoader.a(inputStream);
                    }
                    vertexArray.set(i2, 1, byArray);
                }
            } else {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n3; ++i5) {
                        int n6 = i5;
                        nArray[n6] = nArray[n6] + (byte)M3GLoader.a(inputStream);
                        byArray[i5] = (byte)nArray[i5];
                    }
                    vertexArray.set(i4, 1, byArray);
                }
            }
        } else {
            short[] sArray = new short[n3];
            if (n4 == 0) {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n3; ++i7) {
                        sArray[i7] = (short)M3GLoader.b(inputStream);
                    }
                    vertexArray.set(i6, 1, sArray);
                }
            } else {
                for (int i8 = 0; i8 < n5; ++i8) {
                    for (int i9 = 0; i9 < n3; ++i9) {
                        int n7 = i9;
                        nArray[n7] = nArray[n7] + (short)M3GLoader.b(inputStream);
                        sArray[i9] = (short)nArray[i9];
                    }
                    vertexArray.set(i8, 1, sArray);
                }
            }
        }
        M3GLoader.a(animationController, vertexArray);
        return vertexArray;
    }

    private VertexBuffer a(InputStream inputStream) {
        VertexArray vertexArray;
        VertexArray vertexArray2;
        VertexBuffer vertexBuffer = new VertexBuffer();
        this.a(vertexBuffer, inputStream);
        vertexBuffer.setDefaultColor(M3GLoader.d(inputStream));
        VertexArray vertexArray3 = (VertexArray)this.a(inputStream);
        float[] fArray = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray[i2] = M3GLoader.a(inputStream);
        }
        float f2 = M3GLoader.a(inputStream);
        if (vertexArray3 != null) {
            vertexBuffer.setPositions(vertexArray3, f2, fArray);
        }
        if ((vertexArray2 = (VertexArray)this.a(inputStream)) != null) {
            vertexBuffer.setNormals(vertexArray2);
        }
        if ((vertexArray = (VertexArray)this.a(inputStream)) != null) {
            vertexBuffer.setColors(vertexArray);
        }
        int n2 = (int)M3GLoader.a(inputStream);
        for (int i3 = 0; i3 < n2; ++i3) {
            VertexArray vertexArray4 = (VertexArray)this.a(inputStream);
            if (vertexArray4 == null) {
                throw new IOException("Null texture vertex array");
            }
            for (int i4 = 0; i4 < 3; ++i4) {
                fArray[i4] = M3GLoader.a(inputStream);
            }
            float f3 = M3GLoader.a(inputStream);
            vertexBuffer.setTexCoords(i3, vertexArray4, f3, fArray);
        }
        return vertexBuffer;
    }

    private World a(InputStream inputStream) {
        World world = new World();
        this.a(world, inputStream);
        Camera camera = (Camera)this.a(inputStream);
        if (camera != null) {
            world.setActiveCamera(camera);
        }
        world.setBackground((Background)this.a(inputStream));
        return world;
    }

    private Object3D a(InputStream inputStream) {
        return this.a((int)M3GLoader.a(inputStream));
    }

    private static final Transform a(InputStream inputStream) {
        Transform transform = new Transform();
        float[] fArray = new float[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            fArray[i2] = M3GLoader.a(inputStream);
        }
        transform.set(fArray);
        return transform;
    }

    private static final int a(InputStream inputStream) {
        return inputStream.read();
    }

    private static boolean b(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 == 0) {
            return false;
        }
        if (n2 != 1) {
            throw new IOException("Malformed boolean.");
        }
        return true;
    }

    private static int b(InputStream inputStream) {
        return inputStream.read() + (inputStream.read() << 8);
    }

    private static final int c(InputStream inputStream) {
        return inputStream.read() + (inputStream.read() << 8) + (inputStream.read() << 16) + (inputStream.read() << 24);
    }

    private static final long a(InputStream inputStream) {
        return (long)inputStream.read() + ((long)inputStream.read() << 8) + ((long)inputStream.read() << 16) + ((long)inputStream.read() << 24);
    }

    private static final float a(InputStream inputStream) {
        int n2 = M3GLoader.c(inputStream);
        if ((n2 & 0x7F800000) != 2139095040 && n2 != Integer.MIN_VALUE && ((n2 & 0x7FFFFF) == 0 || (n2 & 0x7F800000) != 0)) {
            return Float.intBitsToFloat(n2);
        }
        throw new IOException("Malformed float.");
    }

    private static int d(InputStream inputStream) {
        return (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read() + (inputStream.read() << 24);
    }

    private static int e(InputStream inputStream) {
        return (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read();
    }

    private static String a(InputStream inputStream) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream2 = inputStream;
        while ((n2 = inputStream2.read()) != 0) {
            int n3;
            if ((n2 & 0x80) == 0) {
                stringBuffer.append((char)(n2 & 0xFF));
            } else if ((n2 & 0xE0) == 192) {
                n3 = inputStream.read();
                if ((n3 & 0xC0) != 128) {
                    throw new IOException("Invalid UTF-8 string.");
                }
                stringBuffer.append((char)((n2 & 0x1F) << 6 | n3 & 0x3F));
            } else {
                if ((n2 & 0xF0) != 224) {
                    throw new IOException("Invalid UTF-8 string.");
                }
                n3 = inputStream.read();
                int n4 = inputStream.read();
                if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                    throw new IOException("Invalid UTF-8 string.");
                }
                stringBuffer.append((char)((n2 & 0xF) << 12 | (n3 & 0x3F) << 6 | n4 & 0x3F));
            }
            inputStream2 = inputStream;
        }
        return stringBuffer.toString();
    }

    private static int a(byte[] byArray, int n2) {
        int n3;
        byte[] byArray2 = b;
        int n4 = 0;
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            if (byArray[n3 + n2] == byArray2[n3]) continue;
            ++n4;
        }
        if (n4 == 0) {
            return 2;
        }
        byArray2 = a;
        n4 = 0;
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            if (byArray[n3 + n2] == byArray2[n3]) continue;
            ++n4;
        }
        if (n4 == 0) {
            return 1;
        }
        Emulator.getEmulator().getLogStream().println("M3GLoader:Invalid file type, use png instead");
        return 2;
    }

    private static int f(InputStream inputStream) {
        byte[] byArray = new byte[12];
        inputStream.read(byArray);
        return M3GLoader.a(byArray, 0);
    }

    private boolean a(String string) {
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            if (!((String)this.c.elementAt(i2)).equals(string)) continue;
            return true;
        }
        return false;
    }

    private static InputStream a(String string) {
        HttpConnection httpConnection;
        String string2;
        InputConnection inputConnection = (InputConnection)Connector.open(string);
        if (inputConnection instanceof HttpConnection && (string2 = (httpConnection = (HttpConnection)inputConnection).getHeaderField("Content-Type")) != null && !string2.equals("application/m3g") && !string2.equals("image/png")) {
            throw new IOException("Wrong MIME type: " + string2);
        }
        return inputConnection.openInputStream();
    }

    private InputStream b(String string) {
        if (string.indexOf(58) != -1) {
            return M3GLoader.a(string);
        }
        if (string.charAt(0) == '/') {
            return CustomJarResources.getResourceAsStream(string);
        }
        if (this.b == null) {
            throw new IOException("Relative URI.");
        }
        String string2 = this.b.substring(0, this.b.lastIndexOf(47) + 1) + string;
        return string2.charAt(0) == '/' ? CustomJarResources.getResourceAsStream(string2) : M3GLoader.a(string2);
    }

    private static void a(Object3D object3D, Object3D object3D2) {
        object3D2.setUserObject(object3D.getUserObject());
        object3D2.setUserID(object3D.getUserID());
    }

    private static void a(Node node, Node node2) {
        M3GLoader.a((Transformable)node, (Transformable)node2);
        node2.setAlphaFactor(node.getAlphaFactor());
        node2.setScope(node.getScope());
        node2.setPickingEnable(node.isPickingEnabled());
        node2.setRenderingEnable(node.isRenderingEnabled());
    }

    private static void a(Transformable transformable, Transformable transformable2) {
        M3GLoader.a((Object3D)transformable, (Object3D)transformable2);
        float[] fArray = new float[4];
        Transform transform = new Transform();
        transformable.getTranslation(fArray);
        transformable2.setTranslation(fArray[0], fArray[1], fArray[2]);
        transformable.getScale(fArray);
        transformable2.setScale(fArray[0], fArray[1], fArray[2]);
        transformable.getOrientation(fArray);
        transformable2.setOrientation(fArray[0], fArray[1], fArray[2], fArray[3]);
        transformable.getTransform(transform);
        transformable2.setTransform(transform);
    }

    private static void a(Mesh mesh, Mesh mesh2) {
        M3GLoader.a((Node)mesh, (Node)mesh2);
    }

    private static void a(byte[] byArray, byte[] byArray2) {
        try {
            Inflater inflater = new Inflater(false);
            inflater.setInput(byArray);
            inflater.inflate(byArray2);
            inflater.end();
        }
        catch (Exception exception) {
            Emulator.getEmulator().getLogStream().println("m3g upzip error");
        }
    }
}

