/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;

public class Camera
extends Node {
    public static final int GENERIC = 48;
    public static final int PARALLEL = 49;
    public static final int PERSPECTIVE = 50;
    private int projectionType = 48;
    private Transform generic = new Transform();
    private float[] projection = new float[4];

    @Override
    protected Object3D duplicateObject() {
        Camera camera = (Camera)super.duplicateObject();
        ((Camera)super.duplicateObject()).generic = new Transform(this.generic);
        camera.projection = (float[])this.projection.clone();
        return camera;
    }

    public Camera() {
        this.projection[0] = 2.0f;
        this.projection[1] = 1.0f;
        this.projection[2] = -1.0f;
        this.projection[3] = 1.0f;
    }

    public void setParallel(float f2, float f3, float f4, float f5) {
        if (!(f2 > 0.0f) || !(f3 > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.projection[0] = f2;
        this.projection[1] = f3;
        this.projection[2] = f4;
        this.projection[3] = f5;
        this.projectionType = 49;
    }

    public void setPerspective(float f2, float f3, float f4, float f5) {
        if (!(f2 > 0.0f && f2 < 180.0f && f3 > 0.0f && f4 > 0.0f && f5 > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.projection[0] = f2;
        this.projection[1] = f3;
        this.projection[2] = f4;
        this.projection[3] = f5;
        this.projectionType = 50;
    }

    public void setGeneric(Transform transform) {
        if (transform == null) {
            throw new NullPointerException();
        }
        this.generic.set(transform);
        this.projectionType = 48;
    }

    public int getProjection(Transform transform) {
        if (transform != null) {
            if (this.projectionType == 49) {
                float f2 = this.projection[0];
                float f3 = this.projection[1] * f2;
                float f4 = this.projection[3] - this.projection[2];
                if (f4 == 0.0f) {
                    throw new ArithmeticException("near == far");
                }
                float[] fArray = new float[16];
                float[] fArray2 = fArray;
                fArray[0] = 2.0f / f3;
                fArray2[5] = 2.0f / f2;
                fArray2[10] = -2.0f / f4;
                fArray2[11] = -(this.projection[2] + this.projection[3]) / f4;
                fArray2[15] = 1.0f;
                transform.set(fArray2);
            } else if (this.projectionType == 50) {
                float f5 = (float)Math.tan(Math.toRadians(this.projection[0] / 2.0f));
                float f6 = this.projection[1] * f5;
                float f7 = this.projection[3] - this.projection[2];
                if (f7 == 0.0f) {
                    throw new ArithmeticException("near == far");
                }
                float[] fArray = new float[16];
                float[] fArray3 = fArray;
                fArray[0] = 1.0f / f6;
                fArray3[5] = 1.0f / f5;
                fArray3[10] = -(this.projection[2] + this.projection[3]) / f7;
                fArray3[11] = -2.0f * this.projection[2] * this.projection[3] / f7;
                fArray3[14] = -1.0f;
                transform.set(fArray3);
            } else {
                transform.set(this.generic);
            }
        }
        return this.projectionType;
    }

    public int getProjection(float[] fArray) {
        if (fArray != null && fArray.length < 4) {
            throw new IllegalArgumentException();
        }
        if (fArray != null && this.projectionType != 48) {
            System.arraycopy(this.projection, 0, fArray, 0, 4);
        }
        return this.projectionType;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        if (this.projectionType != 48) {
            switch (n2) {
                case 263: {
                    this.projection[3] = this.projectionType != 50 ? fArray[0] : G3DUtils.limitPositive(fArray[0]);
                    return;
                }
                case 264: {
                    this.projection[0] = this.projectionType != 50 ? G3DUtils.limitPositive(fArray[0]) : G3DUtils.limit(fArray[0], 0.0f, 180.0f);
                    return;
                }
                default: {
                    break;
                }
                case 267: {
                    this.projection[2] = this.projectionType != 50 ? fArray[0] : G3DUtils.limitPositive(fArray[0]);
                    return;
                }
            }
        }
        super.updateProperty(n2, fArray);
    }

    @Override
    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform) {
        return false;
    }
}

