/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Vector4f;
import java.util.Vector;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public class Group
extends Node {
    Vector children = new Vector();

    @Override
    protected Object3D duplicateObject() {
        Group group = (Group)super.duplicateObject();
        group.children = (Vector)this.children.clone();
        for (int i2 = group.getChildCount() - 1; i2 >= 0; --i2) {
            Node node = group.getChild(i2);
            Node node2 = (Node)group.getChild(i2).duplicateObject();
            group.removeReference(node);
            group.addReference(node2);
            node2.parent = group;
            group.children.set(i2, node2);
        }
        return group;
    }

    public void addChild(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (node == this) {
            throw new IllegalArgumentException("child is this Group");
        }
        if (node instanceof World) {
            throw new IllegalArgumentException("child is a World node");
        }
        if (node.parent != null && node.parent != this) {
            throw new IllegalArgumentException("child already has a parent other than this Group");
        }
        if (node.isParentOf(this)) {
            throw new IllegalArgumentException("child is an ancestor of this Group");
        }
        if (!this.children.contains(node)) {
            this.children.add(node);
            node.parent = this;
            this.addReference(node);
        }
    }

    public void removeChild(Node node) {
        if (node != null) {
            if (node.isSkinnedMeshBone()) {
                throw new IllegalArgumentException();
            }
            if (this.children.contains(node)) {
                this.children.remove(node);
                node.parent = null;
                this.removeReference(node);
            }
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Node getChild(int n2) {
        if (n2 < 0 || n2 >= this.getChildCount()) {
            throw new IndexOutOfBoundsException();
        }
        return (Node)this.children.get(n2);
    }

    @Override
    protected void alignment(Node node) {
        super.alignment(node);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            ((Node)this.children.get(i2)).alignment(node);
        }
    }

    public boolean pick(int n2, float f2, float f3, Camera camera, RayIntersection rayIntersection) {
        if (camera == null) {
            throw new NullPointerException();
        }
        if (camera.getRoot() != this.getRoot()) {
            throw new IllegalStateException();
        }
        if (!this.isPickingEnabled()) {
            return false;
        }
        Vector4f vector4f = new Vector4f(2.0f * f2 - 1.0f, 1.0f - 2.0f * f3, -1.0f, 1.0f);
        Vector4f vector4f2 = new Vector4f(2.0f * f2 - 1.0f, 1.0f - 2.0f * f3, 1.0f, 1.0f);
        Transform transform = new Transform();
        camera.getProjection(transform);
        transform.getImpl_().invert();
        transform.getImpl_().transform(vector4f);
        transform.getImpl_().transform(vector4f2);
        vector4f.mul(1.0f / vector4f.w);
        vector4f2.mul(1.0f / vector4f2.w);
        float[] fArray = new float[8];
        fArray[6] = vector4f.z;
        fArray[7] = vector4f2.z;
        Transform transform2 = new Transform();
        camera.getTransformTo(this, transform2);
        transform2.getImpl_().transform(vector4f);
        transform2.getImpl_().transform(vector4f2);
        vector4f.mul(1.0f / vector4f.w);
        vector4f2.mul(1.0f / vector4f2.w);
        fArray[0] = vector4f.x;
        fArray[1] = vector4f.y;
        fArray[2] = vector4f.z;
        fArray[3] = vector4f2.x;
        fArray[4] = vector4f2.y;
        fArray[5] = vector4f2.z;
        if (rayIntersection == null) {
            rayIntersection = new RayIntersection();
        }
        rayIntersection.startPick(fArray, f2, f3, camera);
        transform2.setIdentity();
        return this.rayIntersect(n2, fArray, rayIntersection, transform2);
    }

    public boolean pick(int n2, float f2, float f3, float f4, float f5, float f6, float f7, RayIntersection rayIntersection) {
        if (f5 == 0.0f && f6 == 0.0f && f7 == 0.0f) {
            throw new IllegalArgumentException();
        }
        if (!this.isPickingEnabled()) {
            return false;
        }
        float[] fArray = new float[]{f2, f3, f4, f2 + f5, f3 + f6, f4 + f7};
        Transform transform = new Transform();
        if (rayIntersection == null) {
            rayIntersection = new RayIntersection();
        }
        rayIntersection.startPick(fArray, 0.0f, 0.0f, null);
        return this.rayIntersect(n2, fArray, rayIntersection, transform);
    }

    @Override
    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform) {
        boolean bl2 = false;
        Transform transform2 = new Transform();
        Transform transform3 = new Transform();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            Node node = (Node)this.children.get(i2);
            if (!node.isPickingEnabled()) continue;
            transform2.set(transform);
            node.getCompositeTransform(transform3);
            transform2.postMultiply(transform3);
            if (!node.rayIntersect(n2, fArray, rayIntersection, transform2)) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    protected void updateAlignReferences() {
        super.updateAlignReferences();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            ((Node)this.children.get(i2)).updateAlignReferences();
        }
    }

    @Override
    protected void clearAlignReferences() {
        super.clearAlignReferences();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            ((Node)this.children.get(i2)).clearAlignReferences();
        }
    }
}

